#include "all.h"


#define bossship(a) ((long*)spritegfx+1314+64*a)	//128
#define bossshipmask(a) ((long*)spritegfx+1442+32*a)	//64
#define SHOOTERLIFE 8

/* Almost all sprite data is in the following file */
/* Eventually may be in the dukegfx pak file */

#include "sprite_images.h"

const char normal_steps[4] = { 0, 1, 2, 1 };
const char second_steps[4] = { 0, 1, 0, 2 };

mb1_struct mb1;

//Check if an {x,y} is free based on a few things
short is_free(short x, short y, short type)
{
	short tempval = 0;
	if (level.correction && level.yHard >= level.ySize - 13)
		y++;
	// handle out of screen locations
	if (y > 12) {
		if (type == 2)
			return 0;	// below is solid //now is free
		if (type == 10)
			return 0;
		if (y < 15)
			return 1;
		else
			return 1;
	}
	if (y < 0) {
		if (type == 10)
			return 0;
		else
			return 1;	// above is free
	}

	if (x < 0)
		x = 0;		// route sides to next valid location
	if (x > 20)
		x = 20;
	if (type < 10)
		y -= level.correction;
	tempval = y * 21 + x;
	switch (attribs[vidmem[tempval]]) {
	case 0:
		return 1;

	case 4:
		return 2;

	case 5:
		return 1;

	case 2:
		if (!type)
			return 1;
		break;

	default:
		return 0;
	}
	return 0;
}


short oos(short x, short y)
{
	if (x <= -30 || x >= 170)
		return 1;
	if (y <= -1 || y >= 112)
		return 1;
	return 0;
}

short alive_oos(Sprite * s)
{
	if (s->x <= 0 - s->width || s->x >= 160)
		return 1;
	if (s->y <= 0 - s->height || s->y >= 96)
		return 1;
	return 0;
}


short boss_oos(short x, short y)
{
	if (x <= -16 || x >= 160)
		return 1;
	if (y <= 0 || y >= 96)
		return 1;
	return 0;
}

// Non-Standard Draw Functions

void button_draw(Sprite * s)
{
if(!oos(s->x, s->y))
{
	Sprite16_OR_GS(s->x, s->y, s->height, s->image, s->mask);
}
}

void boss_final_draw(Sprite * s)
{
short face = (s->dir > 0) ? 1 : 0;
if (!s->dy) {
Sprite32_OR_GS(s->x - 1 - 8,s->y - 1 -16, 32,NULL,bossshipmask(face));
Sprite32_OR_GS(s->x + 1 - 8,s->y - 1 -16, 32,NULL,bossshipmask(face));
Sprite32_OR_GS(s->x - 1 - 8,s->y + 1 -16, 32,NULL,bossshipmask(face));
Sprite32_OR_GS(s->x + 1 - 8,s->y + 1 -16, 32,NULL,bossshipmask(face));
Sprite32_OR_GS(s->x - 8    ,s->y - 16   , 32,bossship(face),bossshipmask(face));
}
}


// Enemy: Mine Functions

void enemy_mine_init(Sprite * s)
{

	s->image = mine1;
	s->mask = mine1m;
	if (s->minor)
		s->dir = 3;
	else
		s->dir = -3;
	s->data0 = 0;
	s->dx = 0;
	s->life = 10;
}

void enemy_mine_run(Sprite * s)
{
	short a;
	equalize_a(s);

	if (sprite_player_collision(s)) {
		for (a = 0; a < 4; a++) {
			OSContrastUp();
			delayt(1);
		}
		delayt(2);
		player.life -= 33;
		s->major = 0;
		for (a = 0; a < 4; a++) {
			OSContrastDn();
			delayt(1);
		}
	}
}
void enemy_mine_erase(Sprite * s)
{
	s->image = NULL;
	persistent_sprite(s);
}

void enemy_mine_kill(Sprite * s)
{
	s->image = NULL;
	s->major = 0;
	player.score += 1500;
}

Sprite_funcs enemy_mine_funcs =
    { enemy_mine_init, enemy_mine_run, enemy_mine_erase,
	enemy_mine_kill, enemy_draw_std,
};

// Enemy: Skeleton Bot Functions
void enemy_bot_init(Sprite * s)
{

	s->height = 24;
	s->image = enemy_bot_data;
	s->mask = enemy_bot_mask;
	if (s->minor)
		s->dir = 3;
	else
		s->dir = -3;
	s->data0 = 1;
	s->data1 = 0;
	s->life = SHOOTERLIFE;
	s->ani_step = 0;
	s->dx = 0;
//	s->y = (s->y >> 3) << 3;
}

void enemy_bot_run(Sprite * s)
{

	char direction = 0;
	if (alive_oos(s)) {
		s->data1 = 0;
		s->shooting = 0;
		return;
	} else {
		s->image = enemy_bot_data;
		s->mask = enemy_bot_mask;
		//if(s->shooting==0)s->y-=8;
	}
	if (s->y == 99)
		s->y -= s->height;
	sideadjust();

	direction = enemy_a(s);
	if (!s->data0)
		s->y = (s->y >> 3) << 3;
	s->image =
	    enemy_bot_data +
	    (48 * ((int) normal_steps[s->ani_step] + (direction ? 0 : 3)));
	s->mask =
	    enemy_bot_mask +
	    (24 * ((int) normal_steps[s->ani_step] + (direction ? 0 : 3)));

}

void enemy_bot_erase(Sprite * s)
{
	s->image = NULL;
	persistent_sprite(s);
}

void enemy_bot_kill(Sprite * s)
{
	s->image = NULL;
	s->_list_entry = s->_list_entry;
	s->_minor_major = 0;
	player.score += 1500;
}

Sprite_funcs enemy_bot_funcs =
    { enemy_bot_init, enemy_bot_run, enemy_bot_erase,
	enemy_bot_kill, enemy_draw_std,
};


// Enemy: Masked Man Functions
void enemy_masked_init(Sprite * s)
{

	s->height = 24;
	s->image = enemy_masked_data;
	s->mask = enemy_masked_mask;
	if (s->minor)
		s->dir = 2;
	else
		s->dir = -2;
	s->data0 = 1;
	s->data1 = 0;
	s->life = SHOOTERLIFE;
	s->ani_step = 1;
	s->dx = 0;
//	s->y = (s->y >> 3) << 3;
}

void enemy_masked_run(Sprite * s)
{

	char direction = 0;
	if (alive_oos(s)) {
		s->data1 = 0;
		s->shooting = 0;
		return;
	} else {
		s->image = enemy_masked_data;
		s->mask = enemy_masked_mask;
		//if(s->shooting==0)s->y-=8;
	}
	if (s->y == 99)
		s->y -= s->height;
	sideadjust();

	direction = enemy_a(s);
	if (!s->data0)
		s->y = (s->y >> 3) << 3;

	s->image =
	    enemy_masked_data +
	    (48 * ((int) normal_steps[s->ani_step] + (direction ? 0 : 3)));
	s->mask =
	    enemy_masked_mask +
	    (24 * ((int) normal_steps[s->ani_step] + (direction ? 0 : 3)));

}

void enemy_masked_erase(Sprite * s)
{
	s->image = NULL;
	persistent_sprite(s);
}

void enemy_masked_kill(Sprite * s)
{
	s->image = NULL;
	s->_list_entry = s->_list_entry;
	s->_minor_major = 0;
	player.score += 1500;
}

Sprite_funcs enemy_masked_funcs =
    { enemy_masked_init, enemy_masked_run, enemy_masked_erase,
	enemy_masked_kill, enemy_draw_std,
};

// Enemy: MiniBoss Functions
void enemy_mb1_init(Sprite * s)
{
	short a;
	s->height = 25;
	s->image = enemy_mb1_data;
	s->mask = enemy_mb1_mask;
	s->dir = -2;
	s->data0 = 1;
	if (!(s->data1 == 99))
		s->data1 = 0;
	s->life = ((boss.health != -1) ? boss.health : 500);
	s->ani_step = 1;
	s->dx = 0;
//	s->y = (s->y >> 3) << 3;
	mb1.jumpwait = 0;
	mb1.jump = 3;
	s->dx = 68;
	for (a = 0; a < SPRITE_NO; a++) {
		if (sprites[a].dx == 68) {
			boss.notify = a;
			break;
		}
	}
	s->dx = 0;
}

void enemy_mb1_run(Sprite * s)
{

	char direction = 0;

	if (s->life < 10 && s->life > -1) {
		s->image = NULL;
		s->data1 = 99;
		s->mask = NULL;
		s->life = -1;
		player.score += 50000;
		mb1.jumpwait = 0;
		mb1.jump = 0;
		boss.health = -1;
		boss.notify = -1;
	}

	if (alive_oos(s) || s->life == -1) {
		s->image = NULL;
		s->mask = NULL;
		if (s->data1 != 99)
			s->data1 = 0;
		s->shooting = 0;
		return;
	} else {
		s->image = enemy_mb1_data;
		s->mask = enemy_mb1_mask;
	}
	if (s->y == 99)
		s->y -= s->height;
	sideadjust();

	s->y += 8;
	if (level_num_cur == 9)
		s->y -= 8;
	direction = enemy_a(s);
	s->y -= 8;
	if (level_num_cur == 9)
		s->y += 8;
	if (!s->data0)
		s->y &= ~7;
	s->image =
	    enemy_mb1_data + 50 * ((int) normal_steps[s->ani_step] +
				   (direction ? 3 : 0));
	s->mask =
	    enemy_mb1_mask + 25 * ((int) normal_steps[s->ani_step] +
				   (direction ? 3 : 0));


}

void enemy_mb1_erase(Sprite * s)
{
	s = s;
	if (s->data1 != 99)
		persistent_sprite(s);
}

void enemy_mb1_kill(Sprite * s)
{
	s = s;
}

Sprite_funcs enemy_mb1_funcs =
    { enemy_mb1_init, enemy_mb1_run, enemy_mb1_erase,
	enemy_mb1_kill, enemy_draw_std,
};


// Enemy: Final Boss (Ship) Functions
void enemy_boss_init(Sprite * s)
{
	short a;
	s->height = 48;
	s->image = NULL;
	s->mask = NULL;
	s->dir = -2;
	s->data0 = 1;
	if (!(s->data1 == 99))
		s->data1 = 0;
	s->life = ((boss.health != -1) ? boss.health : 203);
	s->ani_step = 1;
	s->dx = 0;
	s->width = 40;
	s->y = (s->y >> 3) << 3;
	mb1.jumpwait = 0;
	mb1.jump = 3;
	s->dx = 68;

	for (a = 0; a < SPRITE_NO; a++) {
		if (sprites[a].dx == 68) {
			boss.notify = a;
			break;
		}
	}

}

void enemy_boss_run(Sprite * s)
{
	char bossxarray[] =
	    { 0, 1, 0, -1};
	char bossyarray[] =
	    { 1, 0, -1, 0};

	static short arraypos = 0;
	short a;
	if (s->life < 3 && s->life > -1) {
		for (a = 0; a < 7; a++) {
			OSContrastDn();
			if (hardwarever != 20)
				OSContrastDn();
			delayt(4);
		}
		delayt(10);
		s->data1 = 99;
		s->dy = 0;
		s->life = -1;
		player.score += 100000;
		boss.health = -1;
		player.exit_hit = 2;
		for (a = 0; a < 7; a++) {
			OSContrastUp();
			if (hardwarever != 20)
				OSContrastUp();
		}
	}
//      if (boss_oos(s->x-8,s->y-16) || s->life == -1) {if(s->data1!=99)s->data1=0;s->shooting=0; return;}
//      if(s->y==99) s->y-= s->height;

//sideadjust();

//s->y+=8;
//direction = enemy_a(s);
//s->y-=8;
	if (!boss_oos(s->x - 8, s->y - 16)) {
		s->dy = 0;
		{
			short flag = 0;
			if (((player.y - 16) >= (s->y - 16 + 24))) {
				s->y += 3;
				flag++;
			}
			if (((player.y - 16) < (s->y - 16 - 24))) {
				s->y -= 3;
				flag++;
			}
			if (((player.x - 16) >= (s->x - 16 + 48))
			    && s->dir > 0) {
				s->x++;
				flag++;
			}
			if (((player.x - 16) >= (s->x - 16 + 32))
			    && s->dir < 0) {
				s->dir = -s->dir;
				flag++;
			}
			if (((player.x - 16) < (s->x - 48 - 16))
			    && s->dir < 0) {
				s->x--;
				flag++;
			}
			if (((player.x - 29 - 16) < (s->x - 16))
			    && s->dir > 0) {
				s->dir = -s->dir;
				flag++;
			}
			if (!flag) {
				arraypos++;
				if (arraypos == 64) {
					arraypos = 0;
				}
				s->x += bossxarray[arraypos>>4];
				s->y += bossyarray[arraypos>>4];

			}
		}

		s->y -= 16;
		shooter_a(s);
		s->y += 16;
		if (s->life) {
//      s->x-=8;
			s->y -= 32;
			player.x += 16;
			player.y -= 16;
			if (sprite_player_collision(s)) {
				player.life--;
				if (player.x > s->x)
					player.x += 4;
				else
					player.x -= 4;
			}
//      s->x+=8;
			s->y += 32;
			player.x -= 16;
			player.y += 16;
		}
	} else
		s->dy = 1;

	if (!
	    (is_free((s->x >> 3) - 1, (s->y >> 3) - 2, 10)
	     && is_free((s->x >> 3) + 2, (s->y >> 3) + 1, 10))) {
		if (!is_free((s->x >> 3) - 1, (s->y >> 3) - 3, 1))
			s->y += 8;
		else if (!is_free((s->x >> 3) - 1, (s->y >> 3) - 1, 1))
			s->y -= 8;
		else if (!is_free((s->x >> 3) - 2, (s->y >> 3) - 1, 1))
			s->x += 8;
		else if (!is_free((s->x >> 3), (s->y >> 3) - 1, 1))
			s->x -= 8;
		else {
			s->x += 8;
			s->y += 8;
		}
	}

}
void enemy_boss_erase(Sprite * s)
{
	s = s;
	if (s->data1 != 99)
		persistent_sprite(s);
}

void enemy_boss_kill(Sprite * s)
{
	s = s;
}

Sprite_funcs enemy_boss_funcs =
    { enemy_boss_init, enemy_boss_run, enemy_boss_erase,
	enemy_boss_kill, boss_final_draw,
};



// Items (major 14)
// minor 0: health can
// minor 1: diamond, score + 500
// minor 2: health Mega
// minor 3: health plant
// minor 4: health box
// minor 5: extra life
// minor 9: rocket upgrade

void item_init(Sprite * s)
{
	switch (s->minor) {
	case 0:
		s->image = health_can;
		s->mask = health_can_mask;
		s->ani_step = 0;
		break;
	case 1:
		s->mask = score_diamond_mask;
		s->image = score_diamond;
		s->ani_step = 0;
		break;
	case 2:
		s->image = health_mega;
		s->mask = health_mega_mask;
		s->ani_step = 0;
		break;
	case 3:
		s->image = health_plant;
		s->mask = health_plant_mask;
		break;
	case 4:
		s->image = health_box;
		s->mask = health_box_mask;
		s->height = 8;
		break;
	case 5:
		s->image = aniMapRight[0];
		s->mask = aniMaskRight[0];
		s->height = 19;
		break;
	case 9:
		s->image = rocket_icon;
		s->mask = mask_16;
		break;
	default:
		s->image = NULL;
		break;
	}
	s->life = -1;
}

void item_run(Sprite * s)
{
	equalize_a(s);
	switch (s->minor) {
	case 0:
		s->data0++;	// ani speed
		if (s->data0 > 2) {
			s->data0 = 0;
			s->ani_step++;
			if (s->ani_step > 4)
				s->ani_step = 0;
			s->image = health_can + 32 * s->ani_step;
		}
		break;
	case 1:
		s->data0++;
		if (s->data0 > 2) {
			s->data0 = 0;
			s->ani_step++;
			if (s->ani_step >= 4)
				s->ani_step = 0;
			s->mask = score_diamond_mask + 16 * s->ani_step;
			s->image = score_diamond + 32 * s->ani_step;
		}
		break;
	case 2:
		s->data0++;
		if (s->data0 > 2) {
			s->data0 = 0;
			s->ani_step++;
			s->ani_step &= 3;
			if (s->ani_step == 3) {
				s->image = health_mega + 32;
				s->mask = health_mega_mask + 16;
			} else {
				s->image = health_mega + 32 * s->ani_step;
				s->mask =
				    health_mega_mask + 16 * s->ani_step;
			}
		}
		break;
	default:
		break;
	}
	equalize_a(s);
	if (!sprite_player_collision(s))
		return;

	switch (s->minor) {
	case 0:
		if (player.life < 200) {
			s->major = 0;
			player.life += (25);
		}
		break;
	case 1:
		player.score += 500;
		s->major = 0;
		break;
	case 2:
		if (player.life < 200) {
			s->major = 0;
			player.life += (100);
		}
		break;
	case 3:
		if (player.life < 200) {
			s->major = 0;
			player.life += (20);
		}
		break;
	case 4:
		if (player.life < 200) {
			s->major = 0;
			player.life += (10);
		}
		break;
	case 5:
		player.lives++;
		s->major = 0;
		break;
	case 9:
		if (player.ammo < ammos[1]) {
			s->major = 0;
			weapon.oldShotType = 1;
			weapon.previousShotType = 2;
			weapon.currentShotType = 2;
			player.ammo = 30;
		}
		break;
	default:
		break;
	}
	if (player.life > 200)
		player.life = 200;

}

void item_erase(Sprite * s)
{
	persistent_sprite(s);
}

void item_kill(Sprite * s)
{
	s = s;
}

Sprite_funcs item_funcs = { item_init, item_run, item_erase,
	item_kill, sprite_draw_std,
};

// Tag sprites, they're usually not visible but have the purpose to trigger
// events, such as save points and level exit

// Tag position: (convention: major 15)
// minor 1: exit point
// minor 2: save point

void tag_position_kill(Sprite * s);
void tag_position_erase(Sprite * s);

void tag_position_init(Sprite * s)
{
	s->life = -1;
	if (s->minor == 2) {
		s->image = saveb1;
		s->mask = saveb1m;
		s->height = 26;
		s->y = (s->y) - 10;
	} else {
		s->image = NULL;
	}

}

void tag_position_run(Sprite * s)
{
switch(s->minor)
{
case 1:
		if (sprite_player_collision(s)) {
			player.exit_hit = 1;
		}
break;
case 2:
		if (sprite_player_collision(s)) {
			unsigned char *list = s->_list_entry;
			player.saved_x = (list[1] << 8) + list[2];
			player.saved_y = (list[3] << 8) + list[4];
			if (s->image != savea1)
				s->y = (s->y) - 22;
			s->image = savea1;
			s->mask = savea1m;
			s->height = 48;
		}
break;
}
}

void tag_position_erase(Sprite * s)
{
	persistent_sprite(s);
}

void tag_position_kill(Sprite * s)
{
	s = s;
}

Sprite_funcs tag_position_funcs =
    { tag_position_init, tag_position_run, tag_position_erase,
	tag_position_kill, sprite_draw_std,
};

//Level Effect: Computer Terminal Functions
void access_a_button_init(Sprite * s)
{
	if (!(s->data1 == 99))
		s->life = 30;
	if (s->data0 != 9)
		s->abs_y--;
	if (s->data1 == 99)
		s->image = terminal_after;
	if (s->data1 != 99)
		s->image = terminal_before;
	s->mask = terminal_mask;
	s->height = 24;		//16
	if (!(s->data1 == 99))
		s->data1 = 0;
	s->data0 = 9;
}

void access_a_button_run(Sprite * s)
{
	if (oos(s->x, s->y)) {
		s->image = NULL;
		s->mask = NULL;
		return;
	} else if (s->data1 == 99) {
		s->image = terminal_after;
		s->mask = terminal_mask;
	} else {
		s->image = terminal_before;
		s->mask = terminal_mask;
	}
	equalize_a(s);
//s->y+=8;
	if ((s->life <= 8) && (s->life > 0)) {
		s->life = -1;
		s->image = terminal_after;
		s->data1 = 99;
		player.score += 500;
	}

}

void access_a_button_erase(Sprite * s)
{
	s = s;
	persistent_sprite(s);
}

void access_a_button_kill(Sprite * s)
{
	s = s;
}

Sprite_funcs access_a_button_funcs =
    { access_a_button_init, access_a_button_run, access_a_button_erase,
	access_a_button_kill, button_draw,
};

//Level Effect: Electric Field Functions
void access_a_block_init(Sprite * s)
{
	s->life = -1;
	s->image = access_a;
	s->mask = access_a_mask;
	s->height = 96;
	s->dir = -1;
	s->data0 = 0;
	s->ani_step = 0;
	{
		short i;
		for (i = 0; i < SPRITE_NO; ++i) {

			if ((sprites[i].data1) == 99) {
				if (s->minor == sprites[i].minor) {
					s->major = 0;
					s->life = 0;
				}
			}

		}
	}
}


void access_a_block_run(Sprite * s)
{


	equalize_a(s);
	{
		short i;
		for (i = 0; i < SPRITE_NO; ++i) {
			if ((sprites[i].data1) == 99) {
				if (s->minor == sprites[i].minor) {
					s->major = 0;
					s->life = 0;
				}
			}

		}
	}
	if (s->life) {
		s->x -= 4;
		if (sprite_player_collision(s)) {
			if (isFreeLeft())
				player.x -= 4;

			player.life -= 15;
		}

		s->data0++;	// ani speed
		if (s->data0 >= 1) {
			s->data0 = 0;
			s->ani_step++;
			if (s->ani_step == 4)
				s->ani_step = 0;
			s->mask =
			    access_a_mask +
			    (96 * (int) second_steps[s->ani_step]);
			s->image =
			    access_a +
			    (192 * (int) second_steps[s->ani_step]);
		}
		s->x += 4;
	}


}

void access_a_block_erase(Sprite * s)
{
	persistent_sprite(s);
}

void access_a_block_kill(Sprite * s)
{
	s = s;
}

Sprite_funcs access_a_block_funcs =
    { access_a_block_init, access_a_block_run, access_a_block_erase,
	access_a_block_kill, sprite_draw_std,
};


//Level Effect: Button-Triggered Wall Functions
void access_b_block_init(Sprite * s)
{
	s->life = -1;
	s->image = b_img_24;
	s->mask = NULL;
	s->height = 24;
	s->dir = -1;
	s->data0 = 0;
	s->ani_step = 0;
	{
		short i;
		for (i = 0; i < SPRITE_NO; ++i) {
			if ((sprites[i].data1) == 99) {
				if (s->minor == sprites[i].minor) {
					s->major = 0;
					s->life = 0;
				}
			}
		}
	}

}
void access_b_block_run(Sprite * s)
{
	equalize_a(s);
	{
		short i;
		for (i = 0; i < SPRITE_NO; ++i) {

			if ((sprites[i].data1) == 99) {
				if (s->minor == sprites[i].minor) {
					s->major = 0;
					s->life = 0;
				}
			}

		}
	}

	if (s->life) {
		if (sprite_player_collision(s)) {
			if (player.x > s->x)
				player.x += 4;
			else
				player.x -= 4;

		}
	}
}

void access_b_block_erase(Sprite * s)
{
	persistent_sprite(s);
}

void access_b_block_kill(Sprite * s)
{
	s = s;
}

Sprite_funcs access_b_block_funcs =
    { access_b_block_init, access_b_block_run, access_b_block_erase,
	access_b_block_kill, sprite_draw_std,
};




//Level Effect: "Palace Self-Destruct" Button Functions
void palace_collapse_init(Sprite * s)
{
	if (!(s->data1 == 99))
		s->life = 30;
	if (s->data1 == 99)
		s->image = terminal_after;
	if (s->data1 != 99)
		s->image = terminal_before;
	s->mask = terminal_mask;
	s->height = 24;
	if (!(s->data1 == 99))
		s->data1 = 0;
}

void palace_collapse_run(Sprite * s)
{

	if (oos(s->x, s->y)) {
		s->image = NULL;
		s->mask = NULL;
	} else if (s->data1 == 99) {
		s->image = terminal_after;
		s->mask = terminal_mask;
	} else {
		s->image = terminal_before;
		s->mask = terminal_mask;
	}
	equalize_a(s);
	if ((s->life <= 8) && (s->life > 0)) {
		s->life = -1;
		s->image = terminal_after;
		s->data1 = 99;
		boss.evactimer = 342;
		player.score += 500;
	}

	if (boss.evactimer && boss.evactimer != 1) {
		contrast.chg += contrast.amt;
		if (contrast.chg == 4)
			contrast.amt = -contrast.amt;
		if (contrast.chg == -4)
			contrast.amt = -contrast.amt;
		switch (contrast.chg) {
		case 1 ... 4:
			OSContrastDn();
			break;
		case -4 ... - 1:
			OSContrastUp();
			break;
		}
	}
}

void palace_collapse_erase(Sprite * s)
{
	s = s;
	persistent_sprite(s);
}

void palace_collapse_kill(Sprite * s)
{
	s = s;
}

Sprite_funcs palace_collapse_funcs =
    { palace_collapse_init, palace_collapse_run, palace_collapse_erase,
	palace_collapse_kill, sprite_draw_std,
};






/*------------------------------------------
Some standard enemy stuff
With this standard AI, coders only have to
worry about GFX and such.
-------------------------------------------*/

void shooter_a(Sprite * s)
{
	if ((player.x >= s->x) && (s->dir < 0)) {
		s->shooting = 0;
		s->data1 = 0;
	}
	if ((player.x < s->x) && (s->dir < 0) && (s->shooting == 0))
		s->shooting = 3;
	if ((player.x >= s->x) && (s->dir > 0) && (s->shooting == 0))
		s->shooting = 3;
	if ((player.x < s->x) && (s->dir > 0)) {
		s->shooting = 0;
		s->data1 = 0;
	}
	s->data1 += s->shooting;
	if (s->data1 > 12) {	//8                     
beep(277,2,VTI,hardwarever);                                                                         
		s->y -= 8;
		shooter(s);
		s->y += 16;
		shooter(s);
		s->y -= 8;
		s->shooting = -4;
	} else if (s->data1 < 0) {
		s->shooting = 3;
	}
}

void shooter_b(Sprite * s)
{
	if ((player.x >= s->x + 48) && (s->dir < 0)) {
		s->shooting = 0;
		s->data1 = 0;
		s->dir = -s->dir;
	}
	if ((player.x < s->x) && (s->dir < 0) && (s->shooting == 0))
		s->shooting = 2;
	if ((player.x >= s->x) && (s->dir > 0) && (s->shooting == 0))
		s->shooting = 2;
	if ((player.x < s->x - 48) && (s->dir > 0)) {
		s->shooting = 0;
		s->data1 = 0;
		s->dir = -s->dir;
	}
	if (s->shooting == 0)
		s->shooting = 2;
	s->data1 += s->shooting;
	if (s->data1 > 8) {
		s->y -= 8;
		if (level_num_cur == 8 && s->height == 25)
			s->y -= 8;
		shooter(s);
		s->y += 8;
		if (level_num_cur == 8 && s->height == 25)
			s->y += 8;
		s->shooting = -4;
	} else if (s->data1 < 0) {
		s->shooting = 2;
	}
}


char enemy_a(Sprite * s)
{
	short x = s->x >> 3;
	short y = s->y >> 3;
	short inwater = 0;
	char direction = 0;
	s->dy++;
	if (s->dy > 1) {

		if (s->dir < 0) {
			if (is_free(x - 1, y, 0)
			    && (inwater = is_free(x - 1, y + 1, 0))
			    && is_free(x - 1, y + 2, 2)) {
				s->x += (inwater == 2) ? 1 : s->dir;

			} else {
				s->dir = -s->dir;

			}
		} else {
			if (is_free(x + 2, y, 0)
			    && (inwater = is_free(x + 2, y + 1, 0))
			    && is_free(x + 2, y + 2, 2)) {
				s->x += (inwater == 2) ? 1 : s->dir;
			} else {
				s->dir = -s->dir;
			}
		}
		if (((s->height > 16 ? (is_free(x, y + 4, 1)) : 1)
		     && is_free(x, y + 3, 1) && is_free(x + 1, y + 3, 1))) {
			s->y += s->data0;
			if ((s->data0 <
			     ((inwater ==
			       2) ? ((level_num_cur == 11) ? 0 : 1) : 4))
			    && s->y < 96)
				++s->data0;

			if (s->dir > 1)
				--s->dir;
			if (s->dir < -1)
				++s->dir;
			s->y++;
		} else {
			if (s->major == 8) {
				mb1.jumpwait += mb1.jump;
				if (mb1.jumpwait > 15) {
					s->y -= 4;
					mb1.jumpwait++;
					mb1.jumpwait = -mb1.jumpwait;
				}
			}


			if (!is_free(x, y + 1, 1))
				s->y -= 8;
			if (s->height > 16 && (!is_free(x, y + 2, 1))
			    && s->major != 8)
				s->y -= 8;
			s->y = (s->y & ~7);
			if (mb1.jumpwait > 0 && mb1.jumpwait <= 0
			    && s->major == 8) {

				s->y += level.ySoft & 7;
				s->y &= ~7;
				s->y -= level.ySoft & 7;
				s->y += 4;
			}


			s->data0 = 0;

			if (s->dir > 0)
				s->dir = 3;
			else
				s->dir = -3;
		}
		s->dy = 0;
		s->ani_step++;
		if (s->ani_step == 4)
			s->ani_step = 0;

	}

	shooter_b(s);

	if (!(s->dir < 0)) {
		direction = 1;
	} else {
		direction = 0;
	}

	return direction;
}



//Sets items and buttons and such to be stuck to one position
void equalize_a(Sprite * s)
{

	short x = s->abs_x - level.xHard;
	short y = s->abs_y - level.yHard;

	if (x < -1 || x > 22 || y < -1 || y > 14) {	// not on screen
		return;
	}

	s->x = x << 3;
	s->y = y << 3;

	s->x += level.xSoft & 7;
	s->x &= ~7;
	s->x -= level.xSoft & 7;

	s->y += level.ySoft & 7;
	s->y &= ~7;
	s->y -= level.ySoft & 7;


}
