// C Source File
// Created 6/24/2002; 6:59:03 PM

#define USE_TI89		// Compile for TI-89
#define USE_TI92PLUS		// Compile for TI-92 Plus
#define USE_V200		// Compile for V200

#define OPTIMIZE_ROM_CALLS	// Use ROM Call Optimization
#define NO_EXIT_SUPPORT

#define MIN_AMS 101		// Compile for AMS 2.00 or higher

#define SAVE_SCREEN		// Save/Restore LCD Contents

#include <tigcclib.h>		// Include All Header Files
#include "lvlfind.h"
#include "levmenu.h"
#include "extgraph.h"
void *screens = NULL;


//These two variables are only non-zero on a 92+ and are used to center various GFX.
unsigned char xoffset;
unsigned char yoffset;


short loadgfx()
{
	SYM_ENTRY *symptr;
	void *archive;
	short i = 1;

	symptr = DerefSym(SymFind($(dukegfx)));
	if (!symptr)
		return -1;

	archive = HLock(symptr->handle);
	archive += 2;

	if (!ttarchive_valid(archive)) {
		HeapUnlock(symptr->handle);
		return -2;
	}

	short retval;
	unsigned short entry_size;
	void *memptr;

	entry_size = ttunpack_size(ttarchive_data(archive, i));
	memptr = (unsigned short *) malloc(entry_size);
	if (!memptr) {
		HeapUnlock(symptr->handle);
		return -3;
	}
	menugfx = memptr;
	retval = ttunpack_decompress(ttarchive_data(archive, i), memptr);
	if (retval) {
		HeapUnlock(symptr->handle);
		return -4;
	}

	HeapUnlock(symptr->handle);

	return 0;
}



// Main Function
void _main(void)
{
	const char *mytype = "duk";
	const char *mytype2 = "duk ";
	char *buffer = NULL;
	short int error = 1;
	FILE *f;
	INT_HANDLER old_int_1 = NULL;
	INT_HANDLER old_int_5 = NULL;
	void *kbd = kbd_queue();
	short int total = 0, exit = 0, number = 0;
	if (LoadDLL("dukedll", 141468000, 1, 00) != DLL_OK) {
		DlgMessage("ERROR", "Error loading DLL!", BT_OK, BT_NONE);
		goto leadout;
	}
	old_int_1 = GetIntVec(AUTO_INT_1);
	SetIntVec(AUTO_INT_1, DUMMY_HANDLER);
	old_int_5 = GetIntVec(AUTO_INT_5);
	SetIntVec(AUTO_INT_5, DUMMY_HANDLER);

	screens = malloc(GRAYDBUFFER_SIZE);
	if (screens == NULL)
		goto leadout;
	if (!GrayOn())
		goto leadout;
	if (loadgfx())
		goto leadout;
	GrayDBufInit(screens);
//If the calc is a 92+, set screen offsets (for some stuff to center)
	if (CALCULATOR) {
		xoffset = 40;
		yoffset = 14;
	} else {
// If a TI-89...
		xoffset = 0;
		yoffset = 0;
	}
	buffer = calloc(HOWMANY * MAXLEN, sizeof(char));
	if (buffer == NULL)
		goto leadout;
	total = findAllFilesSet(buffer, mytype, mytype2, HOWMANY);
	if (!total)
		goto leadout;
	keyscan_init();
	displaybg();
	delay(10000);
	if ((number = domenu(35, 28, buffer, total, 0)) == -1)
		exit++;

	if (!exit) {
		f = fopen("dukeext", "wb");
// we must check to see if we opened the file successfully
		if (f != NULL) {
//Writes stuff
			fwrite(buffer + number * MAXLEN,
			       sizeof(char) * MAXLEN, 1, f);
			fputc(0, f);
			fputs("dlf ", f);
			fputc(0, f);
			fputc(OTH_TAG, f);
			fclose(f);
			error = 0;
		} else {
//Error, oh well
		}

	}


      leadout:
	GrayOff();
	UnloadDLL();
	if (menugfx != NULL) {
		free(menugfx);
		menugfx = NULL;
	}
	if (buffer != NULL) {
		free(buffer);
		buffer = NULL;
	}
	if (screens != NULL) {
		free(screens);
		screens = NULL;
	}
	while (keystat.second || keystat.enter)
		keyscan();
	if (old_int_1 != NULL)
		SetIntVec(AUTO_INT_1, old_int_1);
	if (old_int_5 != NULL)
		SetIntVec(AUTO_INT_5, old_int_5);
	OSqclear(kbd);
	if (!error) {
		char *fptr, *cptr;
		unsigned short plen;
		SYM_ENTRY *SymPtr = DerefSym(SymFind(SYMSTR("duke")));
		HANDLE h;
		if (!SymPtr) {
			ST_showHelp("duke.89z not found");
			return;
		}

		h = SymPtr->handle;
		if (HeapGetLock(h)) {
			cptr = fptr = HeapDeref(h);
			h = 0;
		} else {
			cptr = fptr = HLock(h);
		}
		plen = *(short *) (cptr) + 3;
		if (SymPtr->flags.bits.archived) {
			if (!(cptr = malloc(plen))) {
				if (h)
					HeapUnlock(h);
				{
					ST_showHelp("Out of Memory");
					return;
				}
			}
			memcpy(cptr, fptr, plen);
		}
		clrscr();
		FontSetSys(F_8x10);
		printf_xy(20, 30, "Running Duke...");
		enter_ghost_space();
		EX_patch(cptr + 0x40002, cptr + plen + 0x3FFFE);
		ASM_call(cptr + 0x40002);

		if (h)
			HeapUnlock(h);
		if (cptr != fptr)
			free(cptr);
		SymDel(SYMSTR("dukeext"));
	}
}
