/*------------------------------------------*/
/*             Duke 68k v1.02               */
/*          By:   Malcolm Smith             */
/*           Stephan Effelsberg             */
/*              Michael Holt                */
/*--------------------------------------------*/
/*        Important Source Note!              */
/*--------------------------------------------*/
/* Duke 68k is dangerously close to the 64k   */
/* limit. The current compilation mode is -Os */
/* because of this. Changing this to -O2, etc */
/*    will likely cause compilation errors.   */
/*--------------------------------------------*/


#define SAVE_SCREEN
#define NO_EXIT_SUPPORT
#define USE_TI89
#define USE_TI92PLUS
#define USE_V200
#define MIN_AMS 101           // Compile for AMS 1.01 or higher

#include "all.h"

unsigned char *modules;
unsigned char *tiles;
unsigned char *attribs;
unsigned char *vidmem = NULL;
void *screens = NULL;

//These two variables are only non-zero on a 92+ and are used to center various GFX.
unsigned char xoffset;
unsigned char yoffset;

unsigned char difficulty = 1;

unsigned long episode_score = 0;

// is_loaded equals one when a save game is loaded.
short is_loaded = 0;

// This works through Auto-Int-1, as an always-going-counter.
volatile short count1;
DEFINE_INT_HANDLER(count_int_1)
{
	++count1;
}

// This works through Auto-Int-5, as an always-going-counter.
// It syncs the game loops.
volatile short count;
DEFINE_INT_HANDLER(count_int)
{
	++count;
}

void delay(short del)
{
	short start = count;
	while (count - start < del)	/* nothing */
		;
}
//=============================================================================
// VTI detection routine (thanx, Julien Muchembled)
//
// this routine utilizes a bug in VTI: you can set even non-existing flags in
// the status register and query them later!
//=============================================================================
extern short IsVTI(void);
asm("
IsVTI:
    trap   #12         /* enter supervisor mode. returns old (%sr) in %d0.w   */
    move.w #0x3000,%sr /* set a non-existing flag in %sr (but keep s-flag !!) */
    swap   %d0         /* save %d0.w content in upper part of %d0             */
    move.w %sr,%d0     /* get %sr content and check for non-existing flag     */
    btst   #12,%d0     /* this non-existing flag can only be set on the VTI   */
    bne    __VTI           
    swap   %d0         /* restore old %sr content and return 0                */
    move.w %d0,%sr
    moveq  #0,%d0
    rts
__VTI:
    swap   %d0         /* restore old %sr content and return 1                */
    move.w %d0,%sr
    moveq  #1,%d0
    rts
");

// This contains the length of the calc hardware parm block.
// 20 on HW1s, 42 on HW2s. This is used because they have
// a different contrast range. For level 10.
short hardwarever;

short VTI;

//For external levels
char extname[9] = { 0 };


static const char * const gfx_error_msg[]={
	"",
	"dukegfx.duk not found",
	"dukegfx.duk not valid archive",
	"not enough memory",
	"dukegfx.duk: unpack error",
	"Need RAM",
};

void _main(void)
{
	void *kbd = kbd_queue();
  INT_HANDLER save_int_4 = GetIntVec(AUTO_INT_4);
  INT_HANDLER save_int_1 = GetIntVec(AUTO_INT_1);
  INT_HANDLER save_int_5 = GetIntVec(AUTO_INT_5);
	int error;
	int spriteerror = 0;
	char folder[9];
	unsigned long mem = 0;
/* Checks the calculator hardware version */
	short *hwptr;
	hwptr = (short *) FL_getHardwareParmBlock();
	hardwarever = *hwptr;
	VTI=IsVTI();
	if (VTI) {
		hardwarever = 20;	// Sets VTI to be HW1 because it has a HW1 contrast range
		DlgMessage("VTI slows with sound.", "And, GFX are better on a real calc.",
			   BT_OK, BT_NONE);
	}
/*----------------------------------------*/
	FolderGetCur(folder);
// Loads the Duke DLL
	if (LoadDLL("dukedll", 141468000, 1, 00) != DLL_OK) {
		FolderCur(SYMSTR("duke"), TRUE);
		if (LoadDLL("dukedll", 141468000, 1, 00) != DLL_OK) {
			DlgMessage("ERROR", "Error loading DLL!", BT_OK,
				   BT_NONE);
			goto leadout;
		}
	}
	duke_init();
 //Directs ints to nothing
  SetIntVec(AUTO_INT_4, DUMMY_HANDLER);
  SetIntVec(AUTO_INT_5, count_int);
  //Auto Int 1 is called 350 times per second.
  SetIntVec(AUTO_INT_1, count_int_1);
//For sound
 // OSLinkOpen();

	pokeIO(0x600017, 0xB2);	// Restore normal timer speed

// Inits
	episode_score = 0;
	is_loaded = 0;
	difficulty = 0;
	sound=0;

//External level stuff
	if (SymFindPtr($(dukeext), 0) != H_NULL) {
		strcpy(extname,
		       (char *) HeapDeref(SymFindPtr($(dukeext), 0)->
					  handle) + 2);
	}

//If the calc is a 92+, set screen offsets (for some stuff to center)
	if (CALCULATOR) {
		xoffset = 40;
		yoffset = 14;
	} else {
// If a TI-89...
		xoffset = 0;
		yoffset = 0;
	}
		ClrScr();
// Check the RAM
	HeapCompress();
	mem = HeapAvail();
// If less mem is free than required...  
#define MEMADJUST 79600      
	if (mem < (159850-MEMADJUST)) {
		char buffer[30];
		FontSetSys(F_8x10);
		DrawStr(16, 8, "Out of Memory!", A_NORMAL);
		DrawStr(16, 40, "Duke 68k needs", A_NORMAL);
		DrawStr(16, 50, "159,850 bytes.", A_NORMAL);
		sprintf(buffer, "Available: %li", mem + MEMADJUST);
		DrawStr(16, 63, buffer, A_NORMAL);
		DrawStr(16,89,"Press Enter/Esc",A_NORMAL);
		keyscan();
		while (!(keystat.escape || keystat.enter))
			keyscan();
		while ((keystat.escape || keystat.enter))
			keyscan();
		goto leadout;
	}	
	if (!GrayOn())
		goto leadout;
	
	screens = malloc(GRAYDBUFFER_SIZE);
	if (screens == NULL)
		goto leadout;
	GrayDBufInit(screens);

	keyscan_init();

	ClearGrayScreen2B(GrayDBufGetHiddenPlane(0),
			  GrayDBufGetHiddenPlane(1));

// Allocate memory for sprite structures        
	sprites = (Sprite *) malloc(SPRITE_NO * sizeof(Sprite));
// Allocate memory for vidmem
	vidmem = (unsigned char *) malloc(21 * 13);
// Allocate memory for bullets
	smallshot = (Smallshot *) malloc(20 * sizeof(Smallshot));
	enemyshot = (Smallshot *) malloc(20 * sizeof(Smallshot));
	
	if (sprites == NULL || vidmem == NULL || smallshot == NULL || enemyshot == NULL) {
		spriteerror = -5;
	}
// Load stuff from dukegfx.pak
	error = loadgfx();

	if (error || spriteerror) {
		char err[80];
		if (spriteerror)
			error = -5;
		sprintf(err, "GFX Error %i: ", error);
		if(error <= -1 && error >= -5)
			strcat(err, gfx_error_msg[-error]);
		else
			strcat(err, "unknown (fatal)");
		DrawGrayStrExt(0, 47, err, A_NORMAL | A_CENTERED, F_4x6);
		delay(60);
		goto leadout;
	}

	intropref = 1;

	loadcfg();

#ifndef LEVELONLY
	if (intropref)
		intro();
#endif
	ClearGrayScreen2B(GrayDBufGetActivePlane(0),
			  GrayDBufGetActivePlane(1));
	ClearGrayScreen2B(GrayDBufGetHiddenPlane(0),
			  GrayDBufGetHiddenPlane(1));


//menus(); is the core of everything. See menu.c for more info.
	menus();



leadout:
	savecfg();
	freegfx();

	//Free sprites and vidmem and screens   and smallshot and enemyshot     
	if (sprites != NULL) {
		free(sprites);
		sprites = NULL;
	}
	if (vidmem != NULL) {
		free(vidmem);
		vidmem = NULL;
	}
	if (screens != NULL) {
		free(screens);
		screens = NULL;
	}
	if (smallshot != NULL) {
		free(smallshot);
		smallshot = NULL;
	}
	if (enemyshot != NULL) {
		free(enemyshot);
		enemyshot = NULL;
	}

	UnloadDLL();
	if (IsGrayMode())
		GrayOff();
	FolderCur(SYMSTR(folder), TRUE);
	SetIntVec(AUTO_INT_4, save_int_4);
	SetIntVec(AUTO_INT_1, save_int_1);
	SetIntVec(AUTO_INT_5, save_int_5);
 OSLinkReset();
	OSqclear(kbd);
}
