#ifndef __DRAWSTRS_H
#define __DRAWSTRS_H
// Of course, in this function, comment out what you don't need
/*===========================================================================*/
/* setup charset - draws all characters of the little and medium font set */
/* into internal buffers and uses later own sprite routines to draw them. */
/* This is a much faster way for drawing than using the DrawChar() routine. */
/*===========================================================================*/
static inline void SetupCharSet(void)
{
	unsigned short i;

// 5*256 if you only want little font, 8*256 if you want only medium font
	memset(charset, 0, 5 * 256 + 8 * 256);

// Comment out this block if you don't want F_4x6
// Little font
	FontSetSys(F_4x6);
	PortSet(charset2, 7, 5 * 256 - 1);

	for (i = 0; i < 256; i++) {
		charwidth[i] = FontCharWidth(i);
		DrawChar(0, i * 5, i, A_REPLACE);
	}

// Comment this block if you don't want F_6x8
// Medium font
	FontSetSys(F_6x8);
	PortSet(charset, 7, 8 * 256 - 1);

	for (i = 0; i < 256; i++)
		DrawChar(0, i << 3, i, A_REPLACE);

// F_8x10 is not implemented for the moment...

// Don't forget PortRestore !
	PortRestore();
}

// Other functions here...
/*===========================================================================*/
/* replaces string using own sprites (F_6x8) (much faster than DrawStr) */
/*===========================================================================*/
void NormalString(short x, short y, const unsigned char *s, void *plane)
{
	unsigned char *sprite;
	long addr;
	long addr_const = ((long) plane) + (y << 5) - (y << 1);
	unsigned short cnt;
	long mask;

	while (*s) {
		sprite = &charset[((short) (*s)) << 3];
		addr = addr_const + ((x >> 3) & 0x1e);
		cnt = 24 - (x & 15);
		mask = ~((long) (0xff) << cnt);
// unrolled loop for more speed ...
		*(long *) addr &= mask;
		*(long *) addr |= (long) (*sprite++) << cnt;
		addr += 30;
		*(long *) addr &= mask;
		*(long *) addr |= (long) (*sprite++) << cnt;
		addr += 30;
		*(long *) addr &= mask;
		*(long *) addr |= (long) (*sprite++) << cnt;
		addr += 30;
		*(long *) addr &= mask;
		*(long *) addr |= (long) (*sprite++) << cnt;
		addr += 30;
		*(long *) addr &= mask;
		*(long *) addr |= (long) (*sprite++) << cnt;
		addr += 30;
		*(long *) addr &= mask;
		*(long *) addr |= (long) (*sprite++) << cnt;
		addr += 30;
		*(long *) addr &= mask;
		*(long *) addr |= (long) (*sprite++) << cnt;
		addr += 30;
		*(long *) addr &= mask;
		*(long *) addr |= (long) (*sprite) << cnt;

		x += 6;
		s++;
	}
}

/*===========================================================================*/
/* draws string using own sprites (F_4x6) (much faster than DrawStr) */
/*===========================================================================*/
void LittleString(short x, short y, const unsigned char *s, void *plane)
{
	unsigned char *sprite;
	long addr;
	unsigned short cnt;
	short ytemp;

	while (*s) {
		sprite = &charset2[(short) (*s) * 5];

		ytemp = y;
		if ((*s) == 0x67)
			ytemp++;	// move letter 'g' one pixel down

		addr =
		    ((long) plane) + (ytemp << 5) - (ytemp << 1) +
		    ((x >> 3) & 0x1e);
		cnt = 24 - (x & 15);

// unrolled loop for more speed ...
		*(long *) addr |= (long) (*sprite++) << cnt;
		addr += 30;
		*(long *) addr |= (long) (*sprite++) << cnt;
		addr += 30;
		*(long *) addr |= (long) (*sprite++) << cnt;
		addr += 30;
		*(long *) addr |= (long) (*sprite++) << cnt;
		addr += 30;
		*(long *) addr |= (long) (*sprite) << cnt;

		x += charwidth[*s++];
	}
}

/*===========================================================================*/
/* replaces string using own sprites (about 4 times faster than DrawStr) */
/*===========================================================================*/
void FastString(short x, short y, const unsigned char *s)
{
// If you want to draw in LCD_MEM, else modify the function
	long addr_offset = ((long) LCD_MEM) + (y << 5) - (y << 1);
	long addr;
	unsigned short cnt;
	unsigned char *sprite;
	long mask;

	while (*s) {
		sprite = &charset2[(short) (*s) * 5];
		addr = addr_offset + ((x >> 3) & 0x1e);
		cnt = 24 - (x & 15);
		mask = ~((long) (0xf8) << cnt);

// unrolled loop for more speed ...
		*(long *) addr &= mask;
		*(long *) addr |= (long) (*sprite++) << cnt;
		addr += 30;
		*(long *) addr &= mask;
		*(long *) addr |= (long) (*sprite++) << cnt;
		addr += 30;
		*(long *) addr &= mask;
		*(long *) addr |= (long) (*sprite++) << cnt;
		addr += 30;
		*(long *) addr &= mask;
		*(long *) addr |= (long) (*sprite++) << cnt;
		addr += 30;
		*(long *) addr &= mask;
		*(long *) addr |= (long) (*sprite) << cnt;

		x += charwidth[*s++];
	}
}

// Globals:
unsigned char *charset = NULL;
unsigned char *charset2 = NULL;
unsigned short *charwidth = NULL;

void _main(void)
{


// Now you can use the fast drawing functions...

// The rest of your code...

// Cleanup at the end
	if (h) {
		HeapUnlock(h);
		HeapFree(h);
	}
}

#endif
