/*
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <OneWire.h>
#include <DallasTemperature.h>

#define ONE_WIRE_BUS 10

OneWire oneWire(ONE_WIRE_BUS);
DallasTemperature sensors(&oneWire);
DeviceAddress thermometer;

void setup(void)
{
  Serial.begin(115200);
  
  sensors.begin();
  sensors.getAddress(thermometer, 0);
  sensors.setResolution(thermometer, 12);
}

float getTemperature(DeviceAddress deviceAddress)
{
  sensors.requestTemperatures();
  return sensors.getTempC(deviceAddress);
}

void loop(void)
{
  float temp;
  
  if (Serial.available() > 0) {
     char c = Serial.read();
     switch (c) {
      case 'T':
       temp = getTemperature(thermometer);
       Serial.write('T');
       Serial.print(temp);
       Serial.write(';');
       break;
      default:
       Serial.print("E;");
     }
  }
  
}

