enemy = class()
bullet = class()
bombsrc = "\8\0\0\0\14\0\0\0\0\0\0\0\16\0\0\0\16\0\1\0\0\0\0\0\0\0\0\0\0\0\255\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\0\0\0\0\0\0\0\0\0\0\0\0\255\255\0\0\0\0\0\0\22\128\22\128\22\128\22\128\0\0\0\0\0\0\22\128>\174>\174\22\128\22\128\22\128\0\0\22\128>\174\255\255>\174\22\128\22\128\22\128\22\128\22\128>\174>\174\22\128\22\128\22\128\22\128\22\128\22\128\22\128\22\128\22\128\22\128\22\128\22\128\22\128\22\128\22\128\22\128\22\128\22\128\22\128\22\128\22\128\0\0\22\128\22\128\22\128\22\128\22\128\22\128\0\0\0\0\0\0\22\128\22\128\22\128\22\128\0\0\0\0"
heartsrc = "\8\0\0\0\7\0\0\0\0\0\0\0\16\0\0\0\16\0\1\0\0\0\0\128\0\128\0\0\0\128\0\128\0\128\0\0\0\128\255\255\0\252\0\128\0\252\0\252\0\196\0\128\0\128\255\255\0\252\0\252\0\252\0\252\0\196\0\128\0\128\0\252\0\252\0\252\0\252\0\252\0\196\0\128\0\0\0\128\0\252\0\252\0\252\0\196\0\128\0\0\0\0\0\0\0\128\0\196\0\196\0\128\0\0\0\0\0\0\0\0\0\0\0\128\0\128\0\0\0\0\0\0"

function enemy:init(x, y, vx, vy, v, num, dir)
	self.x = x
	self.y = y
	self.vx = vx
	self.vy = vy
	self.v = v
	self.num = num
	self.dir = dir
end

function bullet:init(x, y, vx, vy)
	self.x = x
	self.y = y
	self.vx = vx
	self.vy = vy
	self.dir = math.abs(self.x-self.vx) > math.abs(self.y-self.vy) and 1 or 2
end

function bullet:posRefresh(p)
	if not (self.vx == 0 and self.vy == 0) then
		self.x = self.x + self.vx
		self.y = self.y + self.vy
		if self.x < 0 or self.y < 0 or self.x > 330 or self.y > 220 then
			table.remove(bulletlist, p)
			self = nil
		end
	end
end

function enemy:posRefresh(p)
	if math.abs(x-self.x) <= 8 and math.abs(y-self.y) <= 8 then
		health = health - 1
		table.remove(enemlist, p)
		self = nil
		if health == 0 then
			gameover = true
			on.tabKey(true)
			if score > hi then
				hi = score
				var.store("hiscore", hi)
			end
		end
		hurt = true
		hurtstart = timer.getMilliSecCounter()
		repeat
			ouchx = math.random(280)
			ouchy = math.random(200)
		until math.abs(ouchx - x) > 50 and math.abs(ouchy - y) > 50
		return 0
	elseif self.num == 1 then
		self.vx = self.v* (x-self.x)/math.sqrt((x-self.x)*(x-self.x) + (y-self.y)*(y-self.y))
		self.vy = self.v* (y-self.y)/math.sqrt((x-self.x)*(x-self.x) + (y-self.y)*(y-self.y))

	elseif self.num == 2 then
		if self.dir == 1 then
			self.vy = 0
			self.vx = self.x-x > 0 and -self.v or self.v
			if math.abs(self.x-x) < 5 then
				self.dir = 2
			end
		elseif self.dir == 2 then
			self.vx = 0
			self.vy = self.y-y > 0 and -self.v or self.v
			if math.abs(self.y-y) < 5 then
				self.dir = 1
			end
		end
	end
	self.x = self.x + self.vx
	self.y = self.y + self.vy
end

function enemy:checkCol(p)
	for i,j in ipairs(bulletlist) do
		if math.abs(j.x - self.x) < 8 and math.abs(self.y - j.y) < 8 then
			score = score + 1
			explosions[#explosions + 1] = {self.x, self.y, 0}
			table.remove(enemlist, p)
			self = nil
			j = nil
			table.remove(bulletlist, i)
			break
		end
	end
end

function enemy:bombCheck(p)
	if math.abs(self.x - cx) < radius and math.abs(self.y - cy) < radius then
		table.remove(enemlist,p)
		self = nil
	end
end

hi = var.recall("hiscore")
if not hi then
	hi = 0
end

mode = 1
function on.paint(gc)
	--Shade background
	gc:setColorRGB(0,0,0)
	gc:fillRect(0,0,318,212)
	if not init then
		hurt = false
		pause = false
		explosions = {}
		score = 0
		bomb = image.new(bombsrc)
		heart = image.new(heartsrc)
		bombs = 3
		bombed = false
		health = 3
		gameover = false
		ticker = 0
		enemlist = {}--enemy(200,150,0,0,2,1), enemy(250,100,0,0,3,2,1)}
		bulletlist = {}
		x,y = 50,50
		timer.start(0.05)
		pressed = {}
		wave = true --True if wave is currently active
		wavenum = 0
		for i=1,9 do
			pressed[i] = 0
		end
	end

	if mode == 2 then
		--Draw Hearts/Bombs
		for i=1,health do
			gc:drawImage(heart,-5+10*i,10)
		end
		for i=1,bombs do
			gc:drawImage(bomb,-5+10*i,20)
		end
		--Draw Player
		gc:setColorRGB(255,255,255)
		if not gameover then
			gc:drawRect(x,y,8,8)
		end
		--Draw Score
		gc:drawString(score,5,40,"top")
		--Draw Announcements
		if not wave and not gameover then
			gc:drawString("Wave "..wavenum+1,150,100,"top")
		elseif gameover then
			gc:drawString("GAME OVER",110,90,"bottom")
			gc:drawString("High Score - "..hi,110,90,"top")
		end
		if pause then
			gc:drawString("Game Paused",110,90,"bottom")
		end
		--Draw Bomb Square
		if bombed then
			gc:drawRect(cx - radius, cy - radius, 2*radius, 2*radius)
		end
		
		if hurt then
			gc:drawString("OUCH",ouchx,ouchy)
		end
	end

	if mode == 1 then
		x,y = 50,170
		gc:setColorRGB(255,255,255)
		gc:setFont("sansserif","r",18)
		gc:drawString("THE SQUARES DO NOT DIE",50,60,"bottom")
		gc:setFont("sansserif","r",12)
		gc:drawString(">>  Press Enter to Begin  <<",60,100)
		gc:drawString("High Score - "..hi,110,120)
		gc:drawRect(x,y,8,8)
		gc:setFont("sansserif","r",8)
		gc:drawString("by cyanophycean314",4,210)
	end

	--Draw Bullets
	for i,j in ipairs(bulletlist) do
		gc:fillRect(j.x, j.y, 3, 3)
	end
	--Draw Mini Explosions
	for i,j in ipairs(explosions) do
		gc:drawRect(j[1] - j[3], j[2] - j[3], 2*j[3], 2*j[3])
	end
	--Draw Enemies
	for i,j in ipairs(enemlist) do
		if j.num == 1 then
			gc:setColorRGB(255,64,64)
		elseif j.num == 2 then
			gc:setColorRGB(34,139,34)
		end
		gc:fillRect(j.x, j.y, 8, 8)
	end
end

function on.timer()
	if (gameover and bombed) or (not pause and not gameover) then
		if mode == 1 then
			ticker = ticker + 1
			if ticker % 10 == 0 then
				on.charIn(6)
				enemlist[#enemlist + 1] = enemy(math.random(270,300),math.random(170,210),0,0,3,math.random(2),math.random(2))
			end
			health = 3
		end
		--ticker = ticker + 1
		for i=1, #enemlist do
			j = enemlist[i]
			if i > #enemlist then
				break
			end
			j:posRefresh(i)
			j:checkCol(i)
			if bombed then
				j:bombCheck(i)
			end
		end
		for i=1, #bulletlist do
			if i > #bulletlist then
				break
			end
			(bulletlist[i]):posRefresh(i)
		end
		--Wave generation
		if #enemlist == 0 then
			if wave then
				waveover = timer.getMilliSecCounter()
			end
			wave = false
			ended = timer.getMilliSecCounter()
			if ended - waveover >= 3000 then
				bombed = false
				wavenum = wavenum + 1
				if not gameover then
					if wavenum % 10 == 0 then
						health = health + 1
					elseif wavenum % 5 == 0 then
						bombs = bombs + 1
					end
					if wavenum > 4 then
						for i=1,wavenum-4 do
							enemygen()
						end
						for i,j in ipairs({{0,0},{0,208},{312,0},{312,208}}) do
							enemlist[#enemlist + 1] = enemy(j[1],j[2],0,0,math.random(2,4+math.floor(math.log(wavenum))),math.random(2),math.random(2))
						end
					else
						for i=1,wavenum do
							enemygen()
						end
					end
				end
				wave = true
			end
		end
		if bombed then
			radius = radius + 10
		end
		--Draw Explosions
		for i=1,#explosions do
			if i > #explosions then
				break
			end
			if explosions[i][3] + 4 > 16 then
				table.remove(explosions, i)
			else
				explosions[i][3] = explosions[i][3] + 4
			end
		end

		if hurt and timer.getMilliSecCounter() - hurtstart > 500 then
			hurt = false
		end
	end
	init = true
	platform.window:invalidate()
end

function on.escapeKey()
	init = false
	platform.window:invalidate()
end

function on.enterKey()
	if mode == 2 then
		pause = not pause
	else
		init = false
		mode = 2
		platform.window:invalidate()
	end
end

function on.charIn(key)
	if not pause and not gameover and #bulletlist < 10 then
		local num = tonumber(key)
		if num and num ~= 0 and num ~= 5 then
			pressed[num] = timer.getMilliSecCounter()
			local avx = ({-5,0,5,-7,0,7,-5,0,5})[num] - 2 + math.random(3)
			local avy = ({5,7,5,0,0,0,-5,-7,-5})[num] - 2 + math.random(3)
			--[[for i,j in ipairs(pressed) do
				for k=i+1,9 do
					if math.abs(j-pressed[k]) < 10 then
					end
				end
			end--]]
			bulletlist[#bulletlist + 1] = bullet(x, y, avx, avy)
		end
	end
end

function enemygen()
	repeat
		ax = math.random(320)
		ay = math.random(200)
	until math.abs(ax - x) > 30 and math.abs(ay - y) > 30
	enemlist[#enemlist+1] = enemy(ax, ay, 0, 0, math.random(2,4+math.floor(math.log(wavenum))), math.random(2), math.random(2))
end

function on.tabKey(abc)
	if abc or (not pause and bombs > 0 and not gameover) then
		if not abc then
			bombs = bombs - 1
		end
		bombed = true
		radius = 0
		cx, cy = x, y
	end
end

function on.arrowKey(dir)
	local prevx, prevy = x, y
	movev = math.min(12 + math.floor(math.log(wavenum)),20)
	if not gameover and not pause then
		if dir == "right" then
			x = x + movev
		elseif dir == "left" then
			x = x - movev
		elseif dir == "up" then
			y = y - movev
		elseif dir == "down" then
			y = y + movev
		end
	end
	if x < 0 or x > 318 or y < 0 or y > 212 then
		x,y = prevx,prevy
	end
end
