import java.io.*;
/*
* Java Linker -- by Mapar007
* Converts any file to a 83+/84+ program.
* 
*/
public class JLink {
//JLink source dest (optional) varname



	private static class TiChecksumWriter { //with thanks to Andy Janata, modified
		FileOutputStream fos;
		int sum = 0;
		public TiChecksumWriter(FileOutputStream f) {
			fos = f;
		}
		
		public void put(int b) throws IOException {
			sum += b;
			fos.write((byte) b);
		}
		public void writeSum() throws IOException {
			System.out.println(Integer.toHexString(sum));
			byte b;
			b = (byte)(sum & 0xFF);
			fos.write(b);
			b = (byte)(sum >> 8);
			fos.write(b);
		}


	}
	public static void main(String[] args) {
		try {
		if(args.length < 2) {
			System.out.println("Usage: JLink <source> <dest> [<varname(max 8 chrs)>]");
			System.exit(-1);
		}
		File inf = new File(args[0]); //2be able to call length();
		FileOutputStream fout = null;
		try {
		fout = new FileOutputStream(args[1]);
		}
		catch(IOException e) {
			System.err.println("ERROR: Could not open output stream to "+ args[1] + "\n Are you sure you have writing permission?");
			System.exit(1);
		}

		//write the header:
		fout.write("**TI83F*".getBytes());
		fout.write(0x1A);
		fout.write(0x0A);
		fout.write(0);
		fout.write("File linked with JLink\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00".getBytes());

		char length = (char)(inf.length() +19);
		fout.write(length & 0xFF);
		fout.write(length >> 8);
		
		TiChecksumWriter w = new TiChecksumWriter(fout);
		w.put(0x0D);
		w.put(0);
		
		//again, the length (plus the 2 size bytes)		
		w.put((int)(inf.length() + 2) & 0xFF);
		w.put((int)(inf.length() + 2) >> 8);
		w.put(6);  //prot prog

		String varname;
		if(args.length < 3) varname = args[1].substring(0, args[1].lastIndexOf(".")).toUpperCase(); //remove extension from dest filename, if no varname is given
		else {
			if(args[2].length() <= 8) varname = args[2].toUpperCase();
			else{
			varname = args[2].substring(0,8).toUpperCase();
			System.out.println("WARNING: Truncated varname "+args[2].toUpperCase() + " to " + varname);
			}
		}
		byte[] namebytes = {0,0,0,0,0,0,0,0}; //for padding
		byte[] bytes = varname.getBytes();		
		for(int i = 0; i < bytes.length; i++) {
			namebytes[i] = bytes[i];
		}
		for(int i = 0 ; i< 8; i++) w.put(namebytes[i]);
		w.put(0); //version and flag
		w.put(0);
		//DATA START

		//again, the length (plus the 2 size bytes)		
		w.put((int)(inf.length() + 2) & 0xFF);
		w.put((int)(inf.length() + 2) >> 8);
		//The internal length
		w.put((int)(inf.length()) & 0xFF);
		w.put((int)(inf.length()) >> 8);
		int curbyte;
		FileInputStream fin = null;
		try {
			fin = new FileInputStream(args[0]);
		}
		catch(IOException e){
			System.out.println("ERROR while opening file input stream to "+ args[0]+"\n Are you sure it exists?");
			System.exit(1);
		}
		while((curbyte = fin.read()) != -1) w.put(curbyte);
		//time for the checksum
		w.writeSum();
		fout.close();
		fin.close();
		System.out.println("Success!");
		}
		catch (Exception e) {
			System.err.println("Abnormal error occurred! Mail following lines to mapar007a@gmail.com");
			e.printStackTrace();
			System.exit(2);	
		}
	}

}
