//This is my very first C++ program so no laughing is needed.
//Suggestions are always welcome though. (blackhaze@thecompany.net)
//Compiled with Borland C++ I don't think this matters though
//version:2.2

#include <stdio.h>
#include <dos.h>
#define TIMAXTIME 10000
int lpt_out;

// Receive a byte from the TI
int get_ti() {
	int bit,titime=0;
	unsigned char data=0, v;
	int lpt_in = lpt_out + 1;

	for (bit=0; bit<8; bit++) {
	while ((v=inportb(lpt_in)&0x30) == 0x30) if(titime++>TIMAXTIME) return -1;
	if (v==0x10) {
		data=(data>>1)|0x80;
		outportb(lpt_out,1);
		while ((inportb(lpt_in)&0x20)==0x00) if(titime++>TIMAXTIME) return -1;
		outportb(lpt_out,3);
	} else {
		data=data>>1;
		outportb(lpt_out,2);
		while ((inportb(lpt_in)&0x10)==0x00) if(titime++>TIMAXTIME) return -1;
		outportb(lpt_out,3);
	}
	inportb(lpt_in);
	inportb(lpt_in);
	inportb(lpt_in);
	}
	return data;
}

void main(int argc, int* argv[]) {
	int ret,stop=0, portnum = 1;
	long bytes=0, totalbytes=16384;
	FILE *fptr;
	const unsigned int far *rom;

	clrscr();
	printf("--------------------------\\\n");
	printf("DumpXP v2.2               |\n");
	printf("                          |\n");
	printf("By:Nate Goergen           |\n");
	printf("blackhaze@thecompany.net  |\n");
	printf("--------------------------/\n");

	printf("Enter your parallel port number (1-3):");
	scanf("%i", &portnum); printf("\n");

	rom = (const unsigned int far *) 0x400008 + (portnum - 1); lpt_out = *rom;
	if(portnum > 3 || portnum < 1 || lpt_out == 0) {
		printf("Invalid parallel port number!!\n");
		getch();
		exit(1);
	}

	if(argc!=2){
		clrscr();
		printf("Use: dumpxp page#.bin or tixx.rom\n");
		printf("Each page = 16384 bytes\n");
		printf("ti86.rom/ti83.rom(whole rom) = 262144 bytes (5 minutes)\n");
		printf("ti82.rom/ti85.rom(whole rom) = 131072 bytes (2 minutes)\n");
		printf("ti92.rom(whole rom) = 1048576 bytes (20 minutes)\n");
		printf("       e.g.:\n");
		printf("            dumpxp ti86.rom\n");
		printf("            dumpxp page0.bin\n");
		getch();
		exit(1);
	}

	if (strcmp(argv[1], "ti83.rom") == 0) totalbytes = 262144;
	if (strcmp(argv[1], "ti86.rom") == 0) totalbytes = 262144;
	if (strcmp(argv[1], "ti82.rom") == 0) totalbytes = 131072;
	if (strcmp(argv[1], "ti85.rom") == 0) totalbytes = 131072;
	if (strcmp(argv[1], "ti92.rom") == 0)	totalbytes = 1048576;

	fptr = fopen(argv[1],"wb");
	printf("TIxx Parallel port ROM dump reciever By: Nate Goergen -ESC exits\n");
	printf("Using port %i @ 0x%x...\n\n", portnum, lpt_out);
	fflush(stdout);

	printf("Waiting...\r");
	do{
		if(kbhit() != 0 && getch() == 27) exit(1);
		ret=get_ti(lpt_out);
	}while(ret == -1);
	putc(ret, fptr);
	bytes++;

	while(stop != 1)
	{

	if(kbhit() != 0 && getch() == 27) exit(1);
	ret=get_ti(lpt_out);
	putc(ret,fptr);

	bytes++;
	printf("Byte: %ld of %ld\r",bytes,totalbytes);
	if(bytes == totalbytes) stop=1;
	fflush(stdout);
	}

	printf("\nDone!");
	fflush(stdin);
	fclose(fptr);
}

