/*
	Peter Taylor (ptaylor@oprf.org)
	24.03.96
*/

#include <string.h>
#include <stdio.h>

long fsize(char *fname) {
    FILE *fl;
    long size;
    
    if ((fl = fopen(fname,"rb")) == NULL) { return -1; }
    fseek(fl,0L,SEEK_END);
    size = ftell(fl);
    fclose(fl);

    return size;
}

char *fload(char *fname, int size) {
    FILE *fl;
    char *buff;
    int dsize;
    
    if ((buff = (char*)malloc(size)) == NULL) { return NULL; }
    if ((fl = fopen(fname,"rb")) == NULL) { return NULL; }
    if ((dsize = fread(buff,1,size,fl)) != size) { return NULL; }
    fclose(fl);

    return buff;
}

void main(int argc, char *argv[]) {
    FILE *fl;
    unsigned char *f1, *f2;
    unsigned int ofs, f1_size, f2_size;
    
    if (argc != 4) {
        printf("usage: mktable file1 file2 table.bin");
        exit(1);
    }

    f1_size = fsize(argv[1]);
    if ((f1 = fload(argv[1],f1_size)) == NULL) {
        perror("error loading file1");
    }

    f2_size = fsize(argv[2]);
    if ((f2 = fload(argv[2],f2_size)) == NULL) {
        perror("error loading file2");
    }

    if (f1_size != f2_size) {
        perror("file sizes do not match");
    }

    if ((fl = fopen(argv[3],"wb")) == NULL) {
        printf("error opening '%s'\n",argv[3]);
        exit(1);
    }
    
    for (ofs = 0; ofs < f1_size; ofs++) {
        if (f1[ofs] != f2[ofs]) { 
            if (fwrite(&ofs,sizeof(ofs),1,fl) != 1) {
                perror("error writing file");
            }
            ofs++;  /* skip next byte ... */
        }
    }
    ofs = 0xffff;
    fwrite(&ofs,sizeof(ofs),1,fl);

}

