/*
	Peter Taylor (ptaylor@oprf.org)
	24.03.96
*/

#include <stdio.h>
#include <string.h>

/* user entry call that needs to be relocated in loader program */
#define user_entry 0x1f
#define title_len 24

long fsize(char *fname) {
    FILE *fl;
    long size;
    
    if ((fl = fopen(fname,"rb")) == NULL) { return -1; }
    fseek(fl,0L,SEEK_END);
    size = ftell(fl);
    fclose(fl);

    return size;
}

char *fload(char *fname, int size) {
    FILE *fl;
    char *buff;
    int dsize;
    
    if ((buff = (char*)malloc(size)) == NULL) { return NULL; }
    if ((fl = fopen(fname,"rb")) == NULL) { return NULL; }
    if ((dsize = fread(buff,1,size,fl)) != size) { return NULL; }
    fclose(fl);

    return buff;
}

void main(int argc, char *argv[]) {
    FILE *fl;
    char *ld_buff, *user_buff;
    int *iptr, *table_buff;
    unsigned int ld_size, user_size, table_size;
    int i,rel,ofs;
    
    if (argc != 4) {
        printf("usage: mkbin user.obj table.bin new.obj");
        exit(1);
    }

    ld_size = fsize("loader.obj");
    if ((ld_buff = fload("loader.obj",ld_size)) == NULL) {
        perror("error loading 'loader.obj'");
    }

    user_size = fsize(argv[1]);
    if ((user_buff = fload(argv[1],user_size)) == NULL) {
        perror("error loading the user file");
    }
    
    table_size = fsize(argv[2]);
    if ((table_buff = (int*)fload(argv[2],table_size)) == NULL) {
        perror("error loading relocation table file");
    }

    /* copy title */
    i = strlen(user_buff);
    if (i > title_len) { i = title_len; }
    memcpy(ld_buff,user_buff,i);
    
    /* offset call to user_entry */
    ld_buff[user_entry] = (ld_size+table_size) & 0xff;
    ld_buff[user_entry+1] = (ld_size+table_size) >> 8;
    
    fl = fopen(argv[3],"wb");
    fwrite(ld_buff,sizeof(char),ld_size,fl);

    /* relocate stuff in user binary & relocation table ... */
    rel = (ld_size+table_size) - strlen(user_buff) - 1;
    for (i = 0; i < (table_size/2)-1; i++) {
        ofs = (int)table_buff[i];
        iptr = (int*)(user_buff+ofs);

        /* ... very much a hack ... ah well ...  */
        if (*iptr >= strlen(user_buff)) {
            *iptr += rel;
        }
        table_buff[i] += rel;
    }
    
    fwrite(table_buff,sizeof(char),table_size,fl); 
    user_size -= strlen(user_buff) + 1;
    fwrite(strchr(user_buff,0)+1,sizeof(char),user_size,fl);
    
    return;
}
                          
