; Peter Taylor (ptaylor@oprf.org)
; 24.03.96
;
; zshell relocatable binary loader
; 
; Thanks to Christopher Busch (cbusch@d.umn.edu) who wrote
; 98% of this code (relocation functions w/minor modifications by me ...)

#include "ti-85.h"
.org 0
.db "                        ",0    ; 24 blank spaces

        CALL_(link)
rel1:   call 0              ; needs to be filled in
rel2:   jp unlink

;; CALL_(link)
;; CALL_(unlink)
;;this function will locate your program
link:
      xor a
      jr loadlink
unlink:
      ld a,1
loadlink:
      ld hl,relocate_table
      ld  bc,(PROGRAM_ADDR)
      add hl,bc
      or a
      jr z,relocatelp

      ld  a,b ;;  need to make bc negative to fix back
      neg
      dec a
      ld  b,a
      ld  a,c
      neg
      ld  c,a

relocatelp:
      ld  e,(hl)  ;;de is table entry
      inc hl
      ld  d,(hl)
      inc hl        ;;hl now points to next table entry
      
      ld  a,$FF     ;;$FFFF is the end of the table marker
      cp  d
      ret z ;;exit function if address is $FFFF ie end of table
      
      push hl
      ld  hl,(PROGRAM_ADDR)
      add hl,de   ;;hl now points to code spot
      push hl
      ld  e,(hl)
      inc hl
      ld  d,(hl)  ;;de contains relative load address
      ld h,b
      ld l,c
      add hl,de   
      ex de,hl    ;;de now contains absolute pointer address
      pop hl      ;; hl points to code spot
      ld  (hl),e
      inc hl
      ld  (hl),d
      pop hl   ;;restore table pointer
      jr relocatelp
;;end of relocate

relocate_table:     ; end of loader
    .dw rel1+1
    .dw rel2+1

.END

