plotLine:
 ld a,b
 cp d
 jr c,drawLine

 ld b,d
 ld d,a
 ld a,e
 ld e,c
 ld c,a

drawLine:

 ; bc to de, with b = x, c = y

 ; y = mx + b

 ; if |x1-x0| > |y1 - y0|

 xor a
 ld (extraY),a
 ld (slopeSign),a

 ld a,e
 cp c
 jr nc,negativeSlope

 ld a,1
 ld (slopeSign),a
 ld a,c
 sub e
 jr endPosSlope

negativeSlope:
 sub c		; |y1 - y0|
endPosSlope:
 ld h,a

 ld a,d		; |x1 - x0|
 sub b
 or a
 jp z,drawVerticalLine

 ld l,a
 ld (absY),a

 push af
 push bc

  call divhbyl	; e = (y1-y0)/(x1-x0), or the slope :)

  ld a,e
  ld (slope),a

  ld a,h
  ld (slope+1),a
 pop bc

 pop af
 ld e,a
plotItLoop:
 push de

 call putPoint

 inc b		; x is normal
 ld a,b
 cp 97			; check bounds (good for outside of the screen use).
 jr nc,exitPlotLoop
 ld a,c
 cp 65
 jr nc,exitPlotLoop

 ld a,(absY)
 ld e,a
 ld a,(extraY)
 ld d,a
 ld a,(remainder)
 add a,d
 cp e
 jr c,skipIncreaseExtraY

 sub e
 push af
  ld a,(slopeSign)
  or a
  jr z,negativeYchange
 pop af
 dec c
 jr returnFromPositiveYchange

negativeYchange:
 pop af
 inc c
returnFromPositiveYchange:
 push af
  call putPoint
 pop af

skipIncreaseExtraY:
 ld (extraY),a

 ld a,(slope)
 or a
 jr z,skipPlotYloop

 ld d,a
plotYloop:
 ld a,(slopeSign)
 or a
 jr z,plotPositiveSlope
 dec c
 jr plotSlope

plotPositiveSlope:
 inc c
plotSlope:
 push de
 call putPoint
 pop de
 dec d
 jr nz,plotYloop
 jr skipPlotTwice

skipPlotYloop:
  call putPoint
skipPlotTwice:
 pop de

 dec e
 jr nz,plotItLoop
 ret

exitPlotLoop:
 pop de
 ret

drawVerticalLine:
 ld a,e
 cp c
 jr c,drawVerticalLoop

 ld c,e
drawVerticalLoop:
 push hl
  push bc
   call putPoint
  pop bc
  dec c
 pop hl
 dec h
 jr nz,drawVerticalLoop
 ret

putPoint:
 ld a,c
 cp 65
 ret nc
 ld e,c

 ld a,b

putPixel:
 push bc
 ld d,0
 ld hl,0
 add hl,de
 add hl,de
 add hl,de
 add hl,hl
 add hl,hl		; de * 12
 
 push af
 srl a
 srl a
 srl a			; x/8
 ld e,a
 add hl,de
 ld de,plotsscreen	; 8e29h on 83
 add hl,de		; hl = location we want to paint at
 pop af
 
 ld c,%10000000

 and %111
 or a
 jr z,skipGetPixelBit

 ld b,a			; 0-7
getPixelBitLoop:
 rrc c
 djnz getPixelBitLoop

skipGetPixelBit:
 ld a,(hl)
 or c
 ld (hl),a
 pop bc
 ret
