/*****************************************************************************/
/*                                                                           */
/* compile with: tigcc -O2 testtse.c                                         */
/*                                                                           */
/*****************************************************************************/

#include <system.h>
#include <statline.h>
#include <kbd.h>
#include <stdio.h>
#include <string.h>
#include <sprites.h>
#include "tse.h"

short _ti89;
short _ti92plus;


/*===========================================================================*/
/* testing monochrome Sprite8_XXX functions ...                              */
/*===========================================================================*/
short Test8() {
    unsigned long  measure_val;
    char           tmpstr[100];
    short          x,y;
    unsigned char  spritedata[8] = {0xaa,0x55,0xaa,0x55,0xaa,0x55,0xaa,0x55};
    long           count;
    
    //-------------------------------------------------------------------------
    // original sprite functions
    //-------------------------------------------------------------------------
    count = 0;
    memset((void *)0x4C00,0,3840);

    OSFreeTimer(USER_TIMER);
    OSRegisterTimer(USER_TIMER,1000);
    OSTimerRestart(USER_TIMER);

    for (y=0;y<100-8;y++) {
        for (x=0;x<160-8;x++) {
            count++;
            Sprite8(x,y,8,spritedata,(void *)0x4C00,SPRT_AND);
            Sprite8(x,y,8,spritedata,(void *)0x4C00,SPRT_OR);
        }
    }

    measure_val = OSTimerCurVal(USER_TIMER);
    OSFreeTimer(USER_TIMER);
    sprintf(tmpstr,"orig8=%lu tics for %ld sprites",(1000-measure_val)*50,count);
    ST_showHelp(tmpstr);
    if (ngetchx() == KEY_ESC) return KEY_ESC;


    //-------------------------------------------------------------------------
    // modified sprite functions using separate and/or 
    //-------------------------------------------------------------------------
    count = 0;
    memset((void *)0x4C00,0,3840);

    OSFreeTimer(USER_TIMER);
    OSRegisterTimer(USER_TIMER,1000);
    OSTimerRestart(USER_TIMER);

    for (y=0;y<100-8;y++) {
        for (x=0;x<160-8;x++) {
            count++;
            Sprite8_AND(x,y,8,spritedata,(void *)0x4C00);
            Sprite8_OR(x,y,8,spritedata,(void *)0x4C00);
        }
    }

    measure_val = OSTimerCurVal(USER_TIMER);
    OSFreeTimer(USER_TIMER);
    sprintf(tmpstr,"%lu tics for %ld sprites",(1000-measure_val)*50,count);
    ST_showHelp(tmpstr);
    if (ngetchx() == KEY_ESC) return KEY_ESC;

    //-------------------------------------------------------------------------
    // modified sprite functions using just one call
    //-------------------------------------------------------------------------

    count = 0;
    memset((void *)0x4C00,0,3840);

    OSFreeTimer(USER_TIMER);
    OSRegisterTimer(USER_TIMER,1000);
    OSTimerRestart(USER_TIMER);

    for (y=0;y<100-8;y++) {
        for (x=0;x<160-8;x++) {
            count++;
            Sprite8_MASK(x,y,8,spritedata,spritedata,(void *)0x4C00);
        }
    }

    measure_val = OSTimerCurVal(USER_TIMER);
    OSFreeTimer(USER_TIMER);
    sprintf(tmpstr,"%lu tics for %ld sprites",(1000-measure_val)*50,count);
    ST_showHelp(tmpstr);
    return ngetchx();
}


/*===========================================================================*/
/* testing monochrome Sprite16_XXX functions ...                             */
/*===========================================================================*/
short Test16() {
    unsigned long  measure_val;
    char           tmpstr[100];
    short          x,y;
    unsigned short spritedata[8] = {0xaaaa,0x5555,0xaaaa,0x5555,0xaaaa,0x5555,0xaaaa,0x5555};
    long           count;
    
    //-------------------------------------------------------------------------
    // original sprite functions
    //-------------------------------------------------------------------------
    count = 0;
    memset((void *)0x4C00,0,3840);

    OSFreeTimer(USER_TIMER);
    OSRegisterTimer(USER_TIMER,1000);
    OSTimerRestart(USER_TIMER);

    for (y=0;y<100-8;y++) {
        for (x=0;x<160-16;x++) {
            count++;
            Sprite16(x,y,8,spritedata,(void *)0x4C00,SPRT_AND);
            Sprite16(x,y,8,spritedata,(void *)0x4C00,SPRT_OR);
        }
    }

    measure_val = OSTimerCurVal(USER_TIMER);
    OSFreeTimer(USER_TIMER);
    sprintf(tmpstr,"orig16=%lu tics for %ld sprites",(1000-measure_val)*50,count);
    ST_showHelp(tmpstr);
    if (ngetchx() == KEY_ESC) return KEY_ESC;


    //-------------------------------------------------------------------------
    // modified sprite functions using separate and/or 
    //-------------------------------------------------------------------------
    count = 0;
    memset((void *)0x4C00,0,3840);

    OSFreeTimer(USER_TIMER);
    OSRegisterTimer(USER_TIMER,1000);
    OSTimerRestart(USER_TIMER);

    for (y=0;y<100-8;y++) {
        for (x=0;x<160-16;x++) {
            count++;
            Sprite16_AND(x,y,8,spritedata,(void *)0x4C00);
            Sprite16_OR(x,y,8,spritedata,(void *)0x4C00);
        }
    }

    measure_val = OSTimerCurVal(USER_TIMER);
    OSFreeTimer(USER_TIMER);
    sprintf(tmpstr,"%lu tics for %ld sprites",(1000-measure_val)*50,count);
    ST_showHelp(tmpstr);
    if (ngetchx() == KEY_ESC) return KEY_ESC;

    //-------------------------------------------------------------------------
    // modified sprite functions using just one call
    //-------------------------------------------------------------------------

    count = 0;
    memset((void *)0x4C00,0,3840);

    OSFreeTimer(USER_TIMER);
    OSRegisterTimer(USER_TIMER,1000);
    OSTimerRestart(USER_TIMER);

    for (y=0;y<100-8;y++) {
        for (x=0;x<160-16;x++) {
            count++;
            Sprite16_MASK(x,y,8,spritedata,spritedata,(void *)0x4C00);
        }
    }

    measure_val = OSTimerCurVal(USER_TIMER);
    OSFreeTimer(USER_TIMER);
    sprintf(tmpstr,"%lu tics for %ld sprites",(1000-measure_val)*50,count);
    ST_showHelp(tmpstr);
    return ngetchx();
}


/*===========================================================================*/
/* testing monochrome Sprite32_XXX functions ...                             */
/*===========================================================================*/
short Test32() {
    unsigned long  measure_val;
    char           tmpstr[100];
    short          x,y;
    unsigned long spritedata[8] = {0xaaaaaaaa,0x55555555,0xaaaaaaaa,0x55555555,
                                   0xaaaaaaaa,0x55555555,0xaaaaaaaa,0x55555555};
    long           count;
    
    //-------------------------------------------------------------------------
    // original sprite functions
    //-------------------------------------------------------------------------
    count = 0;
    memset((void *)0x4C00,0,3840);

    OSFreeTimer(USER_TIMER);
    OSRegisterTimer(USER_TIMER,1000);
    OSTimerRestart(USER_TIMER);

    for (y=0;y<100-8;y++) {
        for (x=0;x<160-32;x++) {
            count++;
            Sprite32(x,y,8,spritedata,(void *)0x4C00,SPRT_AND);
            Sprite32(x,y,8,spritedata,(void *)0x4C00,SPRT_OR);
        }
    }

    measure_val = OSTimerCurVal(USER_TIMER);
    OSFreeTimer(USER_TIMER);
    sprintf(tmpstr,"orig32=%lu tics for %ld sprites",(1000-measure_val)*50,count);
    ST_showHelp(tmpstr);
    if (ngetchx() == KEY_ESC) return KEY_ESC;


    //-------------------------------------------------------------------------
    // modified sprite functions using separate and/or 
    //-------------------------------------------------------------------------
    count = 0;
    memset((void *)0x4C00,0,3840);

    OSFreeTimer(USER_TIMER);
    OSRegisterTimer(USER_TIMER,1000);
    OSTimerRestart(USER_TIMER);

    for (y=0;y<100-8;y++) {
        for (x=0;x<160-32;x++) {
            count++;
            Sprite32_AND(x,y,8,spritedata,(void *)0x4C00);
            Sprite32_OR(x,y,8,spritedata,(void *)0x4C00);
        }
    }

    measure_val = OSTimerCurVal(USER_TIMER);
    OSFreeTimer(USER_TIMER);
    sprintf(tmpstr,"%lu tics for %ld sprites",(1000-measure_val)*50,count);
    ST_showHelp(tmpstr);
    if (ngetchx() == KEY_ESC) return KEY_ESC;

    //-------------------------------------------------------------------------
    // modified sprite functions using just one call
    //-------------------------------------------------------------------------

    count = 0;
    memset((void *)0x4C00,0,3840);

    OSFreeTimer(USER_TIMER);
    OSRegisterTimer(USER_TIMER,1000);
    OSTimerRestart(USER_TIMER);

    for (y=0;y<100-8;y++) {
        for (x=0;x<160-32;x++) {
            count++;
            Sprite32_MASK(x,y,8,spritedata,spritedata,(void *)0x4C00);
        }
    }

    measure_val = OSTimerCurVal(USER_TIMER);
    OSFreeTimer(USER_TIMER);
    sprintf(tmpstr,"%lu tics for %ld sprites",(1000-measure_val)*50,count);
    ST_showHelp(tmpstr);
    if (ngetchx() == KEY_ESC) return KEY_ESC;
}


/*===========================================================================*/
/* just a simple demo program to measure the performance gain ...            */
/*===========================================================================*/
void _main() {
    char backscreen[3840];    
    short retval;

    memcpy(backscreen,(void *)0x4C00,3840);
    retval = Test8();
    if (retval != KEY_ESC) retval=Test16();
    if (retval != KEY_ESC) retval=Test32();
    memcpy((void *)0x4C00,backscreen,3840);
}
    