    include "92plus.h" ; This include file contains the ROM functions
    include "util.h" ; This include file allows access to the UTIL library.
                     ; This library includes the keyboard input and clear
                     ; screen functions.

    xdef _main          ; This line tells the assembler that a _main
                        ; function exists and execution will start at it.
                        ; Not including this line will cause execution to
                        ; always start at the first instruction.
    xdef _comment       ; This line tells the assembler that a program
                        ; comment exists.

_main:
    ; Execution will start here, at the _main label
    jsr      util::clr_scr          ; clear the screen
    move.w   #4,-(a7)               ; move the first param to the stack
    lea      string(pc),a0          ; move adress of string to the stack
    move.l   a0,-(a7)
    move.w   #0,-(a7)               ; push position
    move.w   #0,-(a7)               ; push position
    jsr      tios::DrawStrXY        ; call the DrawStrXY ROM function
    add.l    #10,a7                 ; restore the stack pointer
    jsr      util::idle_loop        ; library routine which waits until a key
                                    ; is pressed.
    rts

string:
    dc.b "Hello, World!",0
_comment:
    dc.b "Hello World example",0

    end
