// Links an AmigaDOS object file and outputs a raw .BIN image with
// the PlusShell format.
// Written by Rusty Wagner for PlusShell

#include <stdio.h>
#include "progstub.h"
#include "libstub.h"

#define PROGRAM 0
#define LIBRARY 1

unsigned char buf[65536];
int relocSize=0;
unsigned short relocBuf[32768];
char str[64];
int funcCount=0;
unsigned short funcOfs[1024];
int mainOfs,commentOfs;
int stubLen,stubStart;
int libCount=0;
unsigned char libName[32][8];
int libRelCount[32];
unsigned short libRelOfs[32][2048];
unsigned short libRelNum[32][2048];
int romCount=0;
unsigned short romOfs[16384];
unsigned short romNum[16384];

unsigned long ReadDWord(FILE *fp)
{
        unsigned long val;
        val=fgetc(fp)<<24;
        val|=fgetc(fp)<<16;
        val|=fgetc(fp)<<8;
        val|=fgetc(fp);
        return val;
}

int GetLibNum(char *str)
{
        unsigned char buf[8];
        int i,j,find;

        for (i=0;i<8;i++) buf[i]=0;
        for (i=0;str[i]!='@';i++) buf[i]=str[i];
        for (find=-1,i=0;i<libCount;i++)
        {
                for (j=0;j<8;j++)
                {
                        if (buf[j]!=libName[i][j])
                                break;
                }
                if (j==8)
                {
                        find=i;
                        break;
                }
        }
        if (find!=-1)
                return find;
        for (i=0;i<8;i++) libName[libCount][i]=buf[i];
        libRelCount[libCount]=0;
        libCount++;
        return libCount-1;
}

int GetLibFunc(char *str)
{
        int i;

        sscanf(&str[strlen(str)-4],"%X",&i);
        return i;
}

int main(int argc,char *argv[])
{
        FILE *fp,*out;
        char str[256];
        int len,i,j,ofs,type,k,lib,fnc;

        if (argc<2)
        {
                printf("Usage: MAKEBIN ObjectName (without extension)\n");
                return 1;
        }
        sprintf(str,"%s.o",argv[1]);
        fp=fopen(str,"rb");
        sprintf(str,"%s.bin",argv[1]);
        out=fopen(str,"wb");
        fseek(fp,0x18,SEEK_SET);
        len=ReadDWord(fp)<<2;
        for (i=0;i<len;i++)
                buf[i]=fgetc(fp);
        k=ReadDWord(fp);
        if (k==0x3ec)
        {
                relocSize=ReadDWord(fp)<<1;
                ReadDWord(fp);
                for (i=0;i<relocSize;i+=2)
                {
                        ofs=ReadDWord(fp);
                        relocBuf[i]=(buf[ofs+2]<<8)+buf[ofs+3];
                        relocBuf[i+1]=ofs;
                }
                ReadDWord(fp);
                k=ReadDWord(fp);
        }
        else
                relocSize=0;
        type=PROGRAM;
        libCount=0;
        romCount=0;
        if (k==0x3ef)
        {
                funcCount=0;
                while (1)
                {
                        k=ReadDWord(fp);
                        if (!(k&0x1000000)) break;
                        if (k&0x80000000)
                        {
                                k&=0xffff;
                                for (i=0;k;k--)
                                {
                                        str[i++]=fgetc(fp);
                                        str[i++]=fgetc(fp);
                                        str[i++]=fgetc(fp);
                                        str[i++]=fgetc(fp);
                                }
                                str[i++]=0;
                                if (!strncmp(str,"_ROM_CALL_",10))
                                {
                                        sscanf(&str[10],"%X",&j);
                                        k=ReadDWord(fp);
                                        for (i=0;i<k;i++)
                                        {
                                                romOfs[romCount]=ReadDWord(fp);
                                                romNum[romCount++]=j;
                                        }
                                        continue;
                                }
                                if (strlen(str)<=4)
                                {
                                        printf("Undefined symbol '%s'\n",str);
                                        return 1;
                                }
                                if (str[strlen(str)-5]!='@')
                                {
                                        printf("Undefined symbol '%s'\n",str);
                                        return 1;
                                }
                                lib=GetLibNum(str);
                                fnc=GetLibFunc(str);
                                k=ReadDWord(fp);
                                for (i=0;i<k;i++)
                                {
                                        libRelOfs[lib][libRelCount[lib]]=ReadDWord(fp);
                                        libRelNum[lib][libRelCount[lib]]=fnc;
                                        libRelCount[lib]++;
                                }
                        }
                        else
                        {
                                k&=0xffff;
                                for (i=0;k;k--)
                                {
                                        str[i++]=fgetc(fp);
                                        str[i++]=fgetc(fp);
                                        str[i++]=fgetc(fp);
                                        str[i++]=fgetc(fp);
                                }
                                str[i++]=0;
                                ofs=ReadDWord(fp);
                                if (!strcmp(str,"_library"))
                                        type=LIBRARY;
                                if (!strcmp(str,"_main"))
                                        mainOfs=ofs;
                                if (!strcmp(str,"_comment"))
                                        commentOfs=ofs;
                                if (strlen(str)>4)
                                {
                                        if (str[strlen(str)-5]=='@')
                                                funcOfs[funcCount++]=ofs;
                                }
                        }
                }
        }
        if (type==PROGRAM)
        {
                stubLen=20+progStubLen+(libCount<<3)+(romCount<<2);
                for (i=0;i<libCount;i++)
                {
                        stubLen+=2;
                        stubLen+=libRelCount[i]<<2;
                }
                stubStart=stubLen-4-progStubLen;
                fputc(0x60,out); fputc(0,out);
                fputc(((stubStart-2)>>8)&0xff,out);
                fputc((stubStart-2)&0xff,out);
                fputc('P',out); fputc('S',out); fputc('v',out); fputc('0',out);
                fputc(0,out); fputc('P',out);
                fputc(((commentOfs+stubLen)>>8)&0xff,out);
                fputc((commentOfs+stubLen)&0xff,out);
                fputc((romCount>>8)&0xff,out); fputc(romCount&0xff,out);
                for (i=0;i<romCount;i++)
                {
                        romOfs[i]+=stubLen;
                        fputc((romOfs[i]>>8)&0xff,out);
                        fputc(romOfs[i]&0xff,out);
                        fputc((romNum[i]>>8)&0xff,out);
                        fputc(romNum[i]&0xff,out);
                }
                fputc((libCount>>8)&0xff,out); fputc(libCount&0xff,out);
                for (i=0;i<libCount;i++)
                {
                        for (j=0;j<8;j++)
                                fputc(libName[i][j],out);
                        fputc((libRelCount[i]>>8)&0xff,out);
                        fputc(libRelCount[i]&0xff,out);
                        for (j=0;j<libRelCount[i];j++)
                        {
                                libRelOfs[i][j]+=stubLen;
                                fputc((libRelOfs[i][j]>>8)&0xff,out);
                                fputc(libRelOfs[i][j]&0xff,out);
                                fputc((libRelNum[i][j]>>8)&0xff,out);
                                fputc(libRelNum[i][j]&0xff,out);
                        }
                }
                for (i=0;i<progStubLen;i++)
                        fputc(progStub[i],out);
                fputc(0x60,out); fputc(0,out);
                fputc(((mainOfs+2)>>8)&0xff,out);
                fputc((mainOfs+2)&0xff,out);
                for (i=0;i<len;i++)
                        fputc(buf[i],out);
                fputc(0,out); fputc(0,out);
                for (i=0;i<relocSize;i++)
                {
                        relocBuf[i]+=stubLen;
                        fputc((relocBuf[i]>>8)&0xff,out);
                        fputc(relocBuf[i]&0xff,out);
                }
                fputc(0,out); fputc(0,out);
                fputc(((stubStart+6)>>8)&0xff,out);
                fputc((stubStart+6)&0xff,out);
        }
        else
        {
                stubLen=20+libStubSize+(funcCount<<1)+(romCount<<2)+(libCount<<3);
                for (i=0;i<libCount;i++)
                {
                        stubLen+=2;
                        stubLen+=libRelCount[i]<<2;
                }
                fputc(0x60,out); fputc(0,out);
                fputc(((stubLen-2-libStubSize)>>8)&0xff,out);
                fputc((stubLen-2-libStubSize)&0xff,out);
                fputc('P',out); fputc('S',out); fputc('v',out); fputc('0',out);
                fputc(0,out); fputc('L',out);
                fputc(0x60,out); fputc(0,out);
                fputc(((stubLen-16)>>8)&0xff,out);
                fputc((stubLen-16)&0xff,out);
                fputc((funcCount>>8)&0xff,out);
                fputc(funcCount&0xff,out);
                for (i=0;i<funcCount;i++)
                {
                        fputc(((funcOfs[i]+stubLen)>>8)&0xff,out);
                        fputc((funcOfs[i]+stubLen)&0xff,out);
                }
                fputc((romCount>>8)&0xff,out); fputc(romCount&0xff,out);
                for (i=0;i<romCount;i++)
                {
                        romOfs[i]+=stubLen;
                        fputc((romOfs[i]>>8)&0xff,out);
                        fputc(romOfs[i]&0xff,out);
                        fputc((romNum[i]>>8)&0xff,out);
                        fputc(romNum[i]&0xff,out);
                }
                fputc((libCount>>8)&0xff,out); fputc(libCount&0xff,out);
                for (i=0;i<libCount;i++)
                {
                        for (j=0;j<8;j++)
                                fputc(libName[i][j],out);
                        fputc((libRelCount[i]>>8)&0xff,out);
                        fputc(libRelCount[i]&0xff,out);
                        for (j=0;j<libRelCount[i];j++)
                        {
                                libRelOfs[i][j]+=stubLen;
                                fputc((libRelOfs[i][j]>>8)&0xff,out);
                                fputc(libRelOfs[i][j]&0xff,out);
                                fputc((libRelNum[i][j]>>8)&0xff,out);
                                fputc(libRelNum[i][j]&0xff,out);
                        }
                }
                for (i=0;i<libStubSize;i++)
                        fputc(libStub[i],out);
                for (i=0;i<len;i++)
                        fputc(buf[i],out);
                fputc(0,out); fputc(0,out);
                for (i=0;i<relocSize;i++)
                {
                        relocBuf[i]+=stubLen;
                        fputc((relocBuf[i]>>8)&0xff,out);
                        fputc(relocBuf[i]&0xff,out);
                }
        }
        fclose(fp); fclose(out);
        return 0;
}

