// Make9XZ makes a .9XZ (92+ ASM program) file out of a raw .BIN file
// Written by Rusty Wagner for PlusShell

#include <stdio.h>
#include <io.h>

unsigned char buf[65536];

int main(int argc,char *argv[])
{
        char str[256];
        FILE *fp,*out;
        int len,i,csum;

        if (argc<2)
        {
                printf("Usage: MAKE9XZ ProgramName (Do not include extension)\n");
                return 1;
        }
        sprintf(str,"%s.bin",argv[1]);
        fp=fopen(str,"rb");
        if (!fp)
        {
                printf("Binary code file %s could not be found\n",str);
                return 1;
        }
        len=filelength(fileno(fp));
        for (i=0;i<len;i++)
                buf[i]=fgetc(fp);
        fclose(fp);
        sprintf(str,"%s.9xz",argv[1]);
        out=fopen(str,"wb");
        fprintf(out,"**TI92P*");
        fputc(1,out); fputc(0,out);
        fprintf(out,"main");
        fputc(0,out); fputc(0x8b,out); fputc(0x76,out); fputc(0xa,out);
        fputc(0,out); fputc(0,out); fputc(0,out); fputc(0,out);
        fputc(0,out); fputc(0,out); fputc(0,out); fputc(0,out);
        fputc(0,out); fputc(0,out); fputc(0,out); fputc(0,out);
        fputc(0,out); fputc(0,out); fputc(0,out); fputc(0,out);
        fputc(0,out); fputc(0,out); fputc(0,out); fputc(0,out);
        fputc(0,out); fputc(0,out); fputc(0,out); fputc(0,out);
        fputc(0,out); fputc(0,out); fputc(0,out); fputc(0,out);
        fputc(0,out); fputc(0,out); fputc(0,out); fputc(0,out);
        fputc(0,out); fputc(0,out); fputc(0,out); fputc(0,out);
        fputc(0,out); fputc(0,out); fputc(0,out); fputc(0,out);        
        fputc(1,out); fputc(0,out); fputc(0x52,out); fputc(0,out);
        fputc(0,out); fputc(0,out);
        for (i=0;i<8;i++)
                fputc(argv[1][i],out);
        fputc(0x21,out); fputc(0,out); fputc(0,out); fputc(0,out);
        fputc((len+0x5b)&0xff,out);
        fputc((len+0x5b)>>8,out);
        fputc(0,out); fputc(0,out);
        fputc(0xa5,out); fputc(0x5a,out); fputc(0,out); fputc(0,out);
        fputc(0,out); fputc(0,out);
        fputc((len+1)>>8,out);
        fputc((len+1)&0xff,out);
        csum=(len+1)&0xff;
        csum+=(len+1)>>8;
        for (i=0;i<len;i++)
        {
                fputc(buf[i],out);
                csum+=buf[i];
        }
        fputc(0xf3,out);
        csum+=0xf3;
        fputc(csum&0xff,out);
        fputc((csum>>8)&0xff,out);
        fclose(fp);
        fclose(out);
}

