        include "92plus.h"
        include "util.h"

        xdef _main
        xdef _comment
        xdef _ti92plus
        xdef _ti89

_main:
        move.b CALCULATOR,_CALCULATOR
        cmp.b #CALC_TI89,CALCULATOR
        bne notti89
        move.w #0,textfont
        move.w #6,textheight
        move.w #1,titlefont
        move.w #14,titleheight
        move.w #40,namewidth
        move.w #6,fontwidth
        move.w #160,_LCD_WIDTH
        move.w #100,_LCD_HEIGHT
        bra calctestdone
notti89:
        move.w #1,textfont
        move.w #8,textheight
        move.w #2,titlefont
        move.w #16,titleheight
        move.w #54,namewidth
        move.w #8,fontwidth
        move.w #240,_LCD_WIDTH
        move.w #128,_LCD_HEIGHT
calctestdone:
        move.w FOLDER_LIST_HANDLE,currentfolder
        move.w #0,infolder
        move.w #0,first
        move.w #12,last
        bsr DrawFolder
        bsr Select
;        clr.w emu89
;        clr.w util::emu89
;        clr.w util::override89
;        clr.w util::alwaysemu89
        rts

DrawFolder:
        move.w _LCD_HEIGHT,-(a7)
        sub.w #8,(a7)
        move.w _LCD_WIDTH,-(a7)
        sub.w #1,(a7)
        move.w #0,-(a7)
        move.w #0,-(a7)
        jsr util::erase_rect
        add.l #8,a7
        move.w titlefont,-(a7)
        jsr tios::FontSetSys
        add.l #2,a7
        move.w titleheight,-(a7)
        move.w _LCD_WIDTH,-(a7)
        sub.w #1,(a7)
        move.w #0,-(a7)
        move.w #0,-(a7)
        jsr util::frame_rect
        add.l #8,a7
        move.w _LCD_HEIGHT,-(a7)
        sub.w #7,(a7)
        move.w namewidth,-(a7)
        move.w titleheight,-(a7)
        move.w #0,-(a7)
        jsr util::frame_rect
        add.l #8,a7
        move.w _LCD_HEIGHT,-(a7)
        sub.w #7,(a7)
        move.w _LCD_WIDTH,-(a7)
        sub.w #1,(a7)
        move.w titleheight,-(a7)
        move.w namewidth,-(a7)
        jsr util::frame_rect
        add.l #8,a7
        move.w #2,-(a7)
        move.l #shellname,-(a7)
        move.w #4,-(a7)
        move.w #4,-(a7)
        jsr tios::DrawStrXY
        add.l #10,a7
        move.l #version,-(a7)
        jsr tios::strlen
        add.l #4,a7
        move.w #2,-(a7)
        move.l #version,-(a7)
        move.w #4,-(a7)
        mulu.w fontwidth,d0
        move.w _LCD_WIDTH,d1
        sub.w #4,d1
        sub.w d0,d1
        move.w d1,-(a7)
        jsr tios::DrawStrXY
        add.l #10,a7
        move.w textfont,-(a7)
        jsr tios::FontSetSys
        add.l #2,a7
        move.w currentfolder(pc),d0
        DEREF d0,a0
        move.w 2(a0),d7
        add.l #4,a0
        move.l #name,a1
        move.w titleheight,d0
        add.w #1,d0
        move.w d0,y
        clr.w count
        move.l #handlelist,a3
dfLoop:
        tst.w d7
        beq dfEnd
        clr.w flags
        move.l (a0),(a1)
        move.l 4(a0),4(a1)
        tst.w infolder
        beq dfDrawName
        move.w SYM_ENTRY.hVal(a0),d0
        DEREF d0,a2
        clr.l d0
        move.w (a2),d0
        move.l a2,a4
        add.l d0,a4
        add.l #1,a4
        move.b (a4),d0
        add.l #2,a2
;        cmp.l #$45584520,2(a2) ; 'EXE '
;        beq dfFargoPrgm        
        cmp.b #$f3,d0
        bne dfNext
        move.l 4(a2),d0
        and.l #$ffffff00,d0
        cmp.l #$36386b00,d0 ; '68k'
        bne dfDrawName
;        move.b 8(a2),d0
;        cmp.b #CALC_TI89,_CALCULATOR
;        bne checknot89
;        and.b #$80,d0
;        bne checkdone
;        or.w #$8000,flags
;        bra checkdone
;checknot89:
;        and.b #$40,d0
;        beq checkdone
;        or.w #$4000,flags
checkdone:
        cmp.b #'P',7(a2)
        beq dfSkipLibCheck
        cmp.b #'L',7(a2)
        beq dfNext
        bra dfSkipLibCheck
;dfFargoPrgm:
;        cmp.l #$444c4c20,6(a2) ; 'DLL '
;        beq dfFargoLib
;        cmp.l #$4150504c,6(a2) ; 'APPL'
;        bne dfNext
;        clr.l d0
;        move.w $14(a2),d0
;        sub.w #2,d0
;        bra doCommentCheck
;dfFargoLib:
;        move.l #fargoLibMsg,a2
;        bra doComment
dfSkipLibCheck:
        clr.l d0
        move.w 10(a2),d0
doCommentCheck:
        tst.w d0
        beq dfDrawName
        add.l d0,a2
doComment:
        move.b (a2),d0
        cmp.b #'^',d0
        beq dfNext
        move.w count,d0
        move.w first,d1
        add.w #1,count
        cmp.w d1,d0
        blt dfNext
        move.w last,d1
        cmp.w d1,d0
        bgt dfNext
        sub.w #1,count
        movem.l d7/a0-a3,-(a7)
        move.w #2,-(a7)
        move.l a2,-(a7)
        move.w y,d0
        move.w d0,-(a7)
        move.w namewidth,-(a7)
        add.w #2,(a7)
        jsr tios::DrawStrXY
        add.l #10,a7
        movem.l (a7)+,d7/a0-a3
dfDrawName:
        move.w count,d0
        move.w first,d1
        add.w #1,count
        cmp.w d1,d0
        blt dfNext
        move.w last,d1
        cmp.w d1,d0
        bgt dfNext
        movem.l d7/a0-a3,-(a7)
        move.w #2,-(a7)
        move.l a1,-(a7)
        move.w y,d0
        move.w d0,-(a7)
        move.w #2,-(a7)
        jsr tios::DrawStrXY
        add.l #10,a7
        movem.l (a7)+,d7/a0-a3
        move.w SYM_ENTRY.hVal(a0),d0
        or.w flags,d0
        move.w d0,(a3)+
        move.w textheight,d0
        add.w d0,y
dfNext:
        move.l #handlelist,a3
        clr.l d0
        move.w count,d0
        lsl.l #1,d0
        add.l d0,a3
        add.l #SYM_ENTRY_LENGTH,a0
        dbra d7,dfLoop
dfEnd:
        rts

Select:
        move.w #0,sel
SelLoop:
        bsr InvertSel
        jsr util::idle_loop
        bsr InvertSel
        cmp.w #KEY_UP,d0
        beq slUp
        cmp.w #KEY_DOWN,d0
        beq slDown
        cmp.w #13,d0
        beq slEnter
        cmp.w #264,d0
        beq slEsc
;        cmp.w #275,d0
;        beq slEmu89
        bra SelLoop
;slEmu89:
;        cmp.b #CALC_TI92PLUS,CALCULATOR
;        bne SelLoop
;        not.w emu89
;        move.w emu89,util::emu89
;        tst.w util::emu89
;        beq slDisable89
;        jsr util::clr_scr
;        pea.l enable89emu(pc)
;        jsr tios::ST_showHelp
;        add.l #4,a7
;        move.w #0,textfont
;        move.w #6,textheight
;        move.w #1,titlefont
;        move.w #14,titleheight
;        move.w #40,namewidth
;        move.w #6,fontwidth
;        move.w #160,_LCD_WIDTH
;        move.w #100,_LCD_HEIGHT
;        move.b #CALC_TI89,_CALCULATOR
;        bsr DrawFolder
;        bra SelLoop
;slDisable89:
;        pea.l disable89emu(pc)
;        jsr tios::ST_showHelp
;        add.l #4,a7
;        move.w #1,textfont
;        move.w #8,textheight
;        move.w #2,titlefont
;        move.w #16,titleheight
;        move.w #54,namewidth
;        move.w #8,fontwidth
;        move.w #240,_LCD_WIDTH
;        move.w #128,_LCD_HEIGHT
;        move.b #CALC_TI92PLUS,_CALCULATOR
;        bsr DrawFolder
;        bra SelLoop
slUp:
        cmp.w #0,sel
        beq SelLoop
        sub.w #1,sel
        move.w sel,d0
        move.w first,d1
        cmp.w d1,d0
        bge SelLoop
        sub.w #1,first
        sub.w #1,last
        bsr DrawFolder
        bra SelLoop
slDown:
        tst.w count
        beq SelLoop
        add.w #1,sel
        move.w count,d0
        move.w sel,d1
        cmp.w d0,d1
        blt slCheckLast
        sub.w #1,sel
slCheckLast:
        move.w sel,d0
        move.w last,d1
        cmp.w d1,d0
        ble SelLoop
        add.w #1,first
        add.w #1,last
        bsr DrawFolder
        bra SelLoop
slEnter:
        tst.w count
        beq SelLoop
        move.l #handlelist,a0
        clr.l d0
        move.w sel,d0
        lsl.w #1,d0
        add.l d0,a0
        move.w (a0),d0
        move.w d0,-(a7)
        cmp.w #$ffff,d0
        bne slNotIncompat
        move.l #notcompatDialog,a6
        jsr util::show_dialog
        jsr util::idle_loop
        jsr util::clear_dialog
        bsr DrawFolder
        move.w (a7)+,d0
        bra SelLoop
slNotIncompat:
        move.w d0,d1
        and.w #$8000,d1
        beq slNot89Warn
        move.l #overrideDialog,a6
        jsr util::show_dialog
slOverrideLoop:
        jsr util::idle_loop
        cmp.w #13,d0
        beq overrideContinue
        cmp.w #264,d0
        bne slOverrideLoop
        jsr util::clear_dialog
        bsr DrawFolder
        move.w (a7)+,d0
        bra SelLoop
overrideContinue:
        jsr util::clear_dialog
;        move.w #1,util::override89
        bra slNot92Warn
slNot89Warn:
        move.w d0,d1
        and.w #$4000,d1
        beq slNot92Warn
        move.l #warn89emuDialog,a6
        jsr util::show_dialog
sl89emuLoop:
        jsr util::idle_loop
        cmp.w #13,d0
        beq emu89Continue
        cmp.w #264,d0
        bne sl89emuLoop
        jsr util::clear_dialog
        bsr DrawFolder
        move.w (a7)+,d0
        bra SelLoop
emu89Continue:
        jsr util::clear_dialog
;        move.w #1,util::alwaysemu89
slNot92Warn:
        move.w (a7)+,d0
        tst.w infolder
        beq slEnterFolder
;        move.l a7,errorStack
;        bsr installCrashRecover
        move.w d0,-(a7)
        jsr util::exec
;        bsr deinstallCrashRecover
        add.l #2,a7
continueAfterError:
        tst.l d0
        bne slExecError
        move.l #null,-(a7)
        jsr tios::ST_showHelp
        add.l #4,a7
        jsr tios::ST_eraseHelp
slExecError:
;        move.w emu89,util::emu89
;        clr.w util::override89
;        clr.w util::alwaysemu89
        bsr DrawFolder
        bra SelLoop
slEnterFolder:
        move.w d0,currentfolder
        move.w #1,infolder
        move.w #0,first
        move.w #12,last
        bsr DrawFolder
        bsr Select
        move.w #8,currentfolder
        move.w #0,infolder
        move.w #0,first
        move.w #12,last
        bsr DrawFolder
        move.w #0,sel
        bra SelLoop
slEsc:
        rts

errorInExec:
        move.l handlecount,d1
        move.l #handlelist,a0
eieDelLoop:
        tst.l d1
        beq eieDispErr
        move.w (a0)+,d2
        tst.w d2
        beq eieNext
        movem.l d0-d1/a0,-(a7)
        move.w d2,-(a7)
        jsr tios::HeapFree
        add.l #2,a7
        movem.l (a7)+,d0-d1/a0
eieNext:
        dbra d1,eieDelLoop
eieDispErr:
        move.l #errorMsg,a0
        clr.l d1
        move.w d0,d1
        lsl.l #2,d1
        add.l d1,a0
        move.l (a0),-(a7)
        jsr tios::ST_showHelp
        add.l #4,a7
        clr.l d0
        trap #1
        move.l #1,d0
        bra continueAfterError

InvertSel:
        move.l d0,-(a7)
        move.l #LCD_MEM,a0
        move.w sel(pc),d0
        sub.w first(pc),d0
        mulu.w textheight,d0
        add.w titleheight,d0
        add.w #1,d0
        mulu.w #30,d0
        add.l d0,a0
        clr.l d0
        move.w textheight,d0
        sub.l #1,d0
        cmp.b #CALC_TI89,_CALCULATOR
        beq eorloop89
eorloop:
        eor.b #$7f,(a0)
        eor.b #$ff,1(a0)
        eor.b #$ff,2(a0)
        eor.b #$ff,3(a0)
        eor.b #$ff,4(a0)
        eor.b #$ff,5(a0)
        eor.b #$fc,6(a0)
        add.l #30,a0
        dbra d0,eorloop
        move.l (a7)+,d0
        rts
eorloop89:
        eor.b #$7f,(a0)
        eor.b #$ff,1(a0)
        eor.b #$ff,2(a0)
        eor.b #$ff,3(a0)
        eor.b #$ff,4(a0)
        add.l #30,a0
        dbra d0,eorloop89
        move.l (a7)+,d0
        rts


installCrashRecover:
        move.l ($40008),oldVect+0
        move.l ($4000c),oldVect+4
        move.l ($40010),oldVect+8
        move.l ($40014),oldVect+$c
        move.l ($4002c),oldVect+$10
        move.l ($400ac),oldVect+$14
        move.l ($400b0),oldVect+$18
        move.l ($400b4),oldVect+$1c
        move.l ($400b8),oldVect+$20
        move.l ($400bc),oldVect+$24
        move.l ($40064),oldVect+$28
        move.l ($40068),oldVect+$2c
        move.l ($4006c),oldVect+$30
        move.l ($40070),oldVect+$34
        move.l ($40074),oldVect+$38
        move.l ($40078),oldVect+$3c
        move.l ($4007c),oldVect+$40
        move.l ($40028),oldVect+$44
        move.l ($40084),oldVect+$48
        move.l #crashBusError,($40008)
        move.l #crashAddrError,($4000c)
        move.l #crashIllegalError,($40010)
        move.l #crashDivideError,($40014)
        move.l #crashThrowError,($40028)
        move.l #crashLine1111Error,($4002c)
        move.l #crashTrap11Error,($400ac)
        move.l #crashTrap12Error,($400b0)
        move.l #crashTrap13Error,($400b4)
        move.l #crashTrap14Error,($400b8)
        move.l #crashTrap15Error,($400bc)
        cmp.b #CALC_TI92PLUS,CALCULATOR
        bne noCheckTerminate
        move.l #checkTerminate,($40078)
noCheckTerminate:
        move.l #crashMemoryError,($4007c)
        move.l #newTrap1,($40084)
        move.l #683,d7
        move.l #newROMTable,a0
        move.l $c8,a1
        move.l a1,oldROMTable
romTableInstLoop:
        move.l (a1)+,(a0)+
        dbra d7,romTableInstLoop
        move.l #newHeapAlloc,newROMTable+$240
        move.l #newHeapAllocThrow,newROMTable+$24c
        move.l #newHeapFree,newROMTable+$25c
        move.l #newHeapFreeIndir,newROMTable+$260
        move.l #newERThrow,newROMTable+$54c
        move.l #newROMTable,($400c8)
        move.l #0,handlecount
        rts

newHeapAlloc:
        move.l oldROMTable,a0
        move.l $240(a0),a0
        move.l 4(a7),a1
        move.l a1,-(a7)
        jsr (a0)
        add.l #4,a7
        move.l #handlelist,a0
        move.l handlecount,d1
        lsl.l #1,d1
        add.l d1,a0
        move.w d0,(a0)
        add.l #1,handlecount
        rts

newHeapAllocThrow:
        move.l oldROMTable,a0
        move.l $24c(a0),a0
        move.l 4(a7),a1
        move.l a1,-(a7)
        jsr (a0)
        add.l #4,a7
        move.l #handlelist,a0
        move.l handlecount,d1
        lsl.l #1,d1
        add.l d1,a0
        move.w d0,(a0)
        add.l #1,handlecount
        rts

newHeapFree:
        move.w 4(a7),d0
        move.l handlecount,d1
        move.l #handlelist,a0
nhfFindLoop:
        tst.l d1
        beq nhfCallOld
        move.w (a0)+,d1
        cmp.w d0,d1
        beq nhfDelMe
        dbra d1,nhfFindLoop
        bra nhfCallOld
nhfDelMe:
        sub.l #2,a0
        clr.w (a0)
nhfCallOld:
        move.l oldROMTable,a0
        move.l $25c(a0),a0
        jmp (a0)

newHeapFreeIndir:
        move.l 4(a7),a0
        move.w (a0),d0
        move.l handlecount,d1
        move.l #handlelist,a0
nhfiFindLoop:
        tst.l d1
        beq nhfiCallOld
        move.w (a0)+,d1
        cmp.w d0,d1
        beq nhfiDelMe
        dbra d1,nhfiFindLoop
        bra nhfiCallOld
nhfiDelMe:
        sub.l #2,a0
        clr.w (a0)
nhfiCallOld:
        move.l oldROMTable,a0
        move.l $260(a0),a0
        jmp (a0)

newERThrow:
        dc.w $a000

newTrap1:
        and.w #$700,d0
        cmp.w #$600,d0
        blt doTrap1
        move.w #$600,d0
doTrap1:
        move.l oldVect+$48,-(a7)
        rts

deinstallCrashRecover:
        move.l oldROMTable,($400c8)
        move.l oldVect+0,a0
        move.l a0,($40008)
        move.l oldVect+4,a0
        move.l a0,($4000c)
        move.l oldVect+8,a0
        move.l a0,($40010)
        move.l oldVect+$c,a0
        move.l a0,($40014)
        move.l oldVect+$10,a0
        move.l a0,($4002c)
        move.l oldVect+$14,a0
        move.l a0,($400ac)
        move.l oldVect+$18,a0
        move.l a0,($400b0)
        move.l oldVect+$1c,a0
        move.l a0,($400b4)
        move.l oldVect+$20,a0
        move.l a0,($400b8)
        move.l oldVect+$24,a0
        move.l a0,($400bc)
        move.l oldVect+$3c,a0
        move.l a0,($40078)
        move.l oldVect+$40,a0
        move.l a0,($4007c)
        move.l oldVect+$44,a0
        move.l a0,($40028)
        move.l oldVect+$48,a0
        move.l a0,($40084)
        move.w #$980,$600010
        rts

delay:
        nop
        nop
        nop
        nop
        nop
        nop
        rts

checkTerminate:
        move.w #$fffe,$600018
        bsr delay
        bsr delay
        bsr delay
        cmp.b #$f3,$60001b
        beq terminateError
noTerminate:
        move.l oldVect+$38,-(a7)
        rts

crashBusError:
        move.l #0,d0
        bra CrashRecover
crashAddrError:
        move.l #1,d0
        bra CrashRecover
crashIllegalError:
        move.l #2,d0
        bra CrashRecover
crashDivideError:
        move.l #3,d0
        bra CrashRecover
crashLine1111Error:
        move.l #4,d0
        bra CrashRecover
crashTrap11Error:
        move.l #5,d0
        bra CrashRecover
crashTrap12Error:
        move.l #6,d0
        bra CrashRecover
crashTrap13Error:
        move.l #7,d0
        bra CrashRecover
crashTrap14Error:
        move.l #8,d0
        bra CrashRecover
crashTrap15Error:
        move.l #9,d0
        bra CrashRecover
crashMemoryError:
        move.l #10,d0
        bra CrashRecover
terminateError:
        move.l #11,d0
        bra CrashRecover
crashThrowError:
        move.l #12,d0
        bra CrashRecover
CrashRecover:
        move.l oldVect+$28,a0
        move.l a0,($40064)
        move.l oldVect+$2c,a0
        move.l a0,($40068)
        move.l oldVect+$30,a0
        move.l a0,($4006c)
        move.l oldVect+$34,a0
        move.l a0,($40070)
        move.l oldVect+$38,a0
        move.l a0,($40074)
        move.l oldVect+$3c,a0
        move.l a0,($40078)
        bsr deinstallCrashRecover
        move.l #DoCrashRecover,a0
        move.l a0,2(a7)
        rte
DoCrashRecover:
        move.l errorStack,a7
        bra errorInExec

textfont dc.w 1
textheight dc.w 8
titlefont dc.w 2
titleheight dc.w 16
namewidth dc.w 54
fontwidth dc.w 0
_LCD_WIDTH dc.w 240
_LCD_HEIGHT dc.w 128
_CALCULATOR dc.b CALC_TI92PLUS,0

;emu89 dc.w 0

y dc.w 0
infolder dc.w 0
currentfolder dc.w 8
count dc.w 0
name dc.l 0,0,0
sel dc.w 0
shellname dc.b "PlusShell Browser",0
version dc.b "v1.0",128,0
null dc.l 0
first dc.w 0
last dc.w 12
_comment dc.b "^",0 ; '^' marks program as hidden

errorMsg dc.l busErrorMsg,addrErrorMsg,illegalErrorMsg,divideErrorMsg
         dc.l line111ErrorMsg,trap11ErrorMsg,trap12ErrorMsg,trap13ErrorMsg
         dc.l trap14ErrorMsg,trap15ErrorMsg,memoryErrorMsg,terminateMsg
         dc.l throwMsg
busErrorMsg dc.b "Bus Error",0
addrErrorMsg dc.b "Address Error",0
illegalErrorMsg dc.b "Illegal Instruction",0
divideErrorMsg dc.b "Divide by Zero",0
line111ErrorMsg dc.b "Line 1111 Emulator",0
trap11ErrorMsg dc.b "Trap 11",0
trap12ErrorMsg dc.b "Trap 12",0
trap13ErrorMsg dc.b "Trap 13",0
trap14ErrorMsg dc.b "Trap 14",0
trap15ErrorMsg dc.b "Trap 15",0
memoryErrorMsg dc.b "Protected Memory Violation",0
terminateMsg dc.b "Terminated by User",0
throwMsg dc.b "Unknown Error",0
enable89emu dc.b "TI-89 emulation enabled",0
disable89emu dc.b "TI-89 emulation disabled",0

overrideDialog dc.l $000B0014,$00950050,$00060006,ovrtext1,$0006000E,ovrtext2
               dc.l $00060016,ovrtext3,$0006001E,ovrtext4,$00060026,ovrtext5
               dc.l $0006002E,ovrtext6,0
ovrtext1 dc.b "This program was not",0
ovrtext2 dc.b "designed to run on",0
ovrtext3 dc.b "the TI-89 and may",0
ovrtext4 dc.b "cause problems.  Do",0
ovrtext5 dc.b "you want to continue?",0
ovrtext6 dc.b "[Enter]=Yes [ESC]=No",0

notcompatDialog dc.l $000B0018,$0095004C,$00060006,nctext1,$0006000E,nctext2
                dc.l $00060016,nctext3,$0006001E,nctext4,$00060026,nctext5,0
nctext1 dc.b "This program was",0
nctext2 dc.b "compiled for an older",0
nctext3 dc.b "version of PlusShell",0
nctext4 dc.b "and will not run on",0
nctext5 dc.b "this version.",0

warn89emuDialog dc.l $001E001C,$00D20064,$00060006,emutext1,$00060010,emutext2
                dc.l $0006001A,emutext3,$00060024,emutext4,$0006002E,emutext5
                dc.l $00060038,emutext6,0
emutext1 dc.b "This program was not",0
emutext2 dc.b "designed to run on",0
emutext3 dc.b "the TI-92+ and may",0
emutext4 dc.b "cause problems.  Do",0
emutext5 dc.b "you want to continue?",0
emutext6 dc.b "[Enter]=Yes [ESC]=No",0

;fargoLibMsg dc.b "Fargo II Lib - Run to convert",0

        BSS
handlelist ds.w 128
handlecount ds.l 1
oldVect ds.b $4c
errorStack ds.l 1
newROMTable ds.l 684
oldROMTable ds.l 1
OldHandleB ds.l 1
OldHandleC ds.l 1
flags ds.w 1

        end
