        xdef _library

        xdef util@0000
        xdef util@0001
        xdef util@0002
        xdef util@0003
        xdef util@0004
        xdef util@0005
        xdef util@0006
        xdef util@0007
        xdef util@0008
        xdef util@0009
        xdef util@000A
        xdef util@000B
        xdef util@000C
        xdef util@000D
        xdef util@000E
        xdef util@000F
        xdef util@0010
        xdef util@0011
        xdef util@0012
        xdef util@0013

        include "tios.h"

        xdef _ti92plus
        xdef _ti89

ST_busy equ $e2

pixel_do        macro
        movem.l d0-d1/a0,-(a7)

	lea	LCD_MEM,a0

        move.w  4*4+2(a7),d0            ; y-coordinate
        cmp.w   #LCD_HEIGHT,d0
	bcc	\pixel_bad
        lsl.w   #1,d0
        move.w  d0,d1
        lsl.w   #4,d0
        sub.w   d1,d0
	lea	0(a0,d0.w),a0

        move.w  4*4+0(a7),d0            ; x-coordinate
        cmp.w   #LCD_WIDTH,d0
	bcc	\pixel_bad
	move.w	d0,d1
	lsr.w	#3,d0

	not.w	d1
	and.w	#7,d1
	b\1.b	d1,0(a0,d0.w)

\pixel_bad:
        movem.l (a7)+,d0-d1/a0
		endm

;*****************************************************

find_pixel:
util@0000:
        move.w  d1,-(a7)

	lea	LCD_MEM,a0

        move.w  (4+2)+2(a7),d0          ; y-coordinate
        cmp.w   #LCD_HEIGHT,d0
        bcc     pixel_bad
        lsl.w   #1,d0
        move.w  d0,d1
        lsl.w   #4,d0
        sub.w   d1,d0
	lea	0(a0,d0.w),a0

        move.w  (4+2)+0(a7),d1          ; x-coordinate
        cmp.w   #LCD_WIDTH,d1
	bcc	pixel_bad
	move.w	d1,d0
	lsr.w	#3,d1
	lea	0(a0,d1.w),a0
	not.w	d0
	and.w	#7,d0

pixel_good:
        move.w  (a7)+,d1
	rts

pixel_bad:
	sub.l	a0,a0
	bra	pixel_good

;*****************************************************

pixel_on:
util@0001:
	pixel_do	set
	rts

;*****************************************************

pixel_off:
util@0002:
	pixel_do	clr
	rts

;*****************************************************

pixel_chg:
util@0003:
	pixel_do	chg
	rts

;*****************************************************
; prep_rect: used by frame_rect and erase_rect
;*****************************************************
prep_rect:
util@0004:
	move.l	#0,d4
        move.w  $36(a7),d4
	move.w	d4,d5
	lsl.w	#5,d4
	lsl.w	#1,d5
	sub.w	d5,d4
	add.l	#LCD_MEM,d4
	move.l	d4,a0

	move.l	#0,d5
        move.w  $3A(a7),d5
	move.w	d5,d6
	lsl.w	#5,d5
	lsl.w	#1,d6
	sub.w	d6,d5
	add.l	#LCD_MEM,d5
	move.l	d5,a1

        move.w  $34(a7),d0
	move.w	d0,d6
	lsr.w	#3,d0
	and.w	#$7,d6

        move.w  $38(a7),d1
	move.w	d1,d7
	lsr.w	#3,d1
	and.w	#$7,d7

	rts

;*****************************************************

frame_rect:
util@0005:
        movem.l d0-d7/a0-a2,-(a7)

	bsr	prep_rect
	move.b	#$FF,d2
	move.b	#$FF,d3
	move.b	#$80,d4
	move.b	#$01,d5
	lsr.b	d6,d2
	lsr.b	d6,d4
	move.w	#7,d6
	sub.w	d7,d6
	lsl.b	d6,d3
	lsl.b	d6,d5

	move.w	d0,d7
horz_loop:
	move.b	#$FF,d6
	cmp.w	d0,d7
	bne	horz_not_left
	and.b	d2,d6
horz_not_left:
	cmp.w	d1,d7
	bne	horz_not_right
	and.b	d3,d6
horz_not_right:
	or.b	d6,0(a0,d7.w)
	or.b	d6,0(a1,d7.w)
	add.w	#1,d7
	cmp.w	d1,d7
	bls	horz_loop

        lea     30(a0),a2
vert_loop:
	or.b	d4,0(a2,d0.w)
	or.b	d5,0(a2,d1.w)
        lea     30(a2),a2
	cmp.l	a1,a2
	bcs	vert_loop

        movem.l (a7)+,d0-d7/a0-a2
	rts

;*****************************************************

erase_rect:
util@0006:
        movem.l d0-d7/a0-a2,-(a7)

	bsr	prep_rect
	move.b	#$FF,d2
	move.b	#$FF,d3
	lsr.b	d6,d2
	move.w	#7,d6
	sub.w	d7,d6
	lsl.b	d6,d3
	not.b	d2
	not.b	d3

	not.b	d6
	move.l	a0,a2
vert_loop1:
	move.w	d0,d7
horz_loop1:
	clr.b	d6
	cmp.w	d0,d7
	bne	horz_not_left1
	or.b	d2,d6
horz_not_left1:
	cmp.w	d1,d7
	bne	horz_not_right1
	or.b	d3,d6
horz_not_right1:
	and.b	d6,0(a2,d7.w)
	add.w	#1,d7
	cmp.w	d1,d7
	bls	horz_loop1
        lea     30(a2),a2
	cmp.l	a1,a2
	bls	vert_loop1

        movem.l (a7)+,d0-d7/a0-a2
	rts

;*****************************************************

show_dialog:
util@0007:
        movem.l d0-d7/a0-a6,-(a7)

	move.l	0(a6),dialog_pos+0
	move.l	4(a6),dialog_pos+4

        sub.l   #8,a7
        move.l  0(a6),0(a7)
        move.l  4(a6),4(a7)
	bsr	erase_rect
        add.l   #$00010001,0(a7)
        sub.l   #$00010001,4(a7)
	bsr	frame_rect
        add.l   #$00010001,0(a7)
        sub.l   #$00010001,4(a7)
	bsr	frame_rect
        add.l   #$00020002,0(a7)
        sub.l   #$00020002,4(a7)
	bsr	frame_rect
        add.l   #8,a7

        move.w  #2,-(a7)
        cmp.w #CALC_TI89,CALCULATOR
        bne dialog_not89
dialog_89:
        move.w  #1,(a7)
dialog_not89:
        jsr tios::FontSetSys
        add.l   #2,a7
	move.b	d0,old_font		; save original font

        sub.l   #$A,a7
	move.l	0(a6),d6
	add.l	#8,a6
dialog_loop:
	move.l	(a6)+,d0
	beq	dialog_done
	add.l	d6,d0
        move.l  d0,$0(a7)
        move.l  (a6)+,$4(a7)
        move.w  #$0004,$8(a7)
        jsr tios::DrawStrXY
	bra	dialog_loop
dialog_done:
        add.l   #10,a7

	move.b	old_font,d0
        move.w  d0,-(a7)
        jsr tios::FontSetSys        ; restore original font
        add.l   #2,a7

        movem.l (a7)+,d0-d7/a0-a6
	rts

;*****************************************************

clear_dialog:
util@0008:
        movem.l d0-d7/a0-a6,-(a7)

        move.l  dialog_pos+4,-(a7)
        move.l  dialog_pos+0,-(a7)
	bsr	erase_rect
        add.l   #8,a7

        movem.l (a7)+,d0-d7/a0-a6
	rts


clr_scr:
util@0009:
	movem.l	d0/a0,-(sp)

	bsr	zap_screen

        lea     LCD_MEM,a0
        move.w  #LCD_HEIGHT-7,d0
        mulu.w  #30,d0
        add.l   d0,a0
        move.w  #LCD_WIDTH-160,d1
	move.l	#$FFFFFFFF,d0
	move.l	d0,(a0)+
	move.l	d0,(a0)+
	move.l	d0,(a0)+
	move.l	d0,(a0)+
	move.l	d0,(a0)+
        tst.w   d1
        beq     clrscr_skiprest
	move.l	d0,(a0)+
	move.l	d0,(a0)+
	move.w	d0,(a0)+
clrscr_skiprest:

	movem.l	(sp)+,d0/a0
	rts

;*****************************************************

zap_screen:
util@000A:
	movem.l	d0-d7/a0-a6,-(sp)
	move.l	a7,save

        lea     LCD_MEM,a7
        add.l   #3840,a7
	movem.l	zeroes,d0-d7/a0-a6

	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times
	movem.l	d0-d7/a0-a6,-(a7)	; repeated 64 times

	move.l	save,a7
	movem.l	(sp)+,d0-d7/a0-a6
	rts

zap_smallscreen:
        movem.l d0-d4,-(a7)
        move.l  save,a7
        movem.l (sp)+,d0-d7/a0-a6
        rts


idle_loop:
util@000B:
        movem.l a0-a6/d1-d7,-(a7)

idle_start:
        move.l APD_INIT,APD_TIMER
        clr.w APD_FLAG
        move.w  #0,-(a7)
        jsr tios::ST_busy
        add.l   #2,a7
wait_idle:
        tst.w APD_FLAG
        bne do_apd
        move.l #31421,d0
        bsr random
        tst.w   tios::kb_globals+$1c ; has a key been pressed?
	beq	wait_idle
        move.w  tios::MaxHandles+$1e,d0
        clr.w   tios::kb_globals+$1c ; clear key buffer

        move.l  d0,-(a7)
        move.w  #1,-(a7)
        jsr tios::ST_busy
        add.l   #2,a7
        move.l  (a7)+,d0

try_key_off:
        cmp.w   #KEY_DIAMOND+$10B,d0
        bne     not_key_off
        bra     do_apd
not_key_off:

        movem.l (a7)+,a0-a6/d1-d7
	rts

do_apd:
        trap    #4
        bra     idle_start

;*****************************************************

random:
util@000C:
        move.l  d1,-(a7)
	move.w	rand_seed(pc),d1
	mulu.w	#31421,d1
	add.w	#6927,d1
	mulu.w	d1,d0
	move.w	d1,rand_seed
	clr.w	d0
	swap	d0
        move.l  (a7)+,d1
	rts

tios::DrawCharXY
util@000D:
        move.w 4(a7),d0
        move.b d0,charstr
        move.w 6(a7),d0
        move.w 8(a7),d1
        move.w 10(a7),d2
        move.w d2,-(a7)
        move.l #charstr,-(a7)
        move.w d1,-(a7)
        move.w d0,-(a7)
        jsr tios::DrawStrXY
        add.l #10,a7
        rts

kernel::exec
util@000E:
        move.w 4(a7),d0
        move.w d0,d7
        DEREF d0,a0
        cmp.l #$200000,a0
        blt notarchived
        clr.l d0
        move.b (a0),d0
        lsl.l #8,d0
        or.b 1(a0),d0
        add.l #3,d0
        and.l #$fffe,d0
        move.l a0,-(a7)
        move.l d0,-(a7)
        jsr tios::HeapAlloc
        move.l (a7)+,d1
        move.l (a7)+,a1
        tst.w d0
        beq eFail
        move.w d0,-(a7)
        move.w d0,d7
        DEREF d0,a0
        move.l a0,-(a7)
        sub.l #1,d1
eCopyLoop:
        move.b (a1)+,(a0)+
        dbra d1,eCopyLoop
        move.l (a7)+,a0
        bra eReloc
notarchived:
        move.w #0,-(a7)
eReloc:
        ; Relocate the program
        move.l a0,a5
        add.l #2,a5
        clr.l d1
        move.w (a0),d1
        add.l #1,d1
        add.l d1,a0
eRelocLoop:
        move.w -(a0),d0
        tst.w d0
        beq eEnd
        clr.l d1
        move.w -(a0),d1
        add.l a5,d1
        move.l d1,0(a5,d0.w)
        bra eRelocLoop
eEnd:
        jsr (a5)
eNoExec:
        move.w (a7)+,d1
        tst.w d1
        beq eRet
        move.l d0,-(a7)
        move.w d1,-(a7)
        jsr tios::HeapFree
        add.l #2,a7
        move.l (a7)+,d0
eRet:
        rts
eFail:
        move.l #1,d0
        rts

tios::FindSymEntry
util@000F:
        movem.l d0-d3/a1,-(a7)
        clr.l filesearch
        clr.l filesearch+4
        move.l 26(a7),a0
        move.l #filesearch,a1
fseCopyLoop:
        tst.b (a0)
        beq fseCopyEnd
        move.b (a0)+,(a1)+
        bra fseCopyLoop
fseCopyEnd:
        move.w 24(a7),d0
        DEREF d0,a1
        move.l #0,a0
        move.l filesearch,d2
        move.l filesearch+4,d3
        move.w 2(a1),d1
        add.l #4,a1
fseSearchLoop:
        tst.w d1
        beq fseEnd
        move.l (a1),d0
        cmp.l d2,d0
        bne fseNotEqual
        move.l 4(a1),d0
        cmp.l d3,d0
        bne fseNotEqual
        move.l a1,a0
        bra fseEnd
fseNotEqual:
        add.l #$e,a1
        dbra d1,fseSearchLoop
fseEnd:
        movem.l (a7)+,d0-d3/a1
        rts

InitFargoCompatibility:
util@0011:
        ; Copy the font so that the order is correct for Fargo programs
        move.l #6144,-(a7)
        jsr tios::HeapAlloc
        add.l #4,a7
        move.w d0,SF_font_handle
        tst.w d0
        beq ifcEnd
        DEREF d0,a1
        move.l #$407a80,a0
        move.l #383,d0
smallFontCopy:
        move.l (a0)+,(a1)+
        dbra d0,smallFontCopy
        move.l #$407280,a0
        move.l #511,d0
medFontCopy:
        move.l (a0)+,(a1)+
        dbra d0,medFontCopy
        move.l #$408080,a0
        move.l #639,d0
largeFontCopy:
        move.l (a0)+,(a1)+
        dbra d0,largeFontCopy
ifcEnd:
        rts

DeinitFargoCompatibility:
util@0012:
        tst.w SF_font_handle
        beq dfcEnd
        move.w SF_font_handle,-(a7)
        jsr tios::HeapFree
        add.l #2,a7
dfcEnd:
        rts

        cnop 0,4

;*****************************************************
; miscellaneous program data
;*****************************************************

SF_font_handle  dc.w    0
util@0013:
SF_font         dc.l    0
util@0010:
rand_seed	dc.w	0
oldint0         dc.l    0
charstr         dc.b    0,0
old_font        dc.w    0
dialog_pos      ds.w    4
zeroes		dcb.l	15,0
save            dc.l    0
filesearch      ds.l    2
ioks            ds.b    10

        end
