KERNEL_VER equ $100
KERNEL_IDENT equ $5053
VERSION_STRING macro
 dc.b "1.0",128
 endm

GET_REL_RAM_WORD macro
 move.l ($c8),a5
 add.l #\1*4,a5
 move.l (a5),a5
 move.w \2(a5),\3
 endm

GET_REL_RAM_DWORD macro
 move.l ($c8),a5
 add.l #\1*4,a5
 move.l (a5),a5
 move.l \2(a5),\3
 endm

SET_REL_RAM_WORD macro
 move.l ($c8),a5
 add.l #\2*4,a5
 move.l (a5),a5
 move.w \1,\3(a5)
 endm

SET_REL_RAM_DWORD macro
 move.l ($c8),a5
 add.l #\2*4,a5
 move.l (a5),a5
 move.l \1,\3(a5)
 endm

_DEREF macro
 lsl.w #2,\1
 GET_REL_RAM_DWORD $2f,$104+$16,\2
 move.l 0(\2,\1.w),\2
 endm

InstallKernel:
        tst.w ($30)
        beq KernelNotInstalled
        cmp.w #KERNEL_IDENT,($32)
        bne KernelNew
        cmp.w #KERNEL_VER,($30)
        blt KernelNew
        bra KernelOld
        rts
KernelOld:
        lea.l NewVersionStringTag(pc),a0
        rts
KernelNew:
        clr.l ($40030)
        SET_REL_RAM_DWORD #$3fff4,$2f,$104+$a
        move.l $c8,d0
        and.l #$600000,d0
        move.l #$120e8,a0
        add.l d0,a0
        move.l #$40060,a1
        move.l #7,d0
KernelNewLoop:
        move.l (a0)+,(a1)+
        dbra d0,KernelNewLoop
        lea.l UninstallStringTag(pc),a0
        rts
KernelNotInstalled:
        GET_REL_RAM_WORD $109,$c,d0
        _DEREF d0,a0
        sub.l #4,a0
        move.l #_KernelEnd-_KernelStart,d0
        sub.l d0,a0
        SET_REL_RAM_DWORD a0,$2f,$104+$a
        move.l a0,a2
        lea.l _KernelStart(pc),a1
        sub.l #1,d0
KernelCopyLoop:
        move.b (a1)+,(a0)+
        dbra d0,KernelCopyLoop
        move.w #KERNEL_VER,($40030)
        move.w #KERNEL_IDENT,($40032)
        lea.l exec-_KernelStart(a2),a0
        move.l a0,($40034)
        lea.l Reloc-_KernelStart(a2),a0
        move.l a0,($40038)
        lea.l RelocFromPtr-_KernelStart(a2),a0
        move.l a0,($4003c)
        lea.l Unreloc-_KernelStart(a2),a0
        move.l a0,($40040)
        lea.l UnrelocFromPtr-_KernelStart(a2),a0
        lea.l RAMTable92+2-_KernelStart(a2),a0
        lea.l _CALCULATOR-_KernelStart(a2),a1
        move.l a1,(a0)
        lea.l RAMTable89+2-_KernelStart(a2),a0
        move.l a1,(a0)
        lea.l RAMTable89emu+2-_KernelStart(a2),a0
        move.l a1,(a0)
        lea.l VersionStringTag(pc),a0
        rts

_KernelStart:

        dc.b "PS"

exec:
        movem.l d1-d7/a0-a6,-(a7)
        move.l 56(a7),a4
        sub.l #4,a4
        move.l a4,a6
        bsr RelocFromPtr
        tst.l d0
        bne execError
        lea.l ProgCount(pc),a0
        tst.w (a0)
        bne execNoSaveScreen
        move.l #3840,-(a7)
        ROM_CALL romfunc::HeapAlloc
        add.l #4,a7
        tst.w d0
        bne execCopyScreen
        moveq.l #1,d0
        bra execError
execCopyScreen:
        lea.l ScreenHandle(pc),a0
        move.w d0,(a0)
        _DEREF d0,a0
        move.l #LCD_MEM,a1
        move.w #959,d0
execSaveLoop:
        move.l (a1)+,(a0)+
        dbra d0,execSaveLoop
execNoSaveScreen:
        lea.l ProgCount(pc),a0
        add.w #1,(a0)
        clr.l d0
        move.w $c(a6),d0
        add.l d0,a6
        jsr (a6)
        move.l 56(a7),a4
        sub.l #4,a4
        move.l a4,a6
        bsr UnrelocFromPtr
        lea.l ProgCount(pc),a0
        sub.w #1,(a0)
        bne execEnd
        lea.l ScreenHandle(pc),a0
        move.w (a0),d0
        move.w d0,d1
        _DEREF d0,a0
        move.l #LCD_MEM,a1
        move.w #959,d0
execRestoreLoop:
        move.l (a0)+,(a1)+
        dbra d0,execRestoreLoop
        move.w d1,-(a7)
        ROM_CALL romfunc::HeapFree
        add.l #2,a7
execEnd:
        movem.l (a7)+,d1-d7/a0-a6
        add.l #4,a7
        rts

execError:
        cmp.l #1,d0
        beq execNoMem
        cmp.l #2,d0
        beq execNoLib
        cmp.l #3,d0
        beq execLibVer
        pea.l BadFileFormatMsg(pc)
        ROM_CALL romfunc::ST_showHelp
        add.l #4,a7
        bra execEnd
execNoMem:
        pea.l NoMemMsg(pc)
        ROM_CALL romfunc::ST_showHelp
        add.l #4,a7
        bra execEnd
execNoLib:
        lea.l MissingLibName(pc),a1
        move.l (a0)+,(a1)+
        move.l (a0)+,(a1)+
        pea.l MissingLibMsg(pc)
        ROM_CALL romfunc::ST_showHelp
        add.l #4,a7
        bra execEnd
execLibVer:
        lea.l WrongLibVersionName(pc),a1
        move.l (a0)+,(a1)+
        move.l (a0)+,(a1)+
        pea.l WrongLibVersionMsg(pc)
        ROM_CALL romfunc::ST_showHelp
        add.l #4,a7
        bra execEnd

Reloc:
        movem.l d1-d7/a1-a6,-(a7)
        _DEREF d0,a6
        bra RelocFromPtrStart

RelocFromPtr:
        movem.l d1-d7/a1-a6,-(a7)
RelocFromPtrStart:
        move.l a6,a4
        tst.w $8(a6)
        bne RelocDone
        clr.w $12(a6)
        move.l 4(a4),d0
        and.l #$ffffff00,d0
        cmp.l #$36386b00,d0
        bne RelocBadFileFormat
        clr.l d0
        move.w $14(a4),d0
        tst.w d0
        beq RelocNoBSSAlloc
        add.l d0,a4
        tst.l (a4)
        beq RelocNoBSSAlloc
        move.l (a4),d0
        movem.l a4-a6,-(a7)
        move.l d0,-(a7)
        ROM_CALL romfunc::HeapAlloc
        add.l #4,a7
        movem.l (a7)+,a4-a6
        tst.w d0
        beq RelocNoMem
        move.w d0,$12(a6)
RelocNoBSSAlloc:
        move.l a6,a4
        add.l #$1a,a4
        move.w (a4)+,d7
RelocLibCheckLoop:
        tst.w d7
        beq RelocLibCheckEnd
        move.l a4,a0
        bsr GetFileAddress
        tst.w d0
        beq RelocLibNotFound
        move.l 6(a0),d0
        and.l #$ffffff00,d0
        cmp.l #$36386b00,d0
        bne RelocLibNotFound
        add.l #10,a4
        dbra d7,RelocLibCheckLoop
RelocLibCheckEnd:
        move.l a6,a4
        add.l #$1a,a4
        move.w (a4)+,d7
        move.w d7,d6
        mulu.w #10,d6
        move.l a4,a3
        add.l d6,a3
RelocLibLoop:
        tst.w d7
        beq RelocLibEnd
        move.l a4,a0
        bsr GetFileAddress
        tst.w d0
        beq RelocLibNotFound
        move.w d0,d1
        movem.l d1-d7/a0-a6,-(a7)
        move.l a0,a6
        add.l #2,a6
        bsr RelocFromPtr
        movem.l (a7)+,d1-d7/a0-a6
        tst.w d0
        bne RelocLibNotFound
        _DEREF d1,a2
        add.l #2,a2
        move.l a2,a5
        clr.l d0
        move.w $16(a2),d0
        add.l d0,a2
        move.w #1,d3
        bsr DoReloc
        tst.w d0
        bne RelocWrongLibVersion
        add.l #10,a4
        dbra d7,RelocLibLoop
RelocLibEnd:
        tst.w (a3)+
        beq RelocNoROM
        move.l $c8,a2
        sub.w #2,a2
        move.w #2,d3
        bsr DoReloc
RelocNoROM:
        tst.w (a3)+
        beq RelocNoRAM
        clr.l d0
        move.w $18(a6),d0
        move.l a6,a4
        add.l d0,a4
        move.l ($4),d0
        and.l #$400000,d0
        beq Reloc89
        lea.l _CALCULATOR(pc),a0
        move.b #CALC_TI92PLUS,(a0)
        lea.l RAMTable92(pc),a2
        lea.l 2(a4),a4
        bra RelocDoRAM
Reloc89:
        lea.l _CALCULATOR(pc),a0
        move.b #CALC_TI89,(a0)
        lea.l RAMTable89(pc),a2
RelocDoRAM:
        move.w #2,d3
        bsr DoReloc
RelocNoRAM:
        clr.l d0
        move.w (a3)+,d0
        tst.w d0
        beq RelocRelEnd
        move.l a6,a0
        add.l d0,a0
        move.l a6,d0
        add.l d0,(a0)
        bra RelocNoRAM
RelocRelEnd:
        tst.w $14(a6)
        beq RelocDone
        tst.w $12(a6)
        beq RelocDone
        add.l #4,a3
        move.w $12(a6),d0
        _DEREF d0,a1
RelocBSSLoop:
        clr.l d0
        move.w (a3)+,d0
        tst.w d0
        beq RelocDone
        move.l a6,a0
        add.l d0,a0
        move.l a1,d0
        add.l d0,(a0)
        bra RelocBSSLoop
RelocDone:
        add.w #1,$8(a6)
RelocOK:
        clr.l d0
RelocEnd:
        movem.l (a7)+,d1-d7/a1-a6
        rts

RelocBadFileFormat:
        moveq.l #4,d0
        bra RelocEnd
RelocLibNotFound:
        bsr DeallocBSS
        move.l a4,a0
        moveq.l #2,d0
        bra RelocEnd
RelocNoMem:
        moveq.l #1,d0
        bra RelocEnd
RelocWrongLibVersion:
        bsr DeallocBSS
        move.l a4,a0
        moveq.l #3,d0
        bra RelocEnd

Unreloc:
        movem.l d1-d7/a1-a6,-(a7)
        _DEREF d0,a6
        bra UnrelocFromPtrStart

UnrelocFromPtr:
        movem.l d1-d7/a1-a6,-(a7)
UnrelocFromPtrStart:
        tst.w $8(a6)
        beq UnrelocOK
        sub.w #1,$8(a6)
        move.l a6,a4
        tst.w $8(a6)
        bne UnrelocOK
        add.l #$1a,a4
        move.w (a4)+,d7
        move.w d7,d6
        mulu.w #10,d6
        move.l a4,a3
        add.l d6,a3
UnrelocLibLoop:
        tst.w d7
        beq UnrelocLibEnd
        move.l a4,a0
        bsr GetFileAddress
        tst.w d0
        beq UnrelocEnd
        move.w d0,d1
        movem.l d1-d7/a0-a6,-(a7)
        move.l a0,a6
        add.l #2,a6
        bsr UnrelocFromPtr
        movem.l (a7)+,d1-d7/a0-a6
        tst.w d0
        bne UnrelocLibEnd
        _DEREF d1,a2
        add.l #2,a2
        move.l a2,a5
        clr.l d0
        move.w $16(a2),d0
        add.l d0,a2
        move.w #1,d3
        bsr DoUnreloc
        add.l #10,a4
        dbra d7,UnrelocLibLoop
UnrelocLibEnd:
        tst.w (a3)+
        beq UnrelocNoROM
        move.l $c8,a2
        sub.w #2,a2
        move.w #2,d3
        bsr DoUnreloc
UnrelocNoROM:
        tst.w (a3)+
        beq UnrelocNoRAM
        clr.l d0
        move.w $18(a6),d0
        move.l a6,a4
        add.l d0,a4
        move.l ($4),d0
        and.l #$400000,d0
        beq Unreloc89
        lea.l _CALCULATOR(pc),a0
        move.b #CALC_TI92PLUS,(a0)
        lea.l RAMTable92(pc),a2
        lea.l 2(a4),a4
        bra UnrelocDoRAM
Unreloc89:
        lea.l _CALCULATOR(pc),a0
        move.b #CALC_TI89,(a0)
        lea.l RAMTable89(pc),a2
UnrelocDoRAM:
        move.w #2,d3
        bsr DoUnreloc
UnrelocNoRAM:
        clr.l d0
        move.w (a3)+,d0
        tst.w d0
        beq UnrelocRelEnd
        move.l a6,a0
        add.l d0,a0
        move.l a6,d0
        sub.l d0,(a0)
        bra UnrelocNoRAM
UnrelocRelEnd:
        tst.w $14(a6)
        beq UnrelocOK
        add.l #4,a3
        move.w $12(a6),d0
        tst.w d0
        beq UnrelocOK
        _DEREF d0,a1
UnrelocBSSLoop:
        clr.l d0
        move.w (a3)+,d0
        tst.w d0
        beq UnrelocBSSDone
        move.l a6,a0
        add.l d0,a0
        move.l a1,d0
        sub.l d0,(a0)
        bra UnrelocBSSLoop
UnrelocBSSDone:
        move.w $12(a6),d0
        tst.w d0
        beq UnrelocOK
        move.w d0,-(a7)
        ROM_CALL romfunc::HeapFree
        add.l #2,a7
UnrelocOK:
        clr.l d0
UnrelocEnd:
        movem.l (a7)+,d1-d7/a1-a6
        rts

DeallocBSS:
        tst.w $12(a6)
        beq NoBSS
        move.l a4,-(a7)
        move.w $12(a6),-(a7)
        ROM_CALL romfunc::HeapFree
        add.l #2,a7
        clr.w $12(a6)
        move.l (a7)+,a4
NoBSS:
        rts

DoReloc:
        clr.l d0
DoRelocStart:
        move.w (a2)+,d5
        move.w (a3)+,d6
DoRelocLoop:        
        clr.l d4
        move.w (a3)+,d4
        move.l a2,a1
        clr.l d2
        cmp.w #$8000,d4
        bcs DoRelocNotWord
        moveq.l #1,d2
        and.w #$7fff,d4
DoRelocNotWord:
        cmp.w #$4000,d4
        bcs DoRelocNotExtra
        move.l a4,a1
        and.w #$3fff,d4
        lsl.l #2,d4
        add.l d4,a1
        move.w (a1),a1
        bra DoRelocFuncLoop
DoRelocNotExtra:
        cmp.w d5,d4
        bgt DoRelocError
        lsl.l d3,d4
        add.l d4,a1
        cmp.w #2,d3
        beq DoRelocLoopDWordOfs
        move.w (a1),a1
        add.l a5,a1
        bra DoRelocFuncLoop
DoRelocLoopDWordOfs:
        move.l (a1),a1
DoRelocFuncLoop:
        clr.l d4
        move.w (a3)+,d4
        tst.w d4
        beq DoRelocFuncEnd
        move.l a6,a0
        add.l d4,a0
        move.l a1,d4
        tst.l d2
        bne DoRelocAddWord
        tst.l d0
        bne DoRelocSubDWord
        add.l d4,(a0)
        bra DoRelocFuncLoop
DoRelocSubDWord:
        sub.l d4,(a0)
        bra DoRelocFuncLoop
DoRelocAddWord:
        tst.l d0
        bne DoRelocSubWord
        add.w d4,(a0)
        bra DoRelocFuncLoop
DoRelocSubWord:
        sub.w d4,(a0)
        bra DoRelocFuncLoop
DoRelocFuncEnd:
        dbra d6,DoRelocLoop
        clr.l d0
        rts
DoRelocError:
        moveq.l #1,d0
        rts

DoUnreloc:
        moveq.l #1,d0
        bra DoRelocStart

GetFileAddress:
        GET_REL_RAM_WORD 0,-$18a,d0
        _DEREF d0,a5  ; Put address of main folder in a5
        move.w 2(a5),d0 ; Put number of files in d0
        add.l #4,a5
        move.l (a0),d1
        move.l 4(a0),d2
gfaFindLoop:
        tst.w d0
        beq gfaEnd
        cmp.l (a5),d1
        bne gfaNext
        cmp.l 4(a5),d2
        bne gfaNext
        move.w $c(a5),d0
        move.w d0,d1
        _DEREF d1,a0
        rts
gfaNext:           
        add.l #$e,a5
        dbra d0,gfaFindLoop
gfaEnd:
        clr.w d0
        move.l #0,a0
        rts

_CALCULATOR dc.b CALC_TI92PLUS

RAMTable92 dc.w $e
           dc.l 0,240,128,$400000,30,337,340,338,344,342,345,8192,3840,16384

RAMTable89emu dc.w $e
              dc.l 0,160,100,$400000,20,337,340,338,344,342,345,8192,2000,16384

RAMTable89 dc.w $e
           dc.l 0,160,100,$200000,20,338,344,337,340,345,342,16384,2000,8192

ProgCount dc.w 0
ScreenHandle dc.w 0

BadFileFormatMsg dc.b "Program is not valid",0
        cnop 0,2
WrongLibVersionMsg dc.b "Wrong library version:  "
WrongLibVersionName dc.b 0,0,0,0,0,0,0,0,0
        cnop 0,2
MissingLibMsg dc.b "Library not found:  "
MissingLibName dc.b 0,0,0,0,0,0,0,0,0
NoMemMsg dc.b "Out of memory",0

        cnop 0,4

_KernelEnd

VersionString dc.b $e9,0,"PlusShell v"
 VERSION_STRING
 dc.b " installed",0
VersionStringTag dc.b tios::STRING_TAG

NewVersionString dc.b $e9,0,"Kernel already installed",0
NewVersionStringTag dc.b tios::STRING_TAG

UninstallString dc.b $e9,0,"Old version uninstalled",0
UninstallStringTag dc.b tios::STRING_TAG
