// C Source File
// Created 2/19/2002; 2:11:52 PM
// By Samuel Stearley Copyright 2002


#define USE_TI89
#define USE_TI92PLUS
#define OPTIMIZE_ROM_CALLS
#define SAVE_SCREEN
#define RETURN_VALUE
#define NO_AMS_CHECK
#define NO_CALC_DETECT
#define NO_EXIT_SUPPORT
#define SET_FILE_IN_USE_BIT


#include <tigcclib.h>


void EventHandler(EVENT *ev);
void EventWrapper(EVENT *ev);
void PrintMainHelp(void);
void ClearTop(void);
void _WinStrXY(int x, int y,char * stringy);
const char blank[] = "                             \0";
const char blank2[] = "\0";
const	char possibles[] = "zsyhgab\0";

const WIN_RECT clearSpace = {0,0,0,34}; //will have to fill in x1
char currentSyntax = 0;
HANDLE h;
TEXT_EDIT te = {};
WINDOW w ={};


//Thiw wrapper wraps around the main event handler.  It
//makes sure that optimize_rom_calls will work for the event
//handler.
asm(
"EventWrapper: \n"
"move.l %a5,-(%a7) \n"
"move.l 200.w,%a5 \n"
"move.l 8(%a7),%d0 \n"
"move.l %d0,-(%a7) \n"
"bsr EventHandler \n"
"addq.l #4,%a7 \n"
"move.l (%a7)+,%a5 \n"
"rts");


void _WinStrXY(int x, int y,char * stringy)
{ 
	WinStrXY(&w,x,y,stringy);
}


void PrintMainHelp(void)
{
	ClearTop();
	WinFont(&w,F_4x6);
	_WinStrXY(0,0,"j-Current\0");
	_WinStrXY(0,7,"e-Voltage\0");
	_WinStrXY(0,14,"s-Short\0");
	_WinStrXY(0,21,"r-Resistor\0");
	_WinStrXY(0,28,"c-Capacitor\0");
	_WinStrXY(50,0,"l-Inductor\0");
	_WinStrXY(50,7,"m-Mutual Induct\0");
	_WinStrXY(50,14,"o-Op-Amp\0");
	_WinStrXY(50,21,"t-Ideal Transformer\0");
	WinFont(&w,F_6x8);
}

void ClearTop(void)
{
	WinFill(&w,&clearSpace,A_REVERSE);
}


void EventHandler(EVENT *ev){
	if (ev->Type == CM_KEYPRESS){
		int key = ev->extra.Key.Code;
  	if (key == KEY_ESC){
			char * text = HeapDeref(h);
			char * t2 = text;
			char * oldEstack = top_estack + 1;
			int badName = 0;
			for (;;){
				while(*text == '\r')	text++;
				if (*text == 0) ER_throwVar(1);
				char * dest = oldEstack;
				char temp;
				char * potentialBaddy = text;
				for (;;){				//copy in the string, stop at a comma
					temp = *(text++);
					if (temp == '\r') break;	//  or line break, or a zero
					if (temp == ',') break;
					if (temp == 0) break;
					*(dest++) = temp;
				}	
				*(dest++)= 0;			//zero terminate
				top_estack = dest;
				TRY
					push_parse_text(oldEstack);
					NG_rationalESI(top_estack);
					if (*top_estack != VAR_NAME_TAG) ER_throwVar(1);
				ONERR		//if error position cusros and print a message
					TE_select(&te,potentialBaddy-t2,potentialBaddy-t2);
					TE_focus(&te);
					_WinStrXY(0,37,&blank);
					_WinStrXY(0,37,"Error: Bad Element Name\0");
					badName = 1;
					currentSyntax = 0;
				ENDTRY
				if (badName) return;
				if (temp == 0) break;			// if we already came to a zero above
				if (temp =='\r') continue;
				// now advance to the next \r if we can
				for (;;){
					temp = *(text++);
					if (temp == '\r') break;
					if (temp == 0) break;
				}	
				if (temp == 0) break;		//if advance loop hit a zero
			}//close for
			top_estack = oldEstack-1;
			ER_throwVar(1);						// and finally exit
 		}
		else if (key == KEY_F1){
			PrintMainHelp();
			return;
		}
		else if (key == KEY_QUIT) ER_throwVar(1);
		else if (key == KEY_F2){
			ClearTop();
			WinFont(&w,F_4x6);
			_WinStrXY(0,0,"Z-2 Port Impedance\0");
			_WinStrXY(0,7,"y-2 Port Admittance\0");
			_WinStrXY(0,14,"h-2 Port Hybrid\0");
			_WinStrXY(0,21,"g-2 Port Gain\0");
			_WinStrXY(0,28,"a-2 Port Transmission Or ABCD params\0");
			_WinStrXY(73,0,"b-2 Port Inv Transmission\0");
			WinFont(&w,F_6x8);
			return;
		}
		else if ( key == KEY_F3){
			ClearTop();
			WinFont(&w,F_4x6);
			_WinStrXY(0,0,"Symbulator Element Writer\0");
			_WinStrXY(0,7,"By Samuel Stearley\0");
			_WinStrXY(0,14,"Copyright 2002\0");
			_WinStrXY(0,28,"http://www.calvin.edu/~sstear70\0");
			WinFont(&w,F_6x8);
			return;
		}
		else if (QModeKey(key)) return;
		else if (QSysKey(key)) return;
		else if ((key >= KEY_F4) && (key <= KEY_F8)) return;
  }
  if (!TE_handleEvent(&te, ev))
    EV_defaultHandler(ev);
	if ( (ev->Type != CM_IDLE) && (ev->Type != CM_BLINK))	{
		char * ptr = HeapDeref(h);
		int i = te.CursorOffset-te.CursorX;
		while (i){
			if (ptr[i-1] == '\r') break;
			i -=te.CharWidth;
		}
		char * string;
		if (ptr[i] == currentSyntax) return;
		char t =ptr[i];
		if (t=='e')
			string = "e#,+Node,-Node,value,0\0";
		else if ( (t=='j') || (t=='r')){
			string = "j#,Node1,Node2,value,0\0";
			string[0] = t;
		}
		else if ( t== '\r')
			string =&blank2;
	 	else if (t=='c')
			string ="c#,+Node,-Node,value,Vc0\0";
	 	else if (t=='l')
			string ="l#,Node1,Node2,value,il0\0";
	 	else if (t=='m')
			string ="m#,1stInd,2ndInd,value,0\0";
	 	else if (t=='t')
			string ="t#,Node1,Node2,N1,N2\0";
		else if (t=='o')
			string ="o#,+Node,-Node,outnode,0\0";
		else if (t==0)
			string =&blank2;
		// instead of if-thens look up in a table
		else{
			char * available = possibles;
			char temp;
			for (;;){
				if ( (temp = *(available++))){
					if (temp == t){
						string ="z#,Node1,Node2,0,0\0";
						string[0] = t;
						break;
					}
				}
				else{
					string = "Bad Char\0";
					break;
				}
			}
		}
		currentSyntax = t;
		_WinStrXY(0,37,&blank);
		_WinStrXY(0,37,string);
	}
}



void _main(void)
{
	SCR_RECT step1 = DeskTop->Client;
	int width = step1.xy.x1;
	int height = step1.xy.y1;
	WIN_RECT screenArea ={0,0,width,height};
	clearSpace.x1 = width;

//now the window

	WinOpen(&w, &screenArea, WF_NOBORDER | WF_NOBOLD);
	WinClr(&w);
	WinActivate(&w);
	w.Flags &= ~WF_DIRTY;
	const WIN_RECT l1= {0,45,width,45};
	const WIN_RECT l2= {0,35,width,35};
	WinLine(&w, &l1);
	WinLine(&w, &l2);
	WinAttr(&w,A_REPLACE);
	PrintMainHelp();

//now the text editor

	char * arg = top_estack;
	if ( (*arg) == STR_TAG){
		arg--;									//point to the end zero
		long count =0;
		while (*(--arg))				//point to the beginning zero
			count++;
		count +=100;
		h = HeapAlloc(count);
		if (h){
			char * point = HeapDeref(h);
			arg++;									//point to the first character
			char c;
			while ( (c = *(arg++))){
				if (c == ';'){
					*(point++) = '\r';
					if (*(arg) == ' ') arg ++;
				}
				else *(point++) = c;
			}
			*point = c;		//zero terminate
		}
	}	// close if
	else{
		h = HeapAlloc(200);
		if (h) memset(HeapDeref(h), 0, 200);
	}
	if (h){
		WIN_RECT textArea = {0, 47, width, height};
	  TE_open (&te, &w, &textArea, h, 0, 0, 3);
	  CU_start();
	  EV_captureEvents(EventWrapper);
	  TRY
	    EV_eventLoop();           // The only way to exit from "EV_eventLoop" is
	  ONERR                        //   to throw an error from the event handler
	    EV_captureEvents(NULL);

//copy it to the estack

			char * p = HeapDeref(h);
			char * e = top_estack;
			char  t;
			e++;
			*(e++) =0;
			while ((t = *(p++))){
				if (t == '\r'){
					*(e++) = ';';
					*(e++) = ' ';
				}
				else *(e++) = t;
			}
			*(e++) = 0;
			*(e) =	STR_TAG;
			top_estack = e;
			HeapFree(h);
	  ENDTRY
	}
	WinClose(&w);
}