	include "graphlib.h"
	include "userlib.h"
	include "doorsos.h"
	include "filelib.h"
	xdef	_ti92plus
	xdef	_ti89
	xdef	_library
	xdef	ziplib@0000
	xdef	ziplib@0001
	xdef	ziplib@0002
	xdef	ziplib@0003
	xdef	ziplib@0004
	xdef	ziplib@0005
	xdef	ziplib@0006
	xdef	ziplib@0007
	xdef	ziplib@0008
	xdef	ziplib@0009
	xdef	ziplib@000A
	xdef	ziplib@000B

;ZIPLIB v1.5
;-----------------------------------------------------------------
;structure de l'archive : 00 01 pour nb de fichiers de hufflibs
;			  XX XX nLenght 
;                         XX XX position de l'addresse de depart
;                         XX XX position du bit de depart
;                         XX XX taille du fichier extrait 
;-----------------------------------------------------------------


Write8992 Macro
	lea	\1(PC),a0
	bsr	WriteS89
	ENDM

ziplib@0000:
Temp_cmem:
	movem.l		a0-a6/d1-d7,-(a7)
	move.l		#$1000,-(a7)
Test_mem:
	jsr		doorsos::HeapMax
	move.l		(a7)+,d1
	cmp.l		d1,d0
	ble		Out_Of_Mem
	moveq.w		#1,d0
Out_Of_Mem:
	movem.l		(a7)+,a0-a6/d1-d7
	rts
;-----------------------------------------------------------------
ziplib@0001:
Temp_emem:
	movem.l 	a0-a6/d1-d7,-(a7)
 	move.l		#1140,-(a7)
	bra		Test_mem

;-----------------------------------------------------------------
ziplib@0002:
Eval_cmem:
	movem.l		a0-a6/d1-d7,-(a7)
	move.w		d0,Lenght
	move.l		a0,origin
	bsr		Temp_cmem
	tst.l		d0
	beq		Out_Of_Mem
	bsr		Evaluation_frequences
	move.w		d4,d7
	move.w		arbre_h,-(a7)
	jsr    		doorsos::HeapFree
	addq.l		#2,a7
	clr.l		d0
	move.w		d7,d0
	movem.l		(a7)+,a0-a6/d1-d7
	rts

;-----------------------------------------------------------------
ziplib@0003:
Eval_emem:
	clr.l		d0
	move.w		8(a0),d0
	rts
;-----------------------------------------------------------------
ziplib@0004:
Compress:
	movem.l		a0-a6/d1-d7,-(a7)
	move.w		d0,Lenght
	move.l		a0,origin
	move.l		a1,cible
	bsr		Temp_cmem
	tst.l		d0
	beq		Out_Of_Mem
	bsr		Evaluation_frequences
	bsr		Compression
	move.w		#1,d0
	movem.l		(a7)+,a0-a6/d1-d7
	rts
;-----------------------------------------------------------------

ziplib@0008:
extract_string:
 	movem.l 	d0-d7/a0-a6,-(sp)
 	st	 	d5
 	bsr 		Extract2
 	movem.l 	(sp)+,d0-d7/a0-a6
 	rts

;-------------------------------------------------------

ziplib@0009:
write_string:
 	movem.l 	d0-d7/a0-a6,-(sp)
 	move.w  	#4,-(sp)
WriteString:
 	subq	 	#4,sp
 	move.w  	d1,-(sp)
 	move.w  	d0,-(sp)
 	move.l  	a0,-(sp)
 	move.l  	#80,-(sp)
 	jsr 		doorsos::HeapAlloc
 	addq	 	#4,sp
 	move.l  	(sp)+,a0
 	tst.w	 	d0
 	beq 		RestoreRegs
 	move.w  	d0,tmpstrH
 	doorsos::DEREF 	d0,a1
 	move.l  	a1,4(sp)
 	st	 	d5
 	bsr 		Extract2
 	jsr 		doorsos::DrawStrXY
 	move.w  	tmpstrH(PC),-(sp)
 	jsr 		doorsos::HeapFree
 	addq	 	#2,sp
RestoreRegs:
 	lea	 	10(sp),sp
 	movem.l 	(sp)+,d0-d7/a0-a6
 rts

;---------------------------------------------------------

ziplib@000A:
write_string_inv:
 	movem.l 	d0-d7/a0-a6,-(sp)
 	clr.w	 	-(sp)
 	bra 		WriteString

;---------------------------------------------------------

ziplib@000B:
iscomp:
	movem.l		a0-a1,-(a7)
	move.w		12(a0),d0
	doorsos::DEREF	d0,a0
	clr.l		d0
	move.w		(a0),d0
	cmp.b		#$FF,3(a0)
	bne		ncompress
	add.l		d0,a0
	subq.l		#3,a0
	moveq.w		#4,d0
	lea		term(PC),a1
loop_test:
	cmp.b		(a0)+,(a1)+
	bne		ncompress
	clr.w		d0
	bra		endiscomp
ncompress:
	moveq.w		#1,d0
endiscomp:
	movem.l		(a7)+,a0-a1
	rts

;------------------------------------------------------------------
ziplib@0005:
extract:
 	movem.l 	d0-d7/a0-a6,-(sp)
 	sf	 	d5
 	bsr 		Extract2
 	movem.l 	(sp)+,d0-d7/a0-a6
 	rts

Extract2:
	movem.l 	a0-a1,-(a7)
 	move.l  	#1024,-(a7)
	jsr 		doorsos::HeapAlloc
	addq	 	#4,a7
	movem.l 	(a7)+,a0-a1
	tst.l		d0
	beq		Out_Of_Mem
 	move.w  	d0,tableH
 	doorsos::DEREF 	d0,a6
	move.w		#$700,d0
	trap		#1
 	move.l  	a0,a2
	move.w  	(a2)+,d2
 	cmp.w	 	#1,d2
 	bne	 	MultiFiles
 	clr.w	 	d3
MultiFiles:
 	move.w  	(a2)+,d0
 	move.l  	a2,a3
 	mulu	 	#6,d2
	add.w	 	d2,a3
	mulu	 	#6,d3
 	add.w	 	d3,a2
 	move.w  	d0,d6
 	subq	 	#1,d6
 	move.l  	a3,a4
 	add.w	 	d0,a4
 	clr.l	 	d0
 	clr.l	 	d1
UncrunchTree:
 	btst.b  	d1,(a4)
 	beq 		NoBranch
 	move.w  	d0,-(a7)
 	addq	 	#2,d0
NextTreeBit:
 	addq	 	#1,d1
 	bclr	 	#3,d1
 	beq 		UncrunchTree
 	addq	 	#1,a4
 	bra 		UncrunchTree
NoBranch:
 	clr.b	 	0(a6,d0)
 	move.b  	(a3)+,1(a6,d0)
 	addq	 	#2,d0
 	tst.w	 	d6
 	beq 		TreeBuilt
 	move.w  	(a7)+,d2
 	move.w  	d0,0(a6,d2)
 	bset.b  	#7,0(a6,d2)
 	dbra	 	d6,NextTreeBit
TreeBuilt:
 	move.w  	(a2)+,d0
 	add.w	 	d0,a0
 	move.w  	(a2)+,d3
 	move.w  	(a2),d7
 	subq	 	#1,d7
UncrunchData:
 	clr.l	 	d1
CheckTree:
 	move.w  	0(a6,d1),d2
 	bclr	 	#15,d2
 	beq 		EndOfBranch
 	btst.b  	d3,(a0)
 	bne 		RightBranch
 	addq	 	#2,d1
 	bra 		NextDataBit
RightBranch:
 	move.w  	d2,d1
NextDataBit:
 	addq	 	#1,d3
 	bclr	 	#3,d3
 	beq 		CheckTree
 	addq	 	#1,a0
 	bra 		CheckTree
EndOfBranch:
 	move.b  	d2,(a1)+
Repeat:
 	dbra	 	d7,UncrunchData
 	bra 		Done
ExtractString:
 	tst.w	 	d4
 	beq 		WriteData
 	tst.b		 d2
 	bne 		Repeat
 	subq	 	#1,d4
 	bra 		Repeat
WriteData:
 	move.b  	d2,(a1)+
 	tst.b	 	d2
 	bne 		Repeat
Done:
 	move.w  	tableH(PC),-(a7)
 	jsr 		doorsos::HeapFree
 	addq	 	#2,a7
	clr.w		d0
	trap		#1
 	move.w  	(a2),d0
	rts

;-----------------------------------------------------------------
Evaluation_frequences:
	move.w		#$700,d0
	trap		#1
	move.l		#$200,-(a7)
	jsr		doorsos::HeapAlloc
	addq.l		#4,a7
	move.w		d0,tab_handle
	doorsos::DEREF	 d0,a1
	bsr		Clr_Handle
	move.l		a1,tab_addr
	move.l		#$200,-(a7)
	jsr		doorsos::HeapAlloc
	addq.l		#4,a7
	move.w		d0,tab_handle2
	doorsos::DEREF	 d0,a1
	bsr		Clr_Handle
	move.l		a1,tab_addr2
	move.l		tab_addr,a2
	move.l		origin,a0
	clr.l		d2
	move.w		Lenght,d2
	add.l		d2,a0
	subq.w		#1,d2
	clr.l		d7
Boucle_de_construction_Tab_de_freq:
	clr.w		d0
	move.b		-(a0),d0
	lsl.w		#1,d0
	tst.w		0(a1,d0.w)
	bne		Non_vide
	addq.w		#1,d7
Non_vide:
	add.w		#1,0(a1,d0.w)
	add.w		#1,0(a2,d0.w)
	dbra		d2,Boucle_de_construction_Tab_de_freq
	move.w		d7,nLenght
	cmp.w		#1,d7
	bne		pas_uni_octet
	move.w  	tab_handle2(PC),-(a7)
 	jsr    		doorsos::HeapFree
	move.l		#$3FE,-(a7)
	jsr		doorsos::HeapAlloc
	addq.l		#6,a7
	move.w		d0,arbre_h
	doorsos::DEREF	d0,a1
	move.l		a1,arbre_a		
	move.l		a1,a4
	move.w		#2,nLenght
	move.l		tab_addr,a0
	move.w		#$FFFE,d1
\uni_octet:
	addq.w		#2,d1
	tst.w		0(a0,d1.w)
	beq		\uni_octet
	lsr.w		#1,d1
	clr.w		d7
	move.w		#$8004,(a1)+
	move.w		d1,(a1)+
	move.w		d1,(a1)+
	bra		uni_octet2
pas_uni_octet:
	move.l		#$400,-(a7)
	jsr		doorsos::HeapAlloc
	addq.l		#4,a7
	move.w		d0,freq_h
	doorsos::DEREF	d0,a1
	move.l		a1,freq_a
	move.l		tab_addr2,a0
	clr.w		d1
Creation_freq:
	move.w		#$FFFF,d2		
	clr.w		d3
	clr.w		d0
Recherche_Freq:
	move.w		0(a0,d0.w),d4
	tst.w		d4
	beq		Plus_petite
	cmp.w		d4,d2
	bls		Plus_petite
	move.w		d0,d3		
	move.w		d4,d2
Plus_petite:
	addq.w		#2,d0
	cmp.w		#$200,d0
	bne		Recherche_Freq
	tst.w		0(a0,d3.w)
	beq		Fin_de_Creation_Freq
	clr.b		(a1)+
	move.w		d3,d4
	lsr.w		#1,d4
	move.b		d4,(a1)+		
	move.w		0(a0,d3.w),(a1)+
	clr.w		0(a0,d3.w)
	bra		Creation_freq
Fin_de_Creation_Freq:
	move.w  	tab_handle2(PC),-(a7)
 	jsr    		doorsos::HeapFree
	move.l		#$3FC,-(a7)
	jsr		doorsos::HeapAlloc
	addq.l		#6,a7
	move.w		d0,noeuds_h
	doorsos::DEREF	d0,a1
	move.l		a1,noeuds_a
	clr.l		d6				;d6 = arbre en construction
	move.w		nLenght,d7			;d7 = nombre de branches -1
	move.l		freq_a,a0
	cmp.w		#2,d7
	beq		bi_octet
	subq.w		#1,d7
Creation_des_noeuds:
	move.w		(a0)+,(a1)+
	move.w		(a0)+,d0
	move.w		(a0),(a1)+
	add.w		2(a0),d0
	subq.b		#1,d7
	clr.b		d2
	clr.w		d3
Rang_Boucle:
	cmp.w		6(a0,d3.w),d0			
	bls		Bien_ranger
	move.l		4(a0,d3.w),0(a0,d3.w)
	addq.b		#1,d2
	addq.w		#4,d3
	cmp.b		d2,d7			; .B ?
	bhi		Rang_Boucle
Bien_ranger:
	move.w		d6,0(a0,d3.w)
	bset.w		#15,0(a0,d3.w)
	move.w		d0,2(a0,d3.w)
	add.w		#1,d6		
	cmp.w		#1,d7
	bne		Creation_des_noeuds		; d6 = nb de noeuds
bi_octet:
	move.w		(a0)+,(a1)+
	move.w		2(a0),(a1)+
	move.w		freq_h(PC),-(a7)
	jsr		doorsos::HeapFree
	move.l		#$3FE,-(a7)
	jsr		doorsos::HeapAlloc
	addq.l		#6,a7
	move.w		d0,arbre_h
	doorsos::DEREF	d0,a1
	move.l		a1,arbre_a
	move.l		noeuds_a,a0			
	move.l		a1,a4
	move.w		nLenght,d7
	lsl.w		#2,d7
	subq.w		#2,d7
	add.w		d7,a4
	subq.w		#6,d7
	move.w		d7,d0
	bra		Debut_Arbre
Creation_Arbre:
	move.w		0(a0,d0.w),d0
	bclr.w		#15,d0
	beq		Fin_de_branche
	lsl.w		#2,d0
Debut_Arbre:
	move.w		d0,d1
	addq.w		#2,d1
	move.l		a1,-(a7)
	move.w		d1,-(a7)
	adda.l		#2,a1
	bra		Creation_Arbre
Fin_de_branche:
	move.w		d0,(a1)+
	cmp.l		a1,a4
	ble		Fin_de_Creation_Arbre
	move.w		(a7)+,d0
	move.l		(a7)+,a2
	move.l		arbre_a,d2
	move.l		a1,d1
	sub.l		d2,d1
	bset.w		#15,d1
	move.w		d1,0(a2)
	bra		Creation_Arbre
Fin_de_Creation_Arbre:
	move.w  	noeuds_h(PC),-(a7)
 	jsr    		doorsos::HeapFree
	addq.l		#2,a7
uni_octet2:
	move.l		arbre_a,a2
	move.w		d7,d6
	addq.w		#6,d6
	clr.l		d4
	move.l		tab_addr,a0
	move.w		#$FF,d0
Freq_non_nulle:
	move.w		d0,d1
	lsl.w		#1,d1
	tst.w		0(a0,d1.w)
	beq		Freq_vide
	move.w		d6,d2
	clr.l		d7
Trouve_debut_arbre:
	subq.w		#2,d2
	cmp.w		0(a2,d2.w),d0
	bne		Trouve_debut_arbre
Cherche_branche:
	move.w		d2,d3
	subq.w		#2,d3
	btst.b		#7,0(a2,d3.w)
	bne		Bonne_branche
	clr.w		d3
	bset.w		#15,d2
Loop_cherche_branche:
	cmp.w		0(a2,d3.w),d2				
	bne		Pas_branche
Bonne_branche:
	add.w		#1,d7
	tst.w		d3
	beq		Trouver
	move.w		d3,d2
	bra		Cherche_branche
Pas_branche:
	addq.w		#2,d3
	bra		Loop_cherche_branche				
Trouver:
	clr.l		d5
	move.w		0(a0,d1.w),d5
	mulu.l		d5,d7
	add.l		d7,d4
Freq_vide:
	dbra		d0,Freq_non_nulle
	move.w  	tab_handle(PC),-(a7)
 	jsr    		doorsos::HeapFree
	addq.l		#2,a7
	clr.l		d7
	move.w		nLenght,d7
	lsl.w		#1,d7
	subq.w		#1,d7
	add.l		d7,d4
	move.b		d4,d7
	and.b		#%00000111,d7
	lsr.l		#3,d4
	add.w		#10,d4
	clr.l		d0
	move.w		nLenght,d0
	add.l		d0,d4
	clr.w		d0
	trap		#1
	tst.b		d7
	beq		Pas_dexces            ;d4 = longueur total du texte compresse
	addq.l		#1,d4
	subq.b		#1,d7
	rts
Pas_dexces:
	move.b		#7,d7
	rts

Compression:	
	move.w		#$700,d0
	trap		#1
	move.l		#$600,-(a7)
	jsr		doorsos::HeapAlloc
	addq.l		#4,a7
	move.w		d0,tableH
	doorsos::DEREF	d0,a4
	move.l		a4,a5
	move.l		a5,a6
	adda.l		#$200,a6
	move.w		#$3F,d0
Clear_table:
	clr.l		(a5)+
	dbra		d0,Clear_table
	move.l		cible,a1
	move.l		a1,a3
	move.w		#1,(a3)+
	clr.w		d0
	move.w		nLenght,d0
	move.w		d0,(a3)+
	move.w		d0,d1
	subq.w		#1,d0
	lsr.w		#2,d0
	addq.w		#1,d0
	add.w		d1,d0
	add.w		#9,d0
	move.w		d0,(a3)+
	lsl.w		#1,d1
	subq.w		#1,d1
	and.b		#%111,d1
	clr.b		(a3)+
	move.b		d1,(a3)+
	clr.l		d5
	move.w		Lenght,d5
	move.w		d5,(a3)+		
	add.l		d4,a1
	suba.l		#1,a1
	move.l		origin,a0
	move.l		arbre_a,a2
	add.l		d5,a0
	subq.w		#1,d5
	clr.w		d0
Compression_des_donnees:
	move.b		-(a0),d0
	tst.b		0(a4,d0.w)
	beq		Nouvel_octet
	move.w		d0,d1
	lsl.w		#2,d1
	clr.w		d4
	move.b		0(a4,d0.w),d4
	move.l		0(a6,d1.w),a3
	move.b		0(a5,d0.w),d1
Copy_octet:
	btst.b		d1,(a3)
	beq		Copy_octet_nul
	bset.b		d7,(a1)
	bra		Fin_Copy_octet
Copy_octet_nul:
	bclr.b		d7,(a1)
Fin_Copy_octet:
	tst.b		d7
	bne		No_Shift_source
	bset.b		#3,d7
	suba.l		#1,a1
No_Shift_source:
	tst.b		d1
	bne		No_Shift_origine
	bset.b		#3,d1
	suba.l		#1,a3
No_Shift_origine:
	subq.b		#1,d7
	subq.b		#1,d1
	dbra		d4,Copy_octet
	bra		Fin_de_compression
Nouvel_octet:
	clr.b		d4
	move.w		d0,d1
	lsl.w		#2,d1
	move.l		a1,0(a6,d1.w)
	move.b		d7,0(a5,d0.w)
	move.w		d6,d2
Trouve_debut_compression:
	subq.w		#2,d2
	cmp.w		0(a2,d2.w),d0
	bne		Trouve_debut_compression
Cherche_droit:
	move.w		d2,d3
	subq.w		#2,d3
	btst.b		#7,0(a2,d3.w)
	beq		Cherche_gauche
	bclr.b		d7,(a1)
	bra		Trouver_origine
Cherche_gauche:
	clr.w		d3
	bset.w		#15,d2
Loop_cherche_gauche:
	cmp.w		0(a2,d3.w),d2
	bne		Pas_gauche
	bset.b		d7,(a1)
Trouver_origine:
	tst.b		d7
	bne		No_Shift
	bset.b		#3,d7
	suba.l		#1,a1
No_Shift:
	subq.b		#1,d7
	tst.w		d3
	beq		Fin_arbre
	addq.b		#1,d4
	move.w		d3,d2
	bra		Cherche_droit
Pas_gauche:
	addq.w		#2,d3
	bra		Loop_cherche_gauche	
Fin_arbre:
	move.b		d4,0(a4,d0.w)
Fin_de_compression:
	dbra		d5,Compression_des_donnees
	clr.l		d1
	move.w		nLenght,d1
	lsl.w		#2,d1
	subq.w		#4,d1
	move.l		cible,a0
	clr.l		d2
	move.w		nLenght,d2
	adda.l		#10,a0
	add.l		d2,a0
Compression_arbre:
	btst.b		#7,0(a2,d1.w)
	bne		T_branche
	move.b		1(a2,d1.w),-(a0)
	bclr.b		d7,(a1)
Loop_Compression_arbre:
	tst.b		d7
	bne		No_Shift_arbre
	bset.b		#3,d7
	suba.l		#1,a1
No_Shift_arbre:
	subq.b		#1,d7
	tst.w		d1
	beq		Fin_de_compression_arbre
	subq.w		#2,d1
	bra		Compression_arbre
T_branche:
	bset.b		d7,(a1)
	bra		Loop_Compression_arbre
Fin_de_compression_arbre:
	move.w  		arbre_h(PC),-(a7)
 	jsr    		 doorsos::HeapFree
	move.w		tableH(PC),-(a7)
	jsr		doorsos::HeapFree
	addq.l		#4,a7
	clr.w		d0
	trap		#1
	rts


ziplib@0006:
	movem.l		d1-d7/a0-a6,-(a7)
	bsr		Temp_file
	movem.l		(a7)+,d1-d7/a0-a6
	rts


Temp_file:
	clr.b		arc
	move.b		d0,com
	move.l		a0,file_a
	cmp.b		#1,temp
	beq		not_archived				;tester l'extraction rapide de fichiers archivs
	btst.w		#4,11(a0)
	bne		archived
	btst.w		#9,10(a0)
	beq		not_archived
	move.b		#1,arc
	move.w		12(a0),d2
	jsr		filelib::hdltoindex
	jsr		filelib::unarchive
	tst.w		d2
	beq		mem
not_archived:
	move.l		a0,a1
	lea		filename(PC),a2
	moveq.w		#8,d0
Copy_nom:
	move.b		(a1)+,(a2)+
	dbra		d0,Copy_nom
	move.w		12(a0),d0
	move.w		d0,file_h
	doorsos::DEREF	d0,a4
	clr.l		d0
	move.w		(a4)+,d0
	cmp.w		#24,d0
	bls		too_small
	move.w		d0,Lenght
	move.l		file_a,a0
	bsr		iscomp
	tst.w		d0
	bne		compress
	cmp.b		#2,com
	bne		eok
	lea		conf(PC),a1
	bsr		Winop
	SetFont		#1
	Write8992	name
	Write8992	eq
	bsr		question
	tst.b		d7
	bne		eok
	rts
eok:
	pea		Title_e(PC)
	jsr		doorsos::ST_showHelp
	addq.l		#4,a7
	addq.w		#2,a4
	clr.l		d0
	move.w		8(a4),d0
	add.l		#2,d0
	move.l		d0,d7
	move.l		d7,-(a7)
	jsr		doorsos::HeapAlloc
	addq.l		#4,a7
	tst.l		d0
	beq		mem
	move.w		d0,arch_h
	doorsos::DEREF	d0,a1
	move.l		a1,arch_a
	bsr		Temp_emem		
	tst.l		d0
	bne		Enough_mem_for_extraction
	move.w		arch_h,-(a7)
	jsr		doorsos::HeapFree
	addq.l		#2,a7
	bra		mem
Enough_mem_for_extraction:
	subq.w		#2,d7
	move.w		d7,(a1)+
	move.l		a4,a0
	bsr		extract
	jsr		doorsos::ST_eraseHelp
	move.l		file_a,a0
	cmp.b		#0,temp
	beq		No_Temp_End
	move.b		#0,temp
	move.w		arch_h,d1
	bra		arche
No_Temp_End:
	move.w		arch_h,12(a0)
	move.w		file_h,-(a7)
	jsr		doorsos::HeapFree
	addq.l		#2,a7
	tst.b		arc
	beq		arche
	move.w		arch_h,d2
	jsr		filelib::hdltoindex
	jsr		filelib::archive
arche:
	clr.b		d0
	clr.b		com
	rts

compress:
	tst.b		temp
	beq		No_Temp_file
	tst.b		com
	beq		no_error5
	move.w	 	#50,-(a7)
	jsr		doorsos::ERD_dialog
	addq.l		#2,a7
no_error5:
	move.b		#5,d0
	rts
No_Temp_file:
	cmp.l          	#$36386B50,4(a4)        ;"68KP"
	beq            		\OK
	cmp.l          	#$36386B4C,4(a4)        ;"68KL"
	bne            		NotDoors
\OK:
	tst.w          		8(a4)
	beq             	NotDoors
	tst.b		com
	beq		no_error4
	move.w	 	#970,-(a7)
	jsr		doorsos::ERD_dialog
	addq.l		#2,a7
no_error4:
	move.b		#4,d0
	rts
NotDoors:
	cmp.b		#2,com
	bne		cok
	lea		conf(PC),a1
	lea		rect(Pc),a0
	bsr		Winop
	SetFont		#1
	Write8992	name
	Write8992	cq
	bsr		question
	tst.b		d7
	bne		cok
	rts
cok:

	pea		Title_c(PC)
	jsr		doorsos::ST_showHelp
	lea		4(a7),a7
	clr.l		d0
	move.w		Lenght,d0
	move.l		d0,-(a7)
	jsr		doorsos::HeapAlloc
	addq.l		#4,a7
	tst.l		d0
	beq		mem
	move.w		d0,arch_h
	doorsos::DEREF	d0,a1
	move.l		a1,arch_a
	bsr		Temp_cmem
	tst.l		d0
	bne		enuf_compr_mem
	move.w		arch_h,-(a7)
	jsr		doorsos::HeapFree
	addq.l		#2,a7
	bra		mem
enuf_compr_mem:
	addq.l		#4,a1
	move.l		a4,origin
	move.l		a1,cible
	bsr		Evaluation_frequences
	add.w		#10,d4
	cmp.w		Lenght,d4
	bls		Good_compressed
	move.w		arbre_h,-(a7)
	jsr    		doorsos::HeapFree
	move.w		arch_h,-(a7)
	jsr		doorsos::HeapFree
	addq.l		#4,a7
too_small:
	tst.b		com
	beq		no_error2
	lea		Title_nc(PC),a1		
	bsr		Winop
	SetFont		#1
	Write8992	Sorry
	Write8992	Sorry2
	jsr		userlib::idle_loop
	bsr		Winc
no_error2:
	move.b		#2,d0
	rts
Good_compressed:
	move.w		d4,c_lenght
	sub.w		#10,d4
	bsr		Compression
	clr.l		d7
	move.w		c_lenght,d7
	subq.w		#2,d7
	move.w		file_h,d2
	jsr		filelib::hdltoindex
	jsr		filelib::gettype
	move.b		d2,type
	move.l		file_a,a0
	move.w		arch_h,12(a0)
	clr.l		d0
	move.w		c_lenght,d0
	jsr		filelib::resizefile
	move.l		arch_a,a1
	move.l		a1,a2
	add.l		d7,a2
	moveq.w		#5,d0
	subq.l		#4,a2
	lea		terma(PC),a0
loot_term:
	move.b		(a0)+,(a2)+
	dbra		d0,loot_term
	move.w		d7,(a1)+
	move.b		type,(a1)+
	move.b		#$FF,(a1)+
	move.w		file_h,-(a7)
	jsr		doorsos::HeapFree
	addq.l		#2,a7
	tst.b		arc
	beq		no_arch3
	move.w		arch_h,d2
	jsr		filelib::hdltoindex
	jsr		filelib::archive
no_arch3:
	jsr		doorsos::ST_eraseHelp
	cmp.b		#2,com
	bne		no_com_c
	addq.w		#2,d7
	clr.l		d0
	move.w		Lenght,d0
	add.w		#2,d0
	move.w		d0,d6
	lea		C_size(PC),a0
	move.l		#5,d1
	bsr		ConvStr
	adda.l		#5,a0
	move.b		#$20,(a0)+
	move.b		#26,(a0)+
	move.b		#$20,(a0)+
	move.w		d7,d0
	move.l		#5,d1
	bsr		ConvStr
	clr.l		d5
	move.w		d7,d5
	mulu		#100,d5
	divu		d6,d5
	move.w		#100,d6
	sub.w		d5,d6
	lea		Ratio(PC),a0
	adda.l		#8,a0
	move.l		#2,d1
	move.w		d6,d0
	bsr		ConvStr
	lea		done_c(PC),a1
	bsr		Winop
	SetFont		#1
	Write8992	name
	Write8992	C_sizea
	Write8992	Ratioa
	SetFont		#0
	Write8992	credits
	jsr		userlib::idle_hot
	bsr		Winc
no_com_c:
	clr.b		d0
	clr.b		com
	rts


WriteS89:
	move.w		#4,-(a7)
WriteS89s:
	pea		4(a0)
	clr.w		d0
	move.b		CALCULATOR,d0
	lsl.b		#1,d0
	clr.w		d1
	move.b		1(a0,d0.w),d1
	move.w		d1,-(a7)
	move.b		0(a0,d0.w),d1
	move.w		d1,-(a7)
	jsr		doorsos::DrawStrXY        ; call the DrawStrXY ROM function
	lea	 	10(a7),a7
	rts

mem:
	tst.b		com
	beq		no_error3
	move.w	 	#670,-(a7)
	jsr		doorsos::ERD_dialog
	addq.l		#2,a7
no_error3:
	move.b		#3,d0
	rts

question:
	tst.b		CALCULATOR
	bne		question922
	SetFont	#0
question922:
	move.w		#3,-(a7)			;1=OK 2=SAVE 3=YES 4=CANCEL 5=NO
	pea		window(PC)			:6=GOTO
	jsr		doorsos::DrawStaticButton
	addq.l		#6,a7
	move.w		#80,-(a7)
	move.w		#5,-(a7)			;1=OK 2=SAVE 3=YES 4=CANCEL 5=NO
	pea		window(PC)			:6=GOTO
	jsr		doorsos::DrawStaticButton
	addq.l		#8,a7
	jsr		userlib::idle_hot
	clr.b		d7
	cmp.w		#264,d0
	beq		fin_q
	moveq.b		#1,d7
fin_q:
	bsr		Winc
	rts
	
Winop:
	move.l		a1,-(a7)
	move.w		#$D018,-(a7)  
	lea		rect(PC),a0
	tst.b		CALCULATOR
	beq		win89
	addq.l		#8,a0
win89:
	move.l		a0,-(a7)
	pea		window(PC)
	jsr		doorsos::WinOpen
	lea		14(a7),a7
	tst.b		CALCULATOR
	bne		question92
	clr.w		-(a7)
	pea		window(PC)
	jsr		doorsos::WinFont
	addq.l		#6,a7
question92:
	pea		window(PC)
	jsr		doorsos::WinActivate
	addq.l		#4,a7
	rts

Winc:
	pea		window(PC)
	jsr		doorsos::WinClose
	addq.l		#4,a7
	rts

archived:
	tst.b		com
	beq		no_error1
	move.w	 	#980,-(a7)
	jsr		doorsos::ERD_dialog
	addq.l		#2,a7
no_error1:
	move.b		#1,d0
	rts

ziplib@0007:
	movem.l		d2-d7/a0-a6,-(a7)
	move.b		#1,temp	
	bsr		Temp_file
	movem.l		(a7)+,d2-d7/a0-a6
	rts

; --------------------------------
;
;  Converts a number to a string
;
;   IN:  d0  - The number
;	 d1  - Number of digits
;	 a0  - Pointer to string
;   OUT: *a0 - The string (null-terminated)
;
; --------------------------------

ConvStr:
 	adda.l  		d1,a0
 	subq.b  		#1,d1
RepConv:
 	divu	 	#10,d0
 	move.l  		d0,d2
 	lsr.l	 	#8,d2
 	lsr.l	 	#8,d2
 	add.b	 	#48,d2
 	move.b  		d2,-(a0)
 	and.l	 	#$FFFF,d0
 	dbra	 	d1,RepConv
 	rts

Clr_Handle: ;a1 points to handle
	move.w		#$7F,d0			
	move.l		a1,a2
Clr_Handle_Loop:
	clr.l		(a2)+
	dbra		d0,Clr_Handle_Loop
	rts


	
;DATAS----------------------------------------------------------------

Lenght		dc.w		0
origin		dc.l		0
cible		dc.l		0
tab_handle	dc.w		0
tab_addr	dc.l		0
tab_handle2	dc.w		0
tab_addr2	dc.l		0
nLenght		dc.w		0
arbre_h		dc.w		0
arbre_a		dc.l		0
freq_h		dc.w		0
freq_a		dc.l		0
noeuds_h	dc.w		0
noeuds_a	dc.l		0
tableH	   	dc.w 		0	
arch_h		dc.w		0
file_a		dc.l		0
file_h		dc.w		0
arch_a		dc.l		0
c_lenght	dc.w		0
tmpstrH		dc.w		0
window		ds.w		21
rect		dc.w		10,21,150,70,41,30,197,90
conf		dc.b		"Confirmation",0
com		dc.b		0
name		dc.b		40,34,75,48,"Name : "
filename	ds.b		9
temp		dc.b		0
Title_e		dc.b		"EXTRACTING ...",0
Title_c		dc.b		"COMPRESSING ...",0
Title_nc	dc.b		"Not Compressing!",0
Ratioa		dc.b		47,54,83,68
Ratio		dc.b		"Ratio:    %",0
C_sizea		dc.b		42,45,78,58
C_size		ds.b		14           
Sorry		dc.b		12,40,52,51,"Compressed file bigger",0
Sorry2		dc.b		18,50,52,61,"than original file.",0
done_c		dc.b		"Compressed !",0
cq		dc.b		42,45,76,62,"Compress it ?",0
eq		dc.b		42,45,76,62,"Extract it ?",0
credits		dc.b		64,64,110,83," 1999 Marc TEYSSIER",0
arc		dc.b		0
type		dc.b		0
terma		dc.b		0
term		dc.b		"ZIP",0,$F8
x end
