// C Source File
// Created 27.02.2003; 20:15:40

#define USE_TI92PLUS          // Compile for TI-92 Plus
#define USE_V200              // Compile for V200

#define OPTIMIZE_ROM_CALLS    // Use ROM Call Optimization

//#define MIN_AMS 101           // Compile for AMS 1.00 or higher

#define SAVE_SCREEN           // Save/Restore LCD Contents

#include <tigcclib.h>         // Include All Header Files

void _main(void)
{
 double imag_c, mag_c, mag, imag, mag2, imag2, mag_min = -2, mag_max = 1, imag_min = -1.33, imag_max = 1.33, multiplikator_mag, mittelpunkt_mag, multiplikator_imag, mittelpunkt_imag;
 int key,i, genauigkeit = 60;
 void *kbq = kbd_queue();
 
 //ESI argptr = top_estack;
 //if (GetIntArg (argptr)) genauigkeit = GetIntArg (argptr);
 
 multiplikator_imag = 128/abs(imag_max - imag_min);
 mittelpunkt_imag = -imag_min*multiplikator_imag;
 
 multiplikator_mag = multiplikator_imag;
 mittelpunkt_mag = -mag_min*multiplikator_mag;
 
 clrscr();
 
 FontSetSys(F_4x6);
 
 if (!GrayOn()) return;
 
 for (mag_c = mag_min; mag_c < mag_max; mag_c+=(1/multiplikator_mag))
 {

 	 for (imag_c = imag_min; imag_c < imag_max; imag_c+=(1/multiplikator_imag))
   {

	  mag = 0;
	  imag = 0;

	  for (i = 0; (mag*mag + imag*imag < 4) && (i <= genauigkeit); i++)
	  {
	   
	   if (!OSdequeue(&key, kbq) && key == KEY_ESC)
	   {
	   	GrayOff();
	   	return;
	   }
	   
	   mag2 = mag*mag - imag*imag + mag_c;
	   imag2 = 2*mag*imag + imag_c;
	   
	   mag = mag2;
	   imag = imag2;
	   
	  }
	  
	  SetPlane(LIGHT_PLANE);
	  if ((i > genauigkeit/4 && i <= genauigkeit/2) || i > 3*genauigkeit/4) DrawPix(mag_c*multiplikator_mag+mittelpunkt_mag, imag_c*multiplikator_imag+mittelpunkt_imag, A_NORMAL);
	  SetPlane(DARK_PLANE);
	  if (i > genauigkeit/2) DrawPix(mag_c*multiplikator_mag+mittelpunkt_mag, imag_c*multiplikator_imag+mittelpunkt_imag, A_NORMAL);
   }

 }
 
 printf_xy(230,121,"ok");
 
 ngetchx();
 GrayOff();
 
}
