/******************************************************************************
*
* project name:  VTI-Logger
* file name:     vtilog.h
* initial date:  14/01/2002
* authors:       Thomas Nussbaumer (thomas.nussbaumer@gmx.net)
*                Hai Pho Truong (novaxius@yahoo.ca)
*
* description:   headerfile for VTI-Logger
*
* If you want to use VTI-Logger this headerfile defines some useful macros
* for you. Make sure you haven't disabled one of interrupts which is necessary
* for link port communications
*
* -----------------------------------------------------------------------------
* the following macros are defined here:
* -----------------------------------------------------------------------------
*
* dbg_prints(message)      - sends a message over the the linkport
* dbg_printsln(message)    - sends a message over the the linkport and appends
*                             a linebreak (NOTE: for VTI-Logger "\r\n" is
*                                               necessary as linebreak!)
*
* dbg_printf(format,...)   - printf-like variant of dbg_prints
* dbg_printfln(format,...) - printf-like variant of dbg_println
*
* -----------------------------------------------------------------------------
* toggle DEBUGGING
* -----------------------------------------------------------------------------
* to turn the linkport output macros OFF just insert the following line
* BEFORE vtilog.h gets included:
*
* #define VTILOG_DISABLED
*
* This may be quite handy, because you don't need to remove the debug output
* lines. Just recompiling is enough
*
******************************************************************************/

#ifndef __VTILOG_H__
#define __VTILOG_H__

#include <link.h>

#if defined(VTILOG_DISABLED)   // log sending disabled

#define dbg_prints(s)
#define dbg_printsln(s)
#define dbg_printf(f...)
#define dbg_printfln(f...)

#else

#define dbg_prints(message)   OSWriteLinkBlock((char*)message,strlen(message))
#define dbg_printsln(message) ({OSWriteLinkBlock((char*)message,strlen(message));\
                               OSWriteLinkBlock((char*)"\r\n",2);})
#define dbg_printf(f...) \
  ({char __s[200]; _rom_call(short,(char*,const char*,...),53)(__s ,##f); \
  dbg_prints(__s);})
#define dbg_printfln(f...) \
  ({char __s[200]; _rom_call(short,(char*,const char*,...),53)(__s ,##f); \
  dbg_printsln(__s);})

#endif

#endif

//#############################################################################
// Revision History
//#############################################################################
//
// Revision 1.0  2002/02/14  tnussb
// initial version
//
