**** This program converted from Z80 to 68K by Source Guru 0.6
EXACT_STACK equ 1
        INCLUDE "sim-ti85.h"
        dc.b    32
**** Original Line:          ; ***************************************************
**** Original Line:          ; *
**** Original Line:          ; *               L U N O I D     V I
**** Original Line:          ; *
**** Original Line:          ; *
**** Original Line:          ; *           Programmed by Patrick Davidson
**** Original Line:          ; *
**** Original Line:          ; *             last updated : 20-May-97
**** Original Line:          ; *
**** Original Line:          ; ***************************************************
**** Original Line:          ; ---------- VARIABLE ADDRESSES (WITHIN TEXT MEMORY) ------
**** Original Line: x        =$80dF
x    equ     $80dF
**** Original Line: y        =$80e0
y    equ     $80e0
**** Original Line: p        =$80e1
p    equ     $80e1
**** Original Line: xv       =$80e2
xv    equ     $80e2
**** Original Line: yv       =$80e3
yv    equ     $80e3
**** Original Line: level    =$80e5
level    equ     $80e5
**** Original Line: lives    =$80e6
lives    equ     $80e6
**** Original Line: won      =$80e7
won    equ     $80e7
**** Original Line: speed    =$80e8
speed    equ     $80e8
**** Original Line: bricks   =$80e9
bricks    equ     $80e9
**** Original Line: score    =$80eb
score    equ     $80eb
**** Original Line: scrlstart =$80ed
scrlstart    equ     $80ed
**** Original Line: scrlpos  =$80ef
scrlpos    equ     $80ef
**** Original Line: sprtemp  =$80f1
sprtemp    equ     $80f1
**** Original Line: uchoice  =$80f2
uchoice    equ     $80f2
**** Original Line: data     =$8100
data    equ     $8100
**** Original Line: temp     =$8180
temp    equ     $8180
**** Original Line: temp2    =$8182
temp2    equ     $8182
**** Original Line: temp3    =$8183
temp3    equ     $8183
**** Original Line:   ; ------------------------ PROGRAM HEADER -------------------
**** Original Line:          .org     0
**** Original Line:          .include "ti-85.h"
**** Original Line: ;
**** Original Line: ;                                   
**** Original Line: ;                                           
**** Original Line: ;                                    
**** Original Line: ;                             
**** Original Line: ;                         Version 4.0 - November 1995
**** Original Line: ;                                Copyright 1995
**** Original Line: ;                          Dan Eble (eble.2@osu.edu)
**** Original Line: ;                      Magnus Hagander (e95_mha@e.kth.se)
**** Original Line: ;                    Rob Taylor (rtaylor@rtaylor.u-net.com)
**** Original Line: ;
**** Original Line: ;                     Extended header file (C) 20/12 1995
**** Original Line: ;
**** Original Line: 
**** Original Line: ;
**** Original Line: ; #DEFINEs for relative calls and jumps included in ZShell
**** Original Line: ;
**** Original Line: #DEFINE ROM_CALL(index)         call $8C09 \ .db index
**** Original Line: #DEFINE CALL_Z(addr)            call $8C0C \ .dw addr
**** Original Line: #DEFINE CALL_(addr)             call $8C0F \ .dw addr
**** Original Line: #DEFINE CALL_NZ(addr)           call $8C12 \ .dw addr
**** Original Line: #DEFINE CALL_C(addr)            call $8C18 \ .dw addr
**** Original Line: #DEFINE CALL_NC(addr)           call $8C1E \ .dw addr
**** Original Line: #DEFINE JUMP_Z(addr)            call $8C24 \ .dw addr
**** Original Line: #DEFINE JUMP_(addr)             call $8C27 \ .dw addr
**** Original Line: #DEFINE JUMP_NZ(addr)           call $8C2A \ .dw addr
**** Original Line: #DEFINE JUMP_C(addr)            call $8C30 \ .dw addr
**** Original Line: #DEFINE JUMP_NC(addr)           call $8C36 \ .dw addr
**** Original Line: 
**** Original Line: 
**** Original Line: ;
**** Original Line: ; #DEFINEs for conditional ROM_CALL:s. The functionality will be
**** Original Line: ; implemented in your own program, not in ZShell.
**** Original Line: ;
**** Original Line: #DEFINE ROM_CALL_C(index)       .db $30,$04 \ call $8c09 \ .db index
**** Original Line: #DEFINE ROM_CALL_NC(index)      .db $38,$04 \ call $8c09 \ .db index
**** Original Line: #DEFINE ROM_CALL_Z(index)       .db $20,$04 \ call $8c09 \ .db index
**** Original Line: #DEFINE ROM_CALL_NZ(index)      .db $28,$04 \ call $8c09 \ .db index
**** Original Line: 
**** Original Line: 
**** Original Line: ;
**** Original Line: ; ZShell Specific Data areas
**** Original Line: ;
**** Original Line: PROGRAM_ADDR	=$8C3C	; program address
PROGRAM_ADDR    equ     $8C3C	
**** Original Line: ROM_VERS	=$8C3E	; ROM version byte
ROM_VERS    equ     $8C3E	
**** Original Line: ZSHELL_VER	=$8C3F	; ZShell version number
ZSHELL_VER    equ     $8C3F	
**** Original Line: ZS_BITS		=$8C40	; bit 0 set : checksum again
ZS_BITS    equ     $8C40	
**** Original Line:                         ; bit 1 set : get out without screen
**** Original Line: 
**** Original Line: 
**** Original Line: ;
**** Original Line: ; Call addresses
**** Original Line: ; These addresses are in the same location in all ROM versions, and can
**** Original Line: ; therefor be accessed through a direct call.
**** Original Line: ; There is no need to use the ROM_CALL function.
**** Original Line: ; Instead, use e.g. "call LD_HL_MHL", without using any macro.
**** Original Line: ;
**** Original Line: LD_HL_MHL       =$0033  ; HL=(HL), A=L
LD_HL_MHL    equ     $0033  
**** Original Line: CP_HL_DE        =$008E  ; CP HL,DE (modifies flags only)
CP_HL_DE    equ     $008E  
**** Original Line: UNPACK_HL       =$009A  ; unpacks one digit of HL into %A
UNPACK_HL    equ     $009A  
**** Original Line: STORE_KEY       =$01B1  ; store immediate keystroke from %A
STORE_KEY    equ     $01B1  
**** Original Line: GET_KEY         =$01BE  ; get immediate keystroke into %A
GET_KEY    equ     $01BE  
**** Original Line: 
**** Original Line: 
**** Original Line: ;
**** Original Line: ; Call Indexes
**** Original Line: ; These indexes are used in the ROM_CALL macro to call functios that
**** Original Line: ; are in the TI-85's ROM.
**** Original Line: ;
**** Original Line: TX_CHARPUT       =$00   ; xlated display of %A on screen, normal text style
TX_CHARPUT    equ     $00   
**** Original Line: D_LT_STR         =$01   ; display length-byte normal text string
D_LT_STR    equ     $01   
**** Original Line: M_CHARPUT        =$02   ; display %A on screen, menu style
M_CHARPUT    equ     $02   
**** Original Line: D_ZM_STR         =$03   ; display zero-terminated string,  menu style
D_ZM_STR    equ     $03   
**** Original Line: D_LM_STR         =$04   ; display length-byte string, menu style
D_LM_STR    equ     $04   
**** Original Line: GET_T_CUR        =$05   ; HL = absolute address of text cursor
GET_T_CUR    equ     $05   
**** Original Line: SCROLL_UP        =$06   ; scroll text screen up
SCROLL_UP    equ     $06   
**** Original Line: TR_CHARPUT       =$07   ; raw display of %A on screen, normal text style
TR_CHARPUT    equ     $07   
**** Original Line: CLEARLCD         =$08   ; clear LCD, but not text or graphics memory
CLEARLCD    equ     $08   
**** Original Line: D_HL_DECI        =$09   ; disp. HL as 5-byte, right just., blank-pad. decimal
D_HL_DECI    equ     $09   
**** Original Line: CLEARTEXT        =$0A   ; clear LCD and text memory (affected by 1,(IY+13))
CLEARTEXT    equ     $0A   
**** Original Line: D_ZT_STR         =$0B   ; display zero-terminated normal text string
D_ZT_STR    equ     $0B   
**** Original Line: BUSY_OFF         =$0C   ; turn off "busy" indicataor
BUSY_OFF    equ     $0C   
**** Original Line: BUSY_ON          =$0D   ; turn on "busy" indicator
BUSY_ON    equ     $0D   
**** Original Line: FIND_PIXEL       =$80   ; Find location in RAM for a pixel on the GFX screen
FIND_PIXEL    equ     $80   
**** Original Line:                         ; WARNING! Page must be set to 4 before this function
**** Original Line:                         ; is called! Do "ld a,4" and "out (5),a" do to that.
**** Original Line: 
**** Original Line: ;
**** Original Line: ; Data Locations
**** Original Line: ;
**** Original Line: KEY_0		=$8000	; translated scancode of last key, but 0 if gotten
KEY_0    equ     $8000	
**** Original Line: KEY_1		=$8001	; translated scancode of key down now
KEY_1    equ     $8001	
**** Original Line: KEY_2		=$8002	; same as 8001, but $FF if more than one key is down
KEY_2    equ     $8002	
**** Original Line: KEY_STAT	=$8004	; bit 2 set = key down now
KEY_STAT    equ     $8004	
**** Original Line: LAST_KEY	=$8006	; last key pressed
LAST_KEY    equ     $8006	
**** Original Line: CONTRAST	=$8007	; contrast
CONTRAST    equ     $8007	
**** Original Line: CURSOR_ROW	=$800C	; text cursor row
CURSOR_ROW    equ     $800C	
**** Original Line: CURSOR_COL	=$800D	; text cursor column
CURSOR_COL    equ     $800D	
**** Original Line: CURSOR_LET	=$800E	; letter under text cursor
CURSOR_LET    equ     $800E	
**** Original Line: BUSY_COUNTER	=$8080	; counter for busy indicator
BUSY_COUNTER    equ     $8080	
**** Original Line: BUSY_BITMAP	=$8081	; bitmap for busy indicator
BUSY_BITMAP    equ     $8081	
**** Original Line: CURR_INPUT	=$80C6	; -> current home-screen input
CURR_INPUT    equ     $80C6	
**** Original Line: BYTES_USED	=$80CC	; # of used user memory (Add to 80C8 to find first 
BYTES_USED    equ     $80CC	
**** Original Line: 			; byte of free memory)
**** Original Line: TEXT_MEM	=$80DF	; text memory
TEXT_MEM    equ     $80DF	
**** Original Line: CURSOR_ROW2	=$800C	; text cursor row
CURSOR_ROW2    equ     $800C	
**** Original Line: CURSOR_COL2	=$800D	; text cursor column
CURSOR_COL2    equ     $800D	
**** Original Line: CHECKSUM	=$81BE	; memory checksum from 8BF7 to FA6F
CHECKSUM    equ     $81BE	
**** Original Line: CURSOR_X	=$8333	; x value of cursor
CURSOR_X    equ     $8333	
**** Original Line: CURSOR_Y	=$8334	; y value of cursor
CURSOR_Y    equ     $8334	
**** Original Line: _IY_TABLE	=$8346	; where IY usually points
_IY_TABLE    equ     $8346	
**** Original Line: GRAPH_MEM	=$8641	; graphics memory
GRAPH_MEM    equ     $8641	
**** Original Line: TEXT_MEM2	=$8A6B	; secondary text memory
TEXT_MEM2    equ     $8A6B	
**** Original Line: USER_MEM	=$8B1B	; -> start of user memory
USER_MEM    equ     $8B1B	
**** Original Line: FIXED_POINT	=$8B3A	; fixed-point decimal place (FFh for floating point)
FIXED_POINT    equ     $8B3A	
**** Original Line: VAT_END		=$8BEB	; -> one byte before end of VAT (backwards)
VAT_END    equ     $8BEB	
**** Original Line: VAT_START	=$FA6F	; start of VAT
VAT_START    equ     $FA6F	
**** Original Line: VIDEO_MEM	=$FC00	; video memory
VIDEO_MEM    equ     $FC00	
**** Original Line: 
**** Original Line: 
**** Original Line: ;
**** Original Line: ; Key Scancode definitions
**** Original Line: ;
**** Original Line: ;                     Function                Character
**** Original Line: K_NOKEY       =$00    ;No key
K_NOKEY    equ     $00    
**** Original Line: K_DOWN        =$01    ;Down
K_DOWN    equ     $01    
**** Original Line: K_LEFT        =$02    ;Left
K_LEFT    equ     $02    
**** Original Line: K_RIGHT       =$03    ;Right
K_RIGHT    equ     $03    
**** Original Line: K_UP          =$04    ;Up
K_UP    equ     $04    
**** Original Line: K_ENTER       =$09    ;Enter
K_ENTER    equ     $09    
**** Original Line: K_PLUS        =$0A    ;+                      X
K_PLUS    equ     $0A    
**** Original Line: K_MINUS       =$0B    ;-                      T
K_MINUS    equ     $0B    
**** Original Line: K_STAR        =$0C    ;*                      O
K_STAR    equ     $0C    
**** Original Line: K_SLASH       =$0D    ;/                      J
K_SLASH    equ     $0D    
**** Original Line: K_RAISE       =$0E    ;^                      E
K_RAISE    equ     $0E    
**** Original Line: K_CLEAR       =$0F    ;Clear
K_CLEAR    equ     $0F    
**** Original Line: K_SIGN        =$11    ;(-)                    Space
K_SIGN    equ     $11    
**** Original Line: K_3           =$12    ;3                      W
K_3    equ     $12    
**** Original Line: K_6           =$13    ;6                      S
K_6    equ     $13    
**** Original Line: K_9           =$14    ;9                      N
K_9    equ     $14    
**** Original Line: K_RIGHTPAR    =$15    ;)                      I
K_RIGHTPAR    equ     $15    
**** Original Line: K_TAN         =$16    ;Tan                    D
K_TAN    equ     $16    
**** Original Line: K_CUSTOM      =$17    ;Custom
K_CUSTOM    equ     $17    
**** Original Line: K_DOT         =$19    ;.                      Z
K_DOT    equ     $19    
**** Original Line: K_2           =$1A    ;2                      V
K_2    equ     $1A    
**** Original Line: K_5           =$1B    ;5                      R
K_5    equ     $1B    
**** Original Line: K_8           =$1C    ;8                      M
K_8    equ     $1C    
**** Original Line: K_LEFTPAR     =$1D    ;(                      H
K_LEFTPAR    equ     $1D    
**** Original Line: K_COS         =$1E    ;Cos                    C
K_COS    equ     $1E    
**** Original Line: K_PRGM        =$1F    ;Prgm
K_PRGM    equ     $1F    
**** Original Line: K_DEL         =$20    ;Del
K_DEL    equ     $20    
**** Original Line: K_0           =$21    ;0                      Y
K_0    equ     $21    
**** Original Line: K_1           =$22    ;1                      U
K_1    equ     $22    
**** Original Line: K_4           =$23    ;4                      Q
K_4    equ     $23    
**** Original Line: K_7           =$24    ;7                      L
K_7    equ     $24    
**** Original Line: K_EE          =$25    ;EE                     G
K_EE    equ     $25    
**** Original Line: K_SIN         =$26    ;Sin                    B
K_SIN    equ     $26    
**** Original Line: K_STAT        =$27    ;Stat
K_STAT    equ     $27    
**** Original Line: K_XVAR        =$28    ;x-Var                  x
K_XVAR    equ     $28    
**** Original Line: K_ON          =$29    ;On
K_ON    equ     $29    
**** Original Line: K_STO         =$2A    ;Sto                    =
K_STO    equ     $2A    
**** Original Line: K_COMMA       =$2B    ;,                      P
K_COMMA    equ     $2B    
**** Original Line: K_SQUARE      =$2C    ;x^2                    K
K_SQUARE    equ     $2C    
**** Original Line: K_LN          =$2D    ;Ln                     F
K_LN    equ     $2D    
**** Original Line: K_LOG         =$2E    ;Log                    A
K_LOG    equ     $2E    
**** Original Line: K_GRAPH       =$2F    ;Graph
K_GRAPH    equ     $2F    
**** Original Line: K_ALPHA       =$30    ;Alpha
K_ALPHA    equ     $30    
**** Original Line: K_F5          =$31    ;F5
K_F5    equ     $31    
**** Original Line: K_F4          =$32    ;F4
K_F4    equ     $32    
**** Original Line: K_F3          =$33    ;F3
K_F3    equ     $33    
**** Original Line: K_F2          =$34    ;F2
K_F2    equ     $34    
**** Original Line: K_F1          =$35    ;F1
K_F1    equ     $35    
**** Original Line: K_SECOND      =$36    ;2nd
K_SECOND    equ     $36    
**** Original Line: K_EXIT        =$37    ;EXIT
K_EXIT    equ     $37    
**** Original Line: K_MORE        =$38    ;MORE
K_MORE    equ     $38    
**** Original Line:          .db      "7.3 / Patrick Davidson"
        dc.b    "7.3 / Patrick Davidson"
**** Original Line:          .db      0
        dc.b    0
**** Original Line: #DEFINE LOCATE(xc,yc)    push hl \ ld hl,(xc*256)+yc \ ld ($800c),hl \ pop hl
**** Original Line: #DEFINE D_HL             push de \ push hl \ ROM_CALL(D_HL_DECI) \ pop hl \ pop de
**** Original Line:   ; ----------------------- INITIALIZATION --------------------
**** Original Line:          ROM_CALL(CLEARLCD)
        jsr     ti85lib3@0002
**** Original Line:          ld       b,96
        and.w   #$ff,d2
        or.w    #(96)<<8,d2
**** Original Line:          ld       a,32
        move.b  #32,d7
**** Original Line:          ld       ix,$8641
        move.w  #$8641+0,d5
**** Original Line: pcl:     ld       hl,0
        __LABEL pcl
        move.w  #0+0,d4
**** Original Line:          ld       ($800c),hl
        move.w  d4,d0
        lsr.w   #8,d0
        move.b  d4,$800c-$10000(a0)
        move.b  d0,1+$800c-$10000(a0)
**** Original Line:          push     af
        move.b  d7,d1
        lsl.w   #8,d1
        move.b  1(a0),d1
        move.w  d1,-(sp)
**** Original Line:          push     bc
        move.w  d2,-(sp)
**** Original Line:          ROM_CALL(TX_CHARPUT)
        jsr     ti85lib3@0004
**** Original Line:          ld       hl,$fc00
        move.w  #$fc00+0,d4
**** Original Line:          ld       b,8
        and.w   #$ff,d2
        or.w    #(8)<<8,d2
**** Original Line:          ld       de,16
        move.w  #16+0,d3
**** Original Line: il2:     ld       a,(hl)
        __LABEL il2
        __ADDR  4
        move.b  (a4),d7
**** Original Line:          ld       (ix),a
        __ADDR  5
        move.b  d7,(a5)
**** Original Line:          add      hl,de
        add.w   d3,d4
**** Original Line:          inc      ix
        addq.w  #1,d5
**** Original Line:          djnz     il2
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_il2
**** Original Line:          pop      bc
        move.w  (sp)+,d2
**** Original Line:          pop      af
        move.w  (sp)+,d1
        move.b  d1,1(a0)
        lsr.w   #8,d1
        move.b  d1,d7
**** Original Line:          inc      a
        addq.b  #1,d7
**** Original Line:          djnz     pcl
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_pcl
**** Original Line:          ld       a,(CONTRAST)
        move.b  CONTRAST-$10000(a0),d7
**** Original Line:          inc      a
        addq.b  #1,d7
**** Original Line:          cp       $20
        cmp.b   #$20,d7
        move.w  sr,(a0)
**** Original Line:          jr       nz,ok1
        bne   RA_ok1
**** Original Line:          dec      a
        subq.b  #1,d7
**** Original Line: ok1:     inc      a
        __LABEL ok1
        addq.b  #1,d7
**** Original Line:          cp       $20
        cmp.b   #$20,d7
        move.w  sr,(a0)
**** Original Line:          jr       nz,ok2
        bne   RA_ok2
**** Original Line:          dec      a
        subq.b  #1,d7
        move.w  sr,(a0)
**** Original Line: ok2:     out      (2),a
        __LABEL ok2
        move.b  #2,d1
        jsr     ti85lib3@0007
**** Original Line:          ld       (iy+13),0
        __ADDR  6
        move.b  #0,13(a6)
**** Original Line:          ld       a,1
        move.b  #1,d7
**** Original Line:          ld       (ZS_BITS),a
        move.b  d7,ZS_BITS-$10000(a0)
**** Original Line:          CALL_(stuff)            ;do the game
        __JSR   RA_stuff
**** Original Line:          ld       a,(CONTRAST)    
        move.b  CONTRAST-$10000(a0),d7
**** Original Line:          out      (2),a
        move.b  #2,d1
        jsr     ti85lib3@0007
**** Original Line:          ROM_CALL(CLEARLCD)
        jsr     ti85lib3@0002
**** Original Line:          ld       hl,temp2
        move.w  #temp2+0,d4
        lea     temp2-$10000(a0),a4
**** Original Line:          ld       a,(hl)
        ;__ADDR 4
        move.b  (a4),d7
**** Original Line:          or       a
        or.b   d7,d7
        move.w  sr,(a0)
**** Original Line:          ret      nz
        beq     NC__0
        __RTS
NC__0:
**** Original Line:          LOCATE(0,0)
        move.w  d4,-(sp)
        move.w  #(0*256)+0+0,d4
        move.w  d4,d0
        lsr.w   #8,d0
        move.b  d4,$800c-$10000(a0)
        move.b  d0,1+$800c-$10000(a0)
        move.w  (sp)+,d4
**** Original Line:          ld       de,(PROGRAM_ADDR)
        move.b  1+PROGRAM_ADDR-$10000(a0),d3
        asl.w   #8,d3
        move.b  PROGRAM_ADDR-$10000(a0),d3
**** Original Line:          ld       hl,hstitle
        move.w  #hstitle+0,d4
**** Original Line:          add      hl,de
        add.w   d3,d4
**** Original Line:          ROM_CALL(D_ZT_STR)
        jsr     ti85lib3@0005
**** Original Line:          LOCATE(16,1)
        move.w  d4,-(sp)
        move.w  #(16*256)+1+0,d4
        move.w  d4,d0
        lsr.w   #8,d0
        move.b  d4,$800c-$10000(a0)
        move.b  d0,1+$800c-$10000(a0)
        move.w  (sp)+,d4
**** Original Line:          ld       ix,hsdata
        move.w  #hsdata+0,d5
**** Original Line:          add      ix,de
        add.w   d3,d5
**** Original Line:          ld       b,7
        and.w   #$ff,d2
        or.w    #(7)<<8,d2
**** Original Line:          ld       de,17
        move.w  #17+0,d3
**** Original Line: high_display_loop:
        __LABEL high_display_loop
**** Original Line:          ld       l,(ix+0)
        __ADDR  5
        move.b  0(a5),d4
**** Original Line:          ld       h,(ix+1)
        __ADDR  5
        move.b  1(a5),d1
        asl.w   #8,d1
        and.w   #$ff,d4
        or.w    d1,d4
**** Original Line:          D_HL
        move.w  d3,-(sp)
        move.w  d4,-(sp)
        jsr     ti85lib3@0011
        move.w  (sp)+,d4
        move.w  (sp)+,d3
**** Original Line:          ld       hl,$800c
        move.w  #$800c+0,d4
        lea     $800c-$10000(a0),a4
**** Original Line:          dec      (hl)
        ;__ADDR 4
        subq.b  #1,(a4)
**** Original Line:          inc      ix
        addq.w  #1,d5
**** Original Line:          inc      ix
        addq.w  #1,d5
**** Original Line:          push     ix
        move.w  d5,-(sp)
**** Original Line:          pop      hl
        move.w  (sp)+,d4
**** Original Line:          ROM_CALL(D_ZT_STR)
        jsr     ti85lib3@0005
**** Original Line:          add      ix,de
        add.w   d3,d5
**** Original Line:          ld       hl,$800c
        move.w  #$800c+0,d4
        lea     $800c-$10000(a0),a4
**** Original Line:          inc      (hl)
        ;__ADDR 4
        addq.b  #1,(a4)
        move.w  sr,(a0)
**** Original Line:          djnz     high_display_loop
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_high_display_loop
**** Original Line:          CALL_(wait_key)
        __JSR   RA_wait_key
**** Original Line:          ret
        __RTS
**** Original Line: stuff:   ld       hl,saved_flag     ;Check for saved game
        __LABEL stuff
        move.w  #saved_flag+0,d4
**** Original Line:          ld       de,(PROGRAM_ADDR)
        move.b  1+PROGRAM_ADDR-$10000(a0),d3
        asl.w   #8,d3
        move.b  PROGRAM_ADDR-$10000(a0),d3
**** Original Line:          add      hl,de
        add.w   d3,d4
**** Original Line:          ld       a,(hl)
        __ADDR  4
        move.b  (a4),d7
**** Original Line:          or       a
        or.b   d7,d7
        move.w  sr,(a0)
**** Original Line:          JUMP_NZ(restore_game)
        bne   RA_restore_game
**** Original Line:          ld       hl,0
        move.w  #0+0,d4
**** Original Line:          ld       ($800c),hl
        move.w  d4,d0
        lsr.w   #8,d0
        move.b  d4,$800c-$10000(a0)
        move.b  d0,1+$800c-$10000(a0)
**** Original Line:          ld       hl,initial_msg
        move.w  #initial_msg+0,d4
**** Original Line:          add      hl,de
        add.w   d3,d4
**** Original Line:          ROM_CALL(D_ZT_STR)
        jsr     ti85lib3@0005
**** Original Line:          ld       ix,$800c
        move.w  #$800c+0,d5
        lea     $800c-$10000(a0),a5
**** Original Line:          inc      (ix)
        ;__ADDR 5
        addq.b  #1,(a5)
**** Original Line:          ROM_CALL(D_ZT_STR)
        jsr     ti85lib3@0005
**** Original Line:          inc      (ix)
        __ADDR  5
        addq.b  #1,(a5)
**** Original Line:          ROM_CALL(D_ZT_STR)
        jsr     ti85lib3@0005
**** Original Line:          ld       a,200
        move.b  #200,d7
**** Original Line:          CALL_(waste_time)
        __JSR   RA_waste_time
**** Original Line:          ld       hl,scrltext
        move.w  #scrltext+0,d4
**** Original Line:          add      hl,de
        add.w   d3,d4
**** Original Line:          ld       (scrlstart),hl
        move.w  d4,d0
        lsr.w   #8,d0
        move.b  d4,scrlstart-$10000(a0)
        move.b  d0,1+scrlstart-$10000(a0)
**** Original Line:          ld       hl,$0806
        move.w  #$0806+0,d4
**** Original Line:          ld       ($8941),hl
        move.w  d4,d0
        lsr.w   #8,d0
        move.b  d4,$8941-$10000(a0)
        move.b  d0,1+$8941-$10000(a0)
**** Original Line: intro_loop:
        __LABEL intro_loop
**** Original Line:          ld       hl,$89c1
        move.w  #$89c1+0,d4
**** Original Line:          ld       b,128
        and.w   #$ff,d2
        or.w    #(128)<<8,d2
**** Original Line: clrg:    ld       (hl),0
        __LABEL clrg
        __ADDR  4
        move.b  #0,(a4)
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          djnz     clrg
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_clrg
**** Original Line:          ld       hl,(scrlpos)
        move.b  1+scrlpos-$10000(a0),d4
        asl.w   #8,d4
        move.b  scrlpos-$10000(a0),d4
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          ld       (scrlpos),hl
        move.w  d4,d0
        lsr.w   #8,d0
        move.b  d4,scrlpos-$10000(a0)
        move.b  d0,1+scrlpos-$10000(a0)
**** Original Line:          ld       de,(scrl_end-scrltext)*8
        move.w  #(scrl_end-scrltext)*8+0,d3
**** Original Line:          call     CP_HL_DE
        jsr     ti85lib3@0010
**** Original Line:          jr       nz,not_end_of_text
        move.b  (a0),ccr
        bne   RA_not_end_of_text
**** Original Line:          ld       hl,0
        move.w  #0+0,d4
**** Original Line:          ld       (scrlpos),hl
        move.w  d4,d0
        lsr.w   #8,d0
        move.b  d4,scrlpos-$10000(a0)
        move.b  d0,1+scrlpos-$10000(a0)
**** Original Line: not_end_of_text:
        __LABEL not_end_of_text
**** Original Line:          ld       de,(scrlpos)
        move.b  1+scrlpos-$10000(a0),d3
        asl.w   #8,d3
        move.b  scrlpos-$10000(a0),d3
**** Original Line:          ld       hl,(scrlstart)
        move.b  1+scrlstart-$10000(a0),d4
        asl.w   #8,d4
        move.b  scrlstart-$10000(a0),d4
**** Original Line:          ld       b,3
        and.w   #$ff,d2
        or.w    #(3)<<8,d2
**** Original Line: fspl:    res      0,e
        __LABEL fspl
        bclr    #0,d3
**** Original Line:          srl      d
        move.w  d3,(a1)
        move.b  (a1),d1
        lsr.b   #1,d1
        move.w  sr,(a0)
        move.b  d1,(a1)
        move.w  (a1),d3
**** Original Line:          jr       nc,no_ovfs
        move.b  (a0),ccr
        bcc   RA_no_ovfs
**** Original Line:          set      0,e
        bset    #0,d3
**** Original Line: no_ovfs: rrc      e
        __LABEL no_ovfs
        ror.b   #1,d3
**** Original Line:          djnz     fspl
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_fspl
**** Original Line:          add      hl,de
        add.w   d3,d4
**** Original Line:          ld       b,15
        and.w   #$ff,d2
        or.w    #(15)<<8,d2
**** Original Line:          ld       a,(scrlpos)
        move.b  scrlpos-$10000(a0),d7
**** Original Line:          cpl
        not.b   d7
**** Original Line:          and      7
        and.b   #7,d7
        move.w  sr,(a0)
**** Original Line:          ld       e,a
        move.b  d7,d3
**** Original Line: scroll:  ld       a,(hl)
        __LABEL scroll
        __ADDR  4
        move.b  (a4),d7
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          push     hl
        move.w  d4,-(sp)
**** Original Line:          push     bc
        move.w  d2,-(sp)
**** Original Line:          ld       hl,$8541
        move.w  #$8541+0,d4
**** Original Line:          push     de
        move.w  d3,-(sp)
**** Original Line:          ld       de,8
        move.w  #8+0,d3
**** Original Line:          ld       b,a
        move.w  d2,(a1)
        move.b  d7,(a1)
        move.w  (a1),d2
**** Original Line: scroll_draw:
        __LABEL scroll_draw
**** Original Line:          add      hl,de
        add.w   d3,d4
**** Original Line:          djnz     scroll_draw
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_scroll_draw
**** Original Line:          ld       b,8
        and.w   #$ff,d2
        or.w    #(8)<<8,d2
**** Original Line:          ld       ix,$8943
        move.w  #$8943+0,d5
**** Original Line: copy_char:
        __LABEL copy_char
**** Original Line:          ld       a,(hl)
        __ADDR  4
        move.b  (a4),d7
**** Original Line:          ld       (ix),a
        __ADDR  5
        move.b  d7,(a5)
**** Original Line:          inc      ix
        addq.w  #1,d5
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          djnz copy_char
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_copy_char
**** Original Line:          pop      de
        move.w  (sp)+,d3
**** Original Line:          ld       b,e
        move.w  d2,(a1)
        move.b  d3,(a1)
        move.w  (a1),d2
**** Original Line:          ld       c,56
        move.b  #56,d2
**** Original Line:          ld       ix,$8941
        move.w  #$8941+0,d5
**** Original Line:          push     de
        move.w  d3,-(sp)
**** Original Line:          CALL_(drw_spr)
        __JSR   RA_drw_spr
**** Original Line:          pop      de
        move.w  (sp)+,d3
**** Original Line:          ld       a,e
        move.b  d3,d7
**** Original Line:          add      a,8
        add.b   #8,d7
**** Original Line:          ld       e,a
        move.b  d7,d3
**** Original Line:          pop      bc
        move.w  (sp)+,d2
**** Original Line:          pop      hl
        move.w  (sp)+,d4
**** Original Line:          djnz     scroll
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_scroll
**** Original Line:          ld       ix,$89c1
        move.w  #$89c1+0,d5
**** Original Line:          ld       b,8
        and.w   #$ff,d2
        or.w    #(8)<<8,d2
**** Original Line: blocks__:ld       (ix),255
        __LABEL blocks__
        __ADDR  5
        move.b  #255,(a5)
**** Original Line:          ld       (ix+15),255
        ;__ADDR 5
        move.b  #255,15(a5)
**** Original Line:          push     bc
        move.w  d2,-(sp)
**** Original Line:          ld       bc,16
        move.w  #16+0,d2
**** Original Line:          add      ix,bc
        add.w   d2,d5
**** Original Line:          pop      bc
        move.w  (sp)+,d2
**** Original Line:          djnz     blocks__
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_blocks__
**** Original Line:          ld       hl,$89c1
        move.w  #$89c1+0,d4
**** Original Line:          ld       de,$ff80
        move.w  #$ff80+0,d3
**** Original Line:          ld       bc,128
        move.w  #128+0,d2
**** Original Line:          ldir
        __LDIR
**** Original Line:          call     GET_KEY
        jsr     ti85lib3@0006
**** Original Line:          or       a
        or.b   d7,d7
        move.w  sr,(a0)
**** Original Line:          JUMP_Z(intro_loop)
        beq   RA_intro_loop
**** Original Line:          cp       K_ALPHA
        cmp.b   #K_ALPHA,d7
        move.w  sr,(a0)
**** Original Line:          ret      z
        bne     NC__1
        __RTS
NC__1:
**** Original Line:          ld       hl,speed
        move.w  #speed+0,d4
        lea     speed-$10000(a0),a4
**** Original Line:          ld       (hl),4
        ;__ADDR 4
        move.b  #4,(a4)
**** Original Line:          cp       K_F2
        cmp.b   #K_F2,d7
        move.w  sr,(a0)
**** Original Line:          jr       nz,not_f2
        bne   RA_not_f2
**** Original Line:          ld       (hl),3
        ;__ADDR 4
        move.b  #3,(a4)
**** Original Line: not_f2:  cp       K_F3
        __LABEL not_f2
        cmp.b   #K_F3,d7
        move.w  sr,(a0)
**** Original Line:          jr       nz,not_f3
        bne   RA_not_f3
**** Original Line:          ld       (hl),2
        __ADDR  4
        move.b  #2,(a4)
**** Original Line: not_f3:  cp       K_F4
        __LABEL not_f3
        cmp.b   #K_F4,d7
        move.w  sr,(a0)
**** Original Line:          jr       nz,not_f4
        bne   RA_not_f4
**** Original Line:          ld       (hl),1
        __ADDR  4
        move.b  #1,(a4)
**** Original Line: not_f4:  cp       K_F5
        __LABEL not_f4
        cmp.b   #K_F5,d7
        move.w  sr,(a0)
**** Original Line:          jr       nz,not_f5
        bne   RA_not_f5
**** Original Line:          ld       (hl),0
        __ADDR  4
        move.b  #0,(a4)
**** Original Line: not_f5:  ld       hl,lives
        __LABEL not_f5
        move.w  #lives+0,d4
        lea     lives-$10000(a0),a4
**** Original Line:          ld       (hl),8
        ;__ADDR 4
        move.b  #8,(a4)
**** Original Line:   ; ------------------- OUTER GAME LOOP ----------------------
**** Original Line:          ROM_CALL(CLEARLCD)
        jsr     ti85lib3@0002
**** Original Line:          ld       hl,0
        move.w  #0+0,d4
**** Original Line:          ld       ($800c),hl
        move.w  d4,d0
        lsr.w   #8,d0
        move.b  d4,$800c-$10000(a0)
        move.b  d0,1+$800c-$10000(a0)
**** Original Line:          ld       hl,universe_ttl
        move.w  #universe_ttl+0,d4
**** Original Line:          ld       de,(PROGRAM_ADDR)
        move.b  1+PROGRAM_ADDR-$10000(a0),d3
        asl.w   #8,d3
        move.b  PROGRAM_ADDR-$10000(a0),d3
**** Original Line:          add      hl,de
        add.w   d3,d4
**** Original Line:          ROM_CALL(D_ZT_STR)
        jsr     ti85lib3@0005
**** Original Line:          push     hl
        move.w  d4,-(sp)
**** Original Line:          ld       hl,$800c
        move.w  #$800c+0,d4
        lea     $800c-$10000(a0),a4
**** Original Line:          inc      (hl)
        ;__ADDR 4
        addq.b  #1,(a4)
**** Original Line:          pop      hl
        move.w  (sp)+,d4
**** Original Line:          ROM_CALL(D_ZT_STR)
        jsr     ti85lib3@0005
**** Original Line: loopu:   call     GET_KEY
        __LABEL loopu
        jsr     ti85lib3@0006
**** Original Line:          cp       K_F1
        cmp.b   #K_F1,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,classic
        beq   RA_classic
**** Original Line:          cp       K_F2
        cmp.b   #K_F2,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,f2
        beq   RA_f2
**** Original Line:          cp       K_F3
        cmp.b   #K_F3,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,f3
        beq   RA_f3
**** Original Line:          cp       K_F4
        cmp.b   #K_F4,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,f4
        beq   RA_f4
**** Original Line:          cp       K_F5
        cmp.b   #K_F5,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,f5
        beq   RA_f5
**** Original Line:          jr       loopu
        bra     RA_loopu
**** Original Line: f2:      ld       a,2
        __LABEL f2
        move.b  #2,d7
**** Original Line:          jr       start
        bra     RA_start
**** Original Line: f3:      ld       a,4
        __LABEL f3
        move.b  #4,d7
**** Original Line:          jr       start
        bra     RA_start
**** Original Line: f4:      ld       a,6
        __LABEL f4
        move.b  #6,d7
**** Original Line:          jr       start
        bra     RA_start
**** Original Line: f5:      ld       a,8
        __LABEL f5
        move.b  #8,d7
**** Original Line:          jr       start
        bra     RA_start
**** Original Line: classic: ld       a,0
        __LABEL classic
        clr.b   d7
**** Original Line: start:   ld       (uchoice),a
        __LABEL start
        move.b  d7,uchoice-$10000(a0)
**** Original Line: play_da_game:
        __LABEL play_da_game
**** Original Line:          CALL_(level_addr)
        __JSR   RA_level_addr
**** Original Line:          ld       ix,lives
        move.w  #lives+0,d5
        lea     lives-$10000(a0),a5
**** Original Line:          inc      (ix)
        ;__ADDR 5
        addq.b  #1,(a5)
**** Original Line:          ld       b,32                  ;Copy the map + count blocks
        and.w   #$ff,d2
        or.w    #(32)<<8,d2
**** Original Line:          ld       ix,$8100
        move.w  #$8100+0,d5
**** Original Line: set_up_1:ld       c,(hl)
        __LABEL set_up_1
        __ADDR  4
        move.b  (a4),d2
**** Original Line:          rlc      c
        rol.b   #1,d2
**** Original Line:          rlc      c
        rol.b   #1,d2
**** Original Line:          ld       a,c
        move.b  d2,d7
**** Original Line:          and      3
        and.b   #3,d7
**** Original Line:          ld       (ix),a
        __ADDR  5
        move.b  d7,(a5)
**** Original Line:          inc      ix
        addq.w  #1,d5
        addq.w  #1,a5
**** Original Line:          rlc      c
        rol.b   #1,d2
**** Original Line:          rlc      c
        rol.b   #1,d2
**** Original Line:          ld       a,c
        move.b  d2,d7
**** Original Line:          and      3
        and.b   #3,d7
**** Original Line:          ld       (ix),a
        ;__ADDR 5
        move.b  d7,(a5)
**** Original Line:          inc      ix
        addq.w  #1,d5
        addq.w  #1,a5
**** Original Line:          rlc      c
        rol.b   #1,d2
**** Original Line:          rlc      c
        rol.b   #1,d2
**** Original Line:          ld       a,c
        move.b  d2,d7
**** Original Line:          and      3
        and.b   #3,d7
**** Original Line:          ld       (ix),a
        ;__ADDR 5
        move.b  d7,(a5)
**** Original Line:          inc      ix
        addq.w  #1,d5
        addq.w  #1,a5
**** Original Line:          rlc      c
        rol.b   #1,d2
**** Original Line:          rlc      c
        rol.b   #1,d2
**** Original Line:          ld       a,c
        move.b  d2,d7
**** Original Line:          and      3
        and.b   #3,d7
**** Original Line:          ld       (ix),a
        ;__ADDR 5
        move.b  d7,(a5)
**** Original Line:          inc      ix
        addq.w  #1,d5
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          djnz     set_up_1
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_set_up_1
**** Original Line:          ld       hl,level
        move.w  #level+0,d4
        lea     level-$10000(a0),a4
**** Original Line:          inc      (hl)
        ;__ADDR 4
        addq.b  #1,(a4)
        move.w  sr,(a0)
**** Original Line: level_loop:
        __LABEL level_loop
**** Original Line:          ld       ix,x
        move.w  #x+0,d5
**** Original Line:          CALL_(do_level)
        __JSR   RA_do_level
**** Original Line: restore_position:
        __LABEL restore_position
**** Original Line:          CALL_(play_level)
        __JSR   RA_play_level
**** Original Line:          xor      a
        eor.b   d7,d7
**** Original Line:          out      (1),a
        move.b  #1,d1
        jsr     ti85lib3@0007
**** Original Line:          ld       a,(ix+8)
        __ADDR  5
        move.b  8(a5),d7
**** Original Line:          or       a
        or.b   d7,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,finished_level
        beq   RA_finished_level
**** Original Line:          dec      (ix+7)
        __ADDR  5
        subq.b  #1,7(a5)
        move.w  sr,(a0)
**** Original Line:          jr       z,game_over
        beq   RA_game_over
**** Original Line:          jr       level_loop
        bra     RA_level_loop
**** Original Line: finished_level:
        __LABEL finished_level
**** Original Line:          CALL_(level_addr)
        __JSR   RA_level_addr
**** Original Line:          ld       a,(hl)
        __ADDR  4
        move.b  (a4),d7
**** Original Line:          cp       255
        cmp.b   #255,d7
        move.w  sr,(a0)
**** Original Line:          Jr       nz,play_da_game
        bne   RA_play_da_game
**** Original Line:   ; ---------------------- END OF GAME -------------------------
**** Original Line: game_over:                    ;Set up score page
        __LABEL game_over
**** Original Line:          ROM_CALL(CLEARLCD)
        jsr     ti85lib3@0002
**** Original Line:          LOCATE(0,0)
        move.w  d4,-(sp)
        move.w  #(0*256)+0+0,d4
        move.w  d4,d0
        lsr.w   #8,d0
        move.b  d4,$800c-$10000(a0)
        move.b  d0,1+$800c-$10000(a0)
        move.w  (sp)+,d4
**** Original Line:          ld       hl,end_msg
        move.w  #end_msg+0,d4
**** Original Line:          ld       de,(PROGRAM_ADDR)
        move.b  1+PROGRAM_ADDR-$10000(a0),d3
        asl.w   #8,d3
        move.b  PROGRAM_ADDR-$10000(a0),d3
**** Original Line:          add      hl,de
        add.w   d3,d4
**** Original Line:          ROM_CALL(D_ZT_STR)
        jsr     ti85lib3@0005
**** Original Line:          ld       a,(ix+7)              ;Score for levels completed
        __ADDR  5
        move.b  7(a5),d7
**** Original Line:          or       a
        or.b   d7,d7
        move.w  sr,(a0)
**** Original Line:          jr       nz,won_
        bne   RA_won_
**** Original Line:          dec      (ix+6)
        __ADDR  5
        subq.b  #1,6(a5)
**** Original Line: won_:    ld       a,(ix+6)
        __LABEL won_
        __ADDR  5
        move.b  6(a5),d7
**** Original Line:          or       a
        or.b   d7,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,no_levels
        beq   RA_no_levels
**** Original Line:          ld       b,a
        move.w  d2,(a1)
        move.b  d7,(a1)
        move.w  (a1),d2
**** Original Line:          ld       hl,0
        move.w  #0+0,d4
**** Original Line:          ld       de,1000
        move.w  #1000+0,d3
**** Original Line: level_score_loop:
        __LABEL level_score_loop
**** Original Line:          ld       a,30
        move.b  #30,d7
**** Original Line:          CALL_(waste_time)
        __JSR   RA_waste_time
**** Original Line:          add      hl,de
        add.w   d3,d4
**** Original Line:          LOCATE(16,1)
        move.w  d4,-(sp)
        move.w  #(16*256)+1+0,d4
        move.w  d4,d0
        lsr.w   #8,d0
        move.b  d4,$800c-$10000(a0)
        move.b  d0,1+$800c-$10000(a0)
        move.w  (sp)+,d4
**** Original Line:          D_HL
        move.w  d3,-(sp)
        move.w  d4,-(sp)
        jsr     ti85lib3@0011
        move.w  (sp)+,d4
        move.w  (sp)+,d3
**** Original Line:          push     hl
        move.w  d4,-(sp)
**** Original Line:          ld       hl,(score)
        move.b  1+score-$10000(a0),d4
        asl.w   #8,d4
        move.b  score-$10000(a0),d4
**** Original Line:          add      hl,de
        add.w   d3,d4
**** Original Line:          LOCATE(16,6)
        move.w  d4,-(sp)
        move.w  #(16*256)+6+0,d4
        move.w  d4,d0
        lsr.w   #8,d0
        move.b  d4,$800c-$10000(a0)
        move.b  d0,1+$800c-$10000(a0)
        move.w  (sp)+,d4
**** Original Line:          D_HL
        move.w  d3,-(sp)
        move.w  d4,-(sp)
        jsr     ti85lib3@0011
        move.w  (sp)+,d4
        move.w  (sp)+,d3
**** Original Line:          ld       (score),hl
        move.w  d4,d0
        lsr.w   #8,d0
        move.b  d4,score-$10000(a0)
        move.b  d0,1+score-$10000(a0)
**** Original Line:          pop      hl
        move.w  (sp)+,d4
**** Original Line:          djnz     level_score_loop
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_level_score_loop
**** Original Line: no_levels:
        __LABEL no_levels
**** Original Line:          ld       bc,(bricks)           ;Score for bricks hit
        move.b  1+bricks-$10000(a0),d2
        asl.w   #8,d2
        move.b  bricks-$10000(a0),d2
**** Original Line:          ld       a,b
        move.w  d2,(a1)
        move.b  (a1),d7
**** Original Line:          or       c
        or.b   d2,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,no_bricks
        beq   RA_no_bricks
**** Original Line:          ld       hl,0              
        move.w  #0+0,d4
**** Original Line: bricks_loop:
        __LABEL bricks_loop
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          LOCATE(16,2)
        move.w  d4,-(sp)
        move.w  #(16*256)+2+0,d4
        move.w  d4,d0
        lsr.w   #8,d0
        move.b  d4,$800c-$10000(a0)
        move.b  d0,1+$800c-$10000(a0)
        move.w  (sp)+,d4
**** Original Line:          D_HL
        move.w  d3,-(sp)
        move.w  d4,-(sp)
        jsr     ti85lib3@0011
        move.w  (sp)+,d4
        move.w  (sp)+,d3
**** Original Line:          push     hl
        move.w  d4,-(sp)
**** Original Line:          ld       hl,(score)
        move.b  1+score-$10000(a0),d4
        asl.w   #8,d4
        move.b  score-$10000(a0),d4
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          LOCATE(16,6)
        move.w  d4,-(sp)
        move.w  #(16*256)+6+0,d4
        move.w  d4,d0
        lsr.w   #8,d0
        move.b  d4,$800c-$10000(a0)
        move.b  d0,1+$800c-$10000(a0)
        move.w  (sp)+,d4
**** Original Line:          D_HL
        move.w  d3,-(sp)
        move.w  d4,-(sp)
        jsr     ti85lib3@0011
        move.w  (sp)+,d4
        move.w  (sp)+,d3
**** Original Line:          ld       (score),hl
        move.w  d4,d0
        lsr.w   #8,d0
        move.b  d4,score-$10000(a0)
        move.b  d0,1+score-$10000(a0)
**** Original Line:          pop      hl
        move.w  (sp)+,d4
**** Original Line:          dec      bc
        subq.w  #1,d2
**** Original Line:          xor      a
        eor.b   d7,d7
**** Original Line:          cp       b
        move.w  d2,(a1)
        cmp.b   (a1),d7
        move.w  sr,(a0)
**** Original Line:          jr       nz,bricks_loop
        bne   RA_bricks_loop
**** Original Line:          cp       c
        cmp.b   d2,d7
        move.w  sr,(a0)
**** Original Line:          jr       nz,bricks_loop
        bne   RA_bricks_loop
**** Original Line: no_bricks:
        __LABEL no_bricks
**** Original Line:          ld       a,5                  ;Score bonus for speed
        move.b  #5,d7
**** Original Line:          sub      (ix+9)
        __ADDR  5
        sub.b   9(a5),d7
        move.w  sr,(a0)
**** Original Line:          ld       b,a
        move.w  d2,(a1)
        move.b  d7,(a1)
        move.w  (a1),d2
**** Original Line:          ld       hl,0
        move.w  #0+0,d4
**** Original Line:          ld       de,1000
        move.w  #1000+0,d3
**** Original Line: speed_loop:
        __LABEL speed_loop
**** Original Line:          ld       a,30
        move.b  #30,d7
**** Original Line:          CALL_(waste_time)
        __JSR   RA_waste_time
**** Original Line:          add      hl,de
        add.w   d3,d4
**** Original Line:          LOCATE(16,3)
        move.w  d4,-(sp)
        move.w  #(16*256)+3+0,d4
        move.w  d4,d0
        lsr.w   #8,d0
        move.b  d4,$800c-$10000(a0)
        move.b  d0,1+$800c-$10000(a0)
        move.w  (sp)+,d4
**** Original Line:          D_HL
        move.w  d3,-(sp)
        move.w  d4,-(sp)
        jsr     ti85lib3@0011
        move.w  (sp)+,d4
        move.w  (sp)+,d3
**** Original Line:          push     hl
        move.w  d4,-(sp)
**** Original Line:          ld       hl,(score)
        move.b  1+score-$10000(a0),d4
        asl.w   #8,d4
        move.b  score-$10000(a0),d4
**** Original Line:          add      hl,de
        add.w   d3,d4
**** Original Line:          LOCATE(16,6)
        move.w  d4,-(sp)
        move.w  #(16*256)+6+0,d4
        move.w  d4,d0
        lsr.w   #8,d0
        move.b  d4,$800c-$10000(a0)
        move.b  d0,1+$800c-$10000(a0)
        move.w  (sp)+,d4
**** Original Line:          D_HL
        move.w  d3,-(sp)
        move.w  d4,-(sp)
        jsr     ti85lib3@0011
        move.w  (sp)+,d4
        move.w  (sp)+,d3
**** Original Line:          ld       (score),hl
        move.w  d4,d0
        lsr.w   #8,d0
        move.b  d4,score-$10000(a0)
        move.b  d0,1+score-$10000(a0)
**** Original Line:          pop      hl
        move.w  (sp)+,d4
**** Original Line:          djnz     speed_loop
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_speed_loop
**** Original Line:          ld       a,(ix+7)              ;Score victory bonus
        __ADDR  5
        move.b  7(a5),d7
**** Original Line:          or       a
        or.b   d7,d7
        move.w  sr,(a0)
**** Original Line:          JUMP_Z(lost)
        beq   RA_lost
**** Original Line:          ld       b,80
        and.w   #$ff,d2
        or.w    #(80)<<8,d2
**** Original Line:          ld       hl,0
        move.w  #0+0,d4
**** Original Line:          ld       de,50
        move.w  #50+0,d3
**** Original Line: victory_loop:
        __LABEL victory_loop
**** Original Line:          ld       a,30
        move.b  #30,d7
**** Original Line:          CALL_(waste_time)
        __JSR   RA_waste_time
**** Original Line:          add      hl,de
        add.w   d3,d4
**** Original Line:          LOCATE(16,4)
        move.w  d4,-(sp)
        move.w  #(16*256)+4+0,d4
        move.w  d4,d0
        lsr.w   #8,d0
        move.b  d4,$800c-$10000(a0)
        move.b  d0,1+$800c-$10000(a0)
        move.w  (sp)+,d4
**** Original Line:          D_HL
        move.w  d3,-(sp)
        move.w  d4,-(sp)
        jsr     ti85lib3@0011
        move.w  (sp)+,d4
        move.w  (sp)+,d3
**** Original Line:          push     hl
        move.w  d4,-(sp)
**** Original Line:          ld       hl,(score)
        move.b  1+score-$10000(a0),d4
        asl.w   #8,d4
        move.b  score-$10000(a0),d4
**** Original Line:          add      hl,de
        add.w   d3,d4
**** Original Line:          LOCATE(16,6)
        move.w  d4,-(sp)
        move.w  #(16*256)+6+0,d4
        move.w  d4,d0
        lsr.w   #8,d0
        move.b  d4,$800c-$10000(a0)
        move.b  d0,1+$800c-$10000(a0)
        move.w  (sp)+,d4
**** Original Line:          D_HL
        move.w  d3,-(sp)
        move.w  d4,-(sp)
        jsr     ti85lib3@0011
        move.w  (sp)+,d4
        move.w  (sp)+,d3
**** Original Line:          ld       (score),hl
        move.w  d4,d0
        lsr.w   #8,d0
        move.b  d4,score-$10000(a0)
        move.b  d0,1+score-$10000(a0)
**** Original Line:          pop      hl
        move.w  (sp)+,d4
**** Original Line:          djnz     victory_loop
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_victory_loop
**** Original Line: 
**** Original Line:          ld       b,(ix+7)              ;Score bonus for extra lives
        __ADDR  5
        move.b  7(a5),d1
        asl.w   #8,d1
        and.w   #$ff,d2
        or.w    d1,d2
**** Original Line:          ld       hl,0
        move.w  #0+0,d4
**** Original Line:          ld       de,250
        move.w  #250+0,d3
**** Original Line: lives_loop:
        __LABEL lives_loop
**** Original Line:          ld       a,30
        move.b  #30,d7
**** Original Line:          CALL_(waste_time)
        __JSR   RA_waste_time
**** Original Line:          add      hl,de
        add.w   d3,d4
**** Original Line:          LOCATE(16,5)
        move.w  d4,-(sp)
        move.w  #(16*256)+5+0,d4
        move.w  d4,d0
        lsr.w   #8,d0
        move.b  d4,$800c-$10000(a0)
        move.b  d0,1+$800c-$10000(a0)
        move.w  (sp)+,d4
**** Original Line:          D_HL
        move.w  d3,-(sp)
        move.w  d4,-(sp)
        jsr     ti85lib3@0011
        move.w  (sp)+,d4
        move.w  (sp)+,d3
**** Original Line:          push     hl
        move.w  d4,-(sp)
**** Original Line:          ld       hl,(score)
        move.b  1+score-$10000(a0),d4
        asl.w   #8,d4
        move.b  score-$10000(a0),d4
**** Original Line:          add      hl,de
        add.w   d3,d4
**** Original Line:          LOCATE(16,6)
        move.w  d4,-(sp)
        move.w  #(16*256)+6+0,d4
        move.w  d4,d0
        lsr.w   #8,d0
        move.b  d4,$800c-$10000(a0)
        move.b  d0,1+$800c-$10000(a0)
        move.w  (sp)+,d4
**** Original Line:          D_HL
        move.w  d3,-(sp)
        move.w  d4,-(sp)
        jsr     ti85lib3@0011
        move.w  (sp)+,d4
        move.w  (sp)+,d3
**** Original Line:          ld (score),hl
        move.w  d4,d0
        lsr.w   #8,d0
        move.b  d4,score-$10000(a0)
        move.b  d0,1+score-$10000(a0)
**** Original Line:          pop      hl
        move.w  (sp)+,d4
**** Original Line:          djnz lives_loop
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_lives_loop
**** Original Line:          ld       b,(ix+6)
        __ADDR  5
        move.b  6(a5),d1
        asl.w   #8,d1
        and.w   #$ff,d2
        or.w    d1,d2
**** Original Line: lost:    CALL_(wait_key)
        __LABEL lost
        __JSR   RA_wait_key
**** Original Line:          ld       hl,lowest                  ;See if ya got a hi-score
        move.w  #lowest+0,d4
**** Original Line:          ld       de,(PROGRAM_ADDR)
        move.b  1+PROGRAM_ADDR-$10000(a0),d3
        asl.w   #8,d3
        move.b  PROGRAM_ADDR-$10000(a0),d3
**** Original Line:          add      hl,de
        add.w   d3,d4
**** Original Line:          call     LD_HL_MHL
        jsr     ti85lib3@000A
**** Original Line:          ld       de,(score)
        move.b  1+score-$10000(a0),d3
        asl.w   #8,d3
        move.b  score-$10000(a0),d3
**** Original Line:          call     CP_HL_DE
        jsr     ti85lib3@0010
**** Original Line:          ret      nc
        move.b  (a0),ccr
        bcs     NC__2
        __RTS
NC__2:
**** Original Line:          ROM_CALL(CLEARLCD)
        jsr     ti85lib3@0002
**** Original Line:          LOCATE(0,0)
        move.w  d4,-(sp)
        move.w  #(0*256)+0+0,d4
        move.w  d4,d0
        lsr.w   #8,d0
        move.b  d4,$800c-$10000(a0)
        move.b  d0,1+$800c-$10000(a0)
        move.w  (sp)+,d4
**** Original Line:          ld       de,(PROGRAM_ADDR)
        move.b  1+PROGRAM_ADDR-$10000(a0),d3
        asl.w   #8,d3
        move.b  PROGRAM_ADDR-$10000(a0),d3
**** Original Line:          ld       hl,hi_score_str
        move.w  #hi_score_str+0,d4
**** Original Line:          add      hl,de
        add.w   d3,d4
**** Original Line:          ROM_CALL(D_ZT_STR)
        jsr     ti85lib3@0005
**** Original Line:          ld       ix,lowest
        move.w  #lowest+0,d5
**** Original Line:          inc      de
        addq.w  #1,d3
**** Original Line:          inc      de
        addq.w  #1,d3
**** Original Line:          add      ix,de
        add.w   d3,d5
**** Original Line:          ld       (temp),ix
        move.w  d5,d0
        lsr.w   #8,d0
        move.b  d5,temp-$10000(a0)
        move.b  d0,1+temp-$10000(a0)
**** Original Line:          ld       b,16
        and.w   #$ff,d2
        or.w    #(16)<<8,d2
**** Original Line:          ld       c,32
        move.b  #32,d2
**** Original Line: space_loop:
        __LABEL space_loop
**** Original Line:          ld       (ix),c
        __ADDR  5
        move.b  d2,(a5)
**** Original Line:          inc      ix
        addq.w  #1,d5
**** Original Line:          djnz     space_loop
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_space_loop
**** Original Line:          ld       ix,(temp)
        move.b  1+temp-$10000(a0),d5
        asl.w   #8,d5
        move.b  temp-$10000(a0),d5
**** Original Line:          ld       b,0
        and.w   #$ff,d2
**** Original Line: enter_name_loop:
        __LABEL enter_name_loop
**** Original Line:          call     GET_KEY
        jsr     ti85lib3@0006
**** Original Line:          cp       0
        cmp.b   #0,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,enter_name_loop
        beq   RA_enter_name_loop
**** Original Line:          cp       K_DEL
        cmp.b   #K_DEL,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,backup
        beq   RA_backup
**** Original Line:          cp       K_ENTER
        cmp.b   #K_ENTER,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,nomore
        beq   RA_nomore
**** Original Line:          ld       c,a
        move.b  d7,d2
**** Original Line:          ld       a,15
        move.b  #15,d7
**** Original Line:          cp       b
        move.w  d2,(a1)
        cmp.b   (a1),d7
        move.w  sr,(a0)
**** Original Line:          jr       z,enter_name_loop
        beq   RA_enter_name_loop
**** Original Line:          ld       hl,chartable
        move.w  #chartable+0,d4
**** Original Line:          ld       de,(PROGRAM_ADDR)
        move.b  1+PROGRAM_ADDR-$10000(a0),d3
        asl.w   #8,d3
        move.b  PROGRAM_ADDR-$10000(a0),d3
**** Original Line:          add      hl,de
        add.w   d3,d4
**** Original Line:          ld       e,c
        move.b  d2,d3
**** Original Line:          ld       d,0
        and.w   #$ff,d3
**** Original Line:          add      hl,de
        add.w   d3,d4
**** Original Line:          ld       a,(hl)
        __ADDR  4
        move.b  (a4),d7
**** Original Line:          ld       (ix),a
        __ADDR  5
        move.b  d7,(a5)
**** Original Line:          ROM_CALL(TX_CHARPUT) 
        jsr     ti85lib3@0004
**** Original Line:          inc      b
        add.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        move.w  sr,(a0)
**** Original Line:          inc      ix
        addq.w  #1,d5
**** Original Line:          jr       enter_name_loop
        bra     RA_enter_name_loop
**** Original Line: backup:  dec      b
        __LABEL backup
        sub.w   #$100,d2
**** Original Line:          ld       a,255
        move.b  #255,d7
**** Original Line:          cp       b
        move.w  d2,(a1)
        cmp.b   (a1),d7
        move.w  sr,(a0)
**** Original Line:          jr       z,too_far
        beq   RA_too_far
**** Original Line:          dec      ix
        subq.w  #1,d5
**** Original Line:          ld       (ix),32
        __ADDR  5
        move.b  #32,(a5)
**** Original Line:          ld       hl,$800d
        move.w  #$800d+0,d4
        lea     $800d-$10000(a0),a4
**** Original Line:          dec      (hl)
        ;__ADDR 4
        subq.b  #1,(a4)
**** Original Line:          ld       a,32
        move.b  #32,d7
**** Original Line:          ROM_CALL(TX_CHARPUT)
        jsr     ti85lib3@0004
**** Original Line:          dec      (hl)
        __ADDR  4
        subq.b  #1,(a4)
        move.w  sr,(a0)
**** Original Line:          jr       enter_name_loop
        bra     RA_enter_name_loop
**** Original Line: too_far: inc      b
        __LABEL too_far
        add.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        move.w  sr,(a0)
**** Original Line:          jr       enter_name_loop
        bra     RA_enter_name_loop
**** Original Line: nomore:  ld       hl,lowest
        __LABEL nomore
        move.w  #lowest+0,d4
**** Original Line:          ld       de,(PROGRAM_ADDR)
        move.b  1+PROGRAM_ADDR-$10000(a0),d3
        asl.w   #8,d3
        move.b  PROGRAM_ADDR-$10000(a0),d3
**** Original Line:          add      hl,de
        add.w   d3,d4
**** Original Line:          ld       de,(score)
        move.b  1+score-$10000(a0),d3
        asl.w   #8,d3
        move.b  score-$10000(a0),d3
**** Original Line:          ld       (hl),e
        __ADDR  4
        move.b  d3,(a4)
**** Original Line:          push     hl
        move.w  d4,-(sp)
**** Original Line:          inc      hl
        addq.w  #1,d4
        addq.w  #1,a4
**** Original Line:          ld       (hl),d
        ;__ADDR 4
        move.w  d3,(a1)
        move.b  (a1),(a4)
**** Original Line:          pop      ix              ;sort hiscore table
        move.w  (sp)+,d5
**** Original Line:          ld       b,6
        and.w   #$ff,d2
        or.w    #(6)<<8,d2
**** Original Line: sort_scores
        __LABEL sort_scores
**** Original Line:          ld       e,(ix)
        __ADDR  5
        move.b  (a5),d3
**** Original Line:          ld       d,(ix+1)
        __ADDR  5
        move.b  1(a5),d1
        asl.w   #8,d1
        and.w   #$ff,d3
        or.w    d1,d3
**** Original Line:          ld       l,(ix-19)
        __ADDR  5
        move.b  -19(a5),d4
**** Original Line:          ld       h,(ix-18)
        __ADDR  5
        move.b  -18(a5),d1
        asl.w   #8,d1
        and.w   #$ff,d4
        or.w    d1,d4
**** Original Line:          call     CP_HL_DE
        jsr     ti85lib3@0010
**** Original Line:          ret      nc
        move.b  (a0),ccr
        bcs     NC__3
        __RTS
NC__3:
**** Original Line:          push     bc
        move.w  d2,-(sp)
**** Original Line:          ld       b,19
        and.w   #$ff,d2
        or.w    #(19)<<8,d2
**** Original Line:          ld       d,0
        and.w   #$ff,d3
**** Original Line: exg_loop:ld       e,(ix)
        __LABEL exg_loop
        __ADDR  5
        move.b  (a5),d3
**** Original Line:          ld       c,(ix-19)
        __ADDR  5
        move.b  -19(a5),d2
**** Original Line:          ld       (ix),c
        __ADDR  5
        move.b  d2,(a5)
**** Original Line:          ld       (ix-19),e
        ;__ADDR 5
        move.b  d3,-19(a5)
**** Original Line:          inc      ix
        addq.w  #1,d5
**** Original Line:          djnz     exg_loop
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_exg_loop
**** Original Line:          ld       de,-38
        move.w  #-38+0,d3
**** Original Line:          add      ix,de
        add.w   d3,d5
**** Original Line:          pop      bc
        move.w  (sp)+,d2
**** Original Line:          djnz     sort_scores
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_sort_scores
**** Original Line:          ret
        __RTS
**** Original Line:  ;------------------ LEVEL STARTING CODE ---------------------
**** Original Line: do_level:ld       (ix+0),128
        __LABEL do_level
        __ADDR  5
        move.b  #128,0(a5)
**** Original Line:          ld       (ix+1),58
        ;__ADDR 5
        move.b  #58,1(a5)
**** Original Line:          ld       (ix+2),112
        ;__ADDR 5
        move.b  #112,2(a5)
**** Original Line:          ld       (ix+3),-1
        ;__ADDR 5
        move.b  #-1,3(a5)
**** Original Line:          ld       (ix+4),-1
        ;__ADDR 5
        move.b  #-1,4(a5)
**** Original Line:          ret
        __RTS
**** Original Line:  ;---------------------- THE MAIN GAME -----------------------
**** Original Line: play_level:
        __LABEL play_level
**** Original Line:          ROM_CALL(CLEARLCD)       ;Display level entry message
        jsr     ti85lib3@0002
**** Original Line:          ld       ix,$800c
        move.w  #$800c+0,d5
        lea     $800c-$10000(a0),a5
**** Original Line:          ld       (ix+0),0
        ;__ADDR 5
        move.b  #0,0(a5)
**** Original Line:          ld       (ix+1),0
        ;__ADDR 5
        move.b  #0,1(a5)
**** Original Line:          ld       hl,approaching
        move.w  #approaching+0,d4
**** Original Line:          ld       de,(PROGRAM_ADDR)
        move.b  1+PROGRAM_ADDR-$10000(a0),d3
        asl.w   #8,d3
        move.b  PROGRAM_ADDR-$10000(a0),d3
**** Original Line:          add      hl,de
        add.w   d3,d4
**** Original Line:          ROM_CALL(D_ZT_STR)
        jsr     ti85lib3@0005
**** Original Line:          ld       hl,level
        move.w  #level+0,d4
        lea     level-$10000(a0),a4
**** Original Line:          ld       c,(hl)
        ;__ADDR 4
        move.b  (a4),d2
**** Original Line:          ld       b,0
        and.w   #$ff,d2
**** Original Line:          push     bc
        move.w  d2,-(sp)
**** Original Line:          pop      hl
        move.w  (sp)+,d4
**** Original Line:          ROM_CALL(D_HL_DECI)
        jsr     ti85lib3@0011
**** Original Line:          ld       hl,press
        move.w  #press+0,d4
**** Original Line:          ld       de,(PROGRAM_ADDR)
        move.b  1+PROGRAM_ADDR-$10000(a0),d3
        asl.w   #8,d3
        move.b  PROGRAM_ADDR-$10000(a0),d3
**** Original Line:          add      hl,de
        add.w   d3,d4
**** Original Line:          ROM_CALL(D_ZT_STR)
        jsr     ti85lib3@0005
**** Original Line:          ld       hl,lives
        move.w  #lives+0,d4
        lea     lives-$10000(a0),a4
**** Original Line:          ld       c,(hl)
        ;__ADDR 4
        move.b  (a4),d2
**** Original Line:          ld       b,0
        and.w   #$ff,d2
**** Original Line:          push     bc
        move.w  d2,-(sp)
**** Original Line:          pop      hl
        move.w  (sp)+,d4
**** Original Line:          ROM_CALL(D_HL_DECI)
        jsr     ti85lib3@0011
**** Original Line:          CALL_(wait_key)
        __JSR   RA_wait_key
**** Original Line:          cp       K_EXIT
        cmp.b   #K_EXIT,d7
        move.w  sr,(a0)
**** Original Line:          JUMP_Z(r3)
        beq   RA_r3
**** Original Line:          ld       ix,x
        move.w  #x+0,d5
**** Original Line: game_main_loop:
        __LABEL game_main_loop
**** Original Line:          ld       hl,$8641
        move.w  #$8641+0,d4
**** Original Line:          ld       b,128
        and.w   #$ff,d2
        or.w    #(128)<<8,d2
**** Original Line:          xor      a
        eor.b   d7,d7
**** Original Line: clgloop: ld       (hl),a
        __LABEL clgloop
        __ADDR  4
        move.b  d7,(a4)
**** Original Line:          inc      hl
        addq.w  #1,d4
        addq.w  #1,a4
**** Original Line:          ld       (hl),a
        ;__ADDR 4
        move.b  d7,(a4)
**** Original Line:          inc      hl
        addq.w  #1,d4
        addq.w  #1,a4
**** Original Line:          ld       (hl),a
        ;__ADDR 4
        move.b  d7,(a4)
**** Original Line:          inc      hl
        addq.w  #1,d4
        addq.w  #1,a4
**** Original Line:          ld       (hl),a
        ;__ADDR 4
        move.b  d7,(a4)
**** Original Line:          inc      hl
        addq.w  #1,d4
        addq.w  #1,a4
**** Original Line:          ld       (hl),a
        ;__ADDR 4
        move.b  d7,(a4)
**** Original Line:          inc      hl
        addq.w  #1,d4
        addq.w  #1,a4
**** Original Line:          ld       (hl),a
        ;__ADDR 4
        move.b  d7,(a4)
**** Original Line:          inc      hl
        addq.w  #1,d4
        addq.w  #1,a4
**** Original Line:          ld       (hl),a
        ;__ADDR 4
        move.b  d7,(a4)
**** Original Line:          inc      hl
        addq.w  #1,d4
        addq.w  #1,a4
**** Original Line:          ld       (hl),a
        ;__ADDR 4
        move.b  d7,(a4)
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          djnz     clgloop
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_clgloop
**** Original Line:          ld       a,(ix+9)              ;Slow down a bit
        __ADDR  5
        move.b  9(a5),d7
**** Original Line:          or       a
        or.b   d7,d7
        move.w  sr,(a0)
**** Original Line:          CALL_NZ(waste_time)
        beq     NC__4
        __JSR   RA_waste_time
NC__4:
**** Original Line:          CALL_(redraw_solid)      ;Redraw all blocks
        __JSR   RA_redraw_solid
**** Original Line:          ld       a,(ix)                ;Move ball left/right      
        __ADDR  5
        move.b  (a5),d7
**** Original Line:          add      a,(ix+3)                   
        __ADDR  5
        add.b   3(a5),d7
**** Original Line:          ld       (ix+0),a             
        ;__ADDR 5
        move.b  d7,0(a5)
**** Original Line:          bit      5,(ix+1)             ;Bounce off of blocks          
        ;__ADDR 5
        btst    #5,1(a5)
        move.w  sr,(a0)
**** Original Line:          jr       nz,bottom_section_1      
        move.b  (a0),ccr
        bne   RA_bottom_section_1
**** Original Line:          CALL_(test_hit)      
        __JSR   RA_test_hit
**** Original Line:          bit      1,a      
        btst    #1,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,horiz_not_solid      
        move.b  (a0),ccr
        beq   RA_horiz_not_solid
**** Original Line:          ld       a,(ix+3)      
        __ADDR  5
        move.b  3(a5),d7
**** Original Line:          neg      
        neg.b   d7
**** Original Line:          ld       (ix+3),a      
        __ADDR  5
        move.b  d7,3(a5)
**** Original Line:          add      a,(ix)      
        ;__ADDR 5
        add.b   (a5),d7
        move.w  sr,(a0)
**** Original Line:          ld       (ix),a      
        ;__ADDR 5
        move.b  d7,(a5)
**** Original Line:          jr       bottom_section_1
        bra     RA_bottom_section_1
**** Original Line: horiz_not_solid:
        __LABEL horiz_not_solid
**** Original Line:          cp       0
        cmp.b   #0,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,bottom_section_1
        beq   RA_bottom_section_1
**** Original Line:          ld       a,(ix+3)
        __ADDR  5
        move.b  3(a5),d7
**** Original Line:          neg
        neg.b   d7
**** Original Line:          ld       (ix+3),a
        __ADDR  5
        move.b  d7,3(a5)
**** Original Line: bottom_section_1:      
        __LABEL bottom_section_1
**** Original Line:          ld       a,(ix+1)              ;Move ball up/down      
        __ADDR  5
        move.b  1(a5),d7
**** Original Line:          add      a,(ix+4)      
        __ADDR  5
        add.b   4(a5),d7
**** Original Line:          ld       (ix+1),a      
        ;__ADDR 5
        move.b  d7,1(a5)
**** Original Line:          bit      5,(ix+1)             ;Bounce off of blocks          
        ;__ADDR 5
        btst    #5,1(a5)
        move.w  sr,(a0)
**** Original Line:          jr       nz,bottom_section_2
        move.b  (a0),ccr
        bne   RA_bottom_section_2
**** Original Line:          CALL_(test_hit)
        __JSR   RA_test_hit
**** Original Line:          bit      1,a
        btst    #1,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,vert_not_solid
        move.b  (a0),ccr
        beq   RA_vert_not_solid
**** Original Line:          ld       a,(ix+4)
        __ADDR  5
        move.b  4(a5),d7
**** Original Line:          neg
        neg.b   d7
**** Original Line:          ld       (ix+4),a
        __ADDR  5
        move.b  d7,4(a5)
**** Original Line:          add      a,(ix+1)
        ;__ADDR 5
        add.b   1(a5),d7
        move.w  sr,(a0)
**** Original Line:          ld       (ix+1),a
        ;__ADDR 5
        move.b  d7,1(a5)
**** Original Line:          jr       bottom_section_2
        bra     RA_bottom_section_2
**** Original Line: vert_not_solid:
        __LABEL vert_not_solid
**** Original Line:          cp       0
        cmp.b   #0,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,bottom_section_2
        beq   RA_bottom_section_2
**** Original Line:          ld       a,(ix+4)
        __ADDR  5
        move.b  4(a5),d7
**** Original Line:          neg
        neg.b   d7
**** Original Line:          ld       (ix+4),a
        __ADDR  5
        move.b  d7,4(a5)
**** Original Line: bottom_section_2:
        __LABEL bottom_section_2
**** Original Line:          push     ix                    ;Draw the ball
        move.w  d5,-(sp)
**** Original Line:          ld       c,(ix+1)
        __ADDR  5
        move.b  1(a5),d2
**** Original Line:          ld       b,(ix+0)
        __ADDR  5
        move.b  0(a5),d1
        asl.w   #8,d1
        and.w   #$ff,d2
        or.w    d1,d2
**** Original Line:          srl      b
        move.w  d2,(a1)
        move.b  (a1),d1
        lsr.b   #1,d1
        move.b  d1,(a1)
        move.w  (a1),d2
**** Original Line:          dec      c
        subq.b  #1,d2
**** Original Line:          dec      b
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        move.w  sr,(a0)
**** Original Line:          ld       ix,spr_ball
        move.w  #spr_ball+0,d5
**** Original Line:          ld       de,(PROGRAM_ADDR)
        move.b  1+PROGRAM_ADDR-$10000(a0),d3
        asl.w   #8,d3
        move.b  PROGRAM_ADDR-$10000(a0),d3
**** Original Line:          add      ix,de
        add.w   d3,d5
**** Original Line:          CALL_(drw_spr)
        __JSR   RA_drw_spr
**** Original Line:          pop      ix
        move.w  (sp)+,d5
**** Original Line:          ld       a,(ix+1)              ;Bounce off top
        __ADDR  5
        move.b  1(a5),d7
**** Original Line:          cp       1
        cmp.b   #1,d7
        move.w  sr,(a0)
**** Original Line:          jr       nz,not_top
        bne   RA_not_top
**** Original Line:          ld       (ix+4),1
        __ADDR  5
        move.b  #1,4(a5)
**** Original Line: not_top: ld       a,(ix+1)              ;Bounce off paddle / Fall off screen
        __LABEL not_top
        __ADDR  5
        move.b  1(a5),d7
**** Original Line:          cp       62
        cmp.b   #62,d7
        move.w  sr,(a0)
**** Original Line:          ret      z
        bne     NC__5
        __RTS
NC__5:
**** Original Line:          cp       61
        cmp.b   #61,d7
        move.w  sr,(a0)
**** Original Line:          CALL_Z(bounce_paddle)
        bne     NC__6
        __JSR   RA_bounce_paddle
NC__6:
**** Original Line:          cp       60
        cmp.b   #60,d7
        move.w  sr,(a0)
**** Original Line:          CALL_Z(bounce_paddle)
        bne     NC__7
        __JSR   RA_bounce_paddle
NC__7:
**** Original Line:          ld       a,(ix+0)              ;Bounce off left edge
        __ADDR  5
        move.b  0(a5),d7
**** Original Line:          and      252
        and.b   #252,d7
        move.w  sr,(a0)
**** Original Line:          jr       nz,not_hit_left_edge
        bne   RA_not_hit_left_edge
**** Original Line: hit_left_edge:                          ;Hit left edge of screen
        __LABEL hit_left_edge
**** Original Line:          ld       a,(ix+3)
        __ADDR  5
        move.b  3(a5),d7
**** Original Line:          bit      7,a
        btst    #7,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,not_hit_left_edge
        move.b  (a0),ccr
        beq   RA_not_hit_left_edge
**** Original Line:          neg
        neg.b   d7
**** Original Line:          ld       (ix+3),a
        __ADDR  5
        move.b  d7,3(a5)
**** Original Line: not_hit_left_edge:
        __LABEL not_hit_left_edge
**** Original Line:          ld       a,(ix+0)              ;Bounce off right edge
        __ADDR  5
        move.b  0(a5),d7
**** Original Line:          add      a,4
        add.b   #4,d7
**** Original Line:          and      252
        and.b   #252,d7
        move.w  sr,(a0)
**** Original Line:          jr       nz,not_hit_right_edge
        bne   RA_not_hit_right_edge
**** Original Line: hit_right_edge:                         ;Hit right edge of screen
        __LABEL hit_right_edge
**** Original Line:          ld       a,(ix+3)
        __ADDR  5
        move.b  3(a5),d7
**** Original Line:          bit      7,a
        btst    #7,d7
        move.w  sr,(a0)
**** Original Line:          jr       nz,not_hit_right_edge
        move.b  (a0),ccr
        bne   RA_not_hit_right_edge
**** Original Line:          neg
        neg.b   d7
**** Original Line:          ld       (ix+3),a
        __ADDR  5
        move.b  d7,3(a5)
**** Original Line: not_hit_right_edge:
        __LABEL not_hit_right_edge
**** Original Line:          ld       a,%00111111           ;Exit key = get out!
        move.b  #%00111111,d7
**** Original Line:          out      (1),a
        move.b  #1,d1
        jsr     ti85lib3@0007
**** Original Line:          in       a,(1)
        move.b  #1,d1
        jsr     ti85lib3@0008
**** Original Line:          bit      6,a
        btst    #6,d7
        move.w  sr,(a0)
**** Original Line:          JUMP_Z(r3)
        move.b  (a0),ccr
        beq   RA_r3
**** Original Line:          ld       a,%01111110           ;Left arrow = go left!
        move.b  #%01111110,d7
**** Original Line:          out      (1),a
        move.b  #1,d1
        jsr     ti85lib3@0007
**** Original Line:          in       a,(1)
        move.b  #1,d1
        jsr     ti85lib3@0008
**** Original Line:          bit      1,a
        btst    #1,d7
        move.w  sr,(a0)
**** Original Line:          CALL_Z(go_left)
        move.b  (a0),ccr
        bne     NC__8
        __JSR   RA_go_left
NC__8:
**** Original Line:          in       a,(1)                 ;Right arrow = go right!
        move.b  #1,d1
        jsr     ti85lib3@0008
**** Original Line:          bit      2,a                 
        btst    #2,d7
        move.w  sr,(a0)
**** Original Line:          CALL_Z(go_right)
        move.b  (a0),ccr
        bne     NC__9
        __JSR   RA_go_right
NC__9:
**** Original Line:          in       a,(1)                 ;Down arrow = save & exit
        move.b  #1,d1
        jsr     ti85lib3@0008
**** Original Line:          bit      0,a
        btst    #0,d7
        move.w  sr,(a0)
**** Original Line:          JUMP_Z(save)
        move.b  (a0),ccr
        beq   RA_save
**** Original Line:          ld       a,(ix+2)              ; Draw paddle
        __ADDR  5
        move.b  2(a5),d7
**** Original Line:          srl      a
        lsr.b   #1,d7
**** Original Line:          add      a,b
        move.w  d2,(a1)
        add.b   (a1),d7
        move.w  sr,(a0)
**** Original Line:          ld       b,a
        move.w  d2,(a1)
        move.b  d7,(a1)
        move.w  (a1),d2
**** Original Line:          ld       c,60
        move.b  #60,d2
**** Original Line:          push     ix
        move.w  d5,-(sp)
**** Original Line:          ld       ix,leftp
        move.w  #leftp+0,d5
**** Original Line:          ld       de,(PROGRAM_ADDR)
        move.b  1+PROGRAM_ADDR-$10000(a0),d3
        asl.w   #8,d3
        move.b  PROGRAM_ADDR-$10000(a0),d3
**** Original Line:          add      ix,de
        add.w   d3,d5
**** Original Line:          push     bc
        move.w  d2,-(sp)
**** Original Line:          push     ix
        move.w  d5,-(sp)
**** Original Line:          CALL_(drw_spr)
        __JSR   RA_drw_spr
**** Original Line:          pop      ix
        move.w  (sp)+,d5
**** Original Line:          ld       de,6
        move.w  #6+0,d3
**** Original Line:          add      ix,de
        add.w   d3,d5
**** Original Line:          pop      bc
        move.w  (sp)+,d2
**** Original Line:          ld       a,b
        move.w  d2,(a1)
        move.b  (a1),d7
**** Original Line:          add      a,8
        add.b   #8,d7
        move.w  sr,(a0)
**** Original Line:          ld       b,a
        move.w  d2,(a1)
        move.b  d7,(a1)
        move.w  (a1),d2
**** Original Line:          CALL_(drw_spr)
        __JSR   RA_drw_spr
**** Original Line:          pop      ix
        move.w  (sp)+,d5
**** Original Line:          xor      a
        eor.b   d7,d7
**** Original Line:          or       (ix+8)
        __ADDR  5
        or.b   8(a5),d7
        move.w  sr,(a0)
**** Original Line:          ld       de,$fc00
        move.w  #$fc00+0,d3
**** Original Line:          ld       hl,$8641
        move.w  #$8641+0,d4
**** Original Line:          ld       bc,1024
        move.w  #1024+0,d2
**** Original Line:          ldir
        __LDIR
**** Original Line:          JUMP_NZ(game_main_loop)
        move.b  (a0),ccr
        bne   RA_game_main_loop
**** Original Line:          ret
        __RTS
**** Original Line:   ; ------------------- UTILITY ROUTINES ----------------------
**** Original Line: save:    pop      bc                ;Save the game
        __LABEL save
        move.w  (sp)+,d2
**** Original Line:          pop      bc
        move.w  (sp)+,d2
**** Original Line:          ld       hl,saved_flag
        move.w  #saved_flag+0,d4
**** Original Line:          ld       de,(PROGRAM_ADDR)
        move.b  1+PROGRAM_ADDR-$10000(a0),d3
        asl.w   #8,d3
        move.b  PROGRAM_ADDR-$10000(a0),d3
**** Original Line:          add      hl,de
        add.w   d3,d4
**** Original Line:          ld       (hl),1
        __ADDR  4
        move.b  #1,(a4)
**** Original Line:          ld       bc,168
        move.w  #168+0,d2
**** Original Line:          ld       hl,saved_game
        move.w  #saved_game+0,d4
**** Original Line:          add      hl,de
        add.w   d3,d4
**** Original Line:          push     hl
        move.w  d4,-(sp)
**** Original Line:          pop      de
        move.w  (sp)+,d3
**** Original Line:          ld       hl,$80df
        move.w  #$80df+0,d4
        lea     $80df-$10000(a0),a4
**** Original Line:          ldir
        __LDIR
**** Original Line:          ld       hl,ZS_BITS
        move.w  #ZS_BITS+0,d4
        lea     ZS_BITS-$10000(a0),a4
**** Original Line:          ld       (hl),3
        ;__ADDR 4
        move.b  #3,(a4)
**** Original Line:          ld       hl,temp2
        move.w  #temp2+0,d4
        lea     temp2-$10000(a0),a4
**** Original Line:          ld       (hl),1
        ;__ADDR 4
        move.b  #1,(a4)
**** Original Line:          ld       a,(CONTRAST)    
        move.b  CONTRAST-$10000(a0),d7
**** Original Line:          out      (2),a
        move.b  #2,d1
        jsr     ti85lib3@0007
**** Original Line:          ret
        __RTS
**** Original Line: restore_game:                       ;Restore the game
        __LABEL restore_game
**** Original Line:          ld       (hl),0
        __ADDR  4
        move.b  #0,(a4)
**** Original Line:          ld       bc,168
        move.w  #168+0,d2
**** Original Line:          inc      hl
        addq.w  #1,d4
**** Original Line:          ld       de,$80df
        move.w  #$80df+0,d3
**** Original Line:          ldir
        __LDIR
**** Original Line:          JUMP_(restore_position)
        bra     RA_restore_position
**** Original Line: wait_key:ld       a,200                   ;Wait for a keypress
        __LABEL wait_key
        move.b  #200,d7
**** Original Line:          CALL_(waste_time)
        __JSR   RA_waste_time
**** Original Line: wait_inner:
        __LABEL wait_inner
**** Original Line:          call     GET_KEY
        jsr     ti85lib3@0006
**** Original Line:          or       a
        or.b   d7,d7
        move.w  sr,(a0)
**** Original Line:          ret      nz
        beq     NC__10
        __RTS
NC__10:
**** Original Line:          jr       wait_inner
        bra     RA_wait_inner
**** Original Line: test_hit:ld       a,(ix+1)                ;Test if a block has been hit
        __LABEL test_hit
        __ADDR  5
        move.b  1(a5),d7
**** Original Line:          and      28
        and.b   #28,d7
**** Original Line:          sla      a
        add.b   d7,d7
**** Original Line:          sla      a
        add.b   d7,d7
**** Original Line:          ld       b,a
        move.w  d2,(a1)
        move.b  d7,(a1)
        move.w  (a1),d2
**** Original Line:          ld       a,(ix+0)
        __ADDR  5
        move.b  0(a5),d7
**** Original Line:          srl      a
        lsr.b   #1,d7
**** Original Line:          srl      a
        lsr.b   #1,d7
**** Original Line:          srl      a
        lsr.b   #1,d7
**** Original Line:          srl      a
        lsr.b   #1,d7
**** Original Line:          add      a,b
        move.w  d2,(a1)
        add.b   (a1),d7
**** Original Line:          ld       hl,$8100
        move.w  #$8100+0,d4
**** Original Line:          ld       c,a
        move.b  d7,d2
**** Original Line:          ld       b,0
        and.w   #$ff,d2
**** Original Line:          add      hl,bc
        add.w   d2,d4
**** Original Line:          ld       a,(hl)
        __ADDR  4
        move.b  (a4),d7
**** Original Line:          cp       1
        cmp.b   #1,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,clr_block
        beq   RA_clr_block
**** Original Line:          cp       2
        cmp.b   #2,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,dec_block
        beq   RA_dec_block
**** Original Line:          ret
        __RTS
**** Original Line: dec_block:
        __LABEL dec_block
**** Original Line:          ld       (hl),1
        __ADDR  4
        move.b  #1,(a4)
**** Original Line:          ret
        __RTS
**** Original Line: clr_block:                    ;Clear out a block
        __LABEL clr_block
**** Original Line:          push     af
        move.b  d7,d1
        lsl.w   #8,d1
        move.b  1(a0),d1
        move.w  d1,-(sp)
**** Original Line:          ld       (hl),0
        __ADDR  4
        move.b  #0,(a4)
**** Original Line:          ld       a,(ix+1)
        __ADDR  5
        move.b  1(a5),d7
**** Original Line:          and      28
        and.b   #28,d7
**** Original Line:          ld       b,0
        and.w   #$ff,d2
**** Original Line:          ld       c,a
        move.b  d7,d2
**** Original Line:          sla      c
        add.b   d2,d2
**** Original Line:          sla      c
        add.b   d2,d2
**** Original Line:          sla      c
        add.b   d2,d2
**** Original Line:          bit      7,c
        btst    #7,d2
        move.w  sr,(a0)
**** Original Line:          jr       z,n_s
        move.b  (a0),ccr
        beq   RA_n_s
**** Original Line:          ld       b,1
        and.w   #$ff,d2
        or.w    #(1)<<8,d2
**** Original Line: n_s:     sla      c
        __LABEL n_s
        add.b   d2,d2
**** Original Line:          ld       a,(ix+0)
        __ADDR  5
        move.b  0(a5),d7
**** Original Line:          srl      a
        lsr.b   #1,d7
**** Original Line:          srl      a
        lsr.b   #1,d7
**** Original Line:          srl      a
        lsr.b   #1,d7
**** Original Line:          srl      a
        lsr.b   #1,d7
**** Original Line:          ld       hl,$fc00
        move.w  #$fc00+0,d4
**** Original Line:          add      hl,bc
        add.w   d2,d4
**** Original Line:          ld       b,0
        and.w   #$ff,d2
**** Original Line:          ld       c,a
        move.b  d7,d2
**** Original Line:          add      hl,bc
        add.w   d2,d4
**** Original Line:          ld       c,16
        move.b  #16,d2
**** Original Line:          ld       (hl),b
        __ADDR  4
        move.w  d2,(a1)
        move.b  (a1),(a4)
**** Original Line:          add      hl,bc
        add.w   d2,d4
**** Original Line:          ld       (hl),b
        __ADDR  4
        move.w  d2,(a1)
        move.b  (a1),(a4)
**** Original Line:          add      hl,bc
        add.w   d2,d4
**** Original Line:          ld       (hl),b
        __ADDR  4
        move.w  d2,(a1)
        move.b  (a1),(a4)
**** Original Line:          add      hl,bc
        add.w   d2,d4
**** Original Line:          ld       (hl),b
        __ADDR  4
        move.w  d2,(a1)
        move.b  (a1),(a4)
**** Original Line:          inc      (ix+10)
        __ADDR  5
        addq.b  #1,10(a5)
        move.w  sr,(a0)
**** Original Line:          jr       z,ovl
        beq   RA_ovl
**** Original Line:          pop      af
        move.w  (sp)+,d1
        move.b  d1,1(a0)
        lsr.w   #8,d1
        move.b  d1,d7
**** Original Line:          ret
        __RTS
**** Original Line: ovl:     inc      (ix+11)
        __LABEL ovl
        __ADDR  5
        addq.b  #1,11(a5)
        move.w  sr,(a0)
**** Original Line:          pop      af
        move.w  (sp)+,d1
        move.b  d1,1(a0)
        lsr.w   #8,d1
        move.b  d1,d7
**** Original Line:          ret
        __RTS
**** Original Line: r3:      ld       a,(CONTRAST)    
        __LABEL r3
        move.b  CONTRAST-$10000(a0),d7
**** Original Line:          out      (2),a
        move.b  #2,d1
        jsr     ti85lib3@0007
**** Original Line:          ld       hl,temp2
        move.w  #temp2+0,d4
        lea     temp2-$10000(a0),a4
**** Original Line:          ld       (hl),1
        ;__ADDR 4
        move.b  #1,(a4)
**** Original Line:          inc      sp                   ;Return multiple levels
        __INCSTACK
**** Original Line:          inc      sp
        __INCSTACK
**** Original Line:          inc      sp
        __INCSTACK
**** Original Line:          inc      sp
        __INCSTACK
**** Original Line:          ret
        __RTS
**** Original Line: go_right:ld       a,(ix+2)
        __LABEL go_right
        __ADDR  5
        move.b  2(a5),d7
**** Original Line:          cp       224
        cmp.b   #224,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,right_edge
        beq   RA_right_edge
**** Original Line:          inc      a
        addq.b  #1,d7
**** Original Line:          ld       c,1
        move.b  #1,d2
**** Original Line:          in       e,(c)
        move.w  d7,-(sp)
        move.b  d2,d1
        jsr     ti85lib3@0008
        move.b  d7,d3
        move.w  (sp)+,d7
**** Original Line:          bit      3,e
        btst    #3,d3
        move.w  sr,(a0)
**** Original Line:          jr       z,quit_moving
        move.b  (a0),ccr
        beq   RA_quit_moving
**** Original Line:          cp       224
        cmp.b   #224,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,right_edge
        beq   RA_right_edge
**** Original Line:          inc      a
        addq.b  #1,d7
**** Original Line:          cp       224
        cmp.b   #224,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,right_edge
        beq   RA_right_edge
**** Original Line:          inc      a
        addq.b  #1,d7
**** Original Line:          cp       224
        cmp.b   #224,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,right_edge
        beq   RA_right_edge
**** Original Line:          inc      a
        addq.b  #1,d7
        move.w  sr,(a0)
**** Original Line: quit_moving:
        __LABEL quit_moving
**** Original Line:          ld       (ix+2),a
        __ADDR  5
        move.b  d7,2(a5)
**** Original Line:          ret
        __RTS
**** Original Line: right_edge:                   ;If paddle is at right edge
        __LABEL right_edge
**** Original Line:          ld       a,224
        move.b  #224,d7
**** Original Line:          ld       (ix+2),a
        __ADDR  5
        move.b  d7,2(a5)
**** Original Line:          ret
        __RTS
**** Original Line: go_left: ld       a,(ix+2)
        __LABEL go_left
        __ADDR  5
        move.b  2(a5),d7
**** Original Line:          cp       0
        cmp.b   #0,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,left_edge
        beq   RA_left_edge
**** Original Line:          dec      a
        subq.b  #1,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,left_edge
        beq   RA_left_edge
**** Original Line:          ld       c,1
        move.b  #1,d2
**** Original Line:          in       e,(c)
        move.w  d7,-(sp)
        move.b  d2,d1
        jsr     ti85lib3@0008
        move.b  d7,d3
        move.w  (sp)+,d7
**** Original Line:          bit      3,e
        btst    #3,d3
        move.w  sr,(a0)
**** Original Line:          jr       z,quit_moving
        move.b  (a0),ccr
        beq   RA_quit_moving
**** Original Line:          dec      a
        subq.b  #1,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,left_edge
        beq   RA_left_edge
**** Original Line:          dec      a
        subq.b  #1,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,left_edge
        beq   RA_left_edge
**** Original Line:          dec      a
        subq.b  #1,d7
**** Original Line:          ld       (ix+2),a
        __ADDR  5
        move.b  d7,2(a5)
**** Original Line:          xor      a
        eor.b   d7,d7
        move.w  sr,(a0)
**** Original Line:          ret
        __RTS
**** Original Line: left_edge:                     ;If paddle is at left edge
        __LABEL left_edge
**** Original Line:          xor      a
        eor.b   d7,d7
        move.w  sr,(a0)
**** Original Line:          ld       (ix+2),a
        __ADDR  5
        move.b  d7,2(a5)
**** Original Line:          ret
        __RTS
**** Original Line: waste_time:                         ;Delay a little bit
        __LABEL waste_time
**** Original Line:          push     bc
        move.w  d2,-(sp)
**** Original Line:          ld       b,0
        and.w   #$ff,d2
**** Original Line: l:       push     bc
        __LABEL l
        move.w  d2,-(sp)
**** Original Line:          ld       b,a
        move.w  d2,(a1)
        move.b  d7,(a1)
        move.w  (a1),d2
**** Original Line: il:      nop
        __LABEL il
        nop
**** Original Line:          djnz     il
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_il
**** Original Line:          pop      bc
        move.w  (sp)+,d2
**** Original Line:          djnz     l
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_l
**** Original Line:          pop      bc
        move.w  (sp)+,d2
**** Original Line:          ret
        __RTS
**** Original Line: bounce_paddle:                ;Bounce ball off paddle
        __LABEL bounce_paddle
**** Original Line:          ld       a,(ix+0)
        __ADDR  5
        move.b  0(a5),d7
**** Original Line:          sub      (ix+2)
        __ADDR  5
        sub.b   2(a5),d7
**** Original Line:          ld       c,a
        move.b  d7,d2
**** Original Line:          srl      a
        lsr.b   #1,d7
**** Original Line:          srl      a             
        lsr.b   #1,d7
**** Original Line:          srl      a
        lsr.b   #1,d7
**** Original Line:          srl      a
        lsr.b   #1,d7
**** Original Line:          srl      a
        lsr.b   #1,d7
        move.w  sr,(a0)
**** Original Line:          ret      nz
        beq     NC__11
        __RTS
NC__11:
**** Original Line:          ld       hl,(PROGRAM_ADDR)
        move.b  1+PROGRAM_ADDR-$10000(a0),d4
        asl.w   #8,d4
        move.b  PROGRAM_ADDR-$10000(a0),d4
**** Original Line:          ld       de,bounces
        move.w  #bounces+0,d3
**** Original Line:          add      hl,de
        add.w   d3,d4
**** Original Line:          ld       b,0
        and.w   #$ff,d2
**** Original Line:          add      hl,bc
        add.w   d2,d4
**** Original Line:          ld       a,(hl)
        __ADDR  4
        move.b  (a4),d7
**** Original Line:          ld       (ix+3),a
        ;__ADDR 5
        move.b  d7,3(a5)
**** Original Line:          ld       a,-1
        move.b  #-1,d7
**** Original Line:          ld       (ix+4),a
        ;__ADDR 5
        move.b  d7,4(a5)
**** Original Line:          ret
        __RTS
**** Original Line: redraw_solid:                 ;Redraw all bricks
        __LABEL redraw_solid
**** Original Line:          ld       hl,won
        move.w  #won+0,d4
        lea     won-$10000(a0),a4
**** Original Line:          ld       (hl),0
        ;__ADDR 4
        move.b  #0,(a4)
**** Original Line:          ld       ix,$8641
        move.w  #$8641+0,d5
**** Original Line:          ld       hl,$8100
        move.w  #$8100+0,d4
**** Original Line:          ld       b,8
        and.w   #$ff,d2
        or.w    #(8)<<8,d2
**** Original Line: rs_outer:push     bc
        __LABEL rs_outer
        move.w  d2,-(sp)
**** Original Line:          ld       b,16
        and.w   #$ff,d2
        or.w    #(16)<<8,d2
**** Original Line: rs_inner:ld       a,(hl)
        __LABEL rs_inner
        __ADDR  4
        move.b  (a4),d7
**** Original Line:          cp       3
        cmp.b   #3,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,draw_block_solid
        beq   RA_draw_block_solid
**** Original Line:          cp       1
        cmp.b   #1,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,draw_block
        beq   RA_draw_block
**** Original Line:          cp       2
        cmp.b   #2,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,draw_block_tough
        beq   RA_draw_block_tough
**** Original Line: ok:      inc      hl
        __LABEL ok
        addq.w  #1,d4
**** Original Line:          inc      ix
        addq.w  #1,d5
**** Original Line:          djnz     rs_inner
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_rs_inner
**** Original Line:          ld       de,48
        move.w  #48+0,d3
**** Original Line:          add      ix,de
        add.w   d3,d5
**** Original Line:          pop      bc
        move.w  (sp)+,d2
**** Original Line:          djnz     rs_outer
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_rs_outer
**** Original Line:          ld       ix,x
        move.w  #x+0,d5
**** Original Line:          ret
        __RTS
**** Original Line: draw_block:                   ;Draw a standard block
        __LABEL draw_block
**** Original Line:          push     hl
        move.w  d4,-(sp)
**** Original Line:          ld       hl,won
        move.w  #won+0,d4
        lea     won-$10000(a0),a4
**** Original Line:          ld       (hl),1
        ;__ADDR 4
        move.b  #1,(a4)
**** Original Line:          pop      hl
        move.w  (sp)+,d4
**** Original Line:          ld       (ix+0),255
        __ADDR  5
        move.b  #255,0(a5)
**** Original Line:          ld       (ix+16),129
        ;__ADDR 5
        move.b  #129,16(a5)
**** Original Line:          ld       (ix+32),129
        ;__ADDR 5
        move.b  #129,32(a5)
**** Original Line:          ld       (ix+48),255
        ;__ADDR 5
        move.b  #255,48(a5)
**** Original Line:          jr       ok
        bra     RA_ok
**** Original Line: draw_block_solid:             ;Draw a solid block
        __LABEL draw_block_solid
**** Original Line:          ld       (ix+0),255
        __ADDR  5
        move.b  #255,0(a5)
**** Original Line:          ld       (ix+16),255
        ;__ADDR 5
        move.b  #255,16(a5)
**** Original Line:          ld       (ix+32),255
        ;__ADDR 5
        move.b  #255,32(a5)
**** Original Line:          ld       (ix+48),255
        ;__ADDR 5
        move.b  #255,48(a5)
**** Original Line:          jr       ok
        bra     RA_ok
**** Original Line: draw_block_tough:             ;Draw a tough block
        __LABEL draw_block_tough
**** Original Line:          push     hl
        move.w  d4,-(sp)
**** Original Line:          ld       hl,won
        move.w  #won+0,d4
        lea     won-$10000(a0),a4
**** Original Line:          ld       (hl),1
        ;__ADDR 4
        move.b  #1,(a4)
**** Original Line:          pop      hl
        move.w  (sp)+,d4
**** Original Line:          ld       (ix+0),255
        __ADDR  5
        move.b  #255,0(a5)
**** Original Line:          ld       (ix+16),195
        ;__ADDR 5
        move.b  #195,16(a5)
**** Original Line:          ld       (ix+32),195
        ;__ADDR 5
        move.b  #195,32(a5)
**** Original Line:          ld       (ix+48),255
        ;__ADDR 5
        move.b  #255,48(a5)
**** Original Line:          jr       ok
        bra     RA_ok
        dc.b    32
**** Original Line:   ; ------------------------ DATA -------------------------
**** Original Line: bounces: .db      -3,-3
        __LABEL bounces
        dc.b    -3
        dc.b    -3
**** Original Line:          .db      -2,-2,-2,-2,-2,-2
        dc.b    -2
        dc.b    -2
        dc.b    -2
        dc.b    -2
        dc.b    -2
        dc.b    -2
**** Original Line:          .db      -1,-1,-1,-1,-1,-1
        dc.b    -1
        dc.b    -1
        dc.b    -1
        dc.b    -1
        dc.b    -1
        dc.b    -1
**** Original Line:          .db      0,0,0,0
        dc.b    0
        dc.b    0
        dc.b    0
        dc.b    0
**** Original Line:          .db      1,1,1,1,1,1
        dc.b    1
        dc.b    1
        dc.b    1
        dc.b    1
        dc.b    1
        dc.b    1
**** Original Line:          .db      2,2,2,2,2,2
        dc.b    2
        dc.b    2
        dc.b    2
        dc.b    2
        dc.b    2
        dc.b    2
**** Original Line:          .db      3,3
        dc.b    3
        dc.b    3
**** Original Line: initial_msg: 
        __LABEL initial_msg
**** Original Line:          .db      "L U N O I D     V I I",0
        dc.b    "L U N O I D     V I I"
        dc.b    0
**** Original Line:          .db      "by Patrick A Davidson"
        dc.b    "by Patrick A Davidson"
**** Original Line:          .db      "  (ariwsi@juno.com)  ",0
        dc.b    "  (ariwsi@juno.com)  "
        dc.b    0
**** Original Line:          .db      "Choose Speed : F1-F5"
        dc.b    "Choose Speed : F1-F5"
**** Original Line:          .db      0
        dc.b    0
**** Original Line: scrltext:.db      "                 "
        __LABEL scrltext
        dc.b    "                 "
**** Original Line:          .db      "WELCOME TO LUNOID 7!     "
        dc.b    "WELCOME TO LUNOID 7!     "
**** Original Line:          .db      "PRESS A FUNCTION KEY "
        dc.b    "PRESS A FUNCTION KEY "
**** Original Line:          .db      "TO SELECT THE SPEED AND "
        dc.b    "TO SELECT THE SPEED AND "
**** Original Line:          .db      "BEGIN THE GAME!  F1 IS THE "
        dc.b    "BEGIN THE GAME!  F1 IS THE "
**** Original Line:          .db      "SLOWEST AND F5 THE FASTEST.  "
        dc.b    "SLOWEST AND F5 THE FASTEST.  "
**** Original Line:          .db      "IF YOU JUST WANT TO LOOK AT "
        dc.b    "IF YOU JUST WANT TO LOOK AT "
**** Original Line:          .db      "THE HIGHSCORES, PRESS ALPHA.  "
        dc.b    "THE HIGHSCORES, PRESS ALPHA.  "
**** Original Line:          .db      "WHEN PLAYING, MOVE AROUND "
        dc.b    "WHEN PLAYING, MOVE AROUND "
**** Original Line:          .db      "WITH THE LEFT AND RIGHT "
        dc.b    "WITH THE LEFT AND RIGHT "
**** Original Line:          .db      "ARROWS.  TO MOVE MORE SLOWLY, "
        dc.b    "ARROWS.  TO MOVE MORE SLOWLY, "
**** Original Line:          .db      "HOLD DOWN THE UP ARROW AT THE "
        dc.b    "HOLD DOWN THE UP ARROW AT THE "
**** Original Line:          .db      "SAME TIME.  TO EXIT AND SAVE "
        dc.b    "SAME TIME.  TO EXIT AND SAVE "
**** Original Line:          .db      "THE GAME, PRESS THE DOWN "
        dc.b    "THE GAME, PRESS THE DOWN "
**** Original Line:          .db      "ARROW.  THIS GAME WAS FINISHED "
        dc.b    "ARROW.  THIS GAME WAS FINISHED "
**** Original Line:          .db      "ON 20-MAY-1997.  THE "
        dc.b    "ON 20-MAY-1997.  THE "
**** Original Line:          .db      "SOURCE CODE "
        dc.b    "SOURCE CODE "
**** Original Line:          .db      "IS 1,248 LINES LONG!  "
        dc.b    "IS 1,248 LINES LONG!  "
**** Original Line:          .db      "TEXT RESTARTS....."
        dc.b    "TEXT RESTARTS....."
**** Original Line: scrl_end:.db      "                 "
        __LABEL scrl_end
        dc.b    "                 "
**** Original Line: end_msg: .db      " -> Final Scoring <- "
        __LABEL end_msg
        dc.b    " -> Final Scoring <- "
**** Original Line:          .db      "Levels finished:    0"
        dc.b    "Levels finished:    0"
**** Original Line:          .db      "     Bricks hit:    0"
        dc.b    "     Bricks hit:    0"
**** Original Line:          .db      "    Speed bonus:    0"
        dc.b    "    Speed bonus:    0"
**** Original Line:          .db      "  Victory bonus:    0"
        dc.b    "  Victory bonus:    0"
**** Original Line:          .db      "Lives remaining:    0"
        dc.b    "Lives remaining:    0"
**** Original Line:          .db      "*** TOTAL SCORE:    0"
        dc.b    "*** TOTAL SCORE:    0"
**** Original Line:          .db      " ---> Lunoid VI <---",0
        dc.b    " ---> Lunoid VI <---"
        dc.b    0
**** Original Line: approaching:
        __LABEL approaching
**** Original Line:          .db      "---> NEXT LEVEL:"
        dc.b    "---> NEXT LEVEL:"
**** Original Line:          .db      0
        dc.b    0
**** Original Line: press:   .db      "PRESS ANY KEY TO PLAY"
        __LABEL press
        dc.b    "PRESS ANY KEY TO PLAY"
**** Original Line:          .db      "LIVES REMAINING:"
        dc.b    "LIVES REMAINING:"
**** Original Line:  ; -------------------- SAVED GAME DATA -----------------------
**** Original Line: saved_flag:
        __LABEL saved_flag
**** Original Line:          .db      0
        dc.b    0
**** Original Line: saved_game:
        __LABEL saved_game
**** Original Line:          .dw      0,0,0,0,0,0,0,0,0,0,0,0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
**** Original Line:          .dw      0,0,0,0,0,0,0,0,0,0,0,0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
**** Original Line:          .dw      0,0,0,0,0,0,0,0,0,0,0,0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
**** Original Line:          .dw      0,0,0,0,0,0,0,0,0,0,0,0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
**** Original Line:          .dw      0,0,0,0,0,0,0,0,0,0,0,0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
**** Original Line:          .dw      0,0,0,0,0,0,0,0,0,0,0,0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
**** Original Line:          .dw      0,0,0,0,0,0,0,0,0,0,0,0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
        __DW    0
**** Original Line:  ; -------------------- UNIVERSE DATA -------------------------
**** Original Line: universe_ttl:
        __LABEL universe_ttl
**** Original Line:          .db      "CHOOSE YOUR UNIVERSE:",0
        dc.b    "CHOOSE YOUR UNIVERSE:"
        dc.b    0
**** Original Line:          .DB      "F1) The Sandbox      "
        dc.b    "F1) The Sandbox      "
**** Original Line:          .db      "F2) Classic Universe "
        dc.b    "F2) Classic Universe "
**** Original Line:          .db      "F3) The Dark Realm   "
        dc.b    "F3) The Dark Realm   "
**** Original Line:          .db      "F4) Castle of Death  "
        dc.b    "F4) Castle of Death  "
**** Original Line:          .db      "F5) Ultimate Universe",0
        dc.b    "F5) Ultimate Universe"
        dc.b    0
**** Original Line: universe_list:
        __LABEL universe_list
**** Original Line:          .dw      sandbox-32
        __DW    sandbox-32
**** Original Line:          .dw      classic_universe-32
        __DW    classic_universe-32
**** Original Line:          .dw      dark_realm-32
        __DW    dark_realm-32
**** Original Line:          .dw      castle_death-32
        __DW    castle_death-32
**** Original Line:          .dw      ultimate-32
        __DW    ultimate-32
**** Original Line: classic_universe:
        __LABEL classic_universe
**** Original Line:          .db      %11111100,%00000000,%00000000,%00111111
        dc.b    %11111100
        dc.b    %00000000
        dc.b    %00000000
        dc.b    %00111111
**** Original Line:          .db      %11110000,%00000000,%00000000,%00001111
        dc.b    %11110000
        dc.b    %00000000
        dc.b    %00000000
        dc.b    %00001111
**** Original Line:          .db      %11000000,%00000000,%00000000,%00000011
        dc.b    %11000000
        dc.b    %00000000
        dc.b    %00000000
        dc.b    %00000011
**** Original Line:          .db      %00000000,%00000000,%00000000,%00000000
        dc.b    %00000000
        dc.b    %00000000
        dc.b    %00000000
        dc.b    %00000000
**** Original Line:          .db      %00000000,%10101010,%10101010,%00000000
        dc.b    %00000000
        dc.b    %10101010
        dc.b    %10101010
        dc.b    %00000000
**** Original Line:          .db      %00000000,%01010101,%01010101,%00000000
        dc.b    %00000000
        dc.b    %01010101
        dc.b    %01010101
        dc.b    %00000000
**** Original Line:          .db      %00000000,%00000000,%00000000,%00000000
        dc.b    %00000000
        dc.b    %00000000
        dc.b    %00000000
        dc.b    %00000000
**** Original Line:          .db      %00000000,%00000000,%00000000,%00000000
        dc.b    %00000000
        dc.b    %00000000
        dc.b    %00000000
        dc.b    %00000000
**** Original Line:          .db      %11000000,%00000000,%00000000,%00000011
        dc.b    %11000000
        dc.b    %00000000
        dc.b    %00000000
        dc.b    %00000011
**** Original Line:          .db      %11010101,%01010101,%01010101,%01010111
        dc.b    %11010101
        dc.b    %01010101
        dc.b    %01010101
        dc.b    %01010111
**** Original Line:          .db      %11000000,%00000000,%00000000,%00000011
        dc.b    %11000000
        dc.b    %00000000
        dc.b    %00000000
        dc.b    %00000011
**** Original Line:          .db      %11010101,%01010101,%01010101,%01010111
        dc.b    %11010101
        dc.b    %01010101
        dc.b    %01010101
        dc.b    %01010111
**** Original Line:          .db      %11000000,%00000000,%00000000,%00000011
        dc.b    %11000000
        dc.b    %00000000
        dc.b    %00000000
        dc.b    %00000011
**** Original Line:          .db      %11010101,%01010101,%01010101,%01010111
        dc.b    %11010101
        dc.b    %01010101
        dc.b    %01010101
        dc.b    %01010111
**** Original Line:          .db      %11000000,%00000000,%00000000,%00000011
        dc.b    %11000000
        dc.b    %00000000
        dc.b    %00000000
        dc.b    %00000011
**** Original Line:          .db      %11000000,%00000000,%00000000,%00000011
        dc.b    %11000000
        dc.b    %00000000
        dc.b    %00000000
        dc.b    %00000011
**** Original Line:          .db      %00000000,%10100000,%00101010,%10000000
        dc.b    %00000000
        dc.b    %10100000
        dc.b    %00101010
        dc.b    %10000000
**** Original Line:          .db      %00000010,%00001000,%00100000,%00000000
        dc.b    %00000010
        dc.b    %00001000
        dc.b    %00100000
        dc.b    %00000000
**** Original Line:          .db      %00000010,%00001000,%00100000,%00000000
        dc.b    %00000010
        dc.b    %00001000
        dc.b    %00100000
        dc.b    %00000000
**** Original Line:          .db      %00000000,%10100000,%00101010,%10000000
        dc.b    %00000000
        dc.b    %10100000
        dc.b    %00101010
        dc.b    %10000000
**** Original Line:          .db      %00000010,%00001000,%00000000,%10000000
        dc.b    %00000010
        dc.b    %00001000
        dc.b    %00000000
        dc.b    %10000000
**** Original Line:          .db      %00000010,%00001000,%00100000,%10000000
        dc.b    %00000010
        dc.b    %00001000
        dc.b    %00100000
        dc.b    %10000000
**** Original Line:          .db      %00000000,%10100000,%00001010,%10000000
        dc.b    %00000000
        dc.b    %10100000
        dc.b    %00001010
        dc.b    %10000000
**** Original Line:          .db      %00001111,%11111111,%11111111,%11110000
        dc.b    %00001111
        dc.b    %11111111
        dc.b    %11111111
        dc.b    %11110000
**** Original Line:          .db      %00000000,%00000000,%00000000,%00000000
        dc.b    %00000000
        dc.b    %00000000
        dc.b    %00000000
        dc.b    %00000000
**** Original Line:          .db      %00111111,%11111111,%11111111,%11111100
        dc.b    %00111111
        dc.b    %11111111
        dc.b    %11111111
        dc.b    %11111100
**** Original Line:          .db      %00101010,%10001010,%10100010,%10100000
        dc.b    %00101010
        dc.b    %10001010
        dc.b    %10100010
        dc.b    %10100000
**** Original Line:          .db      %00100000,%10001000,%00100010,%00001000
        dc.b    %00100000
        dc.b    %10001000
        dc.b    %00100010
        dc.b    %00001000
**** Original Line:          .db      %00101010,%10001010,%10100010,%00001000
        dc.b    %00101010
        dc.b    %10001010
        dc.b    %10100010
        dc.b    %00001000
**** Original Line:          .db      %00100000,%00001000,%00100010,%00001000
        dc.b    %00100000
        dc.b    %00001000
        dc.b    %00100010
        dc.b    %00001000
**** Original Line:          .db      %00100000,%00001000,%00100010,%10100000
        dc.b    %00100000
        dc.b    %00001000
        dc.b    %00100010
        dc.b    %10100000
**** Original Line:          .db      %00111111,%11111111,%11111111,%11111100
        dc.b    %00111111
        dc.b    %11111111
        dc.b    %11111111
        dc.b    %11111100
**** Original Line:          .db      255
        dc.b    255
**** Original Line: dark_realm:
        __LABEL dark_realm
**** Original Line:          .db      %01000100,%01000100,%01000100,%01000100
        dc.b    %01000100
        dc.b    %01000100
        dc.b    %01000100
        dc.b    %01000100
**** Original Line:          .db      %00010001,%00010001,%00010001,%00010001
        dc.b    %00010001
        dc.b    %00010001
        dc.b    %00010001
        dc.b    %00010001
**** Original Line:          .db      %01000100,%01000100,%01000100,%01000100
        dc.b    %01000100
        dc.b    %01000100
        dc.b    %01000100
        dc.b    %01000100
**** Original Line:          .db      %00010001,%00010001,%00010001,%00010001
        dc.b    %00010001
        dc.b    %00010001
        dc.b    %00010001
        dc.b    %00010001
**** Original Line:          .db      %01000100,%01000100,%01000100,%01000100
        dc.b    %01000100
        dc.b    %01000100
        dc.b    %01000100
        dc.b    %01000100
**** Original Line:          .db      %00010001,%00010001,%00010001,%00010001
        dc.b    %00010001
        dc.b    %00010001
        dc.b    %00010001
        dc.b    %00010001
**** Original Line:          .db      %00000000,%00000000,%00000000,%00000000
        dc.b    %00000000
        dc.b    %00000000
        dc.b    %00000000
        dc.b    %00000000
**** Original Line:          .db      %11111100,%00000000,%00000000,%00111111
        dc.b    %11111100
        dc.b    %00000000
        dc.b    %00000000
        dc.b    %00111111
**** Original Line:          .db      %00000000,%00000000,%00000000,%00000000
        dc.b    %00000000
        dc.b    %00000000
        dc.b    %00000000
        dc.b    %00000000
**** Original Line:          .db      %00000001,%01010101,%01010101,%01010101
        dc.b    %00000001
        dc.b    %01010101
        dc.b    %01010101
        dc.b    %01010101
**** Original Line:          .db      %00000000,%00000000,%00000000,%00000000
        dc.b    %00000000
        dc.b    %00000000
        dc.b    %00000000
        dc.b    %00000000
**** Original Line:          .db      %00000011,%11111111,%11111111,%11111111
        dc.b    %00000011
        dc.b    %11111111
        dc.b    %11111111
        dc.b    %11111111
**** Original Line:          .db      %00000000,%00000000,%00000000,%00000000
        dc.b    %00000000
        dc.b    %00000000
        dc.b    %00000000
        dc.b    %00000000
**** Original Line:          .db      %01010101,%01010101,%01010101,%01000000
        dc.b    %01010101
        dc.b    %01010101
        dc.b    %01010101
        dc.b    %01000000
**** Original Line:          .db      %00000000,%00000000,%00000000,%00000000
        dc.b    %00000000
        dc.b    %00000000
        dc.b    %00000000
        dc.b    %00000000
**** Original Line:          .db      %11111111,%11111111,%11111111,%11000000
        dc.b    %11111111
        dc.b    %11111111
        dc.b    %11111111
        dc.b    %11000000
**** Original Line:          .db      255
        dc.b    255
**** Original Line: sandbox: .db      %01010101,%01010101,%01010101,%01010101
        __LABEL sandbox
        dc.b    %01010101
        dc.b    %01010101
        dc.b    %01010101
        dc.b    %01010101
**** Original Line:          .db      %01000000,%00000000,%00000000,%00000001
        dc.b    %01000000
        dc.b    %00000000
        dc.b    %00000000
        dc.b    %00000001
**** Original Line:          .db      %01000101,%01010101,%01010101,%01010001
        dc.b    %01000101
        dc.b    %01010101
        dc.b    %01010101
        dc.b    %01010001
**** Original Line:          .db      %01000100,%00000000,%00000000,%00010001
        dc.b    %01000100
        dc.b    %00000000
        dc.b    %00000000
        dc.b    %00010001
**** Original Line:          .db      %01000100,%00000000,%00000000,%00010001
        dc.b    %01000100
        dc.b    %00000000
        dc.b    %00000000
        dc.b    %00010001
**** Original Line:          .db      %01000101,%01010101,%01010101,%01010001
        dc.b    %01000101
        dc.b    %01010101
        dc.b    %01010101
        dc.b    %01010001
**** Original Line:          .db      %01000000,%00000000,%00000000,%00000001
        dc.b    %01000000
        dc.b    %00000000
        dc.b    %00000000
        dc.b    %00000001
**** Original Line:          .db      %01010101,%01010101,%01010101,%01010101
        dc.b    %01010101
        dc.b    %01010101
        dc.b    %01010101
        dc.b    %01010101
**** Original Line:          .DB      %00000010,%10000010,%10000010,%10000000
        dc.b    %00000010
        dc.b    %10000010
        dc.b    %10000010
        dc.b    %10000000
**** Original Line:          .db      %00000000,%00000000,%00000000,%00000000
        dc.b    %00000000
        dc.b    %00000000
        dc.b    %00000000
        dc.b    %00000000
**** Original Line:          .DB      %00000010,%10000010,%10000010,%10000000
        dc.b    %00000010
        dc.b    %10000010
        dc.b    %10000010
        dc.b    %10000000
**** Original Line:          .db      %00000000,%00000000,%00000000,%00000000
        dc.b    %00000000
        dc.b    %00000000
        dc.b    %00000000
        dc.b    %00000000
**** Original Line:          .DB      %00000010,%10000010,%10000010,%10000000
        dc.b    %00000010
        dc.b    %10000010
        dc.b    %10000010
        dc.b    %10000000
**** Original Line:          .db      %00000000,%00000000,%00000000,%00000000
        dc.b    %00000000
        dc.b    %00000000
        dc.b    %00000000
        dc.b    %00000000
**** Original Line:          .DB      %00000010,%10000010,%10000010,%10000000
        dc.b    %00000010
        dc.b    %10000010
        dc.b    %10000010
        dc.b    %10000000
**** Original Line:          .db      %00000000,%00000000,%00000000,%00000000
        dc.b    %00000000
        dc.b    %00000000
        dc.b    %00000000
        dc.b    %00000000
**** Original Line:          .db      255
        dc.b    255
**** Original Line: castle_death:
        __LABEL castle_death
**** Original Line:          .db      %10101000,%00000000,%00000000,%00101010
        dc.b    %10101000
        dc.b    %00000000
        dc.b    %00000000
        dc.b    %00101010
**** Original Line:          .db      %10101000,%00000000,%00000000,%00101010
        dc.b    %10101000
        dc.b    %00000000
        dc.b    %00000000
        dc.b    %00101010
**** Original Line:          .db      %10101000,%00000000,%00000000,%00101010
        dc.b    %10101000
        dc.b    %00000000
        dc.b    %00000000
        dc.b    %00101010
**** Original Line:          .db      %10101000,%00000000,%00000000,%00101010
        dc.b    %10101000
        dc.b    %00000000
        dc.b    %00000000
        dc.b    %00101010
**** Original Line:          .db      %10101000,%00000000,%00000000,%00101010
        dc.b    %10101000
        dc.b    %00000000
        dc.b    %00000000
        dc.b    %00101010
**** Original Line:          .db      %10101000,%00000000,%00000000,%00101010
        dc.b    %10101000
        dc.b    %00000000
        dc.b    %00000000
        dc.b    %00101010
**** Original Line:          .db      %10101000,%00000000,%00000000,%00101010
        dc.b    %10101000
        dc.b    %00000000
        dc.b    %00000000
        dc.b    %00101010
**** Original Line:          .db      %11111111,%11110000,%00001111,%11111111
        dc.b    %11111111
        dc.b    %11110000
        dc.b    %00001111
        dc.b    %11111111
**** Original Line:          .db      %10001000,%10001000,%10001000,%10001000
        dc.b    %10001000
        dc.b    %10001000
        dc.b    %10001000
        dc.b    %10001000
**** Original Line:          .db      %00100010,%00100010,%00100010,%00100010
        dc.b    %00100010
        dc.b    %00100010
        dc.b    %00100010
        dc.b    %00100010
**** Original Line:          .db      %10001000,%10001000,%10001000,%10001000
        dc.b    %10001000
        dc.b    %10001000
        dc.b    %10001000
        dc.b    %10001000
**** Original Line:          .db      %00100010,%00100010,%00100010,%00100010
        dc.b    %00100010
        dc.b    %00100010
        dc.b    %00100010
        dc.b    %00100010
**** Original Line:          .db      %10001000,%10001000,%10001000,%10001000
        dc.b    %10001000
        dc.b    %10001000
        dc.b    %10001000
        dc.b    %10001000
**** Original Line:          .db      %00100010,%00100010,%00100010,%00100010
        dc.b    %00100010
        dc.b    %00100010
        dc.b    %00100010
        dc.b    %00100010
**** Original Line:          .db      %10001000,%10001000,%10001000,%10001000
        dc.b    %10001000
        dc.b    %10001000
        dc.b    %10001000
        dc.b    %10001000
**** Original Line:          .db      %00100010,%00100010,%00100010,%00100010
        dc.b    %00100010
        dc.b    %00100010
        dc.b    %00100010
        dc.b    %00100010
**** Original Line:          .db      255
        dc.b    255
**** Original Line: ultimate:.db      %10101010,%10101010,%10101010,%10101010
        __LABEL ultimate
        dc.b    %10101010
        dc.b    %10101010
        dc.b    %10101010
        dc.b    %10101010
**** Original Line:          .db      %10101010,%10101010,%10101010,%10101010
        dc.b    %10101010
        dc.b    %10101010
        dc.b    %10101010
        dc.b    %10101010
**** Original Line:          .db      %10101010,%10101010,%10101010,%10101010
        dc.b    %10101010
        dc.b    %10101010
        dc.b    %10101010
        dc.b    %10101010
**** Original Line:          .db      %10101010,%10101010,%10101010,%10101010
        dc.b    %10101010
        dc.b    %10101010
        dc.b    %10101010
        dc.b    %10101010
**** Original Line:          .db      %10101010,%10101010,%10101010,%10101010
        dc.b    %10101010
        dc.b    %10101010
        dc.b    %10101010
        dc.b    %10101010
**** Original Line:          .db      %10101010,%10101010,%10101010,%10101010
        dc.b    %10101010
        dc.b    %10101010
        dc.b    %10101010
        dc.b    %10101010
**** Original Line:          .db      %00000000,%00000000,%00000000,%00000000
        dc.b    %00000000
        dc.b    %00000000
        dc.b    %00000000
        dc.b    %00000000
**** Original Line:          .DB      %11111100,%00111111,%11111100,%00111111
        dc.b    %11111100
        dc.b    %00111111
        dc.b    %11111100
        dc.b    %00111111
**** Original Line:          .db      %10101010,%10101010,%10101010,%10101010
        dc.b    %10101010
        dc.b    %10101010
        dc.b    %10101010
        dc.b    %10101010
**** Original Line:          .db      %10111111,%11111111,%11111111,%11111110
        dc.b    %10111111
        dc.b    %11111111
        dc.b    %11111111
        dc.b    %11111110
**** Original Line:          .db      %10101010,%10101010,%10101010,%10101010
        dc.b    %10101010
        dc.b    %10101010
        dc.b    %10101010
        dc.b    %10101010
**** Original Line:          .db      %10111111,%11111111,%11111111,%11111110
        dc.b    %10111111
        dc.b    %11111111
        dc.b    %11111111
        dc.b    %11111110
**** Original Line:          .db      %10101010,%10101010,%10101010,%10101010
        dc.b    %10101010
        dc.b    %10101010
        dc.b    %10101010
        dc.b    %10101010
**** Original Line:          .db      %10111111,%11111111,%11111111,%11111110
        dc.b    %10111111
        dc.b    %11111111
        dc.b    %11111111
        dc.b    %11111110
**** Original Line:          .db      %10101010,%10101010,%10101010,%10101010
        dc.b    %10101010
        dc.b    %10101010
        dc.b    %10101010
        dc.b    %10101010
**** Original Line:          .db      %10111111,%11111111,%11111111,%11111110
        dc.b    %10111111
        dc.b    %11111111
        dc.b    %11111111
        dc.b    %11111110
**** Original Line:          .db      255
        dc.b    255
**** Original Line:  ; ---------------------- HIGH SCORES -------------------------
**** Original Line: hi_score_str:
        __LABEL hi_score_str
**** Original Line:          .db      "----> LUNOID  7 <----"
        dc.b    "----> LUNOID  7 <----"
**** Original Line:          .db      " You have  a hiscore!"
        dc.b    " You have  a hiscore!"
**** Original Line:          .db      "Enter your name:     ",0
        dc.b    "Enter your name:     "
        dc.b    0
**** Original Line: hstitle: .db      "=LUNOID 7 HIGHSCORES=",0
        __LABEL hstitle
        dc.b    "=LUNOID 7 HIGHSCORES="
        dc.b    0
**** Original Line: hsdata:  .dw      666
        __LABEL hsdata
        __DW    666
**** Original Line:          .db      "Bill Gates      ",0
        dc.b    "Bill Gates      "
        dc.b    0
**** Original Line:          .dw      666
        __DW    666
**** Original Line:          .db      "Bill Gates      ",0
        dc.b    "Bill Gates      "
        dc.b    0
**** Original Line:          .dw      666
        __DW    666
**** Original Line:          .db      "Bill Gates      ",0
        dc.b    "Bill Gates      "
        dc.b    0
**** Original Line:          .dw      666
        __DW    666
**** Original Line:          .db      "Bill Gates      ",0
        dc.b    "Bill Gates      "
        dc.b    0
**** Original Line:          .dw      666
        __DW    666
**** Original Line:          .db      "Bill Gates      ",0
        dc.b    "Bill Gates      "
        dc.b    0
**** Original Line:          .dw      666
        __DW    666
**** Original Line:          .db      "Bill Gates      ",0
        dc.b    "Bill Gates      "
        dc.b    0
**** Original Line: lowest   .dw      666
        __LABEL lowest
        __DW    666
**** Original Line:          .db      "Bill Gates      ",0
        dc.b    "Bill Gates      "
        dc.b    0
**** Original Line: chartable:
        __LABEL chartable
**** Original Line:          .db      "..........XTOJE."
        dc.b    "..........XTOJE."
**** Original Line:          .db      ". WSNID!.ZVRMHC?"
        dc.b    ". WSNID!.ZVRMHC?"
**** Original Line:          .db      ".YUQLGB#x~+PKFA|"
        dc.b    ".YUQLGB#x~+PKFA|"
**** Original Line:          .db      "@54321.~+......."
        dc.b    "@54321.~+......."
**** Original Line:  ; -------------- SRPITE DRAWING ROUTINE--------------
**** Original Line: drw_spr: ld       e,128             ;FindPixel NO MORE !!!!!!!!!!!!!!!
        __LABEL drw_spr
        move.b  #128,d3
**** Original Line:          push     bc
        move.w  d2,-(sp)
**** Original Line:          ld       a,b
        move.w  d2,(a1)
        move.b  (a1),d7
**** Original Line:          and      7                 ;Calculate bit number
        and.b   #7,d7
        move.w  sr,(a0)
**** Original Line:          jr       z,done
        beq   RA_done
**** Original Line:          ld       b,a
        move.w  d2,(a1)
        move.b  d7,(a1)
        move.w  (a1),d2
**** Original Line: bit_loop:srl      e
        __LABEL bit_loop
        lsr.b   #1,d3
**** Original Line:          djnz     bit_loop
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_bit_loop
**** Original Line: done:    pop      bc
        __LABEL done
        move.w  (sp)+,d2
**** Original Line:          ld       a,e
        move.b  d3,d7
**** Original Line:          ld       (sprtemp),a
        move.b  d7,sprtemp-$10000(a0)
**** Original Line:          ld       hl,$8641          ;Calculate byte number
        move.w  #$8641+0,d4
**** Original Line:          srl      b
        move.w  d2,(a1)
        move.b  (a1),d1
        lsr.b   #1,d1
        move.b  d1,(a1)
        move.w  (a1),d2
**** Original Line:          srl      b
        move.w  d2,(a1)
        move.b  (a1),d1
        lsr.b   #1,d1
        move.b  d1,(a1)
        move.w  (a1),d2
**** Original Line:          srl      b
        move.w  d2,(a1)
        move.b  (a1),d1
        lsr.b   #1,d1
        move.b  d1,(a1)
        move.w  (a1),d2
**** Original Line:          ld       a,b               ;A = x shift right (bytes)
        move.w  d2,(a1)
        move.b  (a1),d7
**** Original Line:          sla      c                 
        add.b   d2,d2
**** Original Line:          sla      c
        add.b   d2,d2
**** Original Line:          ld       b,c               
        move.w  d2,(a1)
        move.b  d2,(a1)
        move.w  (a1),d2
**** Original Line:          sla      c
        add.b   d2,d2
**** Original Line:          sla      c                 ;C = 8 LSBs of Y offset              
        add.b   d2,d2
**** Original Line:          or       c                 ;A = 8 LSBs of offset
        or.b   d2,d7
**** Original Line:          ld       c,a               ;C = 8 LSBs of offset
        move.b  d7,d2
**** Original Line:          ld       a,b
        move.w  d2,(a1)
        move.b  (a1),d7
**** Original Line:          rlca
        rol.b   #1,d7
**** Original Line:          rlca
        rol.b   #1,d7
**** Original Line:          and      3
        and.b   #3,d7
**** Original Line:          ld       b,a               ;B = 2 MSBs of offset
        move.w  d2,(a1)
        move.b  d7,(a1)
        move.w  (a1),d2
**** Original Line:          add      hl,bc             ;HL = address
        add.w   d2,d4
**** Original Line:          ld       d,(ix)            ;C is width
        __ADDR  5
        move.b  (a5),d1
        asl.w   #8,d1
        and.w   #$ff,d3
        or.w    d1,d3
**** Original Line:          inc      ix
        addq.w  #1,d5
**** Original Line:          ld       b,(ix)            ;C is height
        __ADDR  5
        move.b  (a5),d1
        asl.w   #8,d1
        and.w   #$ff,d2
        or.w    d1,d2
**** Original Line:          inc      ix
        addq.w  #1,d5
**** Original Line: oloop:   push     bc                ;Save # of rows
        __LABEL oloop
        move.w  d2,-(sp)
**** Original Line:          push     hl                ;Save screen address
        move.w  d4,-(sp)
**** Original Line:          ld       b,d               ;Load width
        move.w  d3,d1
        and.w   #$ff00,d1
        and.w   #$ff,d2
        or.w    d1,d2
**** Original Line:          ld       c,(ix)            ;Load one line of image
        __ADDR  5
        move.b  (a5),d2
**** Original Line:          inc      ix
        addq.w  #1,d5
**** Original Line:          ld       a,(sprtemp)       ;Load pixel mask
        move.b  sprtemp-$10000(a0),d7
**** Original Line: iloop:   bit      7,c               ;Test leftmost pixel
        __LABEL iloop
        btst    #7,d2
        move.w  sr,(a0)
**** Original Line:          jr       z,noplot          ;See if a plot is needed
        move.b  (a0),ccr
        beq   RA_noplot
**** Original Line:          ld       e,a               ;OR pixel with screen
        move.b  d7,d3
**** Original Line:          or       (hl)
        __ADDR  4
        or.b   (a4),d7
**** Original Line:          ld       (hl),a
        ;__ADDR 4
        move.b  d7,(a4)
**** Original Line:          ld       a,e
        move.b  d3,d7
**** Original Line: noplot:  sla      c
        __LABEL noplot
        add.b   d2,d2
**** Original Line:          rrca
        ror.b   #1,d7
        move.w  sr,(a0)
**** Original Line:          jr       nc,notedge        ;Test if edge of byte reached
        move.b  (a0),ccr
        bcc   RA_notedge
**** Original Line:          inc      hl                ;Go to next byte
        addq.w  #1,d4
**** Original Line: notedge: djnz     iloop
        __LABEL notedge
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_iloop
**** Original Line:          pop      hl                ;Restore address
        move.w  (sp)+,d4
**** Original Line:          ld       bc,16             ;Go to next line
        move.w  #16+0,d2
**** Original Line:          add      hl,bc
        add.w   d2,d4
**** Original Line:          pop      bc                ;Restore data
        move.w  (sp)+,d2
**** Original Line:          djnz     oloop
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_oloop
**** Original Line:          ret
        __RTS
        dc.b    32
**** Original Line:  ; -------------- SPRITE FOR PADDLE ------------------
**** Original Line: leftp:   .db      8,4
        __LABEL leftp
        dc.b    8
        dc.b    4
**** Original Line:          .db      %01111111
        dc.b    %01111111
**** Original Line:          .db      %10000000
        dc.b    %10000000
**** Original Line:          .db      %10000000
        dc.b    %10000000
**** Original Line:          .db      %01111111
        dc.b    %01111111
**** Original Line: rightp:  .db      8,4
        __LABEL rightp
        dc.b    8
        dc.b    4
**** Original Line:          .db      %11111110
        dc.b    %11111110
**** Original Line:          .db      %00000001
        dc.b    %00000001
**** Original Line:          .db      %00000001
        dc.b    %00000001
**** Original Line:          .db      %11111110
        dc.b    %11111110
**** Original Line: spr_ball:.db      3,3
        __LABEL spr_ball
        dc.b    3
        dc.b    3
**** Original Line:          .db      %01000000
        dc.b    %01000000
**** Original Line:          .db      %11100000
        dc.b    %11100000
**** Original Line:          .db      %01000000
        dc.b    %01000000
**** Original Line:  ; -------------- FIND A LEVEL ------------------------
**** Original Line: level_addr:
        __LABEL level_addr
**** Original Line:          ld       a,(uchoice)
        move.b  uchoice-$10000(a0),d7
**** Original Line:          ld       e,a
        move.b  d7,d3
**** Original Line:          ld       d,0
        and.w   #$ff,d3
**** Original Line:          ld       hl,universe_list
        move.w  #universe_list+0,d4
**** Original Line:          add      hl,de
        add.w   d3,d4
**** Original Line:          ld       de,(PROGRAM_ADDR)
        move.b  1+PROGRAM_ADDR-$10000(a0),d3
        asl.w   #8,d3
        move.b  PROGRAM_ADDR-$10000(a0),d3
**** Original Line:          add      hl,de
        add.w   d3,d4
**** Original Line:          call     LD_HL_MHL
        jsr     ti85lib3@000A
**** Original Line:          ld       a,(level)
        move.b  level-$10000(a0),d7
**** Original Line:          ld       b,a
        move.w  d2,(a1)
        move.b  d7,(a1)
        move.w  (a1),d2
**** Original Line:          inc      b
        add.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        move.w  sr,(a0)
**** Original Line:          ld       de,(PROGRAM_ADDR)
        move.b  1+PROGRAM_ADDR-$10000(a0),d3
        asl.w   #8,d3
        move.b  PROGRAM_ADDR-$10000(a0),d3
**** Original Line:          add      hl,de
        add.w   d3,d4
**** Original Line:          ld       de,32
        move.w  #32+0,d3
**** Original Line: find_level_loop:
        __LABEL find_level_loop
**** Original Line:          add      hl,de
        add.w   d3,d4
**** Original Line:          djnz     find_level_loop
        sub.w   #$100,d2
        move.w  d2,d1
        and.w   #$ff00,d1
        bne     RA_find_level_loop
**** Original Line:          ret
        __RTS
**** Original Line:          .end
        EVEN
___byebye:
        jsr     ti85lib3@0012
program_end:
        SECTION bss,BSS
buffer: ds.b    $8100
        END
