/* OTHELLO/REVERSI V1.1 (C) 1999 by Zeljko Juric     */
/* Compiled using TI-GCC C-compiler by Xavier Vassor */

int _ti92plus;                          /* Produce 9xz file */
int _nostub;                            /* Don't use DoorsOS kernel */

void _nostub_loader() { _main(); }      /* Necessary for "nostub" mode */

/* My "pretty" macro for calling ROM routines in "nostub" mode */

#define _rom_call(type,addr) ((type(*)())(*((long*)(*((long*)0xc8)+addr*4))))

/* Declaration of some ROM calls used in the program */

#define DrawStr(x,y,s,c) \
        _rom_call(void,0x1a9)((int)(x),(int)(y),(char*)(s),(int)(c))
#define MoveTo(x,y) \
       _rom_call(void,0x19d)((int)(x),(int)(y))
#define LineTo(x,y) \
       _rom_call(void,0x19c)((int)(x),(int)(y))
#define SetCurClip(p) \
        _rom_call(void,0x19b)((long*)(p))
#define FontSetSys(x) \
        _rom_call(int,0x18f)((int)(x))
#define ClrScr \
        _rom_call(void,0x19e)
#define getch \
        _rom_call(int,0x51)
#define sprintf \
        _rom_call(int,0x53)

/* Definition of key codes */

#define ESC_KEY 264
#define ENTER_KEY 13

/* Type definitions */

typedef enum {FALSE,TRUE,ESC_FLAG} BOOL;
typedef enum {COMPUTER,HUMAN,BLANK_NEAR,BLANK_FAR} FIGURE;
typedef FIGURE BOARD[10][10];
typedef struct {unsigned char x1,y1,x2,y2;} SCR_RECT;

/* Forward declarations */

void fast_memcpy(void*,void*,int);
void draw_figure(int,int,FIGURE);
void display_board(BOARD);
void Line(int,int,int,int);
BOOL input_move(int*,int*);
int capture(BOARD,FIGURE,int,int,int,int);
int try_a_move(BOARD,int,int,FIGURE);
int minmax_search(BOARD,FIGURE,int,int,int,int*,int*);
BOOL human_move(BOARD);
BOOL computer_move(BOARD,int);

/* Main program */

int _main()
{
  BOARD board;
  SCR_RECT screen_area={0,0,239,127};
  BOOL human_on_turn,human_played=TRUE,computer_played=TRUE;
  int i,j,level,score=0,answer=0;
  char *level_names[]={"NOVICE","ELEMENTARY","MEDIUM","GOOD","ADVANCED",
    "EXPERT"};
  char scr_buf[3840];
  fast_memcpy(scr_buf,(void*)0x4c00,3840);
  for(i=0;i<=9;i++)
    for(j=0;j<=9;j++)
      board[i][j]=BLANK_FAR;
  for(i=3;i<=6;i++)
    for(j=3;j<=6;j++)
      board[i][j]=BLANK_NEAR;
  board[5][4]=board[4][5]=HUMAN;
  board[4][4]=board[5][5]=COMPUTER;
  SetCurClip(&screen_area);
  display_board(board);
  DrawStr(130,90,"Level (1-6)?",4);
  while(answer<'1'||answer>'6')
    answer=getch();
  level=answer-'0';
  display_board(board);
  DrawStr(130,90,"Level: ",4);
  DrawStr(172,90,level_names[level-1],4);
  DrawStr(5,118,"Do you want to have a first move (y/n)?",4);
  while(answer!='y'&&answer!='n')
    answer=getch()|32;
  human_on_turn=(answer=='y');
  display_board(board);
  while(human_played||computer_played)
    {
      FontSetSys(0);
      DrawStr(5,118,
        "Compiled using TI-GCC compiler by Xavier Vassor & Jean Canazzi",4);
      FontSetSys(1);
      DrawStr(130,90,"Level: ",4);
      DrawStr(172,90,level_names[level-1],4);
      if(human_on_turn)
        human_played=human_move(board);
      else
        computer_played=computer_move(board,level);
      if(human_played==ESC_FLAG)
        break;
      display_board(board);
      human_on_turn=!human_on_turn;
    }
  if(human_played!=ESC_FLAG)
    {
      FontSetSys(2);
      DrawStr(130,50,"Game over!",4);
      for(i=1;i<=8;i++)
        for(j=1;j<=8;j++)
          score+=(board[i][j]==COMPUTER)-(board[i][j]==HUMAN);
      FontSetSys(2);
      DrawStr(130,65,score?((score>0)?"I won!":"You won!"):"Draw!",4);
      getch();
    }
  fast_memcpy((void*)0x4c00,scr_buf,3840);
}

/* Faster alternative for memcpy (copies 4 bytes in one turn) */

void fast_memcpy(void *src,void *dest,int len)
{
  int i;
  for(i=0;i<len;i+=4)
    *((long*)src)++=*((long*)dest)++;
}

/* Tries to capture figures in one particular direction, and returns number */
/* of captured figures (0 if not possible)                                  */

int capture(BOARD board,FIGURE figure,int i,int j,int i_step,int j_step)
{
  int captured=0,loc_i=i,loc_j=j;
  FIGURE next;
  do
    {
      next=board[loc_i+=i_step][loc_j+=j_step];
      if(next>=BLANK_NEAR)
        captured=0;
      else if(next!=figure)
        captured++;
    } while(next==!figure);
  if(captured)
    while(board[i+=i_step][j+=j_step]!=figure)
      board[i][j]=figure;
  return captured;
}

/* Tries to perform a move, and returns an advance in the material plus */
/* extra bonus for corners (returns zero if the move is not possible)   */

int try_a_move(BOARD board,int i,int j,FIGURE figure)
{
  int p,q,score=0;
  if(board[i][j]==BLANK_NEAR)
    {
      for(p=-1;p<=1;p++)
        for(q=-1;q<=1;q++)
          if(p||q)
            score+=capture(board,figure,i,j,p,q);
      if(score)
        {
          board[i][j]=figure;
          for(p=i-1;p<=i+1;p++)
            for(q=j-1;q<=j+1;q++)
              if(board[p][q]==BLANK_FAR)
                board[p][q]=BLANK_NEAR;
          if((i==1||i==8)&&(j==1||j==8))
            score+=3;
          score+=!score;
        }
    }
  return score;
}

/* Performs human move, and returns FALSE if there is no moves avaliable */

BOOL human_move(BOARD board)
{
  int i,j,score,char1,char2;
  BOARD board_save;
  fast_memcpy(board_save,board,sizeof(BOARD));
  for(i=1;i<=8;i++)
    for(j=1;j<=8;j++)
      if(try_a_move(board,i,j,HUMAN))
        {
          fast_memcpy(board,board_save,sizeof(BOARD));
          do
            {
              if(!input_move(&char1,&char2))
                return ESC_FLAG;
              if(!(score=try_a_move(board,char2-'0',char1-'A'+1,HUMAN)))
                DrawStr(130,68,"WRONG MOVE!",4);
            } while(!score);
          return TRUE;
        }
  DrawStr(130,56,"You must pass!",4);
  getch();
  return FALSE;
}

/* Recursive minmax search for a best move with alpha pruning: returns best  */
/* minmax value, and as a side effect, returns coordinates of such best move */

int minmax_search(BOARD board,FIGURE figure,int depth,int level,int alpha_val,
  int *best_i,int *best_j)
{
  int i,j,max_val=-1000,score,dummy;
  BOARD board_save;
  *best_i=0; *best_j=0;
  fast_memcpy(board_save,board,sizeof(BOARD));
  for(i=1;i<=8;i++)
    for(j=1;j<=8;j++)
      if(score=try_a_move(board,i,j,figure))   /* Yes, "=", not "==" ! */
        {
          if(depth!=level)
            score-=minmax_search(board,!figure,depth+1,level,score-max_val,
              &dummy,&dummy);
          if(level==1)
            score+=5*((i==1||i==8)+(j==1||j==8)-(i==2||i==7)-(j==2||j==7));
          if(score>max_val)
            {
              max_val=score; *best_i=i; *best_j=j;
            }
          fast_memcpy(board,board_save,sizeof(BOARD));
          if(score>=alpha_val)
            return max_val;
        }
  if(!*best_i)
    return 0;
  return max_val;
}

/* Performs computer move, and returns FALSE if there is no avaliable moves */

BOOL computer_move(BOARD board,int level)
{
  int best_i,best_j,max;
  char str[50];
  DrawStr(130,56,"Thinking...",4);
  minmax_search(board,COMPUTER,1,level,1000,&best_i,&best_j);
  if(!best_i)
    DrawStr(130,66,"I must pass!",4);
  else
    {
      try_a_move(board,best_i,best_j,COMPUTER);
      sprintf(str,"My move: %c%d",best_j-1+'A',best_i);
      DrawStr(130,68,str,4);
    }
  getch();
  return best_i!=0;
}

/* Asks the user for a move, put its coordinates in char1 and char2, and */
/* returns FALSE if the user pressed ESC key                             */

BOOL input_move(int *char1,int *char2)
{
  char tmp[]=" _";
  int key=0;
  while(key!=ENTER_KEY&&key!=ESC_KEY)
    {
      DrawStr(130,56,"Your move: _     ",4);
      *char1=key&0xffdf;
      while((*char1<'A'||*char1>'H')&&(*char1!=ESC_KEY))
        *char1=getch()&0xffdf;
      if(*char1==ESC_KEY)
        return FALSE;
      *tmp=*char1;
      DrawStr(196,56,tmp,4);
      *char2=0;
      while((*char2<'1'||*char2>'8')&&(*char2!=ESC_KEY))
        *char2=getch();
      *tmp=*char2;
      DrawStr(202,56,tmp,4);
      key=(*char2==ESC_KEY)?ESC_KEY:getch();
    }
  return key!=ESC_KEY;
}

/* Displays the board */

void display_board(BOARD board)
{
  int i,j,human_score=0,computer_score=0;
  char *xs="A",*ys="1";
  char str[50];
  ClrScr();
  FontSetSys(1);
  DrawStr(5,1,"OTHELLO/REVERSI V1.1  (C) Zeljko Juric",4);
  *xs='A'; *ys='1';
  for(i=23;i<=111;i+=11)
    {
      Line(23,i,111,i); Line(i,23,i,111);
      if(i!=111)
        {
          DrawStr(i+3,14,xs,4); (*xs)++;
          DrawStr(14,i+3,ys,4); (*ys)++;
        }
    }
  for(i=1;i<=8;i++)
    for(j=1;j<=8;j++)
      {
        draw_figure(11*j+14,11*i+14,board[i][j]);
        human_score+=(board[i][j]==HUMAN);
        computer_score+=(board[i][j]==COMPUTER);
      }
  sprintf(str,"Me: %d  You: %d",computer_score,human_score);
  DrawStr(130,30,str,4);
}

/* Draws a figure on screen */

void draw_figure(int x,int y,FIGURE c)
{
  int i;
  if(c==COMPUTER||c==HUMAN)
    {
      Line(x+2,y,x+5,y); Line(x+2,y+7,x+5,y+7);
    }
  if(c==COMPUTER)
    {
      Line(x,y+2,x+2,y); Line(x+5,y,x+7,y+2);
      Line(x,y+2,x,y+5); Line(x+7,y+2,x+7,y+5);
      Line(x,y+5,x+2,y+7); Line(x+5,y+7,x+7,y+5);
    }
  else if(c==HUMAN)
    {
      for(i=y+2;i<=y+5;i++)
        Line(x,i,x+7,i);
      Line(x+1,y+1,x+6,y+1); Line(x+1,y+6,x+6,y+6);
    }
}

/* Draws a line */

void Line(int x1,int y1,int x2,int y2)
{
  MoveTo(x1,y1); LineTo(x2,y2);
}

/* Please mail any comments, suggestions, questions and bug reports to:  */
/*  zjuric@utic.net.ba  (Zeljko Juric, Sarajevo, Bosnia and Herzegovina) */

