
/*
With my new knowledge, I reprogrammed Aspirin and reduced its size.
Important: Aspirin 3.0 doesn't support 2 player mode anymore (I thought it sucked!).
Overall, Aspirin has become what it should always have been: a simple, short and hopefully entertaining program.
*/

//(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)
//(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)

#include <tigcclib.h>
#define COMMENT_STRING         "An Orage Studio Prgm"
#define COMMENT_PROGRAM_NAME   "Aspirin Tournament."
#define COMMENT_VERSION_STRING "3.0"
#define COMMENT_BW_ICON \
{0x8001,0x76E9,0x54A0,0x72CB,0x5688,0x0000,0x7580,0x514E,0x6540,0x5544,0x0004,0x8084,0x8800,0x0B93,0x0810,0xE010}
#define COMMENT_GRAY_ICON \
{0x8001,0x76E9,0x54A0,0x72CB,0x5688,0x0000,0x7580,0x514E,0x6540,0x5544,0x0004,0x8084,0x8800,0x0B93,0x0810,0xE010},\
{0xFFFD,0xFFFC,0xFFFC,0xFFFE,0xFFFC,0xFFFC,0xFFE0,0xFFE4,0xFFE0,0xFFE0,0xFFE4,0x8000,0x0000,0x0901,0x0010,0x4000}


//(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)
//(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)


#define DATA_SIZE	(110)
#define spawnx1 	(1)
#define spawny1 	(1)
#define spawnx2 	(155)
#define spawny2 	(88)
#define obst_size (7)
enum bomb {goto_play,goto_info,goto_exit,none};


//(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)
//(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)


typedef struct {
	int x;
	int y;
	int score;
}STRUCT_PLAYER;

typedef struct {
	int x,y;
	int vx,vy;
}STRUCT_OBSTACLE;
    
typedef struct {
	int x,y;
}STRUCT_GOAL;

typedef struct {
	int s[5];
	int dif;
	int security;
}STRUCT_SCORE;



//(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)
//(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)

void enterr() {
	while (!_keytest (RR_ENTER)){}
	while (_keytest (RR_ENTER)){}
}

//:;;;;;;;;;;;;;;;;;;;;://:;;;;;;;;;;;;;;;;;;;;:
//:;;;;;;;;;;;;;;;;;;;;://:;;;;;;;;;;;;;;;;;;;;:
HANDLE get_handle() {
	SYM_ENTRY *sym=SymFindPtr($(aspisav),0);
	HANDLE handle;
	if (sym) {
		if (sym->flags.bits.archived) {
			if (!EM_moveSymFromExtMem($(aspisav),HS_NULL)) return(H_NULL);
		}
		handle=HeapRealloc(sym->handle,47);
		sym=SymFindPtr($(aspisav),0);
	} else {
		HSym hsym=SymAdd($(aspisav));
		//if (!*(unsigned long *)&hsym) return(H_NULL);
		handle=HeapAlloc(47);
		if (handle)
		sym=DerefSym(hsym);
		else
		SymDel($(aspisav));
	}
	if (!handle) return(H_NULL);
	sym->handle=handle;
	return(handle);     
}

//:;;;;;;;;;;;;;;;;;;;;://:;;;;;;;;;;;;;;;;;;;;:
//:;;;;;;;;;;;;;;;;;;;;://:;;;;;;;;;;;;;;;;;;;;:

void write_data(STRUCT_SCORE *s) {
	HANDLE h = get_handle();
	if (!h)
	return;

	short *fptr=HeapDeref(h);
  //First octet will record the size of the file
	*fptr=45;
	memcpy(fptr+1,s,sizeof(STRUCT_SCORE));
  memcpy(fptr+20,(char [7]){0,'H','S','C',' ',0,OTH_TAG},7);
	return;

}


//:;;;;;;;;;;;;;;;;;;;;://:;;;;;;;;;;;;;;;;;;;;:
//:;;;;;;;;;;;;;;;;;;;;://:;;;;;;;;;;;;;;;;;;;;:

void read_data(STRUCT_SCORE *s) {
	HANDLE h = get_handle();
	if (!h)
	return;
	short *fptr=HeapDeref(h);
  memcpy(s,fptr+1,sizeof(STRUCT_SCORE));
}


//(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)
//(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)

void sprite_you(STRUCT_PLAYER *player) {
	int x=player->x;
	int y=player->y;
	DrawLine (x,y+1,x,y+2,A_XOR);
	DrawLine (x+1,y,x+1,y+3,A_XOR);
	DrawLine (x+2,y,x+2,y+3,A_XOR);
	DrawLine (x+3,y+1,x+3,y+2,A_XOR);
}

//(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)
//(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)

void sprite_goal(STRUCT_GOAL *goal) {
	int x=goal->x;
	int y=goal->y;    
	DrawLine(x,y,x+6,y,A_XOR);
	DrawLine(x+6,y,x+6,y+6,A_XOR);
	DrawLine(x+6,y+6,x,y+6,A_XOR);
	DrawLine(x,y+6,x,y,A_XOR);
}


//(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)
//(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)(*)

// Main Function
void _main() {

	
	//Chapter 0: Variables (in order of appearance).
	int loop;	
	int result,dif;	
	int offsetx=0,offsety=0;
	char st[30];
	int quit=0;
	int loss=0;
	int current_number_of_obstacle=5;
	STRUCT_OBSTACLE *ppttaaoo; // Pointer Pointing To The Awful Array Of Obstacle
	
	//Chapter I: check if the score file is valid, otherwise create one that is.
	STRUCT_SCORE s;
	read_data(&s);
	if (s.security != 729) {
		for (loop = 0; loop < 7; loop++) {
			s.s[loop] = 0;
		}
		s.dif = 0;
		s.security = 729;
		write_data(&s);
	}

	//Chapter II: Alloc some memory for the array that will contain the data concerning the moving obstacles. If the alloc failed -> exit.
	ppttaaoo = malloc( sizeof(STRUCT_OBSTACLE)*DATA_SIZE + 30*10);
	if (!ppttaaoo)
	exit(0);
	
	void *pause_buffer = ppttaaoo + sizeof(STRUCT_OBSTACLE)*DATA_SIZE;


	//Chapter III: redirect the Auto_Int. I don't really know what it does but w/o it the keyboard input doesn't work well. See TIGCC's doc for more info.
	//INT_HANDLER save_int_1;
	//save_int_1 = GetIntVec (AUTO_INT_1);
	//SetIntVec (AUTO_INT_1, DUMMY_HANDLER);
	OSSetSR(0x0400);   
	
	//Chapter IV: loop around the menu where we choose to play, to quit or to get help.

	do {
		//Chapter A: Draw the menu.

		if (!TI89) {
			offsetx = 40;//(240-160)/2;
			offsety = 14;//(128-100)/2;
		}

		read_data(&s);
		dif = s.dif;
		result = none;
		memset(LCD_MEM,255,LCD_SIZE);
		
		loop = 32+offsetx;
		FontSetSys(F_8x10);
		DrawStr (loop,18+offsety,"Aspirin 3.0",A_REVERSE);
		FontSetSys(F_4x6);

		DrawStr (loop,38+offsety,"[1] Start!",A_REVERSE);

		DrawStr (loop,52+offsety,"[3] Info",A_REVERSE);
		DrawStr (loop,59+offsety,"[4] Exit",A_REVERSE);


		//Chapter B: Get the keypresses.
		while (result == none) {
			if (_keytest(RR_1))
			result = goto_play;
			
			if (_keytest(RR_2)) {
				dif++;
				if (dif>3)
				dif=0;
				s.dif=dif;
				write_data(&s);
				while (_keytest(RR_2)) {};	
			}
			//DrawChar (117+offsetx,45+offsety,49+dif,A_REVERSE);
			sprintf(st,"~High Score %i~  ",s.s[dif]);
			DrawStr (loop,75+offsety,st,A_REVERSE);
			sprintf(st,"[2] Set difficulty: %i ",dif);
			DrawStr (loop,45+offsety,st,A_REVERSE);
			if (_keytest(RR_3))
			result = goto_info;
			if (_keytest(RR_4))
			result = goto_exit;
		}		
		//Chapter C: Act according the last keypress.
		//Chapter C.a: Display the info.
		if (result == goto_info) {
			clrscr();
			printf(	
"
 Aspirin Tournament, programmed by Jfg

Website-> http://oragestudio.free.fr
Email-> jfgeyelin@hotmail.com

~press [ENTER]~"
			);
			
			enterr();
		}
		//Chapter C.b: The IMPORTANT loop (da game loop).
		if (result == goto_play) {
			// 1/ Accelerate the timer.
			//pokeIO(0x600017,0xFA);
			// 2/ Draw the border.
			ClrScr();
			DrawClipRect (&(WIN_RECT){0, 0, LCD_WIDTH-1, LCD_HEIGHT-1}, &(SCR_RECT){{0, 0, LCD_WIDTH-1, LCD_HEIGHT-1}}, A_NORMAL);
			// 3/ Initialize a couple of variables.
			STRUCT_PLAYER p;
			STRUCT_GOAL goal;
			goal.x = 10;
			goal.y = 10;
			p.x = 20;
			p.y = 20;
			p.score = 0;
			quit=0;
			loss=0;
			current_number_of_obstacle=0;
			FontSetSys(F_8x10);			
			// 4/ XOR the player and the goal.
			sprite_goal(&goal);
		  sprite_you(&p);
		  // 5/ Creates the timer that I will use.
		  pokeIO(0x600017,0xFA);
		  OSFreeTimer(6);
		  OSRegisterTimer(6,7);	
			// 6/ Loop 'till we quit or we loose.
			while (!quit && !loss) {
				//XOR the player. (erase)
				sprite_you(&p);
				//Moves the player.
				if (_keytest(RR_LEFT))
			  p.x--;
			  if (_keytest(RR_RIGHT))
			  p.x++;
			  if (_keytest(RR_UP))
			  p.y--;
			  if (_keytest(RR_DOWN))
			  p.y++;
			  if (_keytest(RR_ESC))
			  quit = 1;
			  
				//Detect loss with the latest coord of the player.
				loss = GetPix(p.x,p.y+1) + GetPix(p.x,p.y+2) + GetPix(p.x+1,p.y) + GetPix(p.x+1,p.y+3) + GetPix(p.x+2,p.y) + GetPix(p.x+2,p.y+3) + GetPix(p.x+3,p.y+1) + GetPix(p.x+3,p.y+2);
				//XOR the player. (draw)
				sprite_you(&p);	
			 if (_keytest(RR_2ND)) {
					memcpy(pause_buffer,LCD_MEM+45*30,30*10);
					DrawStr(45,45,"*Pause*",A_NORMAL);
					while (!_keytest(RR_ENTER)) {};
					while (_keytest(RR_ENTER)) {};
					memcpy(LCD_MEM+45*30,pause_buffer,30*10);
				}
				//Check if the player caught the goal.
				if (abs(goal.x+3-(p.x+2)) < 7 && abs(goal.y+3-(p.y+2)) <7) {
					sprite_goal(&goal);
					goal.x = random (120) + 20;
					goal.y = random (60) + 20;
					sprite_goal(&goal);
					p.score++;
					for (loop=0;loop <= dif+1;loop++) {
							do {
								ppttaaoo[current_number_of_obstacle].x = random(LCD_WIDTH-14)+3;
								ppttaaoo[current_number_of_obstacle].y = random(LCD_HEIGHT-13)+3;
							} while (abs(ppttaaoo[current_number_of_obstacle].x-p.x) < 7 || abs(ppttaaoo[current_number_of_obstacle].y-p.y) < 7);
						  int r = random(2);
							ppttaaoo[current_number_of_obstacle].vx = r;
							ppttaaoo[current_number_of_obstacle].vy = abs(r-1);
							DrawLine(ppttaaoo[current_number_of_obstacle].x+(ppttaaoo[current_number_of_obstacle].vx),ppttaaoo[current_number_of_obstacle].y+(ppttaaoo[current_number_of_obstacle].vy),ppttaaoo[current_number_of_obstacle].x+7*abs(ppttaaoo[current_number_of_obstacle].vx),ppttaaoo[current_number_of_obstacle].y+7*abs(ppttaaoo[current_number_of_obstacle].vy),A_XOR);
						current_number_of_obstacle++;
					}
				}
				//Move all the obstacles; it XORs a pixel at the beginnig and at the end of each segments.
				for (loop = 0; loop < current_number_of_obstacle; loop++) {
					ppttaaoo[loop].x += ppttaaoo[loop].vx;
			    ppttaaoo[loop].y += ppttaaoo[loop].vy;			    
			   
			    DrawPix(ppttaaoo[loop].x,ppttaaoo[loop].y,A_XOR);
					DrawPix(ppttaaoo[loop].x+7*abs(ppttaaoo[loop].vx),ppttaaoo[loop].y+7*abs(ppttaaoo[loop].vy),A_XOR);
			    if (ppttaaoo[loop].x<=1 || ppttaaoo[loop].x>=LCD_WIDTH-8) {
			        ppttaaoo[loop].vx = -ppttaaoo[loop].vx;
			 			  DrawPix(ppttaaoo[loop].x,ppttaaoo[loop].y,A_XOR);
							DrawPix(ppttaaoo[loop].x+7*abs(ppttaaoo[loop].vx),ppttaaoo[loop].y+5*abs(ppttaaoo[loop].vy),A_XOR);
			        }
			    if (ppttaaoo[loop].y<=1 || ppttaaoo[loop].y>=LCD_HEIGHT-8) {
			        ppttaaoo[loop].vy = -ppttaaoo[loop].vy;
			   		  DrawPix(ppttaaoo[loop].x,ppttaaoo[loop].y,A_XOR);
							DrawPix(ppttaaoo[loop].x+7*abs(ppttaaoo[loop].vx),ppttaaoo[loop].y+7*abs(ppttaaoo[loop].vy),A_XOR);
			    }  
				}
				//Wait 'till the timer is expired. (duh)
				while(!OSTimerExpired(6)) {};
				OSTimerRestart(6);
			}
			if (!quit) {
				clrscr();
				printf(
"You lost!
Youre score is %i

~press [ENTER]~",p.score);

				enterr();
			}
			if (p.score > s.s[dif]) {
				s.s[dif] = p.score;
				write_data(&s);
			}
			pokeIO(0x600017,(HW_VERSION==1?0xB2:0xCC));
		}
	} while (result != goto_exit && !quit);

	//Chapter V: the loop around the menu has ended: it means we are quitting... re-redirect the interrupt.

  //SetIntVec (AUTO_INT_1, save_int_1);
  
  
  
  free(ppttaaoo);//#%%!@##@!@*&% I just lost 20 min searching for the cause of a memory leak: the "free" was after "exit".
  //exit(0);

}