;
; Raven 68K Debugger
; Copywrite Bryan Turner 1997
;

;
; Module's Frame
;
ModuleInit	equ	0		; Must preserve A5/A6/A7
PrevModule	equ	ModuleInit+2	; Offset from module pointer (a5)
NextModule	equ	PrevModule+2	; Offset from module pointer
DisplayProc	equ	NextModule+2	; Offset from module pointer
					; Must preserve A5/A6/A7
VarOffset	equ	DisplayProc+2	;    "   "
Editable	equ	VarOffset+2	; Is this data editable
EditOffset	equ	Editable+1	; Offset when press up/down
EditMod		equ	EditOffset+1
EditDataPtr	equ	EditMod+2	; Pointer to the data to be edited
CharArray	equ	EditDataPtr+4	; Chars this module responds to
	; CharArray.w [0] == Character Code (word)
	;             [1] == Offset to proc from module pointer (a5)

;
; Global's Frame
;
; Positions of variables from A6 (global variable space)
;
hex_chars	equ 	0
cur_char_num	equ	hex_chars+16
cur_edit_reg	equ	cur_char_num+2
LCDHANDLE	equ	cur_edit_reg+2
TRAPNUMS	equ	LCDHANDLE+2
ONAUTOVEC	equ	TRAPNUMS+NUMTRAPS+1
FARGOVEC	equ	ONAUTOVEC+4
GRAYAUTOVEC	equ	FARGOVEC+4
RESETFARGO	equ	GRAYAUTOVEC+4
XD0		equ	RESETFARGO+4
XA0		equ	XD0+8*4
XSP		equ	XA0+7*4
XPC		equ	XA0+8*4
XSR		equ	XPC+4
CurModule	equ	XSR+2
is_Editing	equ	CurModule+4
StandardChars	equ	is_Editing+2	; Must be last variable
					;  (it's a variable size array

