;
; Raven 68K Debugger
; Copywrite Bryan Turner 1997
;
; This routine emulates what ROM does (but hopefully much faster).
; Not yet at the point to use it in the program.
; (it works as documented though)
;
;
; Fast 8pt putchar routine
;	d0 = char to put (zero in high byte)
;	d2 = X coord (pixels)
;	d1 = Y coord (pixels)
;
rom_put_char:
	movem.l	d1-d3,-(a7)
	move.l	#$004665c4,a0			; Load characters from rom
	lsl.w	#3,d0				; Find character offset
	add.w	d0,a0

	move.l	#LCD_MEM,a1
	;clr.l	d0
	;move.w	d1,d0				; Y * 30 -> d0
	;lsl.l	#5,d0
	;lsl.w	#1,d1
	;sub.w	d1,d0

	move.w	d2,d0
	lsr.w	#3,d0				; X div 8 -> d1
	add.w	d1,d0				; 30*Y + X/8 -> d0

	add.l	d0,a1				; Move pointer to affected byte
	and.w	#7,d2				; Find remainder of X/8


;
; Possibly use inner loop to process to bytes at a time:
;   Load one byte into high word, and one into low word
;   Use swap to switch between them.
;   - Saves rotations, but adds complexity, lenght and swaps
;

	moveq	#29,d1
	moveq	#7,d3
rom_lup:
	clr.l	d0
	move.b	(a1),d0				; Load affected byte

	lsl.l	d2,d0				; Shift bits into position
	move.b	(a0)+,d0			; Store bits we want
	ror.l	d2,d0				; Rotate back properly
	
	move.b	d0,(a1)+			; Store back in memory
	rol.l	#8,d0
	move.b	d0,(a1)

	add.l	d1,a1
	dbra.w	d3,rom_lup
	
	movem.l	(a7)+,d1-d3
	rts

