;
; Raven 68K Debugger
; Copywrite Bryan Turner 1997
;
;
; Exception Processor
;

	@program	install,prog_name

NUMTRAPS	equ	19
SAVED_STACK	equ	$30
A0_SCRATCH	equ	$34
TRACE		equ	$8000

	INCLUDE "VarFrame.asm"

prog_name:
	dc.b	"68K Debugger Install",0
	ds.w	0

install:
	bsr	clr_LCD
	
	moveq	#1,d0
	move.w	d0,-(a7)
	bsr	set_font		; 8pt font
	addq	#2,a7

	move.w	#$2700,sr		; Turn off interrupts while we're editing...
	move.l	#$1fbb4,a0		; Check to see if we are already installed,
	cmp.l	#$46fc2000,(a0)		;   or if this is an unknown version of Fargo.
	bne	bad_install
	addq	#4,a0
	cmp.l	#$4eb00002,(a0)
	bne	bad_install
					; Patch Fargo's Exec() function:
	subq	#4,a0			; Restore A0
	move.w	#$4EF9,(a0)+		; Store JMP $00000000 instruction
	
	move.l	($5d36),a1		; Load address of top of heap
	move.l	a1,a3			; Make a copy
	move.l	#end_vars-exec_patch,d0	; Load size of debugger
	sub.l	d0,a1			; Subtract size of debugger
	move.l	a1,($5d36)	

	move.l	a1,(a0)+		; Address to jump to
	move.w	#$4e71,(a0)+		; Store NOP instruction

	move.l	a1,a2			; Copy of high mem addr
	
	move.l	a1,a6
	add.l	#allVars-exec_patch,a6	; Load address of variables

	lea	exec_patch(pc),a0	; Load address to start of debugger
	lsr.l	#2,d0			; Divide size by 4 (number of longwords)
	subq	#1,d0			; Adjust to 0..numlongs-1
copy_loop:
	move.l	(a0)+,(a1)+		; Copy debugger to high memory
	dbra	d0,copy_loop		; *** May not copy last 2 bytes!!

	add.l	#except-exec_patch,a2	; Offset to exception process

	bclr.b	#2,($600001)		; Memory protect OFF

					; Install exception proc:
	move.l	a2,d1			; Store addr of exception proc in D1
	lea	TRAPNUMS(a6),a0		; Load trap numbers to catch
	move.l	($78),ONAUTOVEC(a6)	; Save old 'ON' autovector
	move.l	($64),FARGOVEC(a6)	; Save Fargo's autovector 1
	move.l	a3,RESETFARGO(a6)	; Store vector for emergency reset to Fargo
	move.l	a3,($04)		; Store Fargo reset as THE reset vector
	moveq	#NUMTRAPS-1,d2		; Load number of traps to edit
	clr.l	d0

inlup:
	move.b	(a0)+,d0		; Get a trap number
	move.l	d0,a1			; Make it an address
	move.l	d1,(a1)			; Install our exception routine
	move.b	d0,(a1)			; Store the trap number too!! (so we know why we were called)
	dbra	d2,inlup		; Loop back..
	
	;
	; Get memory for LCD
	;
	move.l	#$0F08,-(a7)
	jsr	romlib[create_handle]
	addq	#4,a7
	move.w	d0,LCDHANDLE(a6)

	move.l	ONAUTOVEC(a6),($78)	; Replace 'ON' autovector
	;bset.b	#2,($600001)		; Memory protect ON
	
done:
	move.w	#$2000,sr		; Re-enable interrupts (ROM may need it to draw stuff..??)
	move.w	#4,-(a7)
	pea	good_str(pc)		; Draw good_str
	clr.l	-(a7)
	jsr	romlib[puttext]
	lea	10(a7),a7

	move.w	#4,-(a7)
	pea	good_str2(pc)		; Draw good_str2
	move.w	#10,-(a7)
	clr.w	-(a7)
	bsr	puttext
	lea	10(a7),a7

	bra	pause

bad_install:
	move.w	#$2000,sr		; Re-enable interrupts

	move.w	#4,-(a7)
	pea	bad_str(pc)
	clr.l	-(a7)
	bsr	puttext			; Draw bad_str
	lea	10(a7),a7

	move.l	#$1fbb4,a0		; Draw data found at the patch location
	move.l	(a0)+,d0		;  (two longwords)
	moveq	#7,d4
	moveq	#2,d1
	moveq	#2,d2
	bsr	put_hex
	move.l	(a0)+,d0
	subq	#8,d2
	addq	#1,d1
	bsr	put_hex

pause:
	clr.w	($75b0)
p_lup:
	tst.w	($75b0)
	beq	p_lup
	clr.w	($75b0)
	rts
bad_str:
	dc.b	"Not Installed!",0,0
good_str:
	dc.b	"Instalation Complete, you may",0
good_str2:
	dc.b	"now delete this program!",0,0
	ds.w	0

exec_patch:
	move	#$2000,sr		; Interrupt mask -> 0
	bclr.b	#2,($600001)		; Memory protect OFF
	move.l	SP,(SAVED_STACK)	; Save the stack pointer

	lea	except(pc),a1
	move.l	a1,($78)		; Load new 'ON' autovector
	
	jsr	2(a0,d0.w)		; Execute program
	move	#$2700,sr		; Interrupt mask -> 7

	bclr.b	#2,($600001)		; Memory protect OFF
	lea	allVars(pc),a6
	move.l	ONAUTOVEC(a6),($78)	; Restore 'ON' autovector
	clr.l	(SAVED_STACK)		; Mark stack as bad pointer
	jmp	$1fbbc			; Jump back to exec proc in core.o

	;
	; Exception processor based on public domain work in
	;   68030 Asm. Lang. Reference, Steve Williams/Addison-Wesley
	;
except:
	move.w	#$2700,sr		; Disable interrupts
	bclr.b	#2,($600001)		; Memory protect OFF
	move.l	a0,(A0_SCRATCH)		; Save old A0
	lea	allVars(pc),a0		; Load our globals
	movem.l	d0-d7/a0-a6,XD0(a0)	; Store registers (except stack pointer, it needs adjustment)
	move.l	(A0_SCRATCH),XA0(a0)	; Store proper A0
	move.l	a0,a6			; Globals -> a6
	move.l	($64),GRAYAUTOVEC(a6)	; Store GRAYLIB autovector
	move.l	FARGOVEC(a6),($64)	; Restore correct autoint 1 (Turns off GRAY screens)
	move.l	ONAUTOVEC(a6),($78)	; Restore 'ON' autovector
	move.w	#$0888,($600010)	; Restore LCD base addr (just in case)
	bsr	getpc			; Get the PC
	nop
getpc:
	move.l	(sp)+,d0		; Load PC
	clr.b	d0
	rol.l	#8,d0			; Isolate top byte of PC for trap number
	cmp.b	#$8,d0			; If exeption was Bus Error
	blt	noAdj			
	cmp.b	#$C,d0			; Or if it was Address Error
	bgt	noAdj
	add.l	#8,a7			; Adjust stack pointer for frame differences
noAdj:
	move.w	(a7)+,XSR(a6)		; Store SR from exception frame
	move.b	d0,(a7)			; Store Exception vector in top byte of return address
	move.l	(a7)+,XPC(a6)		; Store PC from exception frame
	move.l	a7,XSP(a6)		; Store correct A7 value...
	andi.w	#TRACE-1,XSR(a6)	; Turn off trace bit in the old SR
	
	;move.l	OURSP(a6),a7		; ** Once we have a protected stack, load it here...
	
; Do debugger stuff..

	bsr	swap_LCD
	bsr	delay			; Wait a sec (er, a few micro secs..)
	bra	module_start		; Call debugger

load_LCD_A0:
	move.w	LCDHANDLE(a6),d0
	lsl.w	#2,d0
	move.l	($5d42),a0
	add.w	d0,a0
	move.l	(a0),d0			; Load pointer to LCD data
	addq	#7,d0
	and.l	#$FFFFFFF8,d0		; Force it to a 4 byte boundary
	move.l	d0,a0
	rts

; Save LCD (actually swap it with what was in memory)
swap_LCD:
	bsr	load_LCD_A0
	lea	$4440,a1
	move.w	#$03bf,d0
swap_lup:
	move.l	(a1),d1
	move.l	(a0),(a1)+
	move.l	d1,(a0)+
	dbra	d0,swap_lup
	rts

	;
	; Now return to the shell...
	;
attempt_escape:
	tst.l	(SAVED_STACK)
	bne	return_to_shell		; If a stack pointer exists return to shell
					; Otherwise, return to the faulted program:
return_to_program:
	bsr	swap_LCD		; Replace the LCD data
	lea	except(pc),a0
	move.l	a0,($78)		; Re-install 'ON' autovecor
	move.l	GRAYAUTOVEC(a6),($64)	; Restore GRAY autovector
	;bset.b	#2,($600001)		; Memory protect ON
	move.l	XSP(a6),a7		; Load program's stack pointer
	move.l	XPC(a6),-(a7)		; Create exception frame
	move.w	XSR(a6),-(a7)
	movem.l	XD0(a6),d0-d7/a0-a6	; Restore registers
	rte				; Return to program

return_to_shell:
	move.l	ONAUTOVEC(a6),$78	; Restore 'ON' autovector
	move.l	(SAVED_STACK),a7	; Restore stack pointer
	clr.l	(SAVED_STACK)		; Mark stack as bad pointer
	subq	#4,a7			; Make stack point to return addr (was pushed on after we saved this value)
	move.w	XSR(a6),-(a7)		; Push SR (make an exception frame)
	;bset.b	#2,$600001		; Memory protect ON
	rte				; Return to shell

;reset_with_fargo:			; *** NOT CURRENTLY WORKING, we edited the execute proc
	;move.l	RESETFARGO(a6),a0	; Load reset address
	;pea	except(pc)		; Build exception frame
	;move.w	sr,-(a7)
	;jmp	(a0)			; Jump to it


	INCLUDE "Module.asm"		; Include the Modules and main module loop
	INCLUDE "Stolen.asm"		; Stuff stolen from other libraries/programs
	INCLUDE "RomChar.asm"		; Faster version of putchar routine for 8pt fonts

	INCLUDE "Allvars.asm"

padding:
	dc.w	0			; Since copy loop may not copy last 2 bytes, add some padding...
end_vars:
	dc.w	0			; Tag to mark the end of the variables, for copying our program in memory

	reloc_open
	add_library flib
	add_library romlib
	reloc_close
	end




