;
; Raven 68K Debugger
; Copywrite Bryan Turner 1997
;

;*****************************************************
; Display Registers
;*****************************************************

STARTX		equ	3
STARTY		equ	2
status_reg_word	equ	0


reged_mod_start:
;ModuleInit
	dc.w	reg_mod_init-reged_mod_start
;PrevModule
	dc.w	0
;NextModule
	dc.w	hexed_mod_start-reged_mod_start
;	dc.w	0	*** for testing purposes
;DisplayProc
	dc.w	draw_regs-reged_mod_start
;VarOffset
	dc.w	reged_mod_vars-reged_mod_start
;Editable
	dc.b	1
;EditOffset
	dc.b	$08
;EditMod
	dc.w	$7F
;EditDataPtr
	dc.l	0
;CharArray
	; CharArray.w [0] == Character Code (word)
	;             [1] == Offset to proc from module pointer (a5)
	dc.w	0
reged_mod_vars:
	dc.b	"SMXNZVC",0

reg_mod_init:
	lea	XD0(a6),a0
	move.l	a0,EditDataPtr(a5)	; Store pointer to edit data
	clr.w	cur_edit_reg(a6)	; Reset the edit register
	bsr	draw_names
	bsr	draw_stat
	rts

draw_names:
	moveq	#STARTY,d1				; Starting line
	
	move.b	#$d0,d6					; With register D0
	move.b	#$a0,d7					; And register A0
	move.w	#1,d4					; display 2 chars
	move.w	#7,d5					; 8 lines

names_loop:
	moveq	#STARTX,d2				; Starting column
	move.l	d6,d0					; Load data register name
	bsr	put_hex					; Draw the stored register
	add.l	#10,d2					; skip to address column
	move.l	d7,d0
	bsr	put_hex					; Draw the stored register
	add.l	#1,d1
	add.b	#1,d6
	add.b	#1,d7
	dbra	d5,names_loop
	rts

draw_regs:
	lea	XD0(a6),a0			; Load pointer to stored data registers 4 = branch PC
	lea	XA0(a6),a1			; Load pointer to stored address regisers
	moveq	#7,d5					; number of registers to display
	move.w	#7,d4					; 8 characters
	moveq	#STARTY,d1				; Starting line
reg_loop1:
	moveq	#STARTX+3,d2				; Starting position

	move.l	(a0)+,d0				; Load a stored register
	bsr	put_hex					; Draw the stored register
	
	add.l	#4,d2					; Skip over to address column

	move.l	(a1)+,d0				; Load a stored register
	bsr	put_hex					; Draw the stored register

	add.l	#1,d1					; Next line..
	dbra	d5,reg_loop1				; Loop back
	
	tst.b	is_Editing(a6)				; If we are editing...
	beq	end_reg_draw	
	
	move.l	#LCD_MEM,a0				; Now, invert the register currently bieng edited
	add.l	#STARTX+3,a0				; Adjust for the register names
	clr.l	d0
	move.w	cur_edit_reg(a6),d0
	move.l	d0,d2
	bclr.b	#6,d0					; Test if it is in the addr column
	beq	not_addr				; Adjust for the data/addr columns
	add.l	#12,a0
not_addr:
	lsr.l	#3,d0					; Clear low 3 bits
	add.w	#STARTY,d0				; Rectify starting line differences
	lsl.l	#4,d0					; Multiply d0 by 240
	move.l	d0,d1
	lsl.l	#4,d1
	sub.l	d0,d1
	add.l	d1,a0
	and.b	#7,d2
	add.l	d2,a0
	
	move.l	#30,d1					; 30 bytes per line
	move.w	#7,d0					; 7 lines to invert
xor_loop:
	not.b	(A0)					; Invert the line
	add.l	d1,a0
	dbra.w	d0,xor_loop
	
end_reg_draw:
	rts

draw_stat:
	lea	reged_mod_vars(pc),a0		; Load string for status reg display
	move.w	XSR(a6),d0			; Load status word
	move.w	d0,d6
	lsl.w	#2,d0				; *** HELP: find a better way of setting these bits!
	bsr	set_status_char			; Supervisor/User Mode
	lsl.w	#1,d0
	bsr	set_status_char			; Master/Interrupt State
	lsl.w	#8,d0
	bsr	set_status_char			; eXtend
	lsl.w	#1,d0
	bsr	set_status_char			; Negative
	lsl.w	#1,d0
	bsr	set_status_char			; Zero
	lsl.w	#1,d0
	bsr	set_status_char			; oVerflow
	lsl.w	#1,d0
	bsr	set_status_char			; Carry
	
	movem.l	d0-d1/a0-a1,-(a7)		; Save registers (ROMLib destroys them)
	move.w	#4,-(a7)
	pea	reged_mod_vars(pc)
	move.w	#STARTY*8+72,-(a7)		; Line #9
	move.w	#STARTX*8,-(a7)			; Beginning of line
	bsr	puttext
	lea	10(a7),a7			; Pop stuff off stack
	movem.l	(a7)+,d0-d1/a0-a1

	moveq	#STARTY+9,d1			; Line #9
	moveq	#STARTX+10,d2			; Ten Places over..
	move.w	d6,d0
	moveq	#3,d4				; Display one digit
	bsr	put_hex				; Display the interrupt level

	addq	#1,d2				; Add a space
	moveq	#7,d4				; 8 characters 
	move.l	XPC(a6),d0			; Load Program Counter
	;subq	#2,d0				; Adjust to proper value ** May not adjust properly for Bus/Addr errors!!
	bsr	put_hex
	
	addq	#2,d1				; Skip two lines
	moveq	#STARTX,d2			; Back at start of line
	move.l	d0,a0				; Load PC
	move.w	#3,d4				; 4 digits each word
	moveq	#3,d3				; 4 words total
instr_loop:
	move.w	(a0)+,d0			; Draw words at PC address
	bsr	put_hex
	addq	#1,d2
	dbra	d3,instr_loop
	
	rts

set_status_char:	
	bset.b	#5,(a0)
	btst.l	#15,d0
	beq	bit_is_zero
	bclr.b	#5,(a0)
bit_is_zero:
	addq.l	#1,a0
	rts



