;
; Raven 68K Debugger
; Copywrite Bryan Turner 1997
;
;
; Generic Debugger Module Framework
;

first_module:
	INCLUDE "MRegEd.asm"
	INCLUDE "MHexEd.asm"
;	INCLUDE "MSearch.asm"

module_start:
	tst.l	CurModule(a6)		; If no module selected
	bne	new_module
	lea	first_module(pc),a0
	move.l	a0,CurModule(a6)	; Load first module
new_module:
	bsr	clr_LCD
	moveq	#1,d0
	move.w	d0,-(a7)
	bsr	set_font		; 8pt font
	addq.l	#2,a7
	move.l	CurModule(a6),a5	; Load module's vars
	move.l	a5,a0
	adda.w	ModuleInit(a5),a0
	jsr	(a0)			; Call module's init proc
module_loop:
	move.w	EditMod(a5),d0
	and.w	d0,cur_edit_reg(a6)	; Force the edit register to be withing bounds
	move.l	a5,a0
	adda.w	DisplayProc(a5),a0
	jsr	(a0)			; Call module's display proc
	
	clr.w	($75B0)
module_wait_key:			; Wait for a keypress
	; Call idle proc?? Must preserve A5-A7

	;
	; Auto Power Down code from flib
	;
	move.l	#$1770,APD_TIMER	; reset APD timer (1)
	clr.w	APD_FLAG		; reset APD timer (2)

	stop	#$2000
	tst.w	APD_FLAG		; time for APD?
	beq	no_apd			; no -- do not shut down
do_apd:
	trap	#4
	bra	module_wait_key
no_apd:
	tst.w	($75B0)
	beq	module_wait_key
	move.w	($75B2),d0
	clr.w	($75B0)
	
	cmp.w	#$210B,d0		; 'Off' key
	beq	do_apd

	lea	StandardChars(a6),a0	; Load regular features
	lea	module_start(pc),a1	; Load base pointer
	bsr	test_chars
	
	lea	CharArray(a5),a0	; Load character array from module
	move.l	a5,a1			; Load module pointer
	bsr	test_chars

	bra	module_wait_key

test_chars:
	move.l	(a7)+,a4		; Pop return addr
test_char_lup:
	move.w	(a0)+,d1		; Load character
	move.w	(a0)+,d2		; Load offset
	tst.w	d1			; Test for end of array
	bne	test_it
	jmp	(a4)			; return to wait for another keypress
test_it:
	cmp.w	d0,d1			; If character matches
	beq	do_char
	cmp.w	#$FFFF,d1		; If it's a wildcard match
	bne	test_char_lup
do_char:
	lea	EditDataPtr(a5),a3	; Load pointer to Module's data pointer
	move.l	a5,a2			; Load pointer to Modules variables
	adda.w	VarOffset(a5),a2
	jsr	0(a1,d2.w)		; Jump to it!
	bra	module_loop

RightArrow:
	tst.b	is_Editing(a6)
	bne	edit_right
	move.w	NextModule(a5),d0	; Load offset to next module
	adda.w	d0,a5			; Adjust module pointer
	move.l	a5,CurModule(a6)	; Save it for future reference
	addq	#4,a7			; Tear off return addr
	bra	new_module
edit_right:
	addq.w	#1,cur_edit_reg(a6)
	rts

LeftArrow:
	tst.b	is_Editing(a6)
	bne	edit_left
	move.w	PrevModule(a5),d0	; Load offset to prev module
	suba.w	d0,a5			; Adjust module pointer
	move.l	a5,CurModule(a6)	; Save it for future reference
	addq	#4,a7			; Tear off return addr
	bra	new_module
edit_left:
	subq.w	#1,cur_edit_reg(a6)
	rts

UpArrow:
	tst.b	is_Editing(a6)
	beq	skip_key		; If not editing, go back to testing chars
	clr.w	d0
	move.b	EditOffset(a5),d0
	sub.w	d0,cur_edit_reg(a6)	; Shift edit cursor
	rts

DownArrow:
	tst.b	is_Editing(a6)
	beq	skip_key		; If not editing, go back to testing chars
	clr.w	d0
	move.b	EditOffset(a5),d0
	add.w	d0,cur_edit_reg(a6)	; Shift edit cursor
	rts

skip_key:
	addq	#4,a7			; Tear off return addr
	bra	test_char_lup

Digits:
	tst.b	is_Editing(a6)
	beq	skip_key		; If not editing, go back to testing chars	

	sub.b	#48,d0			; '0'
	bcs	skip_key
	cmp.w	#10,d0			; '9'
	bcs	is_number
	
	bclr	#5,d0			; Lowercase == Uppercase
	sub.b	#7,d0			; Adjust for 'A'-'F' == 10-15
	cmp.b	#$0A,d0			; 'A'
	blt.w	skip_key
	cmp.b	#$0F,d0			; 'F'
	bgt	skip_key

is_number:
	move.l	EditDataPtr(a5),a0	; Load pointer to data
	clr.l	d1					
	move.w	cur_edit_reg(a6),d1	; Load the nibble bieng edited
	move.l	d1,d3			; Save a copy
	lsr.l	#1,d1			; Find the offset to the nibble in memory
	add.l	d1,a0
	move.b	(a0),d2			; Load the affected byte
	
	move.b	#$F0,d1			; Setup edit mask (keep high nibble)
	btst.b	#0,d3			; Test for high nibble
	bne	no_shift
	lsr.b	#4,d1			; Shift mask (keep low nibble)
	lsl.b	#4,d0			; ...
no_shift:
	and.b	d1,d2			; Delete old data
	or.b	d0,d2			; Install new data
	move.b	d2,(a0)			; Store new value in memory

	bra 	edit_right		; Shift cursor and draw changes

Escape:
	addq	#4,a7			; Tear off return addr
	bra	attempt_escape

Enter:
	addq	#4,a7			; Tear off return addr
	bra	return_to_program

Apps:
	not.w	is_Editing(a6)		; Turn editing on/off
	rts

Trace:
	addq	#4,a7			; Tear off return addr
	ori.w	#TRACE,XSR(a6)		; Turn on trace bit in the program's SR
	bra	return_to_program

