;
; Raven 68K Debugger
; Copywrite Bryan Turner 1997
;
;*****************************************************
; Memory Display and Edit
;*****************************************************
hexed_mod_start:
;ModuleInit
	dc.w	hex_mod_init-hexed_mod_start
;PrevModule
	dc.w	hexed_mod_start-reged_mod_start
;NextModule
;	dc.w	find_mod_start-hexed_mod_start	*** Uncomment when Find is available
	dc.w	0
;DisplayProc
	dc.w	draw_hex_display-hexed_mod_start
;VarOffset
	dc.w	hexed_vars-hexed_mod_start
;Editable
	dc.b	1
;EditOffset
	dc.b	$10
;EditMod
	dc.w	$7F
;EditDataPtr
	dc.l	0
;CharArray
	; CharArray.w [0] == Character Code (word)
	;             [1] == Offset to proc from module pointer (a5)
	dc.w	$0152,key_up-hexed_mod_start
	dc.w	$0158,key_down-hexed_mod_start
	dc.w	$1152,key_up2-hexed_mod_start
	dc.w	$1158,key_down2-hexed_mod_start
	dc.w	$2152,key_up3-hexed_mod_start
	dc.w	$2158,key_down3-hexed_mod_start
	dc.w	$4152,key_up4-hexed_mod_start
	dc.w	$4158,key_down4-hexed_mod_start
	dc.w	$FFFF,hex_key_do-hexed_mod_start
	dc.w	0
hexed_vars:
;bookmarks
	dc.l	0
	dc.l	0
	dc.l	0
	dc.l	$020000		; End of RAM (easier to find Fargo and Raven)
	dc.l	$005340		; Beginning of useful TI-OS globals
	dc.l	$0078B4		; Beginning of user heap
	dc.l	$400000		; Beginning of ROM
	dc.l	$600000		; TI-92 Ports

hex_mod_init:
	clr.w	cur_edit_reg(a6)		; Reset the edit register
	rts

draw_hex_display:
	move.w	#$2600,sr			; Disable interrupts for faster drawing (if keys are held down, it's much slower)
	move.w	#$00FF,-(a7)			; Prepare stack for putchar() command
	move.w	#$0000,-(a7)
	move.w	#$00FF,-(a7)
	move.w	#4,-(a7)
	subq.l	#4,a7

	move.l	EditDataPtr(a5),a2		; Load address to draw
	clr.l	(a7)				; First Row & column
	moveq	#14,d3				; Draw 15 lines
	clr.w	cur_char_num(a6)
hex_loop_1:
	move.w	is_Editing(a6),d6		; Quick Hack fix - do better when fast 8pt display is available
	clr.w	is_Editing(a6)			; Don't count address characters!
	move.l	a2,d0				; Load address
	bsr	put6hex				; Draw address
	add.w	#6,(a7)				; Add a space
	move.w	d6,is_Editing(a6)

	move.l	(a2)+,d0			; Load long word
	bsr	put8hex				; Draw long word
	add.w	#6,(a7)				; Add a space
	
	move.l	(a2)+,d0			; Load long word
	bsr	put8hex				; Draw long word
	add.w	#6,(a7)				; Add a space

	subq	#8,a2				; Restore a0 to beginning of line
	moveq	#7,d5				; Draw 8 characters

draw_ascii_lup:
	move.b	(a2)+,d0
	cmp.b	#$20,d0				; Smaller than a space
	blt	draw_dot
	cmp.b	#$7E,d0				; Bigger than a tilde '~'
	bgt	draw_dot
	bra	draw_char
draw_dot:
	move.b	#$2E,d0				; If it's non-printable, draw a dot
draw_char:
	move.w	d0,-(a7)
	bsr	putchar
	addq	#2,a7
	add.w	#6,(a7)
	dbra	d5,draw_ascii_lup
		
	add.w	#8,2(a7)			; Next line
	clr.w	(a7)				; Beginning of line
	dbf.w	d3,hex_loop_1

	lea	12(a7),a7			; Pop putchar stuff off stack
	rts

put6hex:
	move.l	(a7)+,a4			; Save return address
	moveq	#12,d7
	rol.l	d7,d0				; Shift data into place
	move.l	d0,d7				; Save data
	moveq	#5,d5				; Draw 6 characters
	bra	putlup
put8hex:
	move.l	(a7)+,a4			; Save return address
	rol.l	#4,d0				; Shift data into place
	move.l	d0,d7				; Save data
	moveq	#3,d5				; Draw 8 characters
	move.l	a4,a3				; Move the return address to another register
	lea	continue8(pc),a4		; Jump to continue8 when it's done 4 characters...
putlup:
	andi.w	#$000F,d0			; Word size needed to clear hi byte too
	lea	hex_chars(a6),a0		; Load hex chars
	move.b	0(a0,d0.w),d0			; Get proper hex char

	move.w	d0,-(a7)

	tst.b	is_Editing(a6)			; If we are editing...
	beq	regular_char
	move.w	cur_char_num(a6),d0
	addq.w	#1,cur_char_num(a6)
	cmp.w	cur_edit_reg(a6),d0
	bne	regular_char
	clr.w	6(a7)				; Hilight char
regular_char:
	bsr	putchar				; Draw the hex char
	move.w	#4,6(a7)			; Unhilight
	
	lea	2(a7),a7
	addq.w	#6,(a7)				; Move over one column

	rol.l	#4,d7				; Shift new data into place
	move.l	d7,d0				; Restore display data for next pass
	dbra	d5,putlup			; Loop back

	add.w	#6,(a7)				; Add a space
	jmp	(a4)
continue8:
	move.l	a3,a4
	addq.w	#2,(a7)
	moveq	#3,d5
	bra	putlup

hex_key_do:
	move.l	d0,d1			; Copy key code value
	and.w	#$0FFF,d1		; Mask off modifiers
	sub.w	#$010C,d1		; The function keys
	bcs	hex_end_key
	cmp.w	#8,d1
	bcc	hex_end_key
	lsl.w	#2,d1
	and.w	#$F000,d0
	beq	goto_bookmark
make_bookmark:				; A2 contains a pointer to our variables!
	move.l	EditDataPtr(a5),0(a2,d1.w)	; Store the bookmark
	rts
goto_bookmark:
	move.l	0(a2,d1.w),EditDataPtr(a5)	; Load a bookmark
hex_end_key:
	rts

key_up4:
	sub.l	#$10000-$1000,(a3)	; A3 points to our data pointer on key entry
key_up3:
	sub.l	#$1000-$100,(a3)
key_up2:
	sub.l	#$100-8,(a3)
key_up:
	sub.l	#8,(a3)			; Compressed arithmatic is inefficient in time, but
	rts				;    VERY efficient in size.

key_down4:
	add.l	#$10000-$1000,(a3)	; A3 points to our data pointer on key entry
key_down3:
	add.l	#$1000-$100,(a3)
key_down2:
	add.l	#$100-8,(a3)
key_down:
	add.l	#8,(a3)
	rts


