;----------------------------------------------------------------------------
; check_cmem()
;
; Function: Checks if there are enough memory free for
;           compression ( 2560 B needed ) **AND** for evaluating 
;	    compressed size ( 1140 needed )
;
; Input:    A0   = Pointer to data which will be compressed
;	    D0.W = Length of data which will be compressed
;
; Output:   D0.W = 0 if NOT enough memory
;         
;
;----------------------------------------------------------------------------
complib::check_cmem	equ	complib@0000

;----------------------------------------------------------------------------
; check_emem()
;
; Function: Checks if there are enough memory free for
;           extraction 
;
; Input:    A0   = Pointer to compressed data
;
; Output:   D0.W = 0 if NOT enough memory
;
;----------------------------------------------------------------------------
complib::check_emem	equ	complib@0001

;----------------------------------------------------------------------------
; eval_cmem()
;
; Function: Evaluates the mem size of the compressed file.
;
; Input:    A0   = Pointer to datas which will be compressed 
;	    D0.L = Length of datas which will be compressed
;
; Output:   D0.W = mem size of datas when they will be compressed
;           D0.W = 0 if NOT enough memory ( check_cmem prevents this error )
;----------------------------------------------------------------------------
complib::eval_cmem	equ	complib@0002

;----------------------------------------------------------------------------
; eval_emem()
;
; Function: Evaluates the mem size of the extracted file.
;
; Input:    A0   = Pointer to datas which will be uncompressed 
;
; Output:   D0.W = mem size of datas when they will be uncompressed
;----------------------------------------------------------------------------
complib::eval_emem	equ	complib@0003

;----------------------------------------------------------------------------
; compress()
;
; Function: compress data
;
; Input:    A0   = Pointer to uncompressed data
;           A1   = Pointer to where the compressed data should be stored
;	    D0.W = Length of datas which will be compressed
;
; Output:   D0.W = 0 if NOT enough memory ( check_cmem prevents this error )
;----------------------------------------------------------------------------
complib::compress	equ	complib@0004

;----------------------------------------------------------------------------
; extract()
;
; Function: Extracts data ( in fact same routine as hufflib's one )
;
; Input:    A0   = Pointer to compressed data
;           A1   = Pointer to where the uncompressed data should be stored
;
; Output:   D0.W = 0 if NOT enough memory ( check_emem prevents this error )
;----------------------------------------------------------------------------
complib::extract	equ	complib@0005

