;***********************************************************************
;                            TEXTSURFER 1.B
;  utilitaire - viewer de textes (en chantier)
;***********************************************************************
        @program        code,titre
        include         macros.h
        code:
                jsr     flib[clr_scr]
                bsr     present
                lea     sauveg(pc),a5
                clr.l   (a5)
                bsr     getfolder
                rts
;***********************************************************************
        
        getfolder:
                move.l  #$5D42,a0  ;get the address of the "fat"
                move.l  (a0),a1    
                add.l   #44,a1     ;get the address of handle 11 (folders)
                move.l  (a1),a2    ;go to this handle
                move.l  (a2),d7    ;nmax set (number of folders )
                lea     sauveg(pc),a5  ;get the last menu state
                move.w  (a5)+,d6   ;get the first folder of the list
                move.w  (a5),d5    ;get the highlighted line
                bsr     affich     ;display the list

        boucleclav:
                clr.w   d1               ;set the line to highlight
                move.w  d5,d2
                bsr     bande            ;highlighting procedure
                jsr     flib[idle_loop]  ;wait... with APD
                clr.w   d1               ;set the line
                move.w  d5,d2
                bsr     bande            ;unhighlight the line
                cmp.w   #264,d0          ;cases : exit
                beq     done
                cmp.w   #344,d0
                beq     tstdown          ;move down
                cmp.w   #338,d0
                beq     tstup            ;move up
                cmp.w   #13,d0
                beq     getvar           ;select a text
                cmp.w   #340,d0
                beq     getvar           ;left arrow do the same
                cmp.w   #268,d0
                beq     previeu
                bra     boucleclav       ;else...play it again
        done:   rts                      ;bye

        previeu:
                clr.l   d3
                lea     previous,a6
                move.w  (a6),d3
                bsr     testvar
                tst.b   d0
                beq     desole
                bsr     present2
                move.w  (a6),d1
                bra     chinte
        desole:  
                WriteStr        #35,#25,#4,sorry
                bra     boucleclav

        tstdown:                         ;move down
                move.w  d7,d1
                subq.w  #1,d1
                sub.w   d6,d1
                cmp.w   d5,d1            ;can we ?
                beq     boucleclav       ;no
                cmp.w   #5,d5            ;is the line at the bottom
                beq     exep             ;if so it's a different proc
                addq.w  #1,d5            ;move down the line
                bra     boucleclav       ;get back
        exep:   addq.w  #1,d6            ;change the first name of the list
                bsr     affich           ;display the new list
                bra     boucleclav       ;get back

        tstup:  tst.w   d5          ;move up
                beq     exep2       ;if the line is at the top it's different
                subq.w  #1,d5       ;change the line
                bra     boucleclav  ;get back
        exep2:  tst.w   d6          ;can we ?
                beq     boucleclav  ;no
                subq.w  #1,d6       ;change the first name of the list
                bsr     affich      ;display the new list
                bra     boucleclav  ;get back


        affich:                     ;display the list
                clr.l   d1          ;want to clean the menu on the right
                bsr     effac       ;clean the menu
                move.l  (a1),a2     ;get the address of the 11th handle
                addq.l  #4,a2       ;go to the first string
                move.w  d6,d4       ;get the number of the first name of list
                mulu    #3,d4       
                lsl.l   #2,d4       ;numberX12 (12 bytes per folder)
                add.l   d4,a2       ;so we get the address
                move.l  d7,d4       ;set the number of loop
                subq.w  #1,d4
                move.w  #55,d3      ;position in the screen
                cmp.w   #5,d4       ;case
                bhi     corrig
        loop:   
                move.w  #1,-(a7)
                pea     (a2)
                move.w  d3,-(a7)
                move.w  #50,-(a7)
                jsr     romlib[puttext]   ;write
                lea     10(a7),a7
                add.w   #10,d3      ;change of line
                add.w   #12,a2      ;next address
                dbf.w   d4,loop     ;loop
                tst.w   d6          ;if there is somthing more up
                bne     ecrihaut    ;then write an arrow
                goon:
                move.w  d7,d4       ;is there something more down ?
                sub.w   d6,d4
                cmp.w   #6,d4
                bhi     ecribas     ;if so write an arrow
                rts                 ;get back
        corrig: moveq.b #5,d4       ;if folder>6 display only 6
                bra     loop
        ecribas:                    ;arrow "down"
                WriteStr        #40,#105,#1,bas
                rts
        ecrihaut:                   ;arrow "up"
                WriteStr        #40,#55,#1,haut
                bra     goon
;***********************************************************************
        getvar:
                move.w  d5,(a5)
                move.w  d6,-(a5)
                clr.w   d1          ;line on the right
                move.w  d5,d2       ;at the right position
                bsr     bande       ;keep the highlight
                moveq.w #1,d4       ;start with the line at the top
                add.w   d5,d6       ;get the number of selected folder
                move.l  #$5D42,a0
                move.l  (a0),a1
                add.l   #44,a1
                move.l  (a1),a2
                addq.l  #4,a2
                add.l   #11,a2      ;get the handle of the "main" handle
                mulu    #3,d6
                lsl.l   #2,d6
                add.w   d6,a2       ;get the number of the folder's handle
                clr.l   d5          
                move.b  (a2),d5     ;record it
                move.l  (a0),a1
                lsl.l   #2,d5
                adda.l  d5,a1       ;get the address
                move.l  (a1),a2
                addq.w  #2,a2       ;go to the address
                move.w  (a2),d7     ;number of variables in the folder
                tst.w   d7          ;if any...
                beq     vide        ;else...
                bsr     getmax      ;get the number of text among those var
                tst.w   d4          ;if any...
                beq     vide        ;else...
                clr.l   d6          ;start with the first text
                clr.l   d5          ;and with the line up
                bsr     affich2     ;display the list

        clavbcl:                    ;hook
                moveq.w #1,d1       ;on the right this time
                move.w  d5,d2
                bsr     bande       ;highlight
                jsr     flib[idle_loop]
                moveq.w #1,d1
                move.w  d5,d2
                bsr     bande       ;unhighlight
                cmp.w   #264,d0
                beq     back
                cmp.w   #337,d0
                beq     back
                cmp.w   #344,d0
                beq     testd
                cmp.w   #338,d0
                beq     testu
                cmp.w   #13,d0
                beq     readtext
                cmp.w   #269,d0
                beq     deflate
                bra     clavbcl

        vide:   WriteStr        #132,#55,#1,riend
                move.w  #1,d1            ;if empty
                move.w  #0,d2            ;display "..." and return
                bsr     bande
                jsr     flib[idle_loop]
        back:   moveq.w #1,d1
                bsr     effac
                bra     getfolder

        testd:  tst.w   d4               ;same kind of test than before
                beq     clavbcl
                move.w  d4,d1
                subq.w  #1,d1
                sub.w   d6,d1
                cmp.w   d5,d1
                beq     clavbcl
                cmp.w   #5,d5
                beq     exep1
                addq.w  #1,d5
                bra     clavbcl
        exep1:  addq.w  #1,d6
                bsr     affich2
                bra     clavbcl

        testu:  tst.w   d5               ;idem
                beq     exep3
                subq.w  #1,d5
                bra     clavbcl
        exep3:  tst.w   d6
                beq     clavbcl
                subq.w  #1,d6
                bsr     affich2
                bra     clavbcl
      
      affich2:  moveq.l #1,d1            ;display the list
                bsr     effac            ;clean the menu on the right side
                move.l  a2,a3            ;address of sart
                addq.l  #1,a3
                bsr     count            ;find the next text in list
                clr.w   d1               ;text flag
                moveq.w #1,d2
                subq.l   #1,a3
      next4:    add.l   #12,a3
                clr.l   d3
                move.w  (a3),d3
                bsr     testvar
                cmp.w   #1,d0
                beq     ecrila
      retour:   cmp.w   d2,d7
                beq     done
                addq.w  #1,d2
                bra     next4
                        
      ecrila:   addq.w  #1,d1
                movem.l a3/d1-d3,-(a7)
                sub.l   #10,a3
                lsl.w   #1,d1
                move.w  d1,d3
                lsl.w   #2,d1
                add.w   d3,d1
                add.w   #45,d1
                move.w #1,-(a7)
                pea     (a3)
                move.w  d1,-(a7)
                move.w  #132,-(a7)
                jsr     romlib[puttext]
                lea     10(a7),a7
                movem.l (a7)+,a3/d1-d3
                cmp.w   #6,d1
                beq     fait
                bra     retour
      fait:     tst.w   d6
                bne     ecrih
                gaon:
                move.w  d4,d1
                sub.w   d6,d1
                cmp.w   #6,d1
                bhi     ecrib
                rts
        ecrib:
                WriteStr        #200,#105,#1,bas
                rts
        ecrih:
                WriteStr        #200,#55,#1,haut
                bra     gaon


        count:  tst.w   d6
                beq     done
                clr.w   d2 
                subq.l  #1,a3
        turn:   add.l   #12,a3
                clr.l   d3
                move.w  (a3),d3
                bsr     testvar
                cmp.w   #1,d0
                bne     turn
                addq.w  #1,d2
                cmp.w   d2,d6
                bne     turn
                addq.l  #1,a3
                rts

        getmax:
                move.l  a2,a3               ;Ntext dans d4
                clr.w   d4
                moveq.w #1,d2
                ;addq.l  #1,a3
        next3:
                add.l   #12,a3
                clr.l   d3
                move.w  (a3),d3
                bsr     testvar
                cmp.w   #1,d0
                bne     non
                addq.w  #1,d4
        non:    cmp.w   d2,d7
                beq     done
                addq.w  #1,d2
                bra     next3
        

        testvar:                        ;num du handle dans d3
                move.l  #$5D42,a0
                move.l  (a0),a1
                lsl.l   #2,d3
                add.l   d3,a1
                move.l  (a1),a4
                clr.l   d3
                move.w  (a4),d3
                add.l   d3,a4
                addq.l  #1,a4
                move.b  (a4),d3
                moveq.w #1,d0
                cmp.b   #$E0,d3
                beq     true            ;1 dans d0 si c'est un texte
                clr.w   d0
          true: rts
;***********************************************************************
        bande:  move.l  #$4A9A,a6
                mulu    #10,d1
                add.l   d1,a6

                move.w  d2,d3   ;d2*300
                lsl.w   #8,d2
                lsl.w   #2,d3
                sub.w   d3,d2
                lsl.w   #2,d3
                add.w   d3,d2
                lsl.w   #1,d3
                add.w   d3,d2
                add.l   d2,a6

                moveq.w #8,d2
        boucle: not.l   (a6)+
                not.l   (a6)+
                add.l   #22,a6
                dbf.w   d2,boucle
                rts

        effac:  move.l  #$4A9A,a6
                mulu    #10,d1
                add.l   d1,a6
                move.w  #60,d2
        rond:   clr.l   (a6)+
                clr.l   (a6)+
                add.l   #22,a6
                dbf.w   d2,rond
                WriteStr        #40,#105,#3,rien
                WriteStr        #40,#55,#3,rien
                WriteStr        #200,#105,#3,rien
                WriteStr        #200,#55,#3,rien
                rts
                
;***********************************************************************
        present:
                jsr     flib[clr_scr]
                SetFont #2
                WriteStr        #65,#10,#1,titre
                WriteStr        #48,#40,#1,folder
                WriteStr        #128,#40,#1,varia
                SetFont #1
                WriteStr        #27,#25,#1,sstitre

                move.w  #32,d1
                move.w  #36,d2
                move.w  #208,d3
                bsr     linehoriz
                move.w  #115,d2
                bsr     linehoriz
                move.w  #52,d2
                bsr     linehoriz
                move.w  #36,d2
                move.w  #115,d3
                bsr     linevert
                move.w  #208,d1
                bsr     linevert
                move.w  #120,d1
                bsr     linevert
                rts

        linehoriz:
                move.w  d1,d4
        next:   move.w  d2,-(a7)
                move.w  d1,-(a7)
                jsr     flib[pixel_on]
                lea     4(a7),a7
                add.w   #1,d1
                cmp.w   d1,d3
                bne     next
                move.w  d4,d1
                rts
        linevert:
                move.w  d2,d4
        next2:  move.w  d2,-(a7)
                move.w  d1,-(a7)
                jsr     flib[pixel_on]
                lea     4(a7),a7
                add.w   #1,d2
                cmp.w   d2,d3
                bne     next2
                move.w  d4,d2
                rts
;***********************************************************************
        readtext:       
                bsr     present2
                
                move.l  a2,a3
                addq.l  #1,a3
                add.w   d5,d6
                addq.w  #1,d6
                bsr     count
                bsr     present3
                clr.l   d1
                subq.l  #1,a3
                move.w  (a3),d1         ;<<nom recup
                lea     previous(pc),a6
                move.w  d1,(a6)
        chinte: move.l  #$5D42,a0
                move.l  (a0),a1
                lsl.w   #2,d1
                add.w   d1,a1
                move.l  (a1),a2
                addq.l  #5,a2         
                clr.w   d0
                lea     handle(pc),a6
                move.w  #0,(a6)
                move.b  (a2),d1
                cmp.b   #1,d1
                beq     huffer

        donut:  clr.w   d4
                bsr     affich3


        clav:   jsr     flib[idle_loop]
                cmp.w   #344,d0
                beq     baisse
                cmp.w   #338,d0
                beq     hausse
                cmp.w   #264,d0
                beq     exit
                cmp.w   #340,d0
                beq     baisvit
                cmp.w   #337,d0
                beq     hausvit
                bra     clav
        

        hight:  swap    d0
                move.l  #$4620,a4
                lsl.l   #4,d2
                move.l  d2,d6
                lsl.l   #4,d2
                sub.l   d6,d2
                adda.l  d2,a4
                lsl.l   #1,d1
                move.l  d1,d6
                lsl.l   #2,d1
                sub.l   d6,d1
                addq.w  #4,d1
                move.w  #5,d0
        lian:   move.l  a4,a0
                addq.w  #1,d1
                move.w  d1,d6
                move.w  d6,d2 
                lsr.w   #3,d6             
                adda.l  d6,a0
                not.b   d2
                and.b   #7,d2
                move.w  #7,d6
        ping:   lea     30(a0),a0
                bchg.b  d2,(a0)
                dbf.w   d6,ping
                dbf.w   d0,lian
                clr.w   d6
                swap    d0
                rts



        baisse: tst.b   d6
                bne     clav
                addq.b  #1,d4
                move.l  #$4628,a4
                move.l  #$4718,a5
                move.w  #724,d0
        copy:   move.l  (a5)+,(a4)+
                dbf.w   d0,copy
                move.w  #59,d0
        clear:  clr.l   (a4)+
                dbf.w   d0,clear
                move.w  d4,d1
                add.w   #12,d4
                bsr     genius
                move.w  d1,d4
                move.w  #12,d5
                bsr     ronde
                bra     clav

        hausse: tst.b   d4
                beq     clav
                subq.b  #1,d4
                move.l  #$526E,a4
                move.l  #$517E,a5
                move.w  #722,d0
        copy2:  move.l  -(a5),-(a4)
                dbf.w   d0,copy2
                move.w  #63,d0
        clear2: clr.l   -(a4)
                dbf.w   d0,clear2
                bsr     genius
                clr.w   d5
                bsr     ronde
                bra     clav
        baisvit:        
                tst.b   d6
                bne     clav
                add.b   #13,d4
                bsr     affich3
                bra     clav
        hausvit:
                cmp.b   #12,d4
                bls     hoho
                sub.b   #13,d4
                bsr     affich3
                bra     clav
        hoho:   clr.w   d4 
                bsr     affich3
                bra     clav

        affich3:
                move.l  #$4628,a5
                move.w  #784,d1
                clr.l   d0
        clr:    move.l  d0,(a5)+
                dbf.w   d1,clr
                clr.w   d5
                bsr     genius
        lissa:  bsr     ronde
                cmp.w   #1,d6
                beq     done
                cmp.w   #13,d5
                beq     done
                bra     lissa

        genius: move.l  a2,a6   
                tst.w   d4
                beq     done
                subq.l  #1,a6
                clr.l   d3
                move.w  d4,d0
                subq.w  #1,d0
                move.b  #$0D,d7
        dogf:   cmp.b   (a6)+,d7
                beq     fdeligne
                cmpi.b  #35,(a6)
                beq     dogf    
                addq.b  #1,d3
                cmp.b   #38,d3
                bne     dogf
     fdeligne:  bsr     tester
                clr.b   d3
                dbf.w   d0,dogf
                bsr     tester
                addq.w  #1,a6
                rts
     tester:    cmpi.b  #$0D,(a6)
                bne     done
                addq.w  #1,a6
                rts
             
        ronde:  addq.b  #1,d5
                lea     phrase(pc),a4
                clr.w   d3
                clr.w   d6
                move.b  #$0D,d7
        flie:   cmp.b   (a6),d7
                beq     tuti
                cmp.b   #35,(a6)
                beq     diese
                move.b  (a6)+,(a4)+
                addq.b  #1,d3
                tst.b   (a6)
                beq     tuti
                cmp.b   #38,d3
                bne     flie
        tuti:   clr.b   (a4)
                move.w  d5,d1
                lsl.w   #3,d1
                add.b   #9,d1
                WriteStr        #5,d1,#4,phrase
                bsr     inverse
                clr.w   d6
                tst.b   (a6)
                beq     posit
                cmpi.b  #38,d3
                beq     done
                addq.l  #2,a6
                rts
        posit:  moveq.w #1,d6
                rts
        diese:  addq.l  #1,a6
                cmp.w   #0,d6
                beq     diese2
                addq.w  #1,d6
                bra     flie
        diese2: move.w  d3,d6
                swap    d6
                move.w  #1,d6
                bra     flie
        inverse:
                tst.w   d6
                beq     done
                tst.w   d3
                beq     done
                move.l  a6,a5
                clr.l   d7
                move.w  d3,d7
                add.w   d6,d7
                swap    d6
                cmp.w   d6,d3
                beq     done
                sub.w   d6,d7
                subq.l  #1,d7
                sub.l   d7,a5
                move.w  d6,d0
                subq.l  #1,d7
                clr.l   d6
                move.w  d0,d1
                subq.w  #1,d5
                
        fizz:   cmp.b   #35,(a5)+
                beq     fazz
                tst.w   d6
                beq     gras
        reto2:  addq.b  #1,d0  
                dbf.w   d7,fizz
                addq.w   #1,d5
                rts

        fazz:   not.w   d6
                subq.w  #1,d0
                bra     reto2
        gras:   move.w  d0,d1
                move.w  d5,d2
                bsr     hight
                bra     reto2

        present2:
                jsr     flib[clr_scr]
                clr.w   d1
                move.w  #15,d2
                move.w  #240,d3
                bsr     linehoriz
                SetFont #0
                WriteStr        #140,#123,#0,keys
                SetFont #2
                WriteStr        #5,#3,#4,titre
                SetFont #1
                rts
        present3:
                move.l  a3,a4
                sub.l   #11,a4
                move.w  #0,-(a7)
                pea     (a4)
                move.w  #3,-(a7)
                move.w  #155,-(a7)
                jsr     romlib[puttext]
                lea     10(a7),a7
                rts
;***********************************************************************
        huffer: bsr     unhuff
                bra     donut
        
        unhuff: sub.l   #3,a2
                clr.l   d0
                move.w  (a2),d0

                addq.l  #2,d0
                move.l  d0,-(a7)
                jsr     romlib[create_handle]
                add.l   #$04,a7
                tst.w   d0
                beq     nomem
                lea     handle(pc),a6
                move.w  d0,(a6)

                handle_ptr      d0,a3
                jsr     hufflib[check_mem]
                tst.w   d0
                beq     nomem
                add.l   #2,a2
                move.l  a2,a0
                move.l  a3,a1
                jsr     hufflib[extract]
                move.l  a3,a2
                add.l   #5,a2
                rts

        exit:   lea     handle(pc),a6
                clr.w   d0
                move.w  (a6),d0

                cmp.w   #0,d0
                beq     code
                move.w  d0,-(a7)
                jsr     romlib[destroy_handle]
                lea     2(a7),a7

                bra     code

        nomem:  jsr     flib[clr_scr]
                SetFont #2
                WriteStr        #4,#60,#1,cannot
                jsr     flib[idle_loop]
                bra     code

        deflate:
                move.l  a2,a3
                addq.l  #1,a3
                add.w   d5,d6
                addq.w  #1,d6
                bsr     count
                clr.l   d1
                clr.w   d3
                sub.l   #1,a3
                move.l  a3,a4
                move.w  (a3),d1 
                move.w  d1,d3
                move.l  #$5D42,a0
                move.l  (a0),a1
                lsl.w   #2,d1
                add.w   d1,a1
                move.l  (a1),a2
                addq.l  #5,a2         
                clr.w   d1
                move.b  (a2),d1
                cmp.b   #1,d1
                bne     code
                bsr     unhuff
                lea     handle(pc),a6
                move.w  (a6),d1
                ;sub.l   #1,a4
                move.w  d1,(a4)

                move.w  d3,-(a7)
                jsr     romlib[destroy_handle]
                lea     2(a7),a7
                jsr     flib[clr_scr]
                SetFont #2
                WriteStr        #100,#60,#0,reussi
                jsr     flib[idle_loop]
                bra     code

;***********************************************************************
; STRINGS

titre dc.b "TextSurfer 2.0 ",26,0
sstitre dc.b 16," F1 - Previous  ",16," F2 - Extract",0
folder dc.b "Folder",0                          
varia dc.b "Variable",0
bas dc.b 20,0
haut dc.b 19,0
rien dc.b " ",0
phrase ds.b 40
keys dc.b 19,20," OR ",17,18," (PAGE)",0
riend dc.b 160,0
sauveg ds.l 1
sorry dc.b "Sorry, impossible",0
previous ds.w 1
handle ds.w 1
cannot dc.b "Not enough memory to extract!"
reussi dc.b "Done."

;***********************************************************************
        reloc_open
                add_library     flib
                add_library     romlib
                add_library     hufflib
        reloc_close
        end

