; Fargo IDE header
;=============================================================================
; Last save: Tue Jan 05 18:40:22  1999
; 64.0 31.0 31.0 31.0 31.0 31.0
;=============================================================================
;=============================================================================;
;                     SHRNKLIB
;                  -------------
;; Copyright (c) David Kuehling 1999
;;
;; This software is provided 'as-is', without any express or implied
;; warranty. In no event will the authors be held liable for any damages
;; arising from the use of this software.

;; Permission is granted to anyone to use this software for any purpose,
;; including commercial applications, and to alter it and redistribute it
;; freely, subject to the following restrictions:

;; 1. The origin of this software must not be misrepresented; you must not
;;    claim that you wrote the original software. If you use this software
;;    in a product, an acknowledgment in the product documentation would be
;;    appreciated but is not required.
;; 2. Altered source versions must be plainly marked as such, and must not be
;;    misrepresented as being the original software.
;; 3. This notice may not be removed or altered from any source distribution.

; Contains the routines for extracting archives that where created by 	      ;
; SHRINK92.EXE.								      ;
;									      ;
; Last Modification: Jan 05 1999					      ;
; 									      ;
;=============================================================================;
 
;=============================================================================;
; shrnklib::OpenArchive							      ;
;-----------------------------------------------------------------------------;
; Opens a SHRINK92 - archive and returns the handle of the archive descriptor ;
; in d0. You need to open any archive with this routine before accessing it.  ;
; The descriptor contains all information, required for archive access. So    ;
; you don't need an archive's address any more after you've opend it.         ;
;-----------------------------------------------------------------------------;
; Input:  a0.l = pointer to the archive to be opened			      ;
; Output: d0.w = archive descriptor handle or zero on error		      ;
;=============================================================================;
shrnklib::OpenArchive	EQU	shrnklib@0000

;=============================================================================;
; shrnklib::CloseArchive						      ;
;-----------------------------------------------------------------------------;
; Closes a SHRINK92 - archive: Frees all memory used by the archive           ;
; descriptor whose handle is given by d0. You have to close any archive that  ;
; you've opened, else you will mess up the calculator's memory.               ;
;-----------------------------------------------------------------------------;
; Input:  d0.w = handle of archive descriptor				      ;
; Output: archive descriptor is destroyed, the archive descriptor handle      ;
;         becomes invalid and can't be used any more     		      ;
;=============================================================================;
shrnklib::CloseArchive	EQU	shrnklib@0001

;=============================================================================;
; shrnklib::Extract 							      ;
;-----------------------------------------------------------------------------;
; Extracts one section (file) from an archive. The destination memory region  ;
; is given by a0. If a0 is zero a new memory block with the correct size will ;
; be allocated and its handle be returned in d2.                              ;
;-----------------------------------------------------------------------------;
; Input:  d0.w = handle of archive descriptor				      ;
;	  d1.w = index of section to extract (0 = 1st, 1 = 2nd section etc.)  ;
;         a0.l = address of extraction destination			      ;
;                if it is zero, a new memory block is allocated an a0 is set  ;
;                to its address						      ;
; Output: a0.l = address of extraction destination or zero on error (not      ;
;                enough memory or invalid archive)			      ;
;         d2.w = if input-a0.l was zero: handle of allocated memory block     ;
;                else it stays unchanged				      ;
;=============================================================================;
shrnklib::Extract	EQU	shrnklib@0002


