; Fargo IDE header
;=============================================================================
; Last save: Tue Jan 12 17:59:42  1999
; 20.0 74.4 74.4 74.4 74.4 74.4
;=============================================================================
;; Copyright (c) David Kuehling 1999
;;
;; This software is provided 'as-is', without any express or implied
;; warranty. In no event will the authors be held liable for any damages
;; arising from the use of this software.

;; Permission is granted to anyone to use this software for any purpose,
;; including commercial applications, and to alter it and redistribute it
;; freely, subject to the following restrictions:

;; 1. The origin of this software must not be misrepresented; you must not
;;    claim that you wrote the original software. If you use this software
;;    in a product, an acknowledgment in the product documentation would be
;;    appreciated but is not required.
;; 2. Altered source versions must be plainly marked as such, and must not be
;;    misrepresented as being the original software.
;; 3. This notice may not be removed or altered from any source distribution.
	INCLUDE "tios.h"
	INCLUDE "flib.h"
	INCLUDE "gray7lib.h"
	INCLUDE "shrnklib.h"

	; include file that was automatically created by Shrink92
	INCLUDE "d:\fargo\asm\myprgm\shrnksmp\archive2.inc"

	XDEF	_main
	XDEF	_comment

;-----------------------------------------------------------------------------
; Copy one plane (3840 bytes) from (a1) to (a2)
;-----------------------------------------------------------------------------
CopyPlane:
	move.w	#3840/4-1,d7		; d7 is our counter
\Loop:	move.l	(a1)+,(a2)+
	dbra	d7,\Loop		; loop back until d7 reaches -1
	rts

;-----------------------------------------------------------------------------
; MAIN
;-----------------------------------------------------------------------------
_main:	jsr	gray7lib::on		; switch 7 shade grayscale on
	tst.l	d0			; if d0.l = zero: failure
	beq	\Error

	; open the archive
	lea	Archive(PC),a0		; load addresss of archive into a0
	jsr	shrnklib::OpenArchive	; return: d0.w = archive descriptor handle

	; extract section #0 that contains all planes
	moveq	#0,d1			; d1 = index of archive section to extract
	movea.l	#0,a0			; a0 = 0: Extract has to allocate memory
	jsr	shrnklib::Extract	; do the extraction
					; ->a0.l points to allocated extraction memory
					; ->d2.l is the handle of that memory block

	jsr	shrnklib::CloseArchive	; close the archive whose handle is given
					; by d0 (d0 is still the descriptor handle)

	; copy plane #2 to gray7lib::plane2
	lea	PICTURE2.1PL(a0),a1	; load address of plane within extracted block
	movea.l	gray7lib::plane2,a2	; load destination address
	bsr	CopyPlane		; copy the plane from (a1) to (a2)

	; copy plane #1 to gray7lib::plane1
	lea	PICTURE1.1PL(a0),a1	; load address of plane within extracted block
	movea.l	gray7lib::plane1,a2	; load destination address
	bsr	CopyPlane		; copy the plane from (a1) to (a2)

	; copy plane #0 to gray7lib::plane0
	lea	PICTURE0.1PL(a0),a1	; load address of plane within extracted block
	movea.l	gray7lib::plane0,a2	; load destination address
	bsr	CopyPlane		; copy the plane from (a1) to (a2)

  	; free the memory that was allocated for extracting section #0
	move.w	d2,-(a7)		; d2 is still the handle (watch Extract)
	jsr	tios::HeapFree
	addq.l	#2,a7

	jsr	flib::idle_loop		; wait for keypress

	jsr	gray7lib::off		; disable 7 shade grayscale

\Error:	rts				; exit program
	

	; shrink archive containing the 3 planes in 1 archive section
Archive:	INCBIN "d:\fargo\asm\myprgm\shrnksmp\archive2.shk"

_comment:	dc.b "Shrink92 Example #2",0

	END

