; Fargo IDE header
;=============================================================================
; Last save: Fri Jan 08 09:12:20  1999
; 33.0 49.4 49.4 49.4 49.4 49.4
;=============================================================================
;; Copyright (c) David Kuehling 1999
;;
;; This software is provided 'as-is', without any express or implied
;; warranty. In no event will the authors be held liable for any damages
;; arising from the use of this software.

;; Permission is granted to anyone to use this software for any purpose,
;; including commercial applications, and to alter it and redistribute it
;; freely, subject to the following restrictions:

;; 1. The origin of this software must not be misrepresented; you must not
;;    claim that you wrote the original software. If you use this software
;;    in a product, an acknowledgment in the product documentation would be
;;    appreciated but is not required.
;; 2. Altered source versions must be plainly marked as such, and must not be
;;    misrepresented as being the original software.
;; 3. This notice may not be removed or altered from any source distribution.
	INCLUDE "flib.h"
	INCLUDE "gray7lib.h"
	INCLUDE "shrnklib.h"

	; include file that was automatically created by Shrink92
	INCLUDE "d:\fargo\asm\myprgm\shrnksmp\archive1.inc"

	XDEF	_main
	XDEF	_comment

_main:	jsr	gray7lib::on		; switch 7 shade grayscale on
	tst.l	d0			; if d0.l = zero: failure
	beq	\Error

	; open the archive
	lea	Archive(PC),a0		; load addresss of archive into a0
	jsr	shrnklib::OpenArchive	; return: d0.w = archive descriptor handle

	; extract plane #2 of picture
	moveq	#PICTURE2.1PL,d1	; d1 = index of archive section to extract
	movea.l	gray7lib::plane2,a0	; extraction destination is plane #2
	jsr	shrnklib::Extract	; do the extraction

	; extract plane #1 of picture
	moveq	#PICTURE1.1PL,d1	; d1 = index of archive section to extract
	movea.l	gray7lib::plane1,a0	; extraction destination is plane #1
	jsr	shrnklib::Extract	; do the extraction

	; extract plane #0 of picture
	moveq	#PICTURE0.1PL,d1	; d1 = index of archive section to extract
	movea.l	gray7lib::plane0,a0	; extraction destination is plane #0
	jsr	shrnklib::Extract	; do the extraction

	jsr	shrnklib::CloseArchive	; close the archive whose handle is given
					; by d0 (d0 is still the descriptor handle)

	jsr	flib::idle_loop		; wait for keypress

	jsr	gray7lib::off		; disable 7 shade grayscale

\Error:	rts				; exit program
	

	; shrink archive containing the 3 planes in 3 archive sections
Archive:	INCBIN "d:\fargo\asm\myprgm\shrnksmp\archive1.shk"

_comment:	dc.b "Shrink92 Example #1",0

	END
