
 ;******************************** Seawar 92 *********************************
 ;;
 ;; Seawar pour		TI-92 avec Fargo II, TI-92+ avec kernel
 ;; Version			0.64
 ;; Programm sur		TI-92 v2.1
 ;;
 ;; Programm par		Christophe Molon-Noblot
 ;; Mail:			ximoon@voila.fr
 ;; URL:			http://ximoon.multimania.com
 ;; ICQ:			97005430
 ;;
 ;****************************************************************************

 ;******************************* commentaires *******************************
 ;;		
 ;; Ceci est mon premier (gros) programme en assembleur.
 ;; C'est d'ailleurs une adaptation en asm de mon premier jeu en
 ;; basic pour ti-92.
 ;; J'ai mis tout plein de commentaires pour les curieux.
 ;;
 ;; Vu que je dcouvrais l'assembleur en programmant, le code n'est pas
 ;; toujours d'une grande finesse... Mais du moment que a marhe ;o)
 ;; 
 ;; Merci de me reporter tout bug (je serais surpris que personne ne trouve
 ;; de vrai bug (abandon du tir sur un bateau touch par exemple) dans la 
 ;; phase de tir de l'ordinateur...) et de ne pas faire de modification
 ;; sans me prvenir.
 ;; 
 ;; Ce jeu existe galement en basic, il est disponible sur www.ticalc.org
 ;;
 ;; Tout joueur doit tre conscient du risque qu'il prend, je ne peux pas tre
 ;; considr comme responsable des dommages que pourrait provoquer ce programme.
 ;; J'spre quand mme que ce jeu ne fera pas crasher trop de machines...
 ;;
 ;****************************************************************************

 ;********************************** le jeu **********************************
 ;;
 ;; Ce jeu ncessite une ti-92 avec Fargo II (V.2.7.1) de David Ellsworth,
 ;; il utilise alors graphlib et gray4lib. Pour TI-92+, il faut un kernel
 ;; et simplement graphlib.
 ;;
 ;; Seawar est une bataille navale qui se joue sur une grille de 10*10
 ;; cases. Chaque joueur doit placer un porte-avions (5 cases), une
 ;; frgate (4 cases), deux destroyers (3 cases) et un sous-marin
 ;; (2 cases). Les bateaux ne peuvent pas se toucher, mme en diagonale.
 ;; Pour placer un bateau, slctionner la case, appuyer sur [enter]
 ;; puis choisir le sens avec les flches. Le gagnant est celui qui
 ;; coule le premier tous les bateaux de son adversaire. Les deux
 ;; joueurs jouent le mme nombre de coups, il peut donc y avoir
 ;; galit.
 ;; Deux modes sont disponible: 1 joueur contre l'ordinateur ou
 ;; 2 joueurs l'un contre l'autre.
 ;; Il est possible de quitter en appuyant sur [esc]  tout moment,
 ;; la partie est alors dfinitivement quitte.
 ;; [lock] quivaut  [enter], [F1] et [F2] permattent de rgler le contraste.
 ;;
 ;; Bon jeu!
 ;;
 ;****************************************************************************

 ;******************************* historique *********************************
 ;;
 ;; Versions basic:
 ;;
 ;; 1997-1999		Versions 1.x
 ;; Pour ti-82 (!!!)
 ;; Mode deux joueur termin, mode 1 joueur non aboutit...  un jour peut-tre
 ;;
 ;; 1999-2000		Versions 2.x
 ;; Pour ti-92/ti-92+
 ;; Modes 1 et 2 joueurs complets
 ;; Dbut d'adaptation pour ti-89
 ;;
 ;; Versions assembleur
 ;;
 ;; Dbut:			13/11/2000
 ;; Dbut du programme ET de mon apprentissage de l'asm
 ;;
 ;; 09/01/2001		V. 0.1	4??? octets
 ;; Traage de la grille
 ;; Menu principal
 ;; Placement des bateaux pour le joueur 1 et l'ordinateur
 ;; Traage des bateaux
 ;;
 ;; 14/01/2001		V. 0.2	4864 octets
 ;; Vrification du placement des bateaux
 ;;
 ;; 30/01/2001		V. 0.3	9??? octets
 ;; Cration de sprites pour les navires
 ;; Rcriture du code d'affichage des bateaux
 ;;
 ;; 05/02/2001		V. 0.4	8??? octets
 ;; Partie placement 1 et 2 joueurs termine
 ;; Suppression des masques pour les sprites
 ;;
 ;; 10/02/2001		V. 0.5	7586 octets
 ;; Tir joueurs 1 et 2 termin
 ;; Fentre de dialogue
 ;; Dbut de l'optimisation
 ;; Mode deux joueurs termin
 ;;
 ;; 05/03/2001		V. 0.6.b	8742 octets
 ;; Tir de l'ordinateur termin
 ;; Premire bta
 ;;
 ;; 04/04/2001		V. 0.62.b	8471 octets
 ;; Modulation du contraste par F1-F2
 ;; Activation de Lock=Enter
 ;; On teind la calculatrice
 ;; Optimisation toujours...
 ;;
 ;; 07/06/2001		V. 0.63.b	7574/7997 (92/92+) octets
 ;; Version 92+
 ;; Optimisation, rorganisation...
 ;;
 ;; 06/07/2001		V. 0.64	7720/7869 octets
 ;; Sauvegarde de la case slectionne
 ;; Adoption de la routine de scannage du clavier d'ExtendeD
 ;; (la mienne marchait sous vti, mais buggait on-calc depuis 
 ;; la version 0.62.b...)
 ;; Dplacement du curseur en diagonale
 ;; !Public released!
 ;;
 ;; Les dernires mises  jours sont toujours disponibles sur mon site: http://ximoon.multimania.com
 ;; J'ai finalement dcid d'ouvrir la source :o)
 ;;
 ;; A faire (peut-tre...):
 ;;
 ;; Jeu par cble? => franchement l, je ne suis pas chaud (j'ai dj essay et abandonn...)
 ;; Version ti-89 (plus tard... a marche,  l'cran prs...)
 ;; Option: choisir ses bateaux?
 ;; Amliorer "l'intelligence" de l'ordinateur (pour a, je sais
 ;; quoi faire, mais pas encore comment le faire... a viendra)
 ;; Sauvegarde de la partie en cours?
 ;; Autre chose? Mail!
 ;;
 ;; Toutes les ides, remarques et autres critiques (constructives)
 ;; sont les bienvenues: ximoon@voila.fr
 ;;
 ;****************************************************************************

 ;**************************** remerciements  ... ***************************
 ;;
 ;; David Ellsworth... mais pourquoi donc?
 ;; La Doors Team pour graphlib
 ;; Toute la communaut de www.ti-fr.org: j'ai beaucoup appris (et
 ;; je me suis bien marr) sur le forum :o)
 ;; Tous ceux qui jouent  ce jeu...
 ;;
 ;; Un grand merci  ExtendeD pour m'avoir initi  l'asm, pour ses tests,
 ;; pour ses routines, pour sa patiente, pour me supporter, enfin bref
 ;; pour son aide en gnral.
 ;;
 ;****************************************************************************

ti92			equ	0			; 92+/89=0, 92=1
curseur		equ	1			; curseur de slection de case: 1=fonc, 0=clair

	ifeq		ti92				; compile pour 92+ et 89 si ti92=0
gray4lib::plane1	equ	graphlib::plane0	; pour ti-89 et 92+
gray4lib::plane0	equ	graphlib::plane1	;
gray4lib::on	equ	graphlib::gray4	;
gray4lib::off	equ	graphlib::gray2	;
tios::FontSetSys	equ	_ROM_CALL_18F	;
tios::DrawStrXY	equ	_ROM_CALL_1A9	;
	include	"DoorsOs.h"			;
	xdef		_ti92plus			;
	xdef		_ti89				;
	endif

	ifne		ti92				; compile pour 92 si ti92=1
	include	"gray4lib.h"		; pour ti-92
	include	"tios.h"			;
	endif

	include	"graphlib.h"		; pour toutes les calcs

	xdef		_main				; adresse du dbut du code
	xdef		_comment			; adresse du commentaire

 ;********************************** macros **********************************

scan	MACRO 
; input: 	ligne,col
; 		a2 pointe sur KbdMat
	btst.b	#\2,\1(a2)
	ENDM

 ;***************************** sous programmes ******************************

 ;****************************** efface l'cran ******************************

 clrscr:

	lea		graphlib::clr_scr,a0	; efface l'cran point par a1

	move.l	gray4lib::plane0,a1 	; slctionne l'cran gris clair
	jsr		(a0)

	move.l	gray4lib::plane1,a1 	; slctionne l'cran gris fonc
	jsr		(a0)

	rts

 ;************************** pour ralentir un brin ***************************

 wait:

	move.w	#$2000,d6

 bcl:

	dbra		d6,bcl

	rts

 ;******************* slctionne une case sur la grille *********************

 selec:

 ; input	a5.w = numro de grille (0 ou 1)
 ; output	a3.w = x
 ; 		a2.w = y	

	ifeq		curseur
	move.l	gray4lib::plane0,a1 		; slctionne l'cran gris clair
	endif

	ifne		curseur
	move.l	gray4lib::plane1,a1 		; il parat que c'est mieux en fonc alors...
	endif

	clr.l		d0
	clr.l		d1

	lea		u1,a0					; permet de remettre sur la case prcdemment choisie
	move.b	joueur,d0
	add		d0,a0
	move.b	(a0),d0
	move.b	2(a0),d1
	move		d0,a3
	move		d1,a2

	lsl.w		#3,d0
	lsl.w		#3,d1

	add		#16,d0
	exg		d0,d5

	moveq		#110,d0
	sub		d1,d0
	exg		d0,d1

	moveq		#6,d2				; largeur
	moveq		#6,d3				; hauteur
	clr.w		d4				; en noir

 boucle:

	bsr		mtrd5

 sgetk:

	move.b	#1,sel
	bsr		getk
	clr.b		sel

	cmp.w		#5,d0
	beq		enterapp2

	tst.w		d0
	beq		sgetk

	bsr		mtrd5

	clr.l		d6
	move.b	vdpl,d6
	ext.w		d6
	add.w		d6,a2
	muls.b	#8,d6
	sub.b		d6,d1

	move.b	hdpl,d6
	ext.w		d6
	add.w		d6,a3
	muls.b	#8,d6
	add.b		d6,d5

 hautapp2:

	cmp.w		#11,a2
	beq		vplus

	bra		basapp2

 vplus:

	moveq		#102,d1
	move.w	#1,a2
	
 basapp2:
	
	cmp.w		#0,a2
	beq		vmoins

	bra		droiteapp

 vmoins:

	moveq		#30,d1
	move.w	#10,a2

 droiteapp:

	cmp.w		#11,a3
	beq		hplus

	bra		gaucheapp

 hplus:

	move.w	#1,a3
	moveq		#24,d5

 gaucheapp:

	cmp.w		#0,a3
	beq		hmoins

	bra		boucle

 hmoins:

	move.w	#10,a3
	moveq		#96,d5

	bra		boucle

 enterapp2:

	bsr		mtrd5

	clr.l		d0

	lea		u1,a0				; sauvegarde la case choisie
	move.b	joueur,d0
	add		d0,a0

	move		a3,d0				; u1.l= xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx
	move		a2,d1				;         x j2     x j1     y j2     y j1
	move.b	d0,(a0)
	move.b	d1,2(a0)

	rts

 mtrd5:

	move		a5,d0
	mulu.w	#110,d0			; ajoute le dcalage entre le grilles
	add.w		d5,d0

	bsr		mtr				; trace le rectangle

	rts

 ;********************************** getkey **********************************

 getk:

	movem.l	a0-a2/d1/d3/d7,-(a7)
	clr.w		vdpl

 ScanKbd:						; keyScan par ExtendeD

	moveq		#9,d0
	lea		KbdMat,a0
	move.w	#%1111111111111110,d3

 SaveRow:

	move.w	d3,$600018
	moveq		#11,d1			; d1=0

 WaitKeys:

	dbra		d1,WaitKeys
	move.b	$60001B,(a0)+
	rol.w		#1,d3
	dbra		d0,SaveRow	

	lea		KbdMat,a2			; dixit: "clair, facile  utiliser, efficace, rapide"

	clr		d0

 gapp:
 
	scan		0,4
	beq		gaucheapp1

 dapp:
 
	scan		0,6
	beq		droiteapp1

 happ:

	scan		0,5
	beq		hautapp1

 bapp:
 
	scan		0,7
	beq		basapp1

 eapp:
 
	scan		0,3
	beq		enterapp1

	scan		6,4
	beq		f1app

	scan		4,4
	beq		f2app

	scan		6,6
	beq		enterapp1

	scan		9,1
	beq		enterapp1

	scan		8,6
	beq		escapp1

	clr.b		ancd0

	btst.b	#1,$60001A			; la touche [ON] est appuye ?
	bne		ScanKbd			

	trap		#4				; si oui teind la calc


	bra		ScanKbd

 f2app:

	moveq		#1,d0				; $9 pour contrastup()

 f1app:

	add.w		#9,d0				; $A pour contrastdown()
	trap		#9				; retourne l'addresse de la romcall dans a0
	jsr		(a0)				; appelle la romcall
	bra		pauserts

 hel:

	scan		0,5
	beq		hautapp1

	scan		0,7
	beq		basapp1

	bra		pauserts

 gaucheapp1:

	moveq		#1,d0
	move.b	#-1,hdpl

	cmp.b		#1,sel
	bne		pauserts

	bra		hel

 droiteapp1:

	moveq		#2,d0
	move.b	#1,hdpl

	cmp.b		#1,sel
	bne		pauserts

	bra		hel

 hautapp1:

	moveq		#3,d0
	move.b	#1,vdpl
	bra		pauserts

 basapp1:

	moveq		#4,d0
	move.b	#-1,vdpl
	bra		pauserts

 escapp1:

	bra		fin2

 enterapp1:

	moveq		#5,d0

 pauserts:
	
	move.w	#$9000,d7

 pausebcl:

	dbra		d7,pausebcl

	cmp.b		ancd0,d0			
	beq		prts				; pour aller plus lentement au touche par touche qu'en laissant appuy

	move.w	#$AFFF,d7

 pausebcl2:

	move.b	d0,ancd0			; quitte  ralentir autant que cela serve...
	dbra		d7,pausebcl2

 prts:

	movem.l	(a7)+,a0-a2/d1/d3/d7
	rts

 ;****************** gnrateur de nombre pseudo-alatoire *******************
 rand:

	move.l	d1,-(a7)
	move.w	rand_seed,d1
	mulu.w	#31421,d1
	add		#6927,d1
	mulu.w	d1,d0
	move.w	d1,rand_seed
	clr.w		d0
	swap		d0
	move.l	(a7)+,d1
	rts

 ;*************************** traage de la grille ***************************

 grille:

	jsr		clrscr			; menu principal

	lea		tios::FontSetSys,a5
	lea		tios::DrawStrXY,a6

	move.w	#2,-(a7)			; empile la taille de caractres la plus grande
	jsr		(a5)				; appelle la fonction FontSetSys

	move.w	#4,-(a7)			; couleur
	pea		ca				; pointeur de la chane de caractre
	move.l	#$0017006F,-(a7)		; abscisse et ordonne
	jsr		(a6)				; appelle la fonction
	addq		#2,a7				; restaure la pile de 2 car on ne change que le dernier paramtre

	move.w	#133,-(a7)			; empile l'abscisse 23+110=133
	jsr		(a6)				; appelle la fonction

	move.w	#1,-(a7)			; empile la taille de police moyenne
	jsr		(a5)				; appelle la fonction FontSetSys

	clr.l		cp
	moveq		#8,d7

 gcoord:

	moveq		#9,d6
	sub.w		d7,d6
	add.w		#48,d6
	move.w	d7,d5
	lsl.w		#3,d5
	add.w		#38,d5

	move.b	d6,cp

	move.w	#4,-(a7)
	pea		cp
	move.w	d5,-(a7)
	move.w	#114,-(a7)
	jsr		(a6) 

	dbra		d7,gcoord

	move.w	#$3130,cp

	move.w	#4,-(a7)
	pea		cp
	move.l	#$006F001E,-(a7)
	jsr		(a6)

	lea		100(a7),a7			; restaure la pile de (2+2+2+4)*10+2-2 car on garde l couleur

	pea		j1				; pointeur de la chane de caractre
	move.l	#$00020002,-(a7)		; abscisse et ordonne
	jsr		(a6)				; appelle la fonction

	move.w	#4,-(a7)

	cmp.b		#1,nbrjoueurs
	beq		grordi

	pea		j2

	bra		grsuite

 grordi:

	pea		dernord

 grsuite:

	move.l	#$0002000C,-(a7)
	jsr		(a6)

	lea		32(a7),a7			; restaure la pile de 2+4+2+2=10 une fois par appel = 30+2 pour FontSetSys

	move.l	gray4lib::plane0,a2
	move.l	gray4lib::plane1,a3

	lea		graphlib::vert,a4
	lea		graphlib::horiz,a5

	move.l	a2,a1				; plane0
	moveq		#1,d7

	clr.w		d0
	clr.w		d1
	move.w	#239,d2
	moveq		#20,d3
	moveq		#2,d4
	jsr		mtr

 contour:

	clr		d0
	clr		d1
	move.w	#239,d2
	moveq		#2,d3				; en noir
	jsr		(a5)

	moveq		#10,d1
	jsr		(a5)

	moveq		#20,d1
	jsr		(a5)

	moveq		#127,d1
	jsr		(a5)

	clr.w		d2
	jsr		(a4)

	move.w	#239,d0
	jsr		(a4)

	moveq		#103,d0
	moveq		#19,d1
	jsr		(a4)

	clr		d5				; premire grille

	move.l	a3,a1				; plane1
	dbra		d7,contour
	moveq		#1,d6

 grext:

	moveq		#29,d1
	moveq		#23,d2
	add		d5,d2
	add		d5,d0
	jsr		(a5)
	
	moveq		#109,d1
	jsr		(a5)

	moveq		#29,d2
	jsr		(a4)

	moveq		#23,d0
	add.w		d5,d0
	jsr		(a4)

	move.l	a2,a1				; plane0
	moveq		#8,d7

	addq		#1,d2
	subq		#1,d1

 grintv:

	add.w		#8,d0
	jsr		(a4)
	dbra		d7,grintv

	moveq		#8,d7

	moveq		#102,d0
	moveq		#109,d1
	moveq		#24,d2

	add		d5,d2
	add		d5,d0

 grinth:

	sub.w		#8,d1
	jsr		(a5)
	dbra		d7,grinth

	move.l	a3,a1				; plane1
	addq		#1,d0
	
	moveq		#110,d5
	dbra		d6,grext

	rts

 ;************ placement des bateaux dans la grille et la matrice ************

 place:

 ; input	a2.w = numro de grille (0 ou 1)
 ;		a0.w = x (1..10)
 ;		a3.w = y (1..10)
 ;		a4.w = gauche(1) droite(2) haut(3) bas(4)
 ;		a5.w = longueur du bateau
 ;		c.w  = valeur  mettre dans la matrice

	movem.l	a0-a5,-(a7)

	move.w	a0,a				; a0 et a3 correspondent en fait aux coordonnes dans la matrice
	move.w	a3,b				; il faut donc trouver les coordonnes graphiques

 debutplace:

	cmp.w		#1,a4				; if a4=1
	bne		ifdroite			; then
	bsr		put				; place les bateaux dans la matrice

 bclgauche:

	sub.w		#1,a				; dplace dans la matrice
	cmp.w		#2,a5				; if a5=2
	beq		fingauche			; then goto fingauche
	sub.w		#1,a5				; else	
	bsr		put				; place les bateaux dans la matrice
	bra		bclgauche

 fingauche:

	bsr		put
	
 ifdroite:

	cmp.w		#2,a4				; if a4=2
	bne		ifhaut			; then		
	bsr		put				; place les bateaux dans la matrice

 bcldroite:

	add.w		#1,a				; dplace dans la matrice
	cmp.w		#2,a5				; if a5=2
	beq		findroite			; then goto findroite		
	sub.w		#1,a5				; else
	bsr		put				; place les bateaux dans la matrice
	bra		bcldroite

 findroite:

	bsr		put				; place les bateaux dans la matrice

 ifhaut:

	cmp.w		#3,a4				; if a4=3
	bne		ifbas				; then
	bsr		put				; place les bateaux dans la matrice

 bclhaut:

	add.w		#1,b				; dplace dans la matrice
	cmp.w		#2,a5				; if a5=2
	beq		finhaut			; then goto finhaut			
	sub.w		#1,a5				; else
	bsr		put				; place les bateaux dans la matrice
	bra		bclhaut

 finhaut:

	bsr		put				; place les bateaux dans la matrice

 ifbas:

	cmp.w		#4,a4				; if a4=4
	bne		endifbas			; then
	bsr		put				; place les bateaux dans la matrice

 bclbas:

	sub.w		#1,b				; dplace dans la matrice
	cmp.w		#2,a5				; if a5=2
	beq		finbas			; then goto finbas					
	sub.w		#1,a5				; else
	bsr		put				; place les bateaux dans la matrice
	bra		bclbas

 finbas:

	bsr		put				; place les bateaux dans la matrice

 endifbas:						; endif

	movem.l	(a7)+,a0-a5
	move.l	a0,a2

	move.b	nbrjoueurs,d7
	add.b		joueur,d7
	cmp.w		#1,d7
	beq		efb

	bsr		putspr

 efb:

	rts						; revient au programme principal

 ;************************* choisit le sens du bateau ************************

 batsens:

	bsr		getk

	tst.w		d0
	beq		batsens
	cmp.w		#5,d0
	bge		batsens

	move.w	d0,a4

	rts

;************************* vrification du placement ************************

 placetest:

 ; input:	a0.w = x (1..10)
 ;		a3.w = y (1..10)
 ;		a4.w = gauche(1) droite(2) haut(3) bas(4)
 ;		a5.w = longueur du bateau
 ;
 ; output:	erreur 1 si mauvais placement 0 sinon

	move.w	d0,-(a7)

	clr.b		erreur			; il n'y a pas d'erreur a priori

 ; on vrifie d'abord que les bateaux ne sortent pas de la grille

	cmp.w		#1,a4
	beq		thoriz			; va  thoriz si vers la droite sinon continue
	cmp.w		#2,a4
	bne		tvert				; on sait que  partir de la ligne suivante le bateau est vers la droite

	move.w	a0,d0				; envoie x dans d0
	add.w		a5,d0				; additionne la longueur  x
	sub.w		#1,d0				; coordonnes de la dernire case du bateau <11

	cmp.w		#11,d0
	bge		testrate

	move.w	d0,d1
	move.w	a0,d0
	move.w	a3,d2
	move.w	d2,d3

	bsr		tstbat

	bra		testok

 thoriz:						; si le bateau va vers la gauche

	move.w	a0,d0				; envoie x dans d0
	add.w		#10,d0			; ajoute 10  d0
	sub.w		a5,d0				; soustrait la longueur  x
	add.w		#1,d0				; coordonnes de la dernire case du bateau >10

	cmp.w		#10,d0
	ble		testrate

	sub.w		#10,d0
	move.w	a0,d1
	move.w	a3,d2
	move.w	d2,d3

	bsr		tstbat

	bra		testok

 tvert:

	cmp.w		#3,a4
	bne		tbas				; va  tbas si vers le bas sinon continue

	move.w	a3,d0				; envoie y dans d0
	add.w		a5,d0				; additionne la longueur  y
	sub.w		#1,d0				; coordonnes de la dernire case du bateau <11

	cmp.w		#11,d0
	bge		testrate

	move.w	d0,d3
	move.w	a0,d0
	move.w	d0,d1
	move.w	a3,d2

	bsr		tstbat

	bra		testok

 tbas:

	move.w	a3,d0				; envoie y dans d0
	add.w		#10,d0			; ajoute 10  d0
	sub.w		a5,d0				; soustrait la longueur  y
	add.w		#1,d0				; coordonnes de la dernire case du bateau >10

	cmp.w		#10,d0
	ble		testrate

	sub.w		#10,d0
	move.w	d0,d2
	move.w	a0,d0
	move.w	d0,d1
	move.w	a3,d3

	bsr		tstbat

	bra		testok

 ; on teste maintenant si les bateaux ne se touchent ni ne se chevauchent

 tstbat:

 ; input: 	d0.w = xmin
 ; 		d1.w = xmax
 ; 		d2.w = ymin
 ; 		d3.w = ymax

	move.w	d0,d4
	sub.w		#1,d4
	move.w	d2,d5
	sub.w		#1,d5
	sub.w		d0,d1
	add.w		#2,d1
	move.w	d1,d0
	sub.w		d2,d3
	add.w		#2,d3

 lbltst1:

	move.w	d0,d1

 lbltst2:

	move.w	d1,a
	add.w		d4,a
	move.w	d3,b
	add.w		d5,b

	jsr		get

	clr.l		d6
	move.w	c,d6

	tst.b		joueur			; if le joueur 1 est actif
	bne		tst1

	ror.w		#8,d6				; dans la matrice	d6.w = 	xxxxxxxx xxxxxxxx
	btst.b	#0,d6				; test du bit			.......x ........		
	bne		tstr

	bra		tstfin

 tst1:

	btst.b	#0,d6				; test du bit			........ .......x	
	bne		tstr	

	bra		tstfin

 tstr:

	move.b	#1,erreur
	bra		tstfin2

 tstfin:

	dbra		d1,lbltst2			; teste toutes les cases en contact, c'es  dire
	dbra		d3,lbltst1			; longueur du bateau*3+6 cases

 tstfin2:

	rts

 testrate:

	move.b	#1,erreur			; si le placement est non autoris

 testok:

	move.w	(a7)+,d0

	rts

 ;************************* criture dans la matrice *************************

 put:

 ; input:
 ; put (a.w,b.w)
 ; c.w = valeur  ajouter

	movem.l 	a0/d0-d2,-(a7)

	lea		matrice,a0			; on charge l'adresse du tableau dans A0
	move.w	a,d0				; on veut la a-me colonne
	move.w	b,d1				; on veut la b-me ligne
	mulu.w	#12,d1			; il y a 12 lments par ligne
	add.l		d1,d0				; on ajoute les indices de ligne et colonne
	lsl.l		#1,d0				; notre tableau est compos de mots
	move.w	c,d2
	or.w		d2,0(a0,d0)			; effectue un OU logique avec c aux coordonnes (a,b)

	movem.l 	(a7)+,a0/d0-d2

	rts

 ;****************************** lit la matrice ******************************

 get:

 ; input:
 ; put (a.w,b.w)
 ; 
 ; output:
 ; c.w = valeur lue  matrice(a,b)

	movem.l 	a0-a6/d0-d7,-(a7)

	lea		matrice,a0			; on charge l'adresse du tableau dans A0
	move.w	a,d0				; on veut la a-me colonne
	move.w	b,d1				; on veut la b-me ligne
	mulu.w	#12,d1			; il y a 12 lments par ligne
	add.l		d1,d0				; on ajoute les indices de ligne et colonne
	lsl.l		#1,d0				; notre tableau est compos de mots
	move.w	0(a0,d0),c			; met la valeur lue dans c

	movem.l 	(a7)+,a0-a6/d0-d7

	rts

 ;***************************** place les sprites ****************************

 putspr:

	movem.l 	a0-a6/d0-d7,-(a7)

 ; input	
 ;		a2.w = x (1..10)
 ;		a3.w = y (1..10)
 ;		a4.w = gauche(1) droite(2) haut(3) bas(4)
 ;		a5.w = longueur du bateau

	moveq		#2,d2
	moveq		#2,d3
	cmp.w		#3,a4
	bne		putnxt
	add.w		a5,a3				; si le bateau va vers le haut, on ajoute sa longueur  y
	bra		putokv

 putnxt:

	cmp.w		#1,a4
	bne		putnxt2
	sub.w		a5,a2				; si il va vers la gauche, on soustrait sa longueur  x
	add.w		#1,a2
	add.w		#1,a3
	bra		putokh
	
 putnxt2:

	add.w		#1,a3
	cmp.w		#2,a4				; va vers la droite?
	bne		putokv
	beq		putokh

 putokh:

	cmp.w		#5,a5				; porte-avions
	bne		ptspr1h
	moveq		#3,d2
	moveq		#5,d3
	lea		phc(pc),a4
	lea		phf(pc),a5
	lea		phm(pc),a6
	bra		ptspr0

 ptspr1h:

	cmp.w		#4,a5				; frgate
	bne		ptspr2h
	moveq		#4,d3
	move.w	#3,d2
	lea		fhc(pc),a4
	lea		fhf(pc),a5
	lea		fhm(pc),a6
	bra		ptspr0

 ptspr2h:

	cmp.w		#3,a5				; destroyers
	bne		ptspr3h
	moveq		#4,d3
	lea		shc(pc),a4
	lea		shf(pc),a5
	lea		shm(pc),a6
	bra		ptspr0

 ptspr3h:

	moveq		#1,d2
	moveq		#3,d3
	lea		nhc(pc),a4			; sous-marin
	lea		nhf(pc),a5
	lea		nhm(pc),a6
	bra		ptspr0

 putokv:

	cmp.w		#5,a5				; porte-avions
	bne		ptspr1
	moveq		#4,d2
	moveq		#5,d3
	lea		pvc(pc),a4
	lea		pvf(pc),a5
	lea		pvm(pc),a6
	bra		ptspr0

 ptspr1:

	cmp.w		#4,a5				; frgate
	bne		ptspr2
	moveq		#5,d3
	lea		fvc(pc),a4
	lea		fvf(pc),a5
	lea		fvm(pc),a6
	bra		ptspr0

 ptspr2:

	moveq		#4,d3
	cmp.w		#3,a5				; destroyers
	bne		ptspr3
	lea		svc(pc),a4
	lea		svf(pc),a5
	lea		svm(pc),a6
	bra		ptspr0

 ptspr3:

	moveq		#1,d2
	moveq		#3,d3
	lea		nvc(pc),a4			; sous-marin
	lea		nvf(pc),a5
	lea		nvm(pc),a6
	bra		ptspr0

 ptspr0:

	move.w	a2,d0				; met x dans d0
	sub.w		#1,d0
	lsl.w		#3,d0
	add.w		#24,d0			; obtient les coordonnes du sprite
	sub.w		d2,d0

	move.b	joueur,d2
	tst.w		d2
	bne		ptstr00
	add.w		#110,d0			; choisit la grille en fonction du joueur

 ptstr00:		

	move.w	a3,d1				; met y dans d1
	moveq		#10,d4
	sub.w		d1,d4
	move.w	d4,d1
	lsl.w		#3,d1
	add.w		#40,d1			; obtient les coordonnes du sprite
	sub.w		d3,d1

	moveq		#1,d4				; pour masquer en blanc -> effacer !!
	move.l	gray4lib::plane1,a1

	movem.w 	d0-d7,-(a7)
	jsr		(a6)				; pseudo-masque
	bsr		mtr
	movem.w 	(a7)+,d0-d7
	move.l	gray4lib::plane0,a1 

	movem.w 	d0-d7,-(a7)
	jsr		(a6)				; pseudo-masque
	bsr		mtr
	movem.w 	(a7)+,d0-d7

	move.l	gray4lib::plane1,a1
	move.l	a5,a0				; addresse du sprite
	move.l	a0,a2				; les sprites sont leurs propres masques
	add.w		#4,a2				; il faut juste sauter les dimensions du sprite
	clr.w		d3
	jsr		graphlib::put_sprite2

	move.l	gray4lib::plane0,a1
	move.l	a4,a0				; addresse du sprite
	move.l	a0,a2
	add.w		#4,a2
	clr.w		d3
	jsr		graphlib::put_sprite2

	movem.l 	(a7)+,a0-a6/d0-d7

	rts

 ;****************************** pseudo-masques ******************************

 ; pour mes sprites, il m'aurait fallu environ 1240 octets de masques... je prfre comme  :o)
 ; l a prend dans les 340 octets soit environ 900 octets d'conomie !

 ; input:		d0.w = x
 ;			d1.w = y

 mtr:							; fait gagner plein de place mais plus lent...

	jsr		graphlib::fill
	rts

 phm:

	addq		#2,d0
	addq		#2,d1
	moveq		#40,d2
	moveq		#8,d3
	bsr		mtr

	moveq		#14,d2
	moveq		#10,d3
	bsr		mtr

	add.w		#27,d0
	add.w		#8,d1
	moveq		#15,d2
	moveq		#2,d3
	bsr		mtr

	add.w		#13,d0
	sub.w		#9,d1
	clr.w		d2
	clr.w		d3

	rts

 fhm:

	addq		#2,d0
	addq		#2,d1
	moveq		#32,d2
	moveq		#6,d3
	bsr		mtr

	add.w		#28,d0
	addq		#7,d1
	moveq		#2,d2
	clr.w		d3
	bsr		mtr

	subq		#4,d0
	sub.w		#8,d1
	clr.w		d2

	rts

 shm:

	addq		#1,d0
	addq		#2,d1
	move		#22,d2
	moveq		#6,d3
	bsr		mtr

	add.w		#24,d0
	addq		#3,d1
	clr.w		d2
	moveq		#1,d3
	bsr		mtr

	sub.w		#9,d0
	subq		#4,d1
	clr.w		d3

	rts

 nhm:

	add.w		#8,d0
	addq		#1,d1
	clr.w		d2
	moveq		#6,d3
	bsr		mtr

	add.w		#8,d0
	addq		#3,d1
	clr.w		d3

	rts

 pvm:

	addq		#1,d0
	addq		#2,d1
	moveq		#10,d2
	moveq		#8,d3
	bsr		mtr

	addq		#1,d0
	add.w		#9,d1
	moveq		#9,d2
	moveq		#31,d3
	bsr		mtr

	add.w		#32,d1
	clr.w		d3
	moveq		#5,d2
	bsr		mtr

	addq		#5,d0
	subq		#1,d1
	bsr		mtr

	addq		#5,d0
	sub.w		#32,d1
	clr.w		d2

	rts

 fvm:

	addq		#2,d0
	addq		#2,d1
	moveq		#6,d2
	moveq		#32,d3
	bsr		mtr

	add.w		#23,d1
	moveq		#7,d2
	moveq		#2,d3
	bsr		mtr

	add.w		#11,d1
	moveq		#4,d2
	clr.b		d3
	bsr		mtr

	subq		#1,d0
	subq		#6,d1
	clr.w		d2
	moveq		#2,d3

	rts

 svm:

	addq		#2,d0
	addq		#2,d1
	moveq		#6,d2
	moveq		#22,d3
	bsr		mtr

	addq		#1,d0
	add.w		#14,d1
	clr.w		d3
	bsr		mtr

	addq		#2,d0
	add.w		#9,d1
	clr.w		d2

	rts

 nvm:

	addq		#1,d0
	add.w		#8,d1
	moveq		#6,d2
	clr.w		d3
	bsr		mtr

	addq		#2,d0
	add.w		#8,d1
	moveq		#2,d2

	rts

 ;****************************** curseur du menu *****************************

 menucurseur:

	cmp.b		#-1,d5
	beq		mcrs1
	cmp.w		#3,d5
	beq		mcrs2
	bra		mcrs0

 mcrs1:

	moveq		#2,d5
	bra		mcrs0

 mcrs2:

	clr.w		d5

 mcrs0:

	move.w	d5,d1
	mulu.w	#20,d1
	add.w		#40,d1

	moveq		#21,d0
	move.w	#197,d2
	moveq		#18,d3
	clr.w		d4
	jsr		mtr
	moveq		#4,d7

 cbcl:						; on calme un peu plus...

	jsr		wait
	dbra		d7,cbcl

	rts

 ;******************************* pour le retour *****************************
 prepback:

	jsr		gray4lib::off		; dsactive le niveau de 4 gris
	move.l	#$600001,a0
	move.w	#$700,d0			; permet d'abords de dtourner l'int1
	trap		#1				; (voir au dbut du code) pour pouvoir afficher 
	bclr.b	#2,(a0)			; des niveaux de gris qui ne flashent pas quand
	move.l	old_int1,$64		; on teste la matrice clavier, puis la remet
	bset.b	#2,(a0)			; en place (ici).
	clr.w		d0
	trap		#1

	rts

 ;**************************** tir de l'ordinateur ***************************

 ; l c'est la partie la plus rigolote...

 ; input:	tch.w
 ;		cle.w
 ;		xr
 ;		yr
 ;		rtir
 ;		sens...
 ;
 ; output:	x.w
 ;		y.w
 ;		xr
 ;		yr
 ;		rtir
 ;		sens...

 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 sprg1:

	move.w	xr,x				; le bateau est touch pour la premire fois
	move.w	yr,y				; en (x,y) que l'on a sauvegardes en (xr,yr)
							; on tire alors en (xr+1,yr),(xr,yr+1),(xr-1,yr) ou (xr,yr-1)
	bsr		sprg10			; tout en vrifiant que le tir est valide
	bsr		sprg3
	tst.b		erreur
	bne		sprg1

	rts

 sprg10:

	moveq		#4,d0
	bsr		rand

	cmp.w		#1,d0
	beq		sg11
	cmp.w		#2,d0
	beq		sg12
	cmp.w		#3,d0
	beq		sg13

	add.w		#1,x
	move.w	yr,y
	rts

 sg11:

	sub.w		#1,x
	move.w	yr,y
	rts

 sg12:

	add.w		#1,y
	move.w	xr,x
	rts

 sg13:

	sub.w		#1,y
	move.w	xr,x
	rts

 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 sprg20:

	moveq		#5,d0				; nombre entre 1 et 5
	bsr		rand
	add.w		#1,d0
	lsl.w		#1,d0				; entre 2 et 10
	rts

 sprg2:

	clr.b		erreur			; tire au hasard tout en intercalant les cases
	moveq		#10,d0			; en effet, le blus petit bateau faisant deux cases de
	bsr		rand				; long, il ne sert  rien de tirer sur toutes les cases
	move.w	d0,y
	add.w		#1,y				; entre 1 et 10

	bsr		sprg20
	move.w	d0,x
	move.w	y,d0
	add.w		tircte,d0
	btst.b	#0,d0
	beq		sg2
	sub.w		#1,x

 sg2:

	bsr		sprg3				; vrifie si le tir est valide
	tst.b		erreur
	bne		sprg2
	clr.w		rtir

	rts

 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 sprg3:

	clr.b		erreur			; vrifie la validit de la case
	tst.w		x
	beq		sprg31
	cmp.w		#11,x
	beq		sprg31

	tst.w		y
	beq		sprg31
	cmp.w		#11,y
	beq		sprg31

	move.w	x,a
	move.w	y,b
	bsr		get				; lit la matrice  (x=a,y=b)

	or.w		#%1111110111111111,c	; il ne faut pas y avoir dj tir
	cmp.w		#$FFFF,c
	bne		sg30

 sprg31:

	move.b	#1,erreur

 sg30:

	rts

 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 sg42:

	tst.b		sens
	beq		sg422

 sg421:

	move.w	xr,x
	add.w		d1,x
	sub.w		#4,x
	move.w	yr,y
	bra		sg423

 sg422:

	move.w	yr,y
	add.w		d1,y
	sub.w		#4,y
	move.w	xr,x

 sg423:

	rts

 sg43:

	move.w	x,a
	move.w	y,b

	rts

 sprg4:						; on a dja touch le bateau deux fois, et on connait son sens
							; on tire donc dans l'alignement, de plus en plus loin jusqu'
	moveq		#4,d1				; ce que le bateau soit coul ou que l'ou trouve de l'eau,
	moveq		#2,d0				; auquel cas on tire de l'autre ct de (xr,yr)
	bsr		rand				; il n'y a pas de prfrence pour tirer  gauche ou 
	tst.w		d0				; droite de (xr,yr), alors... rand
	beq		sg410

 sg400:

	add.w		#1,d1
	bsr		sg42
	bsr		sg43
	bsr		get
	or.w		#%1111110111111111,c	; continue si on a dj tir sur la case et qu'on y a touch un
	cmp.w		#$FFFF,c			; bateau, retourne si on n'y a pas tir, change de sens si on y
	bne		sg409				; a dj tir dans l'eau

	bsr		get
	or.w		#%1111111111111110,c
	cmp.w		#$FFFF,c
	beq		sg400

 sg401:

	moveq		#4,d1

 sg402:

	sub.w		#1,d1
	bsr		sg42
	bsr		sg43

	bsr		get
	or.w		#%1111110111111111,c
	cmp.w		#$FFFF,c
	bne		sg409

	bra		sg402

 sg409:

	rts		

 sg410:

	sub.w		#1,d1
	bsr		sg42
	bsr		sg43

	bsr		get
	or.w		#%1111110111111111,c
	cmp.w		#$FFFF,c
	bne		sg409

	bsr		get
	or.w		#%1111111111111110,c
	cmp.w		#$FFFF,c
	beq		sg410

 sg411:

	moveq		#4,d1

 sg412:

	add.w		#1,d1
	bsr		sg42
	bsr		sg43

	bsr		get
	or.w		#%1111110111111111,c
	cmp.w		#$FFFF,c
	bne		sg409

	bra		sg412

 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 sprg9:

	clr.b		sens				; si xr=x alors le bateau est horizontal,
	move.w	x,d0				; sinon il est vertical
	cmp.w		xr,d0
	beq		sg90
	move.b	#1,sens

 sg90:

	rts

 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 tirordi:

	tst.w		tch
	bne		t00

 t01:

	tst.w		rtir				; on a rat au coup prcdent
	beq		t05				; rtir=0: pas de bateau non coul connu
							; rtir=1: on a touch une seule fois le bateau  (xr,yr)
 t06:							; rtir=2: on a touch le bateau au moins deux fois sans le couler

	bsr		t1				; rtir>0

 t04:

	rts

 t05:							; rtir=0

	bsr		sprg2				; tire au hasard
	rts

 t00:

	tst.w		rtir				; on a touch au coup prcdent
	beq		t02
	cmp.w		#1,rtir
	beq		t03

 t08:							; rtir>0

	bsr		t3
	rts

 t03:							; rtir=1

	bsr		t2
	rts

 t02:

	move.w	#1,rtir			; on a touch pour la premire fois :o)
	move.w	x,xr				; on sauvegarde (x,y) en (xr,yr)
	move.w	y,yr				; et on tire dans une case adjacente valide
	bsr		sprg1
	rts

 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 t1:

	cmp.w		#2,rtir			; tir prcdent rat et rtir>0
	beq		t11

 t10:							; rtir=1

	bsr		sprg1
	rts

 t11:							; rtir=2

	bsr		sprg4
	rts

 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 t2:

	tst.w		cle				; on recommence  zro si le bateau a t coul
	beq		t21

 t20:

	bsr		sprg2
	rts

 t21:

	bsr		sprg9				; sinon, on a touch le bateau une deuxime fois :o)))
	bsr		sprg4
	move.w	#2,rtir
	rts

 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 t3:

	tst.w		cle				; on vrifie que le bateau n'est pas encore coul
	bne		t30

 sg31:

	bsr		sprg4				; on continue  frapper...
	rts

 t30:

	bsr		sprg2
	rts

 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 ;************************** fin des sous-programmes *************************

 ;****************************************************************************
 
_main:						; c'est ici que la lecture du code commence

 ;**************************** dbut du programme ****************************
	even
 seawar:
				
	move.l	a7,save			; sauvegarde le pointeur de la pile utilisateur
							; rinitialisation des variables
	move.w	#288-2,d2			; il y a 144 cases dans la matrice
							; 10*10 entoures d'un "carr de scurit"
 efmat1:						; d'une ligne d'paisseur (a simplifie drlement le code!!!)
							; donc la matrice est 12*12
	lea		matrice,a0			; on charge l'adresse du tableau dans a0
	clr.b		0(a0,d2)			; on efface le mot  0+a0+d0
	dbra		d2,efmat1			; efface toute la matrice

	move.w	#1,a
	moveq		#9,d2
	move.w	#%0000001000000010,c

 efmat10:

	clr.w		a				; fait en sorte qu'il soit impossible de tirer
	move.w	d2,b				; dans la bordure de la matrice
	bsr		put				; sinon l'ordinateur le ferait...
	move.w	#11,a
	bsr		put
	clr.w		b
	move.w	d2,a
	bsr		put
	move.w	#11,b
	bsr		put

	dbra		d2,efmat10

	move.l	#$01010101,u1
	clr.l		tot1				; efface tot1 et tot2
	clr.w		vdpl				; efface vdpl et hdpl
	clr.b		sel

	moveq		#4,d2

 efmat2:						; on rinitialise aussi les listes de longueurs restantes des bateaux

	lea		longbat,a0			; on charge l'adresse du tableau dans a0
	move.l	d2,d0				; on veut la d2-me valeur
	lsl.l		#1,d0				; la liste contient des mots
	move.w	0(a0,d0),d3			; on enregistre le contenu de la d3-me valeur dans d3


	add.w		d3,tot1			; nombre de cases total
	add.w		d3,tot2	

	lea		batj1,a0			; on charge l'adresse du tableau dans a0
	move.w	d3,0(a0,d0)			; on enregistre le contenu de d3 dans la liste

	lea		batj2,a0			; on charge l'adresse du tableau dans a0
	move.w	d3,0(a0,d0)			; on enregistre le contenu de d3 dans la liste

	dbra		d2,efmat2

	move.l	#$600116,a6			; sans cela, rand_seed serait toujours le mme  chaque premier jeu
	move.w	(a6),d0
	move.w	$6000D6,rand_seed		; j'ai vu que l'octet  $6000D7 et celui  
							; $600116 bouge tout le temps mais je ne sais
	add.w		d0,rand_seed		; pas  quoi ils correspondent... si quelqu'un sait... timer?

	moveq		#2,d0
	bsr		rand
	move.w	d0,tircte

	bsr		sprg2

	move.w	#$700,d0			; aucun int
	move.l	#$600001,a0
	trap		#1
	bclr.b	#2,(a0)			; dprotge la mmoire basse
	move.l	$64,old_int1		; sauvegarde l'ancien vecteur
	move.l	#newint1,$64		; nouveau vecteur
	bset.b	#2,(a0)			; reprotge la mmoire basse
	clr.w		d0
	trap		#1				; remet les ints

	move.w	#1,graphlib::choosescreen	;affiche dans l'cran dont l'addresse est dans a1
	jsr		gray4lib::on		; active le niveau de 4 gris

	jsr		clrscr			; menu principal

	moveq		#1,d7
	lea		graphlib::horiz,a5
	lea		graphlib::vert,a6

 tracemenu1:

	clr.w		d0
	clr.w		d1
	moveq		#127,d2
	jsr		(a6)

	move.w	#239,d0
	jsr		(a6)

	moveq		#20,d0
	moveq		#39,d1
	moveq		#99,d2
	jsr		(a6)

	move.w	#219,d0
	jsr		(a6)

	clr.w		d0
	clr.w		d1
	move.w	#239,d2
	moveq		#2,d3
	jsr		(a5)

	moveq		#19,d1
	jsr		(a5)

	moveq		#127,d1
	jsr		(a5)

	moveq		#3,d6

	moveq		#20,d0
	moveq		#19,d1
	move.w	#219,d2

 tracemenu2:

	add.w		#20,d1
	jsr		(a5)

	dbra		d6,tracemenu2

	move.l	gray4lib::plane0,a1
	dbra		d7,tracemenu1

	lea		tios::DrawStrXY,a6

	move.w	#2,-(a7)			; empile taille de la police
	jsr		tios::FontSetSys		; appelle la fonction

	move.w	#4,-(a7)			; couleur
	pea		titre(pc)			; pointeur de la chane de caractre
	move.l	#$00640005,-(a7)		; abscisse,ordonne
	jsr		(a6)				; appelle la fonction

	move.w	#4,-(a7)
	pea		unjoueur(pc)
	move.l	#$0032002C,-(a7)
	jsr		(a6)		

	move.w	#4,-(a7)
	pea		deuxjoueurs	(pc)
	move.l	#$00230040,-(a7)
	jsr		(a6)

	move.w	#4,-(a7)
	pea		quitter(pc)
	move.l	#$005F0054,-(a7)
	jsr		(a6)
	lea		42(a7),a7			; restaure la pile de 2+(2+4+4)*4=42

	move.l	gray4lib::plane0,a1	; facultatif sur ti-92, mais indispensable sur 92+... alors je le
	clr.w		d0				; laisse pour faciliter la compatibilit...
	clr.w		d1
	move.w	#239,d2
	moveq		#19,d3
	moveq		#2,d4
	jsr		mtr

	clr.w		d5

 menubcl:

	bsr		menucurseur

 menugetk:

	bsr		getk
	
	cmp.w		#4,d0
	beq		basapp
	cmp.w		#3,d0
	beq		hautapp
	cmp.w		#5,d0
	beq		enterapp
	bra		menugetk

 hautapp:

	bsr		menucurseur
	subq		#1,d5
	bra		menubcl

 basapp:

	bsr		menucurseur
	addq		#1,d5
	bra		menubcl

 enterapp:

	cmp.w		#2,d5
	beq		fin2

	addq		#1,d5
	move.b	d5,nbrjoueurs		; fin du menu principal

	clr.w		x				; cle,tch,x,y,xr et yr sont ici utilises comme variables temporaires
	move.b	#1,joueur

 deb:

	bsr		grille			; trace la grille

 j1place:

	moveq		#4,d7				; nombre de bateaux  placer-1

 j1placebcl:

	move.w	d7,xr
	move.w	d7,cle			; sauvegarde la longueur

	move.w	d7,yr				; cette partie du code est trs obscure... je ne me comprends plus...
	add.w		#2,yr				; il faudra que je revoie tout cel un de ces quatres...

	lea		longbat(pc),a0		; on charge l'adresse du tableau dans a0
	move.l	d7,d0				; on veut la d7-me valeur
	lsl.w		#1,d0				; la liste contient des mots
	move.w	0(a0,d0),y			; on enregistre le contenu de la a5-me valeur dans y

	move.w	#0,a5				; dans la grille de gauche

	tst.b		joueur
	bne		s1
	move.w	#1,a5

 s1:

	bsr		selec				; sous programme pour slctionner une case de la grille

	cmp.w		#1,a4				; test a4

 j1lbl:

	move.w	a3,a0				; x
	move.w	a2,a3				; y

	bsr		batsens			; sous programme pour choisir le sens du bateau  placer

	move.w	#0,a2				; grille
	move.w	y,a5				; charge la longueur

	bsr		placetest			; sous programme pour vrifier le placement

	tst.b		erreur
	beq		paserr1

	move.w	xr,d7

	move.w	d7,tch
	moveq		#8,d7

 ws2:

	bsr		wait				; on calme un peu plus...
	dbra		d7,ws2
	move.w	tch,d7

	bra		j1placebcl

 paserr1:

	move.w	#%0000000000000001,c

	movem.l	a0-a6/d0-d7,-(a7)
	move.w	c,d5
	move.w	yr,d7
	moveq		#%0000000000000001,d6
	rol.w		d7,d6
	or.w		d6,d5
	move.w	d5,c
	movem.l 	(a7)+,a0-a6/d0-d7

	tst.b		joueur
	bne		s2
	move.w	#%0000000100000000,c

	movem.l 	a0-a6/d0-d7,-(a7)
	move.w	c,d5
	move.w	yr,d7
	move.w	#%0000000100000000,d6
	rol.w		d7,d6
	or.w		d6,d5
	move.w	d5,c
	movem.l 	(a7)+,a0-a6/d0-d7

 s2:

	bsr		place				; sous programme pour placer les bateaux  l'cran et dans la matrice

	moveq		#8,d7

 ws1:

	bsr		wait				; on calme un peu plus...
	dbra		d7,ws1

	move.w	cle,d7			; restitue la longueur

	dbra		d7,j1placebcl		; effectue la boucle 5 fois

	bsr		putspr

	cmp.b		#2,nbrjoueurs
	bne		ordiplace

	clr.b		joueur

	tst.w		x
	bne		pretir

	move.w	#1,x

	bra		deb

 ordiplace:
	
	clr.b		joueur
	
	moveq		#4,d7				; nombre de bateaux  placer-1

 ordiplacebcl:

	move.w	d7,xr
	move.w	d7,yr
	add.w		#2,yr

	lea		longbat(pc),a0		; on charge l'adresse du tableau dans a0
	move.l	d7,d0				; on veut la d7-me valeur
	lsl.l		#1,d0				; la liste contient des mots
	move.w	0(a0,d0),y			; on enregistre le contenu de la a5-me valeur dans y

	move.w	#1,a5				; dans la grille de droite

	moveq		#10,d0
	bsr		rand
	add.w		#1,d0
	move.w	d0,a2				; gnre y alatoirement

	moveq		#10,d0
	bsr		rand
	add.w		#1,d0
	move.w	d0,a3				; gnre x alatoirement

 ordilbl:

	move.w	a3,a0				; x
	move.w	a2,a3				; y

	moveq		#4,d0
	bsr		rand
	add.w		#1,d0
	move.w	d0,a4				; gnre le sens alatoirement

	move.w	#1,a2				; grille de droite
	move.w	y,a5				; charge la longueur

	bsr		placetest			; sous programme pour vrifier le placement
	move.w	y,a5
	tst.b		erreur
	beq		paserr2

	move.w	xr,d7
	bra		ordiplacebcl

 paserr2:

	move.w	#%0000000100000000,c

	movem.l	a0-a6/d0-d7,-(a7)
	move.w	c,d5
	move.w	yr,d7
	move.w	#%0000000100000000,d6
	rol.w		d7,d6
	or.w		d6,d5
	move.w	d5,c
	movem.l	(a7)+,a0-a6/d0-d7		; il y a une fuite de la pile quelque part... o?

	bsr		place				; sous programme pour placer les bateaux  l'cran et dans la matrice
	move.w	xr,d7

	dbra		d7,ordiplacebcl		; effectue la boucle 5 fois


 pretir:

	clr.w		rtir
	clr.l		tch				; efface tch et cle
	clr.l		xr

	move.l	#$01010101,u1		; rinitialise u1

 tir:

	cmp.b		#1,nbrjoueurs
	beq		txr

	bsr		grille

 txr:

	move.l	gray4lib::plane0,a1 	; slctionne l'cran gris clair

	moveq		#1,d0
	moveq		#11,d1
	moveq		#101,d2
	moveq		#8,d3
	moveq		#1,d4
	bsr		mtr

 tir1:						; tir joueur

	movem.l 	a0-a6/d0-d7,-(a7)

	move.l	gray4lib::plane0,a1 	; slctionne l'cran gris clair

	moveq		#1,d0
	moveq		#1,d1
	moveq		#101,d2
	moveq		#8,d3
	clr.w		d4
	bsr		mtr
	moveq		#11,d1
	bsr		mtr

	move.l	gray4lib::plane1,a1 	; slctionne l'cran gris fonc

	moveq		#1,d4
	moveq		#104,d0
	move.w	#2,d1
	move.w	#134,d2
	moveq		#7,d3

	tst.b		joueur
	beq		tgf

 tg1:

	add.w		#10,d1

 tgf:

	bsr		mtr

	move.w	#4,-(a7)			; empile la couleur
	pea		chcase(PC)			; empile le pointeur de la chane de caractre
	move.w	d1,-(a7)			; empile l'ordonne
	move.w	#108,-(a7)			; empile l'abscisse
	jsr		tios::DrawStrXY		; appelle la fonction
	lea		10(a7),a7			; restaure la pile de 2+4+2+2=10

	movem.l 	(a7)+,a0-a6/d0-d7

 tirj00:

	move.w	#1,a5
	tst.b		joueur
	beq		tirj0
	move.w	#0,a5
	bra		tirj0	

 tirj0:

	cmp.b		#2,nbrjoueurs
	bne		tira

 tja:

	bsr		selec
	move.w	a3,a
	move.w	a2,b
	bra		tirb

 tira:

	tst.b		joueur
	beq		tja

	move.w	x,a
	move.w	y,b

 tirb:

	bsr		get
	move.w	c,d6

	move.w	#%1111110111111111,d7	; a-ton dja tir ici ?
	tst.b		joueur
	bne		tirj2
	move.w	#%1111111111111101,d7	; si le joueur 2 est actif

 tirj2:

	or.w		d7,d6				; teste le bit ......x.
	cmp.w		#%1111111111111111,d6
	beq		tirj00			; recommence si le joueur a dja tir ici
							;  partir d'ici on sait que la case est valide
	move.w	#%1111111011111111,d7	; y a-til un bateau averse ici ?
	tst.b		joueur
	beq		tirj1
	move.w	#%1111111111111110,d7

 tirj1: 

	bsr		get				; on teste maintenant s'il y avait un bateau dans la case

	move.w	c,d6
	or.w		d7,d6
	move.w	#2,a6
	tst.b		joueur
	beq		tf01
	add.w		#10,a6

 tf01:

	movem.l 	a0-a6/d0-d7,-(a7)

	move.l	gray4lib::plane1,a1

	move.w	#2,a6				; affiche les coordonnes du tir
	tst.b		joueur
	beq		pcd1
	add.w		#10,a6

 pcd1:

	moveq		#1,d4
	moveq		#104,d0
	move.w	a6,d1
	move.w	#134,d2
	moveq		#7,d3
	bsr		mtr

	lea		tcor,a0

	move.w	b,d6
	add.b		#48,d6
	moveq		#32,d7
	cmp.b		#58,d6
	bne		pcn

	move.b	#48,d7
	move.b	#49,d6

 pcn:

	move.w	a,d5
	add.b		#64,d5

	move.b	d5,(a0)
	move.b	d6,2(a0)			; cre la chane  afficher: d5,"-",d6,d7,0
	move.b	d7,3(a0)

	move.w	#4,-(a7)			; empile la couleur
	move.l	a0,-(a7)			; empile le pointeur de la chane de caractre
	move.w	a6,-(a7)			; empile l'ordonne
	move.w	#108,-(a7)			; empile l'abscisse
	jsr		tios::DrawStrXY		; appelle la fonction
	lea		10(a7),a7

	movem.l 	(a7)+,a0-a6/d0-d7

	move.w	a,d0				; met x dans d0
	sub.w		#1,d0
	lsl.w		#3,d0
	add.w		#30,d0			; obtient les coordonnes du sprite
	sub.w		d2,d0

	move.b	joueur,d2
	tst.w		d2
	bne		ptstr000
	add.w		#110,d0			; choisit la grille en fonction du joueur

 ptstr000:

	tst.b		joueur
	beq		pt2
	cmp.b		#2,nbrjoueurs
	beq		pt2
 	add.w		#2,d0

 pt2:

	move.w	b,d1				; met y dans d1
	moveq		#10,d4
	sub.w		d1,d4
	move.w	d4,d1
	lsl.w		#3,d1
	add.w		#30,d1			; obtient les coordonnes du sprite

	movem.l	d0-d1,-(a7)

	cmp.w		#%1111111111111111,d6	; test s'il y a un bateau adverse dans la case
	beq		atouche			; dans l'eau !!

	move.w	#4,-(a7)			; empile la couleur
	pea		dansleau(PC)		; empile le pointeur de la chane de caractre
	move.w	a6,-(a7)			; empile l'ordonne
	move.w	#133,-(a7)			; empile l'abscisse
	jsr		tios::DrawStrXY		; appelle la fonction
	lea		10(a7),a7			; restaure la pile de 2+4+2+2=10

	tst.b		joueur
	beq		nc3

	clr.w		tch
	clr.w		cle

 nc3:

	move.l	gray4lib::plane1,a1
	lea		tir2f,a0

	movem.l	(a7)+,d0-d1
	jsr		graphlib::put_sprite
	move.l	gray4lib::plane0,a1

	lea		tir2c,a0
	jsr		graphlib::put_sprite

	bra		tirx1

 atouche:

	movem.l	(a7)+,d0-d1

	move.l	gray4lib::plane1,a1
	lea		tirf,a0
	jsr		graphlib::put_sprite
	move.l	gray4lib::plane0,a1

	lea		tirc,a0
	jsr		graphlib::put_sprite

	lea		batj2,a4
	moveq		#8,d4
	tst.b		joueur
	beq		tirx2
	clr.w		d4
	lea		batj1,a4

 tirx2:
							; on teste maintenant si le bateau a t coul

 ; .....x..	 le bateau est ...	sous marin
 ; ....x...					destroyer
 ; ...x....					destroyer
 ; ..x.....					frgate
 ; .x......					porte-avions

	bsr		get

	move.w	c,d5

	move.w	#%1111111111111011,d6	; sous-marin ?
	rol.w		d4,d6
	or.w		d5,d6
	cmp.w		#$FFFF,d6
	bne		l1
	clr.w		d7
	bra		lfound

 l1:

	move.w	#%1111111111110111,d6	; destroyer1 ?
	rol.w		d4,d6
	or.w		d5,d6
	cmp.w		#$FFFF,d6
	bne		l2
	moveq		#1,d7
	bra		lfound

 l2:

	move.w	#%1111111111101111,d6	; destroyer2 ?
	rol.w		d4,d6
	or.w		d5,d6
	cmp.w		#$FFFF,d6
	bne		l3
	moveq		#2,d7
	bra		lfound

 l3:

	move.w	#%1111111111011111,d6	; frgate ?
	rol.w		d4,d6
	or.w		d5,d6
	cmp.w		#$FFFF,d6
	bne		l4
	moveq		#3,d7
	bra		lfound

 l4:

	moveq		#4,d7				; donc porte-avions
	

 lfound:

	move.l	a4,a0				; on charge l'adresse du tableau dans a0
	move.l	d7,d0				; on veut la d7-me valeur
	lsl.l		#1,d0				; la liste contient des mots
	sub.w		#1,0(a0,d0)			; une case de moins

	tst.w		0(a0,d0)			; si le bateau n'a plus de case, il est coul (!!!)
	bne		ncoule

	movem.l 	a0-a6/d0-d7,-(a7)
	move.w	a,a5
	move.w	b,a6
	move.w	c,d5

	moveq		#%00000100,d3
	rol.w		d7,d3
	rol.w		d4,d3
	not.w		d3				; masque

	moveq		#9,d6				; on scanne toute la matrice pour trouver les bateaux qui ont ts couls
 
 tx0:

	moveq		#9,d7

 tx00:

	move.w	d6,a
	move.w	d7,b
	add.w		#1,a
	add.w		#1,b
	bsr		get
	move.w	d3,d0
	or.w		c,d0
	cmp.w		#$FFFF,d0
	bne		tx1

	move.w	a,d0				; met x dans d0
	sub.w		#1,d0
	lsl.w		#3,d0
	add.w		#24,d0			; obtient les coordonnes du sprite

	move.b	joueur,d2
	add.w		#110,d0			; choisit la grille en fonction du joueur

	tst.w		d2
	beq		ptstr0000
	sub.w		#110,d0			; choisit la grille en fonction du joueur

	cmp.b		#2,nbrjoueurs		; la suite fait partie de la gestion des tirs ordi
	beq		ptstr0000

	move.w	a,-(a7)
	move.w	b,-(a7)
	move.w	c,-(a7)
	movem.w	d0-d7,-(a7)

	move.w	#%0000001000000000,c	; empche de tirer  cot d'un bateau coul
							; car les bateaux ne peuvent pas se toucher
	sub.w		#1,a
	sub.w		#1,b

	move.w	a,d3
	move.w	b,d4

	moveq		#2,d6

 ptstr00001:					; j'adore mes noms de labels!

	moveq		#2,d7

 ptstr00002:

	move.w	d3,d0
	move.w	d4,d1

	add.w		d6,d0
	add.w		d7,d1
	move.w	d0,a
	move.w	d1,b

	bsr		put

	dbra		d7,ptstr00002
	dbra		d6,ptstr00001

	movem.w	(a7)+,d0-d7
	move.w	(a7)+,c
	move.w	(a7)+,b
	move.w	(a7)+,a

 ptstr0000:

	move.w	b,d1				; met y dans d1
	moveq		#10,d2
	sub.w		d1,d2
	move.w	d2,d1
	lsl.w		#3,d1
	add.w		#30,d1			; obtient les coordonnes du sprite

	move.l	gray4lib::plane1,a1
	lea		tir3c,a0
	jsr		graphlib::put_sprite

	move.l	gray4lib::plane0,a1
	jsr		graphlib::put_sprite

 tx1:

	dbra		d7,tx00
	dbra		d6,tx0
	move.w	a5,a
	move.w	a6,b
	movem.l 	(a7)+,a0-a6/d0-d7

	move.w	#4,-(a7)			; empile la couleur
	pea		coule(pc)			; empile le pointeur de la chane de caractre
	move.w	a6,-(a7)			; empile l'ordonne
	move.w	#133,-(a7)			; empile l'abscisse
	jsr		tios::DrawStrXY		; appelle la fonction
	lea		10(a7),a7			; restaure la pile de 2+4+2+2=10

	tst.b		joueur
	beq		ncoule

	move.w	#1,cle

 ncoule:						; pas coul, mais touch quand mme...

	move.w	#4,-(a7)			; empile la couleur
	pea		touche(pc)			; empile le pointeur de la chane de caractre
	move.w	a6,-(a7)			; empile l'ordonne
	move.w	#133,-(a7)			; empile l'abscisse
	jsr		tios::DrawStrXY		; appelle la fonction
	lea		10(a7),a7			; restaure la pile de 2+4+2+2=10

	tst.b		joueur
	beq		nc0
	move.w	#1,tch

 nc0:

	movem.l 	a0-a6/d0-d7,-(a7)

	moveq		#104,d0
	move.w	a6,d1
	sub.w		#1,d1
	move.w	#134,d2
	moveq		#8,d3
	clr.w		d4
	moveq		#79,d7
	move.l	gray4lib::plane0,a1	; slctionne l'cran gris clair

	tst.b		joueur
	bne		txs1				; si le joueur 1 tire
	sub.w		#1,tot2
	bra		txs2

 txs1:

	sub.w		#1,tot1

 txs2:

	bsr		wait

	bsr		mtr
	dbra		d7,txs2

	movem.l 	(a7)+,a0-a6/d0-d7

 tirx1:

	move.w	#%0000000000000010,c	; valeurs pour empcher de tirer 2 fois au mme endroit
	tst.b		joueur
	beq		tirf1
	move.w	#%0000001000000000,c	; si le joueur 1 est actif

 tirf1:

	bsr		put

	moveq		#3,d7

 tirw:

	bsr		wait

	dbra		d7,tirw

	tst.b		joueur
	beq		cont				; les deux joueurs doivent tirer le mme nombre de fois
							; on effectue donc les tests aprs le tir du joueur2
	move.w	tot1,d0
	add.w		tot2,d0

	tst.w		d0				; si tot1+tot2=0 alors tot1=tot2=0, tous les bateaux ont t couls
	beq		egalite

	tst.w		tot1
	beq		j2gagne

	tst.w		tot2
	beq		j1gagne

	bra		cont

 egalite:

	lea		egal(pc),a3
	lea		old_int1,a4			; l'adresse de oldint1 est du type 00xxxxxx donc le premier octet est nul
	bra		jfin				; donc je l'utilise comme chane de caractre... vide!

 j1gagne:

	lea		gagnant(pc),a3
	lea		j1(pc),a4
	bra		jfin

 j2gagne:

	cmp.b		#2,nbrjoueurs
	bne		j2g2

	lea		gagnant(pc),a3
	lea		j2(pc),a4
	bra		jfin

 j2g2:

	lea		gagnant(pc),a3
	lea		ordi(pc),a4
	
 jfin:

	lea		rejouer(pc),a5

 ; box
 ; input:	a3.l	adresse du texte 1
 ;		a4.l	adresse du texte 2
 ;		a5.l	adresse du texte 2

	move.l	gray4lib::plane1,a1

	moveq		#62,d0
	moveq		#30,d1
	moveq		#113,d2
	moveq		#65,d3
	moveq		#2,d4
	bsr		mtr

	move.l	gray4lib::plane0,a1
	move.w	#1,d4
	bsr		mtr

	move.l	gray4lib::plane1,a1

	moveq		#63,d0
	moveq		#31,d1
	moveq		#111,d2
	moveq		#63,d3
	bsr		mtr

	move.l	gray4lib::plane0,a1
	bsr		mtr

	moveq		#64,d0
	moveq		#32,d1
	moveq		#109,d2
	moveq		#61,d3
	moveq		#2,d4
	bsr		mtr

	moveq		#69,d0
	moveq		#78,d1
	moveq		#44,d2
	moveq		#11,d3
	moveq		#1,d4
	bsr		mtr
	
	add.w		#55,d0
	bsr		mtr

	moveq		#125,d0
	moveq		#79,d1
	moveq		#42,d2
	moveq		#9,d3
	moveq		#2,d4
	bsr		mtr

	lea		tios::DrawStrXY,a6

	move.w	#4,-(a7)			; couleur
	move.l	a3,-(a7)			; texte1
	move.l	#$005F0027,-(a7)		; l'abscisse et ordonne
	jsr		(a6)				; appelle la fonction

	move.w	#4,-(a7)
	move.l	a4,-(a7)			; texte2
	move.l	#$005F0031,-(a7)		; empile l'abscisse
	jsr		(a6)

	move.w	#4,-(a7)
	move.l	a5,-(a7)			; texte3
	move.l	#$00460050,-(a7)
	jsr		(a6)

	move.w	#4,-(a7)
	pea		quitter(pc)			; texte4
	move.l	#$007D0050,-(a7)
	jsr		(a6)
	lea		40(a7),a7			; restaure la pile de 2+4+2+2=10 4 fois

	clr.w		d6				; le curseur est sur [texte 3]

	moveq		#79,d1
	moveq		#42,d2
	moveq		#9,d3
	moveq		#2,d4
	clr.w		d4

 bx1:
 
 	move.l	gray4lib::plane0,a1

	moveq		#70,d0
	bsr		mtr

	add.w		#55,d0
	bsr		mtr

 bx0:

	bsr		getk

	cmp.w		#5,d0				; enter (ou lock)
	beq		bx2

	cmp.w		#1,d0				; gauche
	beq		bx4

	cmp.w		#2,d0				; droite
	beq		bx5

	bra		bx0

 bx2:

	tst.w		d6
	bne		fin2

	bsr		prepback

	move.l	save,a7			; je suis toujours sr de ne pas planter au retour avec a :o)
	bra		seawar			; l je saute au moins 2 rts, a ne plante pas seulement parceque
							; j'ai restitu a7 tel qu'il tait  l'origine, sinon c'est le crash assur!
 bx4:

	tst.w		d6
	beq		bx0
	clr.w		d6
	bra		bx1

 bx5:

	cmp.w		#1,d6
	beq		bx0
	moveq		#1,d6
	bra		bx1

 cont:						; fin du tir joueur

	tst.b		joueur
	beq		tj00

	clr.b		joueur

	bra		tir1

 tj00:

	move.b	#1,joueur			; fait tirer l'ordinateur en mode 1 joueur et le joueur2 sinon

	cmp.b		#1,nbrjoueurs
	bne		tir1
	bsr		tirordi
	bra		tir1

 ;*************************** prparation du retour **************************

 fin2:

	bsr		prepback			; restaure les ints

	move.l	save,a7			; je suis toujours sr de ne pas planter au retour avec a :o)

	rts						; quitte le programme

 ;***************************** fin du programme *****************************

 newint1:						; nouveau vecteur int1
	
	rte						; quivalent de rts pour les ints

 ;****************************************************************************

 ;********************************* variables ********************************

 ; structure de la matrice:
 ;
 ;		xxxxxxxxxxxx b =
 ;		xwwwwwwwwwwx-10
 ;		xwwwwwwwwwwx-9
 ;		xwwwwwwwwwwx-8
 ;		xwwwwwwwwwwx-7
 ;		xwwwwwwwwwwx-6
 ;		xwwwwwwwwwwx-5
 ;		xwwwwwwwwwwx-4
 ;		xwwwwwwwwwwx-3
 ;		xwwwwwwwwwwx-2
 ;		xwwwwwwwwwwx-1
 ;		xxxxxxxxxxxx
 ;		 ||||||||||
 ;	   a = 12345678910
 ;
 ; les "w" sont des mots, les "x" sont inutiliss, ils servent de "marge de scurit" pour ne pas
 ; aller lire des octets hors de la matrice qui pourraient fausser les test de placement
 ;
 ; structure d'un mot de la matrice:
 ;
 ; xxxxxxxx........ tout concernant le joueur 2
 ; ........xxxxxxxx pour le joueur 1
 ; 
 ; il y a donc un octet par joueur:
 ;
 ; .......x		prsence d'un bateau du joueur
 ; ......x.		le joueur a tir ici
 ; .....x..		le bateau est ...	sous marin
 ; ....x...					destroyer
 ; ...x....					destroyer
 ; ..x.....					frgate
 ; .x......					porte-avions
 ; x.......		(le bateau est touch) inutilis car ......xx = bateau + tir = touch
 ; 76543210		le bateau est coul si batj* vaut 0 au mot correspondant  ce bateau

longbat		dc.w	2,3,3,4,5		; liste de rfrence des longueurs des bateaux
rand_seed		dc.w	1			; pour gnrer des nombres pseudo-alatoires
							; les autres variables sont dans le bss
 ;********************************** chanes *********************************
_comment		dc.b	"Ximoon's Seawar 0.64",0
titre			dc.b	"SeaWar",0
unjoueur		dc.b	"Partie  un joueur",0
deuxjoueurs		dc.b	"Partie  deux joueurs",0
chcase		dc.b	"Choisir une case",0
dernord		dc.b	"Dernier tir Ordi:",0
touche		dc.b	": touch",0
coule			dc.b	": touch-coul!",0
dansleau		dc.b	": dans l'eau",0
gagnant		dc.b	"Gagnant:",0
egal			dc.b	"Egalit!",0
j1			dc.b	"Joueur 1",0
j2			dc.b	"Joueur 2",0
ordi			dc.b	"  Ordi",0
quitter		dc.b	"Quitter",0
rejouer		dc.b	"Rejouer",0
ca			dc.b	"ABCDEFGHIJ",0
tcor			dc.b	0,"-",0,0,0

 ;********************************** sprites *********************************

	even					; a fait pas mal de sprites a!
pvc 	dc.w 45				; sprites au format pour graphlib
	dc.w 2				; bateaux
 dc.b $1F,$C0				; xyz		hauteur.w en pixels
 dc.b $7C,$20				;		largeur.w en octets
 dc.b $42,$70				;		sprite
 dc.b $6B,$70				;		masque (pour les sprites de tir seulement)
 dc.b $63,$70
 dc.b $EB,$F0				; comment s'y retrouver?
 dc.b $9F,$10				; nom du sprite = xyz
 dc.b $DF,$70				; x:
 dc.b $FF,$50				; p = porte-avions
 dc.b $83,$78				; f = frgate
 dc.b $FF,$5C				; s = destroyer (avant c'tait des sous-marins)
 dc.b $FF,$18				; n = sous-marin (avant c'tait une navette)
 dc.b $7F,$70				;
 dc.b $41,$50				; y:
 dc.b $43,$78				; v = vertical
 dc.b $7B,$7C				; h = horizontal
 dc.b $3B,$78				;
 dc.b $2B,$F0				; z:
 dc.b $2B,$70				; c = clair
 dc.b $2B,$78				; f = fonc
 dc.b $2B,$F8
 dc.b $2F,$78				; les sprites prennent environ 1000 octets
 dc.b $37,$78				; mais c'est quand mme plus joli qu'avant...
 dc.b $2B,$F8				; et le code est beaucoup plus propre :o)
 dc.b $5B,$78
 dc.b $6B,$78				; pour faire mes sprites, j'ai crit mon propre logiciel
 dc.b $2F,$F8				; en Visual Basic 4.0, "Spriter" disponible sur mon site ;o)
 dc.b $37,$78
 dc.b $2B,$78
 dc.b $5B,$F8
 dc.b $7B,$78
 dc.b $7B,$78
 dc.b $5B,$F8
 dc.b $5B,$78
 dc.b $5B,$78
 dc.b $5B,$FC
 dc.b $7B,$74
 dc.b $5F,$74
 dc.b $5F,$F4
 dc.b $5F,$F4
 dc.b $4F,$F4
 dc.b $5F,$F4
 dc.b $5F,$84
 dc.b $5F,$FC
 dc.b $7F,$00

pvf 	dc.w 45
	dc.w 2
 dc.b $1F,$C0
 dc.b $7F,$E0
 dc.b $7F,$90
 dc.b $41,$90
 dc.b $41,$90
 dc.b $E1,$10
 dc.b $F1,$F0
 dc.b $B1,$F0
 dc.b $FE,$F0
 dc.b $FE,$E8
 dc.b $82,$B4
 dc.b $82,$F8
 dc.b $7E,$F0
 dc.b $7E,$F0
 dc.b $7C,$E8
 dc.b $74,$14
 dc.b $24,$18
 dc.b $34,$10
 dc.b $34,$10
 dc.b $34,$08
 dc.b $34,$08
 dc.b $3C,$08
 dc.b $3C,$08
 dc.b $3C,$08
 dc.b $74,$08
 dc.b $74,$08
 dc.b $3C,$08
 dc.b $3C,$08
 dc.b $3C,$08
 dc.b $74,$08
 dc.b $64,$08
 dc.b $44,$08
 dc.b $64,$08
 dc.b $64,$08
 dc.b $64,$08
 dc.b $74,$04
 dc.b $5C,$0C
 dc.b $60,$0C
 dc.b $70,$0C
 dc.b $78,$0C
 dc.b $70,$0C
 dc.b $70,$0C
 dc.b $78,$7C
 dc.b $60,$FC
 dc.b $7F,$00

fvc	dc.w 38
	dc.w 2
 dc.b $1F,$00
 dc.b $1F,$00
 dc.b $2F,$80
 dc.b $3C,$80
 dc.b $3E,$80
 dc.b $34,$80
 dc.b $33,$80
 dc.b $2F,$80
 dc.b $3F,$80
 dc.b $21,$80
 dc.b $3F,$80
 dc.b $3C,$C0
 dc.b $5F,$C0
 dc.b $7C,$C0
 dc.b $7F,$C0
 dc.b $78,$40
 dc.b $78,$40
 dc.b $5F,$80
 dc.b $5E,$80
 dc.b $3F,$80
 dc.b $27,$80
 dc.b $2E,$80
 dc.b $3D,$80
 dc.b $3B,$80
 dc.b $37,$80
 dc.b $3F,$C0
 dc.b $3F,$E0
 dc.b $37,$C0
 dc.b $3B,$80
 dc.b $3F,$80
 dc.b $7F,$80
 dc.b $FF,$80
 dc.b $7B,$80
 dc.b $3D,$80
 dc.b $3F,$80
 dc.b $39,$00
 dc.b $7E,$00
 dc.b $20,$00

fvf 	dc.w 38
	dc.w 2
 dc.b $1F,$00
 dc.b $11,$00
 dc.b $3F,$80
 dc.b $2B,$80
 dc.b $39,$80
 dc.b $2C,$80
 dc.b $2E,$80
 dc.b $22,$80
 dc.b $3F,$80
 dc.b $3E,$80
 dc.b $2F,$80
 dc.b $3F,$40
 dc.b $7F,$C0
 dc.b $50,$C0
 dc.b $5F,$C0
 dc.b $4F,$C0
 dc.b $78,$40
 dc.b $7F,$80
 dc.b $63,$80
 dc.b $3E,$80
 dc.b $38,$80
 dc.b $37,$80
 dc.b $2F,$80
 dc.b $2D,$80
 dc.b $2E,$80
 dc.b $21,$40
 dc.b $2C,$A0
 dc.b $3E,$C0
 dc.b $36,$80
 dc.b $2C,$80
 dc.b $50,$80
 dc.b $A6,$80
 dc.b $6F,$80
 dc.b $2B,$80
 dc.b $36,$80
 dc.b $2F,$00
 dc.b $5E,$00
 dc.b $20,$00

svc 	dc.w 27
	dc.w 2
 dc.b $1F,$00
 dc.b $22,$80
 dc.b $3F,$80
 dc.b $33,$80
 dc.b $7F,$80
 dc.b $52,$80
 dc.b $5F,$C0
 dc.b $51,$40
 dc.b $7F,$C0
 dc.b $6E,$80
 dc.b $3F,$80
 dc.b $3F,$80
 dc.b $3F,$80
 dc.b $31,$80
 dc.b $37,$80
 dc.b $33,$C0
 dc.b $3F,$E0
 dc.b $3F,$C0
 dc.b $3F,$80
 dc.b $3F,$80
 dc.b $31,$80
 dc.b $35,$80
 dc.b $3F,$80
 dc.b $7E,$80
 dc.b $39,$00
 dc.b $1A,$00
 dc.b $04,$00

svf 	dc.w 27
	dc.w 2
 dc.b $1F,$00
 dc.b $3F,$80
 dc.b $22,$80
 dc.b $22,$80
 dc.b $7F,$80
 dc.b $7C,$80
 dc.b $7F,$C0
 dc.b $7E,$40
 dc.b $5F,$C0
 dc.b $49,$80
 dc.b $38,$80
 dc.b $20,$80
 dc.b $2E,$80
 dc.b $39,$80
 dc.b $39,$80
 dc.b $3D,$40
 dc.b $2E,$A0
 dc.b $21,$40
 dc.b $20,$80
 dc.b $2E,$80
 dc.b $3D,$80
 dc.b $39,$80
 dc.b $29,$80
 dc.b $57,$80
 dc.b $2F,$00
 dc.b $1E,$00
 dc.b $04,$00

nvc 	dc.w 18
	dc.w 2
 dc.b $08,$00
 dc.b $14,$00
 dc.b $14,$00
 dc.b $14,$00
 dc.b $26,$00
 dc.b $26,$00
 dc.b $26,$00
 dc.b $26,$00
 dc.b $4B,$00
 dc.b $5F,$00
 dc.b $FF,$80
 dc.b $DC,$80
 dc.b $77,$00
 dc.b $55,$00
 dc.b $2A,$00
 dc.b $22,$00
 dc.b $14,$00
 dc.b $08,$00

nvf 	dc.w 18
	dc.w 2
 dc.b $08,$00
 dc.b $14,$00
 dc.b $14,$00
 dc.b $14,$00
 dc.b $32,$00
 dc.b $32,$00
 dc.b $32,$00
 dc.b $32,$00
 dc.b $61,$00
 dc.b $7D,$00
 dc.b $F7,$80
 dc.b $B6,$80
 dc.b $77,$00
 dc.b $77,$00
 dc.b $3E,$00
 dc.b $3A,$00
 dc.b $14,$00
 dc.b $08,$00

phc 	dc.w 14
	dc.w 6
 dc.b $00,$21,$00,$00,$1F,$F0
 dc.b $00,$73,$9F,$FF,$F0,$10
 dc.b $3F,$FF,$FF,$FF,$FF,$D0
 dc.b $7D,$4B,$FF,$FF,$FF,$D0
 dc.b $BD,$EF,$FF,$FF,$FF,$D0
 dc.b $84,$00,$49,$24,$93,$F0
 dc.b $9F,$FF,$FF,$FF,$FF,$F8
 dc.b $BF,$FB,$FF,$FF,$FF,$F8
 dc.b $C3,$B8,$06,$30,$07,$F8
 dc.b $D7,$B9,$FD,$EF,$FF,$F8
 dc.b $C3,$B9,$82,$97,$FF,$78
 dc.b $5C,$B9,$FF,$7B,$08,$08
 dc.b $7D,$BF,$00,$C7,$FF,$F8
 dc.b $07,$F0,$00,$00,$00,$00

phf 	dc.w 14
	dc.w 6
 dc.b $00,$21,$00,$00,$1F,$F0
 dc.b $00,$52,$9F,$FF,$EF,$F0
 dc.b $3F,$BD,$E0,$00,$00,$30
 dc.b $43,$FE,$00,$00,$00,$30
 dc.b $C3,$DE,$00,$00,$00,$30
 dc.b $FB,$FE,$00,$00,$00,$10
 dc.b $FF,$00,$00,$00,$00,$08
 dc.b $E0,$FC,$00,$00,$00,$08
 dc.b $E0,$CF,$FF,$FF,$F8,$08
 dc.b $E0,$CE,$07,$38,$09,$28
 dc.b $E3,$CF,$7F,$FC,$1B,$E8
 dc.b $67,$CF,$FF,$FE,$F7,$F8
 dc.b $7E,$CF,$00,$C7,$FF,$F8
 dc.b $07,$F0,$00,$00,$00,$00

fhc 	dc.w 11
	dc.w 5
 dc.b $00,$00,$00,$20,$00
 dc.b $00,$1F,$80,$70,$00
 dc.b $3F,$FE,$7F,$FF,$E0
 dc.b $E3,$EA,$5B,$FF,$F0
 dc.b $EB,$AA,$7D,$FF,$A8
 dc.b $FD,$BE,$7E,$F7,$68
 dc.b $F9,$BF,$F7,$6F,$F8
 dc.b $DE,$BF,$F3,$FF,$F8
 dc.b $3F,$F7,$9F,$FF,$FC
 dc.b $00,$0F,$E0,$03,$88
 dc.b $00,$00,$00,$01,$00

	even
fhf 	dc.w 11
	dc.w 5
 dc.b $00,$00,$00,$20,$00
 dc.b $00,$1F,$80,$50,$00
 dc.b $3F,$EF,$7F,$BF,$E0
 dc.b $F8,$BB,$67,$40,$D0
 dc.b $B3,$FB,$76,$99,$F8
 dc.b $A6,$FB,$57,$BD,$B8
 dc.b $BE,$FB,$DB,$B4,$D8
 dc.b $E8,$DE,$DC,$1A,$28
 dc.b $3F,$F8,$FF,$FD,$F4
 dc.b $00,$0F,$E0,$02,$88
 dc.b $00,$00,$00,$01,$00

	even
shc 	dc.w 10
	dc.w 4
 dc.b $00,$00,$80,$00
 dc.b $03,$81,$C0,$00
 dc.b $7E,$FF,$FF,$00
 dc.b $BB,$BF,$FE,$80
 dc.b $FE,$FB,$F3,$40
 dc.b $AA,$FA,$F7,$20
 dc.b $AA,$F8,$F3,$C0
 dc.b $BF,$BF,$FF,$C0
 dc.b $78,$FF,$FF,$80
 dc.b $0F,$C0,$01,$00

shf 	dc.w 10
	dc.w 4
 dc.b $00,$00,$80,$00
 dc.b $03,$81,$40,$00
 dc.b $7E,$FE,$BF,$00
 dc.b $CA,$C7,$4F,$80
 dc.b $FB,$88,$91,$C0
 dc.b $CF,$89,$99,$E0
 dc.b $CF,$EF,$9E,$C0
 dc.b $CF,$A7,$0D,$40
 dc.b $7F,$3F,$FE,$80
 dc.b $0F,$C0,$01,$00

nhc 	dc.w 9
	dc.w 3
 dc.b $00,$30,$00
 dc.b $00,$EC,$00
 dc.b $0F,$EB,$00
 dc.b $7F,$7C,$80
 dc.b $80,$F2,$40
 dc.b $70,$7C,$80
 dc.b $0F,$2B,$00
 dc.b $00,$FC,$00
 dc.b $00,$30,$00

	even
nhf	dc.w 9
	dc.w 3
 dc.b $00,$30,$00
 dc.b $00,$EC,$00
 dc.b $0F,$3F,$00
 dc.b $70,$7E,$80
 dc.b $80,$43,$40
 dc.b $7F,$7F,$80
 dc.b $0F,$FF,$00
 dc.b $00,$EC,$00
 dc.b $00,$30,$00

	even
tirc	dc.w 7					; sprites du tir
	dc.w 1
 dc.b $BA
 dc.b $54
 dc.b $82
 dc.b $C6
 dc.b $82
 dc.b $54
 dc.b $BA

 dc.b $FE
 dc.b $FE
 dc.b $FE
 dc.b $FE
 dc.b $FE
 dc.b $FE
 dc.b $FE

	even
tirf	dc.w 7
	dc.w 1
 dc.b $7C
 dc.b $EE
 dc.b $C6
 dc.b $82
 dc.b $C6
 dc.b $EE
 dc.b $7C

 dc.b $FE
 dc.b $FE
 dc.b $FE
 dc.b $FE
 dc.b $FE
 dc.b $FE
 dc.b $FE

tir2c	dc.w 5
	dc.w 1
 dc.b $00
 dc.b $00
 dc.b $28
 dc.b $10
 dc.b $28

 dc.b $00
 dc.b $00
 dc.b $38
 dc.b $38
 dc.b $38

	even
tir2f	dc.w 5
	dc.w 1
 dc.b $00
 dc.b $00
 dc.b $10
 dc.b $38
 dc.b $10

 dc.b $00
 dc.b $00
 dc.b $38
 dc.b $38
 dc.b $38

tir3c	dc.w 5
	dc.w 1
 dc.b $00
 dc.b $00
 dc.b $38
 dc.b $38
 dc.b $38

 dc.b $00
 dc.b $00
 dc.b $38
 dc.b $38
 dc.b $38

 ;****************************************************************************
	bss						; tout cel est cr vide au moment de l'xcution
	even						; plus de 350 octets conomiss :o)
matrice		ds.w	144			; matrice de 10*10 contenant des mots + bords de scurit=12*12
old_int1		dc.l	0			; sauvegarde de l'int1 avant son dtournement
save			dc.l	0			; sauvegarde de a7 au dbut du programme pour le restaurer inchang au retour
u1			dc.l	0			; sauvegarde des cases choisies avec selec pour chaque joueur
cp			dc.l	0			; chane de caractres
batj1			ds.w	5			; liste du nombre de cases intactes pour chaque bateau du joueur 1
batj2			ds.w	5			; liste du nombre de cases intactes pour chaque bateau du joueur 2
tot1			dc.w	0			; nombre total de cases non touches du joueur 1
tot2			dc.w	0			; nombre total de cases non touches du joueur 2
c			dc.w	0			; valeur mise/lue  (a,b) dans la matrice
a			dc.w	0			; coordonnes matrice
b			dc.w	0			; "
x			dc.w	0			; coordones tir ordinateur
y			dc.w	0			; "
xr			dc.w	0			; coordonnes de la premire case touche par l'ordinateur
yr			dc.w	0			; "
rtir			dc.w	0			; tape du tir ordinateur 0, 1 ou 2
tircte		dc.w	0			; constante pour quadrier le tir 0 ou 1
tch			dc.w	0			; 1 si touch
cle			dc.w	0			; 1 si coul
vdpl			dc.b	0			; dplacement vertical pour selec
hdpl			dc.b	0			; dplacement horizontal pour slec
KbdMat		ds.b 10			; ExtendeD's "virtual keyboard"
joueur		dc.b	0			; joueur actif (0 =j2 ou ordi, 1 =j1)
nbrjoueurs		dc.b	0			; nombre de joueurs 1 ou 2
sens			dc.b	0			; 0 = horizontal 1 = vertical
erreur		dc.b	0			; erreur=1,0 sinon
ancd0			dc.b	0			; une sauvegarde de d0 dans getk
sel			dc.b	0			; dtermine si getkey a t appel par selec ou non
 ;****************************************************************************
		end



