; Sim92.asm
; Copyright (c) CUBE Interactive, 1998. All rights reserved.

; Version b0.2

	include tios.h
	include flib.h
	xdef _main
	xdef _comment

	;include Sim92.sdb

; Section (c) Thomas FERNIQUE - Begin ->
WriteStrA MACRO
 move.w  \3,-(a7)
 move.l  \4,-(a7)
 move.w  \2,-(a7)
 move.w  \1,-(a7)
 jsr     tios::DrawStrXY
 lea     10(a7),a7
 ENDM
; -> End - Section (c) Thomas FERNIQUE

_main:

; Main code section

	nop

	jsr flib::zap_screen

	; Initialisation du tableau simarea
	move.l #35,d0
	lea simarea(pc),a0
ini_simarea_loop:
	clr.b (a0)+
	dbra d0,ini_simarea_loop

	; Affichage du tableau de jeu
	; i.e. des 6 points et de leurs noms
	; invariants de boucle : d0 = index du point
	; a0 = adresse des coordonnes du point
	; a1 = adresse des coordonnes du label
	; d1 = label du point
	; d2 est utilis en intermdiare pour la traduction BYTE -> WORD
	move.l #5,d0
	move.w #$30,d1
	lea pt_coor(pc),a0
	lea lbl_coor(pc),a1
	clr.w d2
show_game_loop:
	movem.l d0-d1/a0-a1,-(a7)

	; Affichage du point
	clr.w d2
	move.l d1,-(a7)
	move.b (a0)+,d2 ; y
	move.w d2,-(a7)
	move.b (a0),d2	; Coordonne x
	move.w d2,-(a7)
	jsr flib::pixel_on
	lea 4(a7),a7
	move.l (a7)+,d1

	; Affichage du label
	clr.w d2
	move.w #$00ff,-(a7)
	clr.w -(a7)
	move.w #$00ff,-(a7)
	move.w #4,-(a7) ; Couleur
	move.b (a1)+,d2
	move.w d2,-(a7) ; x
	move.b (a1),d2
	move.w d2,-(a7) ; y
	move.w d1,-(a7) ; Numro
	jsr tios::DrawCharXY
	lea 14(a7),a7

	; Modification des invariants
	movem.l (a7)+,d0-d1/a0-a1
	addq #2,a0
	addq #2,a1
	addq #1,d1
	dbra d0,show_game_loop

	; Boucle principale
	; Invariants :
	; simarea contient la reprsentation du jeu
	; d3.b contient le numro du joueur courant
	;

	move.l #1,d3 ; Le joueur 1 commence (dommage...)
main_game_loop:
	bsr input_turn ; Entre d'un coup
	; On joue le coup
	bsr play_turn
	bsr fatal      ; Fatal ?
	cmpi.b #1,d0
	beq fin
	; d3.b = 3-d3.b
	move.b d3,d4
	moveq #3,d3
	sub.b d4,d3
	bra main_game_loop

	; Fin du programme
fin:
	move.w #60,-(a7)
	move.w #160,-(a7)
	clr.w -(a7)
	move.w #80,-(a7)
	jsr flib::erase_rect
	lea 8(a7),a7
	lea perdustr(pc),a0
	WriteStrA #80,#0,#4,a0
	jsr flib::idle_loop
	rts 

; Sub-routines section

valide:
	; Retourne 1 dans d0.b si le coup (d1.b,d2.b) est valide
	; i.e. (d1.b!=d2.b) && (simarea[d1.b][d2.b]==0)
	; Dtruit d4,a0
	cmp.b d1,d2
	beq valide_inv
	clr.l d4
	move.b d1,d4
	mulu #6,d4
	add.b d2,d4
	lea simarea(pc),a0
	cmpi.b #0,0(a0,d4.w)
	bne valide_inv
	
	moveq #1,d0
	rts
valide_inv:
	clr.b d0
	rts

fatal:
	; Retourne 1 dans d0.b si le coup (d1.b,d2.b) jou par (d3.b) est perdant
	; i.e.
	; for(k=5;k>=0;k--)
	;    if (k!=d1 && k!=d2 && simarea[d1][k]=d3 && simarea[d2][k]=d3)
	;	return 1;
	; return 0;
	; Dtruit d4,a0,a1

	clr.l d4
	move.b d1,d4 ; Positionnement de a0
	mulu #6,d4
	lea simarea(pc),a0
	add.w d4,a0
	addq #5,a0		; BOGUE POSSIBLE
	move.b d2,d4 ; Positionnement de a1
	mulu #6,d4
	lea simarea(pc),a1
	add.w d4,a1
	addq #5,a1		; BOGUE POSSIBLE

	move.w #5,d4 ; Initialisation du compteur
fatal_loop:
	cmp.b d1,d4
	beq continue
	cmp.b d2,d4
	beq continue
	cmp.b (a0),d3
	bne continue
	cmp.b (a1),d3
	bne continue

	moveq #1,d0
	rts
continue:
	subq #1,a0
	subq #1,a1
	dbra d4,fatal_loop
	clr.b d0
	rts

input_turn:
	; Retourne le coup entr (valide) dans (d1.b,d2.b)
	; Affiche "Joueur n :"
	move.b d3,playernum
	addi.b #$30,playernum
	lea playerstr(pc),a0
	WriteStrA #80,#0,#4,a0
	; Affiche "Coor. x ?"
	lea coorxstr(pc),a0
	WriteStrA #80,#10,#4,a0
	bsr input_number
	move.b d0,d1
	; Affiche "Coor. y ?"
	move.w d1,-(a7)
	lea coorystr(pc),a0
	WriteStrA #80,#20,#4,a0
	move.w (a7)+,d1
	bsr input_number
	move.b d0,d2
	; Test de validit
	bsr valide
	cmpi.b #0,d0
	bne fin_input_turn
	lea badinputstr(pc),a0
	WriteStrA #80,#10,#4,a0
	jsr flib::idle_loop
	move.w #60,-(a7)
	move.w #160,-(a7)
	clr.w -(a7)
	move.w #80,-(a7)
	jsr flib::erase_rect
	lea 8(a7),a7
	bra input_turn

fin_input_turn:
	movem.l d0-d3,-(a7)
	move.w #60,-(a7)
	move.w #160,-(a7)
	clr.w -(a7)
	move.w #80,-(a7)
	jsr flib::erase_rect
	lea 8(a7),a7
	movem.l (a7)+,d0-d3
	rts

input_number:
	; Attend l'entre d'un nombre entre 0 et 5, et le retourne dans d0.b
	movem.l d1-d2,-(a7)
	clr.b d0
input_number_loop:
	jsr flib::idle_loop
	cmpi.b #$30,d0
	bcs input_number_loop
	cmpi.b #$35,d0
	bhi input_number_loop
	subi.b #$30,d0
	movem.l (a7)+,d1-d2
	rts

play_turn:
	; Met la valeur d3.b dans simarea[d1.b][d2.b] et simarea[d2.b][d1.b]
	; Dtruit d4,a0
	clr.w d4
	move.b d1,d4 ; Positionnement de a0
	mulu #6,d4
	add d2,d4
	lea simarea(pc),a0
	add.w d4,a0
	move.b d3,(a0)

	move.b d2,d4 ; Positionnement de a0
	mulu #6,d4
	add d1,d4
	lea simarea(pc),a0
	add.w d4,a0
	move.b d3,(a0)

	; Traage de la ligne
	movem.l d0-d3,-(a7)
	clr.w d4
	move.b d3,d4
	; Rcupration des coordonnes
	clr.l d5
	move.b d1,d5
	mulu #2,d5
	clr.l d6
	move.b d2,d6
	mulu #2,d6
	lea pt_coor(pc),a0
	clr.l d0
	move.b 1(a0,d5),d0
	clr.l d1
	move.b 0(a0,d5),d1
	clr.l d2
	move.b 1(a0,d6),d2
	clr.l d3
	move.b 0(a0,d6),d3
	; Trac proprement dit
	bsr bline
	movem.l (a7)+,d0-d3

	rts

bline:
	; Algorithme de Brensenham
	; Paramtres : (d0,d1)-(d2,d3) et d4
	; Trace la ligne de (d0,d1)  (d2,d3) dans le style d4 (plein/pointill)

	move.w d0,a3		; Sauvegarde x0 et y0
	move.w d1,a4
	move.l #$52405241,d1	; Prpare l'automodification
	sub.w d0,d2		; Evalue deltax
	bpl deltax_ok		; Ngatif ?
	neg d2			; Oui on change le signe de deltax
	move.l #$53405241,d1	; dec d0 au lieu de inc d0

deltax_ok:
	sub.w a4,d3		; Evalue deltay
	bpl deltay_ok		; Ngatif ?
	neg d3			; Oui on change le signe
	move.w #$5341,d1	; dec d1 au lieu de inc d1

deltay_ok:
	move.w d2,d5
	or.w d3,d5		; deltax et deltay nuls ?
	bne ok
	rts			; on s'en va

ok:
	move.l d1,dist_pos	; Automodification
	cmp d3,d2		; deltax >= deltay ?
	bge deltax_grand
	exg.w d2,d3		; non, alors on change deltax et deltay
	andi.l #$0000FFFF,d1
	addi.l #$4E710000,d1	; Change le inc d0 en nop
	bra constantes

deltax_grand:
	move.w #$4E71,d1	; Sinon c'est le inc d1 qu'on change

constantes:
	move.l d1,dist_neg	; Automodification
	lsl #1,d3		; dfinit Add_2
	move.w d3,d5		; Sauve en d5
	sub.w d2,d3		; dfinit Start-Dist
	move.w d3,d6		; Sauve en d6
	move.w d6,d7		; Dfinit Add_1
	sub.w d2,d7		; et sauve en d7
	move.w a3,d0		; reprend les valeurs de x0 et y0
	move.w a4,d1

loop_p:
	cmpi.b #2,d4		; Mode pointill
	beq not_dotted
	bchg.l #8,d4
	bne skip_plot

not_dotted:
	movem.w d0-d7,-(a7)
	move.w d1,-(a7)		; Trace un point
	move.w d0,-(a7)
	jsr flib::pixel_on
	lea 4(a7),a7
	movem.w (a7)+,d0-d7

skip_plot:
	or.w d6,d6		; Dist positif ?
	bpl dist_pos

dist_neg:
	addq #1,d0		; Modif. ventuelle
	addq #1,d1
	add.w d5,d6		; met  jour Dist
	dbra d2,loop_p
	rts

dist_pos:
	addq #1,d0		; Modif ventuelle
	addq #1,d1
	add.w d7,d6		; met  jour Dist
	dbra d2,loop_p
	rts

; Data section

simarea		ds.b 6*6 ; L'aire de jeu est un hexagone
pt_coor		dc.b 30,10,50,10,70,30,50,50,30,50,10,30 ; 6 points
lbl_coor	dc.b 25,0,45,0,72,26,45,55,25,55,0,26 ; 6 noms de point
coorxstr	dc.b "Coor. x ?",0
coorystr	dc.b "Coor. y ?",0
perdustr	dc.b "Lost !",0
badinputstr	dc.b "Bad input",0
playerstr	dc.b "Joueur "
playernum	dc.b 0," :",0

_comment	dc.b "v b0.2 (c) CUBE Interactive.",0

	END