	@program	prog_code,prog_name
	include	macros.h
	include raptor92.h

;************** Start of Fargo program ***************

prog_code:
	bsr	Init
	tst.l	d0
	beq	Exit
	
	bsr	Menu

Exit

	tst.w	BScrHdl			;Was handle created ?
	beq	\NoDestroy		;No, don't delet it
	move.w	BScrHdl,-(a7)		
	jsr	romlib[destroy_handle]
	lea	2(a7),a7
\NoDestroy
	tst.w	BMosHdl			;Was handle created ?
	beq	\After			;No, don't delete it
	move.w	BMosHdl,-(a7)
	jsr	romlib[destroy_handle]
	lea	2(a7),a7
\After
	rts


;---------------------------------------------------
; Loop for playing
;--------------------------------------------------
Play:
	move.l	#50,XPlayer
	move.l	#50,YPlayer
	move.l	#0,PlayerSpr

	move.b	#3,NbLives

	bsr	InitScreen
	bsr	ClrBuf
	moveq.w	#15,d6			;Line in buf to print for all the prog
	bsr	MosInBuf

	move.l	LevelAdr,a6		;Point to the world for all the prog
	adda	#46,a6
\Loop
	bsr	ScrollScr		;Scroll the buffer 
	bsr	CpyFirstLine		;Copy a line from BMosAdr to the buffer

	bsr	Buf2Scr			;Copy the buffer to the screen
	
	move.l	XPlayer,d0
	move.l	YPlayer,d1
	move.l	PlayerSpr,d2
	bsr	PutSprite

	bsr	Keys			;See if there is keys
	tst.l	d0
	bne	\Loop

	jsr	graylib[off]

	move.w	#$2700,sr
	move.l	old_int_1,($020064)
	move.w	#$2000,sr

	rts
;---------------------------------------------------
; Menu
;----------------------------------------------------
Menu:
	jsr	flib[clr_scr]		;Clear the screen

	SetFont	#2
	WriteStr #0,#1,#0,title

	SetFont	#0
	WriteStr #50,#110,#1,cpyright

	SetFont	#1
	WriteStr #90,#30,#1,Menu1
	WriteStr #70,#50,#1,Menu2
	WriteStr #85,#75,#1,Menu3

\Mnu	jsr	flib[idle_loop]		;Wait for a key
	cmp.w	#268,d0			;Was F1 ?
	beq	\play			;Yes, play
	cmp.w	#269,d0
	beq	\loadlevel
	cmp.w	#264,d0			;Was ESC ?
	beq	\exit			;Yes, exit
	bra	\Mnu			;else, loop

\play	tst.b	LevelLoad
	beq	\noloaded
	bsr	Play
	bra	Menu
\noloaded
	lea	title3(PC),a4
	bsr	MsgBox
	WriteStr #65,#60,#4,Err4
	jsr	flib[idle_loop]
	bra	Menu	

\loadlevel
	bsr	LoadALevel
	bra	Menu

\exit	rts
;-------------------------------------------------------
; Initialisation function
;--------------------------------------------------------
Init:
	move.l	#5376,-(a7)		;Size of handle : (24*112)*2 (for grayscale)
	jsr	romlib[create_handle]	;Create the handle
	lea	4(a7),a7
	move.w	d0,BScrHdl		;Save the handle number
	tst.l	d0			;Was OK ?
	beq	\exit			;NO, exit
	move.w	d0,BScrHdl		;Save the handle number
	handle_ptr d0,a0		;
	move.l	a0,BScrAdr		;Save the adress

	move.l	#768,-(a7)		;size of handle : (24*8)*2 (for grayscale)
	jsr	romlib[create_handle]	;create the handle
	lea	4(a7),a7
	move.w	d0,BMosHdl		;Save the handle number
	tst.l	d0			;was OK ?
	beq	\exit
	handle_ptr d0,a0
	move.l	a0,BMosAdr		;Save the adress

	clr.b	LevelLoad
	lea	DefaultLev,a4
	bsr	LoadLevel

\exit	rts

;----------------------------------------------------
; Initialise the screen
;---------------------------------------------------
InitScreen:
	move.w	#$2700,sr
	move.l	($020064),old_int_1
	move.l	#int_1,($020064)
	move.w	#$2000,sr


	jsr	graylib[on]
	move.l	a6,grayplane
	bsr	ClearScreen

	move.l	grayplane,a1
	move.l	#LCD_MEM,a0
	adda	#3390,a0
	adda	#3420,a1
	move.w	#23,d3
\line1	move.b	#$FF,(a1)+
	move.b	#$FF,(a0)+
	dbra	d3,\line1

	move.l	#LCD_MEM,a0
	adda	#24,a0
	move.w	#127,d3

\line2	move.b	#%10000000,(a0)
	adda	#30,a0
	dbra	d3,\line2

	WriteStr #195,#10,#1,Live
	WriteStr #195,#40,#1,scor
	WriteStr #10,#117,#1,armor
	rts

;------------------------------------------------------
; 
;------------------------------------------------------
Keys:
	move.w	#%1111111111111110,($600018)
	nop
	nop
	nop
	nop
	move.b	($60001B),d0
	
	btst	#6,d0
	beq	\right
	btst	#4,d0
	beq	\left
	btst	#5,d0
	beq	\up
	btst	#7,d0
	beq	\down


	move.w	#%1111110111111111,($600018)
	nop
	nop
	nop
	nop
	move.b	($60001B),d0
	
	btst	#3,d0
	bne	\exit

	clr.l	d0
	rts

\left	cmp.l	#1,XPlayer
	bls	\exit
	sub.l	#2,XPlayer
	rts

\right cmp.l	#174,XPlayer
	bhi	\exit
	add.l	#2,XPlayer
	rts

\up	cmp.l	#2,YPlayer
	bls	\exit
	sub.l	#2,YPlayer
	rts

\down	cmp.l	#94,YPlayer
	bhi	\exit
	add.l	#2,YPlayer

\exit	rts
;------------------------------------------------------
; Copy the line from the mosaique buffer pointed by d6 to 
; the first line of the buffer
;--------------------------------------------------------
CpyFirstLine:
	move.l	BScrAdr,a0
	move.l	BMosAdr,a1
	move.w	d6,d0			;Save d6 in d0
	mulu.w	#24,d0			;12 mos * 2bytes
	adda	d0,a1			;Point to the beg of the d6 line in buffer mosaique
	moveq.w	#23,d3			;12 loops (copy 24 bytes)
\CpyLine
	move.b	384(a1),2688(a0)
	move.b	(a1)+,(a0)+		;Copy from mosaique buffer to screen buffer
	dbra	d3,\CpyLine

	tst.w	d6			;D6=0 ?
	bne	\NoZero			;No
	moveq.w	#16,d6			;Yes, d6=8 (-1)
	bsr	MosInBuf		;Read the new line of mosaique

\NoZero	subq.w	#1,d6

	rts

;-----------------------------------------------------
; Put the 22 first mos in the screen
; a6 is the pointer to the world description
;------------------------------------------------------
MosInBuf:
	move.l	MosAdr,a3
	move.l	BMosAdr,a2
	moveq.w	#11,d3			;12 loops
	
\Put24Mos
	clr.l	d0
	move.b	(a6)+,d0
	lsl.w	#6,d0			;d0*64
	move.l	a3,a4			;Save a3 in a4
	adda	d0,a4			;a4 point to the beg of mosaique
	move.l	a2,a1			;Save a2 in a1
	moveq.w	#15,d2			;16 laps

\Cpy16Lines
	move.w	(a4)+,(a1)		;put first mos in first part of buffer
	move.w	(a4)+,384(a1)		;Put the 2nde mos in the 2nde part of the buffer
	adda	#24,a1			;next line
	dbra	d2,\Cpy16Lines

	addq.l	#2,a2
	dbra	d3,\Put24Mos
	
	rts

;----------------------------------------------------
; Clear ALL the buffer screen (normal & grayscale)
;---------------------------------------------------
ClrBuf:
	move.l	BScrAdr,a0
	move.w	#1343,d3	;((24*112)*2)/4
\Clr	clr.l	(a0)+
	dbra	d3,\Clr
	rts
;----------------------------------------------------
; Copy the buffer to the screen
;-----------------------------------------------------
Buf2Scr:
	move.l	#LCD_MEM,a0	;Point to the video
	adda	#30,a0		;1 line after
	move.l	BScrAdr,a2	;Point to the buffer
	move.l	grayplane,a4	;point for grayscale
	adda	#30,a4
	moveq.w	#111,d3		;112 loops

\Cpy120Lines
	moveq.w	#5,d2		;6 loops
\CpyLine
	move.l	2688(a2),(a4)+
	move.l	(a2)+,(a0)+	;Copy buffer to screen
	dbra	d2,\CpyLine
	adda	#6,a0
	adda	#6,a4
	dbra	d3,\Cpy120Lines
	rts

;----------------------------------------------------
; Scroll Buffer screen
;------------------------------------------------------
ScrollScr:
	move.l	BScrAdr,a0
	adda	#2664,a0	;a0=24*111
	move.l	a0,a1
	adda	#24,a1
	move.w	#665,d3		;666 loops (24*111/4)

\Scroll	move.l	-(a0),-(a1)
	move.l	2688(a0),2688(a1)
	dbra	d3,\Scroll
	rts

;-----------------------------------------------------
; Load a level
; Input : a0 : pointer to the beginning of the file name
;-----------------------------------------------------
LoadALevel:
	lea	title2(PC),a4
	bsr	MsgBox

	move.w	#8,d1			;8 charac
	move.w	#90,d2			;x=90
	move.w	#60,d3			;y=60
	lea	LevelName(PC),a0	;Point to the level name
	move.l	a0,a4			;Save a0
	bsr	Input			;Call the subroutine
	tst.l	d0			;ESC ?
	beq	exit			;Yes, exit
	
LoadLevel:
	move.l	a4,-(a7)		;Push the adress of the string
	jsr	core[find_var]		;Search the file
	lea	4(a7),a7

	tst.l	d0			;Find ?
	beq	\nolevel			;No, exit
	
	move.w	d0,LevelHdl		;Save the handle file
	handle_ptr d0,a6		;Give the adress file
	move.l	a6,a0			;Save a6

	move.w	(a6),d0			;d0=size of file
	cmp.b	#$E0,1(a6,d0)		;IS a text?
	bne	\invalid
	cmp.w	#$0100,4(a6)		;Check version
	bne	\invalid

	adda	#37,a0
	move.l	a0,-(a7)
	jsr	core[find_var]
	lea	4(a7),a7
	tst.l	d0
	beq	\nomosaic

	handle_ptr d0,a0
	adda	#12,a0
	move.l	a0,MosAdr

	move.l	a6,LevelAdr
	move.b	#1,LevelLoad		;OK, a level is loaded
	bra	exit

\invalid
	lea	Err3(PC),a0
	bra	\ShowMsg	
\nomosaic
	lea	Err2(PC),a0
	bra	\ShowMsg
\nolevel
	lea	Err1(PC),a0
\ShowMsg
	move.w	#4,-(a7)
	move.l	a0,-(a7)
	move.w	#60,-(a7)
	move.w	#65,-(a7)
	jsr	romlib[puttext]
	lea	10(a7),a7
	jsr	flib[idle_loop]

exit	rts

;-------------------------------------------------------
; Draw a universal window dialog
;
;	Input : a4 : point to the title string
;-------------------------------------------------------
MsgBox:
	DrawBox	#56,#40,#184,#80
	SetFont #2

	move.w	#0,-(a7)
	move.l	a4,-(a7)
	move.w	#41,-(a7)
	move.w	#56,-(a7)
	jsr	romlib[puttext]
	lea 	10(a7),a7
	
	SetFont	#1

	rts
;------------------------------------------------------
; Clear Screen (grayscale) by Jimmy Mardell
;-------------------------------------------------------
ClearScreen:             ; Clears both bitplanes, doesn't change any registers
 movem.l d0/a0-a1,-(a7)  ; Push all registers used
 move.l  #959,d0         ; The screen is $F00 bytes = 960 longwords.
 move.l  grayplane,a0    ; Make A0 point at the greyscale plane (plane 1)
 move.l  #$4440,a1       ; and A1 to the LCD memory (plane 0)
RepClr:
 clr.l   (a0)+           ; Clear a longword, increase A0 with 4
 clr.l   (a1)+           ; Clear a longword, increase A1 with 4
 dbra    d0,RepClr       ; Repeat
 movem.l (a7)+,d0/a0-a1  ; Pop the registers
 rts

;---------------------------------------------------
; Put a 16x16 grayscale sprite (by Jimy Mardell)
; Input :	d0 : X
;		d1 : Y
;		d2 : sprite
;---------------------------------------------------
PutSprite:             ; Puts sprite D2 at D0,D1

 movem.l d0-d3/a0-a2,-(a7)
 lea     sprites(PC),a0
 lsl.l   #6,d2
 adda.l  d2,a0
 lsl.w   #1,d1
 move.l  d1,d2
 lsl.w   #4,d2
 sub.w   d1,d2
 move.b  d0,d1
 and.w   #$FFF0,d0
 lsr.b   #3,d0
 add.w   d0,d2
 and.b   #$0F,d1
 sub.b   #16,d1
 neg     d1
 moveq   #15,d0
 lea     $4440,a1
 move.l  grayplane,a2
 adda.l  d2,a1
 adda.l  d2,a2
 move.l  #$FFFF0000,d3
 rol.l   d1,d3
PS_PutRow:
 clr.l   d2
 move.w  (a0)+,d2
 lsl.l   d1,d2
 eor.l    d2,(a1)
 clr.l   d2
 move.w  (a0)+,d2
 lsl.l   d1,d2
 eor.l    d2,(a2)
 lea     30(a1),a1
 lea     30(a2),a2
 dbra    d0,PS_PutRow
 movem.l (a7)+,d0-d3/a0-a2
 rts



int_1:				;a small tips...
	rte
;*****************************************************
; Program data
;*****************************************************

sprites	INCBIN raptor92.bin



BScrAdr	dc.l	0		;Buffer for the screen
BScrHdl	dc.w	0		;Handle
BMosAdr	dc.l	0		;Buffer for the 22mos of the new line
BMosHdl	dc.w	0		;Handle

grayplane dc.l	0
old_int_1 dc.l	0


XPlayer	dc.l	0
YPlayer	dc.l	0
PlayerSpr dc.l	0
NbLives	dc.b	0


LevelHdl dc.w	0
LevelAdr dc.l	0
LevelName dc.b	0,0,0,0,0,0,0,0,0,0
LevelLoad dc.b	0				;a boleen
DefaultLev dc.b	"raptor1",0

MosAdr	dc.l	0

prog_name:
	dc.b	"RAPTOR 92 v0.2",0,0


Menu1	dc.b	"F1 : Play",0
Menu2	dc.b	"F2 : Load Level",0
Menu3	dc.b	"ESC : Exit",0
title	dc.b	26,"         RAPTOR  92         ",25,0
title2	dc.b	"  LOAD A LEVEL  ",0
title3	dc.b	"      ERROR     ",0

Err1	dc.b	"Level not found !",0
Err2	dc.b	"Mosaic not found!",0
Err3	dc.b	"Invalid Level !",0
Err4	dc.b	"No level loaded.",0

Live	dc.b	"Lives :",0
scor	dc.b	"Score :",0
armor	dc.b	"Armor :",0
cpyright dc.b	"RAPTOR 92.       ",64,"Copyright Benoit SCHERRER",0


;*************** End of Fargo program ****************

	reloc_open
	add_library	romlib
	add_library	flib
	add_library	graylib
	reloc_close
	end
