//###########################################################################//
//
//Project :  JezzBall  v 1.00 
//
//Author:  David Coz      
//
//Mail  :  coz.hubert@infonie.fr
//
// Main Program
//
//Created 13/04/2002; 00:21:07
//
//############################################################################//




#define USE_TI89              // Produce .89z File
#define SAVE_SCREEN           // Save/Restore LCD Contents

#include <tigcclib.h>         // Include All Header Files
#include "sprites_jezz.h"      
#include "title_jezz.h" 

// Useful (and fast) Macros,thanks to Thomas Nussbaumer
#define PIXOFFSET(x,y)  ((y<<5)-(y<<1)+(x>>3))
#define PIXADDR(p,x,y)  (((unsigned char*)(p))+PIXOFFSET(x,y))
#define PIXMASK(x)      ((unsigned char)(0x80 >> ((x)&7)))
#define GETPIX(p,x,y)   (!(!(*PIXADDR(p,x,y) & PIXMASK(x))))
#define SETPIX(p,x,y)   (*PIXADDR(p,x,y) |=  PIXMASK(x))


// Constants Definition
#define HORIZONTAL     0     
#define VERTICAL       1
#define NEXT           77    
#define MAX_BALL       30
#define LOOSE          99

//Virtual Screen
 
void *Vscreen2=NULL;// Contain the Background:Walls you'll draw,Infos 
void *Vscreen=NULL; // Contain the rest

// Speed Setting
int ball_speed=9;
int cursor_speed=10;
int line_speed=15;


//Structure for your Cursor
typedef struct
{
	int x;
	int y;
  int dir;//cursor direction
  } CURSOR;

CURSOR cursor;

// Structure for lines (when pressing 2nd)
typedef struct
{
  int activate;// 1 if a line is drawn

	//Coordinates
	int x1; 
	int x2;
	int y1;
	int y2;
	int dir;   // Line direction
	int over_1;//1 if Point 1 is over
	int over_2;//1 if Point 2 is over
  int dx;    //Will be added to X-values
	int dy;    //Will be added to Y-values
} LINE;

LINE line;


//Structure for Balls
typedef struct
{
	int x;
	int y;
	int vx;//Will be added to X-values
  int vy;//Will be added to Y-values
  int speed; 
} BALL;

// Array of Balls,can contain MAX_BALL balls
BALL all_ball[MAX_BALL];


//Structure for HighScores
typedef struct
  {
    char name[10];
    unsigned long score;
  } HSC_ITEM;



int num_ball;
int lifes;
int level;
long int to_fill=128*98;// Pixels to fill
long int filled;        // What you fill
long int percentage;    // when reaches 75,next level
int score;      
int difficulty;         // 0 = Easy,...  


// Waiting function
void wait(unsigned short int w)
{
OSFreeTimer(USER_TIMER);
	OSRegisterTimer(USER_TIMER,w);
	
	 while(!OSTimerExpired(USER_TIMER));
	
}


//Input your name.Thanks to Zeljko Juric with Cave Blaster
 void input_str(char *str)
{
PortSet(LCD_MEM,239,127);
ClrScr();
  int i=0,key=0;
  DrawStr(10,10,"CONGRATULATIONS!",A_NORMAL);
  FontSetSys(F_6x8);
  DrawStr(10,30,"You Entered The TOP!",A_NORMAL);
  DrawStr(10,50,"Enter Your Name:",A_NORMAL);

  FontSetSys(F_6x8);
  while(key!=13)
    {
      str[i]='_'; str[i+1]=' '; str[i+2]=0;
      DrawStr(30,60,str,A_REPLACE);
      key=ngetchx();
      if(key>=' '&&key<='~'&&i<8) str[i++]=key;
      if(key==257&&i)
      {
      	   	i--;
      }
}
str[i]=0;
}


//Give your rank in the highscores:1,2 or 3
void best(HSC_ITEM bestscore[],unsigned long score)
{
  int i;
  for(i=2;(bestscore[i-1].score<score)&&i;i--)
    memcpy(&bestscore[i],&bestscore[i-1],sizeof(HSC_ITEM));
  bestscore[i].score=score;
  ClrScr();
  FontSetSys(F_8x10);
  input_str(bestscore[i].name);
 }



// Draw Horizontal or Vertical Lines
// Return 1 if there was a pixel under the line
int drawline(short x1,short y1,short x2,short y2,short mode,unsigned char* plane)
{
int x,y;
char collision=0;
if (mode==VERTICAL)
{
	for (y=y2;y!=y1;y++)
	{
   collision|=GETPIX(Vscreen,x1,y);         
   SETPIX(plane,x1,y);
	}
}
if (mode==HORIZONTAL)
{
	for (x=x2;x!=x1;x++)
	{
   collision|=GETPIX(Vscreen,x,y1);         
   SETPIX(plane,x,y1);
	}
}
return collision;	

}
   

// Return 1 if there is at least one collision 
// betwwen the sprite and pixels already drawn 
// Sprite shouldn'tbe larger than 24 pixels
int test_sprite(int x,int y,long sprite[],int height,unsigned char* plane)
{
int i;
unsigned char* addr=PIXADDR(plane,x,y);//Pixel Adress
unsigned long mask1 =PIXMASK(x),mask2,data;
for (i=0;i<8;i++)
{
if (mask1&(1<<i))
break;
mask1|=1<<i;
}
mask2=(~(mask1&255))|0xFFFFFF00;
mask1=((mask1<<24)|0xFFFFFF)&mask2;
//Mask1 contains your sprite line

for(i=0;i<height;i++,addr+=30)
{
data=((unsigned long)(*addr)<<24)+((unsigned long)(*(addr+1))<<16)
+((unsigned long)(*(addr+2))<<8)+(*(addr+3));
//Data contains the Screen line

data=data&mask1&((sprite[i])>>(x&7));
if (data!=0)
return 1;
}
return 0;
}


//Create a New Ball
void new_ball()
{
num_ball++;

// Set randomly the Ball Direction on X,Y 
all_ball[num_ball-1].vx=ball_speed;
if (random(2))
all_ball[num_ball-1].vx=-ball_speed;

all_ball[num_ball-1].vy=ball_speed;
if (random(2))
all_ball[num_ball-1].vy=-ball_speed;

// Set randomly the Ball Position 
all_ball[num_ball-1].x=(30+random(80))<<4;
all_ball[num_ball-1].y=(20+random(50))<<4;

}

//Draw the Rectangles (in Vscreen2) that fill the Screen
void rec_draw()
{
// Save Coordinates from the Line you made
int x1=(line.x1>>4);
int y1=(line.y1>>4);
int x2=(line.x2>>4);
int y2=(line.y2>>4);


int flag1=0,flag2=0;
int x,y,dx=0,dy=0,y_low,y_high,y_goal,x_high,x_low,x_goal,i;
	
	if (line.dir==HORIZONTAL) //For Horizontal Lines
	{
			  //Detects the bounds of the area your cursor actually is
				 // y_low => Vertical Low Bound Coordinate
				 for (y_low=y1;;y_low--)
				 if (GETPIX(Vscreen2,x1,y_low))
				 break;
				 
				 // y_high => Vertical High Bound Coordinate
				 for (y_high=y1;;y_high++)
				 if (GETPIX(Vscreen2,x1,y_high))
				 break;
				 
				 //So the Cursor Area is a Rectangle
				 // defined by (x1 , y_high) and (x2 , y_low)   
					    
					// Ball Detection    
					for (i=0;i<num_ball;i++)
					{
							//If this ball is not in the area,skip it 
							if (all_ball[i].x>>4<x2||all_ball[i].x>>4>x1
							||all_ball[i].y>>4<y_low||all_ball[i].y>>4>y_high)
							 continue;
							
							  
								if (y1 > (all_ball[i].y>>4) )
							  	flag1=1; //The Ball is above your line
							  else
							    flag2=1; //The Ball is under your line
				  }
				  
				  //If there are Balls under and above,only draw a single line
				  if (flag1&&flag2) 
				  {
						 	DrawLine(x1,y1,x2,y2,A_NORMAL);
						 filled+=x1-x2; // Increase filled area
						 	return;
				  }
				if (flag1) //The Ball is above your line
				 {dy=1;y_goal=y_high;} // So we must fill toward y_high
				 
				if (flag2)       //The Ball is under your line  
				 {dy=-1,y_goal=y_low;} // So we must fill toward y_low
						
						
						//Draw the Rectangle (at least..:-)
					
						for (y=y1 ; y!=y_goal ; y+=dy) // until we reach y_goal
					  {
					  	filled += x1-x2; // Increase filled area
					    DrawLine(x1,y,x2,y,A_NORMAL);	//Draw the Line
					  }
	}
	else // Same Ideas but for Vertical Lines...
	{   
	
					for (x_high = x1 ; ; x_high ++)
					 if (GETPIX(Vscreen2,x_high,y1))
					 break;
					 
					 for (x_low = x1 ; ; x_low --)
					 if (GETPIX(Vscreen2,x_low,y1))
					 break;
					
						for (i=0;i<num_ball;i++)
						{
								if (all_ball[i].y>>4<y2||all_ball[i].y>>4>y1
								||all_ball[i].x>>4<x_low||all_ball[i].x>>4>x_high)
								continue;
								
								if (x1>all_ball[i].x>>4)
								 flag1=1;
								else
								 flag2=1;
					  }
					  
					  if (flag1&&flag2)
					  {
						  DrawLine(x1,y1,x2,y2,A_NORMAL);
						  filled+=y1-y2;
						  return;
					  }
					if (flag1)
					 { dx = 1 ; x_goal = x_high ; }
					if (flag2)
					 { dx = -1; x_goal = x_low ; }
				     
				     for (x = x1 ; x!=x_goal ; x+=dx )
						  {
						  	filled += y1-y2;
						    DrawLine(x,y1,x,y2,A_NORMAL);	
						  }
	
	}
}


// Draw Lines in Vscreen 2 (when pressing 2nd)
int line_draw()
{

// if over_1=0,update point 1 position
if (line.over_1==0){
line.x1+=line.dx*line_speed;
line.y1+=line.dy*line_speed;
}

// if over_2=0,update point 2 position
if (line.over_2==0){
line.x2-=line.dx*line_speed;
line.y2-=line.dy*line_speed;
}

// If point 1 reaches Something in Vscreen2(Walls)
if (GETPIX(Vscreen2,(line.x1)>>4,(line.y1)>>4))
{
line.over_1=1; // Point 1 is over
line.x1-=line.dx*line_speed;
line.y1-=line.dy*line_speed;
}

// If point 2 reaches Something in Vscreen2(Walls)
if (GETPIX(Vscreen2,(line.x2)>>4,(line.y2)>>4))
{
line.over_2=1;// Point 2 is over
line.x2+=line.dx*line_speed;
line.y2+=line.dy*line_speed;
}

// point 1 and Point2 are over : the line is over...
if (line.over_1&&line.over_2)
{
line.activate=0; //desactivate the line	
rec_draw();      //Draw the Rectangle
percentage=(long)(filled*100)/(to_fill);//Update Pecentage
printf_xy(135,8,"%02ld%%",percentage);  //Display Percentage
if (percentage>74)  // Percentage>75 , Next Level !
return NEXT;
return 0;
}

// Draw the Line
// If the Line reaches something in Vscreen (Balls),you loose !
if (drawline(line.x1>>4,line.y1>>4,line.x2>>4,line.y2>>4,line.dir,Vscreen))
return LOOSE;

return 0;	
}

// Draw all the Balls in Vscreen
void draw_ball()
{
int i;
// For all the balls...
 for (i=0;i<num_ball;i++)
  {
     // If something is hit when updating X coordinates,
     // invert the X direction...
		if (test_sprite((all_ball[i].x+all_ball[i].vx)>>4,
		 all_ball[i].y>>4,ball,6,Vscreen2))
		all_ball[i].vx=-all_ball[i].vx;
	
	  // If something is hit when updating Y coordinates,
     // invert the Y direction...
		if (test_sprite(all_ball[i].x>>4,
		 (all_ball[i].y+all_ball[i].vy)>>4,ball,6,Vscreen2))
		all_ball[i].vy=-all_ball[i].vy;
		
		//Update the Ball coordinates...
		all_ball[i].x+=all_ball[i].vx;
		all_ball[i].y+=all_ball[i].vy;
		
		//Draw the Ball
		Sprite32(all_ball[i].x>>4,all_ball[i].y>>4,6,
		ball,Vscreen,SPRT_OR);
 }
	
}


// Key Detection
int key()
{

//Variable used to slow down diamond key detection  
static unsigned int diamond_delay;
diamond_delay++;

// ESC id pressed
if 	(_rowread(~((short)(1<<6))) & (1<<0))
return 264;

// 2nd id pressed
// if there is no line drawn and if the cursor is on a blank area...
if 	(_rowread(~((short)(1<<0))) & (1<<4)&&line.activate==0&&
GETPIX(Vscreen2,(cursor.x>>4)+(cursor.dir)*3,(cursor.y>>4)+(1-cursor.dir)*3)==0)
{
line.activate=1;  // Activate a Line
line.dx=1-cursor.dir;// Set Line Direction on X-Axis 
line.dy=cursor.dir;  // Set Line Direction on Y-Axis
line.over_1=0;       
line.over_2=0;
line.dir=cursor.dir; // HORIZONTAL or VERTICAL

// Set Line Points Coordinates
line.x1=cursor.x+(cursor.dir)*(3<<4);
line.x2=line.x1;
line.y1=cursor.y+(1-cursor.dir)*(3<<4);
line.y2=line.y1;
}

// If Diamond is pressed and diamond_delay>50 
if 	(_rowread(~((short)(1<<0))) & (1<<6)&&diamond_delay>50)
{
diamond_delay=0; //reset diamond_delay
cursor.dir=1-cursor.dir;//change cursor direction
}

// Clear is pressed
if(_rowread(~((short)(1<<1))) & (1<<6))
off();

// Right is pressed
if (_rowread(0x7E)&0x08)
	{
	if (cursor.x>>4<121)
	cursor.x+=cursor_speed;
  cursor.dir=VERTICAL;
  }

// Left is pressed
if (_rowread(0x7E)&0x02)
	{
	if (cursor.x>>4>1)
	cursor.x-=cursor_speed;
  cursor.dir=VERTICAL;
  }

// Down is pressed
if (_rowread(0x7E)&0x04)
	{
	if (cursor.y>>4<91)
	cursor.y+=cursor_speed;
  cursor.dir=HORIZONTAL;
  }

// Up is pressed
if (_rowread(0x7E)&0x01)
	{
	if (cursor.y>>4>1)
	cursor.y-=cursor_speed;
  cursor.dir=HORIZONTAL;
  }

//Draw the Cursor  
Sprite8(cursor.x>>4,cursor.y>>4,8,cursor_spr[cursor.dir],Vscreen,SPRT_XOR);

return 0;
} 



int display()
{
// Copy the Walls in Vscreen
memcpy(Vscreen,Vscreen2,3840);

// Draw the balls
draw_ball();

int value=0;

// if a line is activated...	
if (line.activate)
value=line_draw();

// if line_draw doesn't return 0... 
if (value!=0)
{
memcpy(Vscreen,Vscreen2,3840);
draw_ball();
memcpy(LCD_MEM,Vscreen,3840);	
return value;
} 

value=0;
// key detection
value=key();
// copy Vscreen on the Screen
memcpy(LCD_MEM,Vscreen,3840);	

return value;

}


// initialize variables at the beginning of each level
void init()
{
percentage=0;
lifes=level; //You get as many life as the level you are
filled=0;    //You fill 0 pixels 
line.activate=0;//No Line activated
PortSet(Vscreen2,239,127);//Redirected Graphical functions to Vscreen2
ClrScr();                      
// Display Informations
FontSetSys(F_6x8);
printf_xy(135,8,"%02ld%%",percentage);
printf_xy(132,33,"%04d ",score);
Sprite16(134,58,8,heart,Vscreen2,SPRT_OR);
printf_xy(148,58,"%d%",lifes);
printf_xy(132,83,"Lv %d%",level);

// Draw the Frame
DrawLine(0,0,129,0,A_NORMAL);
DrawLine(0,0,0,99,A_NORMAL);
DrawLine(0,99,129,99,A_NORMAL);
DrawLine(129,0,129,99,A_NORMAL);
int i;
for (i=0;i<3;i++)
DrawLine(129,22+i*25,159,22+i*25,A_NORMAL);


// Disable All Interrupts
OSSetSR(0x0400);


// Cursor initial Setting
cursor.x=20<<4;
cursor.y=20<<4;
cursor.dir=HORIZONTAL;

// Create a new ball
if (num_ball<MAX_BALL)
new_ball();

}

// Initial HighScores Table
static HSC_ITEM bestscore[3][3]={
	{{"David",300},{"David",150},{"David",100}},
	{{"David",300},{"David",150},{"David",100}},
  {{"David",300},{"David",150},{"David",100}}	};

// Difficulty Settings
// the number represents the speed
HSC_ITEM diff[3]={{"Easy  ",280},{"Normal",140},{"Hard  ",10}};


// Main Function
void _main(void)
{
// Allocate Memory for Virtual Screens
Vscreen = malloc(3840);
Vscreen2 = malloc(3840);

difficulty=0; //Easy
int speed;
int value;
unsigned i,j,f,key;

//Main Loop
while(1)
{
			
			value=0;
			key=0;
			title(); //Display 'Jezzball' title
			randomize();
			
			
			num_ball=0; 
			lifes=0;   
			level=0;
			score=100;
			
			// Title Choice 
			 while (key!=13)
			{
			
						FontSetSys(F_8x10);
						DrawStr(25,74,"Level :",A_NORMAL);
						DrawStr(85,74,diff[difficulty].name,A_REPLACE);// display the difficulty
						FontSetSys(F_6x8);
						
						// Dispaly the 3 highscores
						for (i=0;i<3;i++)
						{
						DrawStr(30,44+9*i,"                ",A_REPLACE);
						DrawStr(80,44+9*i,bestscore[difficulty][i].name,A_NORMAL);
						printf_xy(30,44+9*i,"%ld by",bestscore[difficulty][i].score);
						}
						
						key=ngetchx();
						// you press right
						if (key==344)
						{
						  difficulty++;
							if (difficulty==3)
						  difficulty=0;
						}
						// you press left
						if (key==338)
						{
						difficulty--;
							if (difficulty==-1)
						difficulty=2;
						}
						// you press ESC
						if (key==264)
						break;
						
			
			}
			
			if (key==264)
			break;
			
			// Set Speed Variable,depending on difficulty
			speed=diff[difficulty].score;
			
			// Initialize 
			init();	
			
			f=0; // Variable for Score Count-down
			
			while (value==0)
			{
						value=display();
						
						f++;
						
						if (f==50)
						{
						// Decrease Score and redraw it
						 f=0,score--;
						 printf_xy(132,33,"%04d ",score);
						}
						// If score<0 , you loose
						if (score<0)
						{
						 value=LOOSE;
						 score=0;
						}
						
						// Waiting loop,depending on speed variable
						for (i=0;i<speed*10;i++)
						{
							for (j=0;j<100;j++)
							{
								
							}
						}
						
						// if you loose a life
						if (value==LOOSE)
						{
						
								PortSet(LCD_MEM,239,127);
								// Xor the Screen
								ScrRectFill(&(SCR_RECT){{0, 0, 159, 99}}, &(SCR_RECT){{0, 0, 159, 99}}, A_XOR);
								wait(13);
								ScrRectFill(&(SCR_RECT){{0, 0, 159, 99}}, &(SCR_RECT){{0, 0, 159, 99}}, A_XOR);
								
								line.activate=0;
								lifes--;
								value=0;
								if (lifes==-1)
								break;	
								PortSet(Vscreen2,239,127);
								printf_xy(148,58,"%d%",lifes);
						
						}
						// if you finish this level
						if (value==NEXT)
						{
							
								level++;
								score+=(percentage-70)*level*20;
								//increase Score,according to your percentage and level
							 	score+=lifes*20*level;
							  //increase Score,according to your lifes left and level
								wait(13);
							  //initialize a new level (will add a ball)
								init();
								value=0;
						 
						 }
		
			}
			
			// If you make a highscore
			if (score>bestscore[difficulty][2].score)
			best(bestscore[difficulty],score);
			
}

//free allocated memory
free(Vscreen);
free(Vscreen2);
PortRestore();	
	
	
}
