	include "doorsos.h"
	include "Graphlib.h"
	xdef	_library
	xdef    _ti89
	xdef    _ti92plus
	xdef	userlib@0000	;idle_loop	;OK
	xdef	userlib@0001	;random	;OK
	xdef	userlib@0002	;rand_seed	;OK
	xdef	userlib@0003	;exec		;OK
	xdef	userlib@0004	;FindSymEntry	;OK
	xdef	userlib@0005	;DrawCharXY	;OK
	xdef	userlib@0006	;inputstr	;OK
	xdef	userlib@0007	;getpassword	;OK
	xdef	userlib@0008	;changepass	;OK
	xdef	userlib@0009	;lockcalc	;OK
	xdef	userlib@000A	;idle_hot	;OK
	xdef	userlib@000B	;getfreeRAM	;OK
	xdef	userlib@000C	;smallmenu	;OK
	xdef	userlib@000D	;getfreearchive	;OK

defil:
retbas: move.w	Ymes,d1
	addq.w		#1,d1
	move.w		#1,nblim
	move.w		Xmes,d0
	addq		#1,d0
inver: clr.w		d4
	bsr		fill

Waitkey: move.l	d0,-(a7)
	bsr		idle_hot
	move.w		d0,d7
	move.l		(a7)+,d0
	bsr		fill
	cmp.w		#KEY_UP,d7
	beq		padup
	cmp.w		#KEY_DOWN,d7
	beq		paddown
	cmp.w		#13,d7
	beq 		fin
	move.w		d7,d4
	cmp.w		#$7A,d4
	bgt		esc
	cmp.w		#$30,d4
	beq		esc
	move.w		nbitem,d5
	cmp.w		#$39,d4
	ble		\underten
	cmp.w		#10,d5
	blt		\underten
	subi.w		#$27,d4
\underten subi.w	#$30,d4
\loop	cmp.w		d4,d5
	beq		raccourci
	dbra		d5,\loop
	bra		esc

padup:	cmp.w           #1,nblim
	beq		rethaut
	subq.w		#1,nblim
	sub.w		nbinc,d1 
	bra		inver

paddown: move.w	nbitem,d7
	cmp		nblim,d7
	beq		retbas	; (nblim == nbitem)  ==> retbas
	addq		#1,nblim
	add.w		nbinc,d1           
	bra		inver

rethaut: move.w          nbitem,nblim
        add.w           d6,d1
        sub.w           nbinc,d1
        bra             inver

raccourci: move.w	d4,nblim	
	bra		esc2
fin:    moveq.w	#3,d7
\flash	bsr		fill
	move.w		#25000,d5
\losetime dbra	d5,\losetime
	dbra		d7,\flash
esc2:	clr.l		d6
esc:	move.w	nblim,d5
	rts

disptext:
	movem.l	a0-a6/d0-d7,-(a7)
	move.w		#4,-(a7)             ;affiche le nom
	move.l		a0,-(a7)             ;suivant
	movem.w	d1-d0,-(a7)
	jsr		doorsos::DrawStrXY
	lea		10(a7),a7
	movem.l	(a7)+,a0-a6/d0-d7
	rts
fill:	jmp	graphlib::fill

userlib@000C:
smallmenu:
;a0:adresse de la liste
;d2:nb de cadre(barre non comprise)
;d0:x
;d1:y
	move.w          d0,Xmes           ;argu de defil
	move.w          d1,Ymes           ;
	move.w          d2,nbitem         ;
	movem.l         d3-d7/a0-a6,-(a7)
	movem.l         d0-d4/a0-a2,-(a7)
	clr.w           -(a7)
	jsr             doorsos::FontSetSys
	addq.l          #2,a7
	move.w		d0,Font
	movem.l         (a7)+,d0-d4/a0-a2
	lsr.w		#3,d0
	mulu		#10,d2
	move.w		d2,d3
	addq.w		#1,d3
	move.w		#7,d2	
	jsr		graphlib::scrtomem
	tst.w		d4
	beq		\fini
	movem.l		d0-d4,-(a7)
	move.w          Xmes,d0           ;argu de defil
	move.w          nbitem,d2         ;

	move.w          d2,d7
	move.w          d2,d3
	mulu		#10,d3
	move.w		d3,d6             ;argu de defil
	moveq.w	#1,d4             ;color de fill
	moveq.w	#47,d2            
	bsr		fill    ;prepare le fond blanc

        moveq.w          #47,d4            ;argu
        move.w          d3,d5             ;cadre
        jsr             graphlib::frame   ;

        addx.w          d0,d2             ;argu pour horiz  x2
        moveq.w          #2,d3             ;color de horiz
\debut:
	addq.w		#2,d0
        addq.w          #3,d1                ;
	bsr	disptext
	subq.w		#2,d0
	subq.w		#3,d1
\incremadd:
        tst.b           (a0)+        ;nom
        bne             \incremadd   ;suivant
        subq.w          #1,d7
	addi		#10,d1
        tst.w           d7           ;fini ?
        beq             \suite
        tst.b           (a0)         ;tracer une ligne ?
        beq             \line
        bra             \debut
\line:  
	jsr             graphlib::horiz        ; affiche la ligne
	addq.l		#1,a0
        bra             \debut                   ;

\suite: 
        move.w          #10,nbinc                ;
        moveq.w          #45,d2                   ;pour defil
        moveq.w          #8,d3                    ;
        bsr             defil                    ;
	movem.l		(a7)+,d0-d4
	jsr		graphlib::memtoscr
\fini	move.w          Font,-(a7)
        jsr             doorsos::FontSetSys
        addq.l          #2,a7
	move.w		d7,d1
	move.w		d5,d0
	move.w		d6,d2
	movem.l         (a7)+,d3-d7/a0-a6
        rts

userlib@0000:
idle_loop:
	movem.l	a0-a6/d1-d7,-(a7)
\idle_start
	move.l	APD_INIT,APD_TIMER   ; reset APD timer
	clr.w	APD_FLAG		; reset APD flag
\wait_idle
	tst.w	APD_FLAG		; time for APD?
	beq	\no_apd			; no -- do not shut down
\do_apd
	trap	#4
	bra	\idle_start
\no_apd
	tst.w	(doorsos::kb_vars+$1C)     ; has a key been pressed?
	beq	\wait_idle
	move.l	APD_INIT,APD_TIMER   ; reset APD timer (1)
	move.w	(doorsos::MaxHandles+$1E),d0
	clr.w	(doorsos::kb_vars+$1C)     ; clear key buffer
\try_key_off
	cmp.w	#KEY_DIAMOND+$10B,d0		;press of diamond+On
	beq	\do_apd			;->off
\not_key_off
	movem.l	(a7)+,a0-a6/d1-d7
	rts

userlib@000A:
idle_hot:
\again	bsr	idle_loop
	tst.b	CALCULATOR
	beq	\hot89
	cmp.w   #274,d0  ;F7 ==> lock
	bne     \275
	bsr     lockcalc
	bra	\again
\275	cmp.w   #275,d0  ;F8 ==> shut
	bne	\fin
	trap    #4
	bra	\again
\fin	rts
\hot89	cmp.w   #277,d0  ;Home ==> lock
	bne     \266
	bsr     lockcalc
	bra	\again
\266	cmp.w   #266,d0  ;Mode ==> shut
	bne	\fin
	trap    #4
	bra	\again

userlib@0009
lockcalc:
;sauve l'ecran
	movem.l	d0-d7/a0-a6,-(a7)
	clr.w		d0
	clr.w		d1
	move.w		#LCD_LINE_BYTES,d2
	move.w		#LCD_HEIGHT,d3
	jsr		graphlib::scrtomem
;eteint la caltos
shut:	movem.l	d0-d2/d4-d7/a0-a6,-(a7)
	lea 		LCD_MEM,a0
	move.w		#1919,d2
	move.w		d3,rand_seed
\copy	move.w		#$FFFF,d0
	bsr		random
	move.w		d0,(a0)+
	dbra		d2,\copy
	movem.l	(a7)+,d0-d2/d4-d7/a0-a6
	trap		#4

	bsr		getpassword
	tst.l		d1
	bne		shut
	clr.w		d1
	tst.w		d4
	beq		\fin
	move.w		#LCD_HEIGHT,d3
	jsr		graphlib::memtoscr
\fin	movem.l	(a7)+,d0-d7/a0-a6
	rts

userlib@0001:
random:
	move.l	d1,-(sp)
	move.w	rand_seed(pc),d1
	mulu.w	#31421,d1
	add.w	#6927,d1
	mulu.w	d1,d0
	move.w	d1,rand_seed
	clr.w	d0
	swap	d0
	move.l	(sp)+,d1
	rts

userlib@000B        
getfreeRAM:
;renvoie dans d0 la memoire libre
	movem.l	d1-d7/a0-a6,-(a7)
	move.l		doorsos::Heap,a0
	move.w		doorsos::MaxHandles,d0
	subq.w		#2,d0		;-1 pour dbra + 1ere adress bouhh
	addq.l		#4,a0
	clr.l		d1		;mem utilisee = 0
	clr.l		d3
\hdl	tst.l		(a0)	;si adresse = 0
	beq		\pas		; pas de hdl alloue->suivant
	move.l		(a0),a2	;adresse du debut
	cmp.l		#$200000,a2
	bge		\pas
	move.w		-(a2),d3
	bclr.w		#15,d3
	add.l		d3,d1	;ajoute la taille du handle
\pas	addq.l		#4,a0
	dbra		d0,\hdl
	lsl.l		#1,d1		;d1 = totale mem utilisee
	move.l		doorsos::TopHeap,d0
	sub.l		d1,d0
	sub.l		a0,d0
	movem.l	(a7)+,d1-d7/a0-a6
	rts

userlib@000D
getfreearchive:
;renvoie dans d0 la memoire libre
	movem.l	d1-d7/a0-a6,-(a7)
	move.l		doorsos::Heap,a0
	move.w		doorsos::MaxHandles,d0
	subq.w		#2,d0		;-1 pour dbra + 1ere adress bouhh
	addq.l		#4,a0
	clr.l		d1		;mem utilisee = 0
	clr.l		d3
\hdl	tst.l		(a0)	;si adresse = 0
	beq		\pas		; pas de hdl alloue->suivant
	move.l		(a0),a2	;adresse du debut
	cmp.l		#$200000,a2
	ble		\pas
	move.w		-(a2),d3
	bclr.w		#15,d3
	add.l		d3,d1	;ajoute la taille du handle
\pas	addq.l		#4,a0
	dbra		d0,\hdl
	lsl.l		#1,d1		;d1 = totale mem utilisee

	lea		doorsos::ROM_base+$190000,a0
	clr.l		d0
	clr.l		d3
	moveq.w	#6,d2
\look	move.w		(a0),d3
	cmp.w		#$FFFF,d3
	beq		\non
	add.l		d3,d0
\non	add.l		#$10000,a0
	dbra		d2,\look
	sub.l		d1,d0

	movem.l	(a7)+,d1-d7/a0-a6
	rts


userlib@0002:
rand_seed	dc.w	0

userlib@0003:
exec:
	move.w 4(a7),d0
	DEREF d0,a0
	clr.l	d1
	move.w (a0),d1
	lea	1(a0,d1.l),a2
	cmp.b	#$F3,(a2)	;is ASM ?
	bne	\Fail		;no -> bye !

	cmp.l #$200000,a0
	blt \notarchived
	clr.l d0
	move.w	(a0),d0
	addq.l #3,d0
	move.l a0,-(a7)
	move.l d0,-(a7)
	jsr doorsos::HeapAlloc	;allocates a block to copy from Archive memory
	move.l (a7)+,d1
	move.l (a7)+,a1

	tst.w d0
	beq \Fail

	move.w d0,-(a7)
	DEREF d0,a0
	move.l a0,-(a7)
	subq.l #1,d1
\cpy
	move.b (a1)+,(a0)+
	dbra d1,\cpy
	move.l (a7)+,a0
	bra \rel
\notarchived
	clr.w	-(a7)
\rel
	move.l a0,a5
	addq.l #2,a5

	clr.l	d1
	move.w (a0),d1
	lea	1(a0,d1.l),a0

\rloop
	clr.l	d0
	move.w -(a0),d0
	tst.w d0
	beq \endr
	clr.l d1
	move.w -(a0),d1
	add.l a5,d1
	move.l d1,0(a5,d0.l)
	bra \rloop
\endr
	jsr (a5)

	move.w (a7)+,d1
	tst.w d1
	beq \Fail
	move.l d0,-(a7)
	move.w d1,-(a7)
	jsr doorsos::HeapFree
	add.l #2,a7
	move.l (a7)+,d0
\Fail	rts

userlib@0004:

FindSymEntry:
;parameters are pushed in the stack in that order
;1 : adress to the name of the symbol to look for
;2 : handle of the list you look in

	movem.l	d0-d7/a1-a6,-(a7)
	move.l	62(a7),a1
	move.w	60(a7),d0

	move.l	doorsos::Heap,a0
	lsl.w	#2,d0
	move.l	0(a0,d0.w),a0
	addq.l	#2,a0
	move.w	(a0)+,d5
	tst.w	d5
	beq	\false
	subq.w	#1,d5	;for dbra

\search movem.l	a0/a1,-(a7)
	jsr		doorsos::strcmp
	movem.l	(a7)+,a0/a1
	tst.w		d0
	beq		\end
	lea		14(a0),a0
	dbra		d5,\search
\false	sub.l		a0,a0
\end	movem.l (a7)+,d0-d7/a1-a6
	rts

userlib@0005
DrawCharXY
	move.w	4(a7),d0
	lea	char(pc),a0
	move.b	d0,char
	move.w	10(a7),-(a7)
	move.l	a0,-(a7)
	move.w	14(a7),-(a7)
	move.w	14(a7),-(a7)
	jsr	doorsos::DrawStrXY
	lea	10(a7),a7
	rts

userlib@0006
InputStr:
;       d1.w : X
;       d2.w : Y
;       d3.w : Maxchar
;output:  d0 = nbchars  0 si on presse echap
	move.l	d6,-(a7)
	moveq.l	#1,d6
	bsr		Input
	move.l	(a7)+,d6
	rts

Input:
;d1=x ; d2 = y ; d3  = maxchar ; d6 = 0 -> mettre des *
	movem.l	 d1-d7/a1,-(a7)
	move.b		doorsos::ST_flags+$11,d7	;sauve le mode alphanum
	move.b		#1,doorsos::ST_flags+$11

\OK  	lea	temp1,a0
	move.w  d3,d5
	subq    #1,d5
	lsl.w   #3,d5 ; nb de char * 8
	move.l  a0,a1
\retclear clr.w   d4
\retour    move.b  #124,(a0)       ;the '|' char
	clr.b   1(a0)
\WaitKey bsr	Print_Txt
	bsr     idle_hot
	cmp.w	#13,d0			; Enter ?
	beq	\enter
	cmp.w   #263,d0
	beq     \clear
	cmp.w   #257,d0                 ; Backspace ?
	beq     \BackSp
	cmp.w   #264,d0                 ;ESC ?
	beq     \ESC
	cmp.w   #255,d0         ;Valid character ?
	bhi     \WaitKey        ;no => loop
	cmp.w   d3,d4           ;Maxchar ?
	beq     \WaitKey
	move.b  d0,(a0)+
	addq.w  #1,d4
	bra	\retour
\clear  move.l  a1,a0
	bra		\retclear
\BackSp tst.w	d4
	beq		\WaitKey
	subq.w	#1,d4
	tst.b		-(a0)
	bra		\retour
\enter clr.b	(a0)
	bsr		Print_Txt
	move.w	d4,d0
	bra		\end
\ESC	clr.w		d0
\end	lea		temp1,a0

	move.b		d7,doorsos::ST_flags+$11

	movem.l (a7)+,d1-d7/a1
	rts
Print_Txt:
        movem.l d0-d7/a0-a6,-(a7)
        move.w  d1,d0
        move.w  d2,d1
        move.w  d5,d2
        moveq.w  #7,d3
        moveq.w  #1,d4
        jsr     graphlib::fill
	tst.w	d6
	beq	dispstars
	bra	Write2
Write: movem.l	d0-d7/a0-a6,-(a7)
Write2: move.w	#4,-(a7)		;Color
	move.l	a1,-(a7)                ;address
	move.w	d1,-(a7)		;Y
	move.w	d0,-(a7)		;X
        jsr             doorsos::DrawStrXY         ;Print !
	lea		10(a7),a7		
	movem.l	(a7)+,d0-d7/a0-a6
	rts
printf: movem.l	d0-d7/a0-a6,-(a7)
	clr.w		d0
	clr.w		d1
	move.b	(a1)+,d0
	move.b	(a1)+,d1
	bra		Write2

dispstars:
	move.l	16(a7),d4
	lea		stars(pc),a1
\affstar tst.w	d4
	beq		\disped
	bsr		Write
	addq.w	#6,d0
	dbra		d4,\affstar
\disped movem.l	(a7)+,d0-d7/a0-a6
	rts

userlib@0007
getpassword:
	movem.l		d0/d2-d7/a0-a6,-(a7)
	lea		mespass(pc),a0
	jsr		graphlib::smallbox
	clr.w		-(a7)
	jsr		doorsos::FontSetSys
	addq.l		#2,a7
	move.w		d0,a5
	lea		tit1pass(pc),a1
	tst.b		CALCULATOR
	bne		\OK92
	lea		s89_tit1pass(pc),a1
\OK92	bsr		printf
getpword:
	bclr.b		#2,($600001)
	move.l		$78,d5	;sauve l'ancienne adresse de trap 2
	move.l		#ONKEY,$78 ;installe la mienne
	move.l		APD_INIT,d7
	move.l		#100,APD_INIT
	moveq.w	#63,d1
	moveq.w	#59,d2
	moveq.w	#10,d3
	tst.b		CALCULATOR
	bne		\OK92
	moveq.w	#50,d1	;+10
	moveq.w	#48,d2	;+15
	moveq.w	#10,d3
\OK92	clr.w		d6
	bsr		Input

	move.l		d5,$78	;restore l'adresse de trap 2
	bset.b		#2,($600001)
	move.l		d7,APD_INIT
	movem.L	d0-d2/a0-a1,-(a7)
	move.w		a5,-(a7)
	jsr		doorsos::FontSetSys
	addq.l		#2,a7
	movem.l	(a7)+,d0-d2/a0-a1
	tst.w           d0
	beq             wrong
	lea             pword(pc),a1
	bsr             strcomp
wrong:	clr.w	d0
	trap	#1
	movem.l		(a7)+,d0/d2-d7/a0-a6
	rts
ONKEY:	rte

userlib@0008
changepass:
	movem.l		d0-d7/a0-a6,-(a7)
\debut
	bsr             getpassword
	tst             d1
	bne             \exit         ;si mauvais pass => retourne
;obtenir le nveau pass
	clr.w		-(a7)
	jsr		doorsos::FontSetSys
	addq.l		#2,a7
	lea		npword(pc),a1
	moveq.w	#59,d2
	moveq.w	#63,d1
	tst.b		CALCULATOR
	bne		\OK92
	lea		s89_npword(pc),a1
	moveq.w	#48,d2
	moveq.w	#50,d1
\OK92	bsr		\smallbsr	;demande le pass

	lea		temppass,a2
	move.l		a2,a3
\cpy	move.b		(a0)+,(a3)+	;copie le pass obtenu
	dbra		d0,\cpy

;demande la confirmation
	lea		confirm(pc),a1
	moveq.w	#84,d2
	moveq.w	#63,d1
	tst.b		CALCULATOR
	bne		\OK92i
	lea		s89_confirm(pc),a1
	moveq.w	#70,d2
	moveq.w	#50,d1
\OK92i	bsr		\smallbsr
	move.l		a2,a1
	bsr		strcomp
	tst.w		d1
	beq		\okconfirm
; si la confirmation est differente
	pea		badconf(pc)
	jsr		doorsos::ST_showHelp
	addq.l		#4,a7
	bra		\debut
\okconfirm
	lea		pword(pc),a1
\copy	move.b		(a0)+,(a1)+
	dbra		d0,\copy
\exit	movem.l		(a7)+,d0-d7/a0-a6
	rts                     ;retour  options
\smallbsr
	bsr		printf
	moveq.w	#10,d3
	clr.w		d6
	bsr		Input
	tst.w		d0
	bne		\OK
	addq.l		#4,a7
	bra		\exit
\OK	rts


strcomp:
;a0 et a1 chaine a comparer 
	movem.l	d0/d2/a0-a1,-(a7)
	movem.l	a0/a1,-(a7)
	jsr		doorsos::strcmp
	addq.l		#8,a7
	move.w		d0,d1
	movem.l	(a7)+,d0/d2/a0-a1
	rts



;*****************************************************
; Program data
;*****************************************************

char	dc.b	0,0
stars		dc.b "*",0
pword		dc.b "doors",0,0,0,0,0,0
npword		dc.b 53,44,"Enter the new Doorspass:",0
tit1pass	dc.b 53,44,"Enter the Doorspass:",0
mespass	dc.b "Doors Password Protection",0
confirm	dc.b 53,71,"Confirm the Doorspass:",0
badconf	dc.b "Password confirmation failed",0

s89_npword	dc.b 40,38,"Enter the new Doorspass:",0
s89_tit1pass	dc.b 40,38,"Enter the Doorspass:",0
s89_confirm	dc.b 40,60,"Confirm the Doorspass:",0

	BSS
temppass	ds.b	11
temp1           dc.b 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
nbitem	dc.w 0
Xmes    dc.w 0
Ymes    dc.w 0
nblim   dc.w 0
nbinc   dc.w 0
Font	dc.w 0

	end
