	include "doorsos.h"
	xdef	_library
	xdef	_ti92plus
	xdef	_ti89
	xdef	hufflib@0000
	xdef	hufflib@0001
	xdef	hufflib@0002
	xdef	hufflib@0003
	xdef	hufflib@0004

;*****************************************************
;Originally written by Jimmy Mardell for Fargo
;Ported by Xavier VASSOR to Doors OS


hufflib@0000:
extract:
 movem.l d0-d7/a0-a6,-(sp)
 sf	 d5
 bsr Extract2
 movem.l (sp)+,d0-d7/a0-a6
 rts

;*****************************************************

hufflib@0001:
extract_string:
 movem.l d0-d7/a0-a6,-(sp)
 st	 d5
 bsr Extract2
 movem.l (sp)+,d0-d7/a0-a6
 rts

;*****************************************************

hufflib@0002:
write_string:
 movem.l d0-d7/a0-a6,-(sp)
 move.w  #4,-(sp)
WriteString:
 subq	 #4,sp
 move.w  d1,-(sp)
 move.w  d0,-(sp)
 move.l  a0,-(sp)
 move.l  #80,-(sp)
 jsr doorsos::HeapAlloc
 addq	 #4,sp
 move.l  (sp)+,a0
 tst.w	 d0
 beq RestoreRegs
 move.w  d0,tmpstrH
 doorsos::DEREF d0,a1
 move.l  a1,4(sp)
 st	 d5
 bsr Extract2
 jsr doorsos::DrawStrXY
 move.w  tmpstrH(PC),-(sp)
 jsr doorsos::HeapFree
 addq	 #2,sp
RestoreRegs:
 lea	 10(sp),sp
 movem.l (sp)+,d0-d7/a0-a6
 rts

;*****************************************************

hufflib@0003:
write_string_inv:
 movem.l d0-d7/a0-a6,-(sp)
 clr.w	 -(sp)
 bra WriteString

;*****************************************************

hufflib@0004:
check_mem:
 movem.l d1-d7/a0-a6,-(sp)
 move.l  #1140,-(sp)
 jsr doorsos::HeapAlloc
 addq	 #4,sp
 tst.w	 d0
 beq OutOfMem
 move.w  d0,-(sp)
 jsr doorsos::HeapFree
 addq	 #2,sp
 moveq	 #1,d0
OutOfMem:
 movem.l (sp)+,d1-d7/a0-a6
 rts

Extract2:
 movem.l a0-a1,-(sp)
 move.l  #1024,-(sp)
 jsr doorsos::HeapAlloc
 addq	 #4,sp
 movem.l (sp)+,a0-a1
 tst.w	 d0
 beq Done
 move.w  d0,tableH
 doorsos::DEREF d0,a6
 move.l  a0,a2
 move.w  (a2)+,d2
 cmp.w	 #1,d2
 bne	 MultiFiles
 clr.w	 d3
MultiFiles:
 move.w  (a2)+,d0
 move.l  a2,a3
 mulu	 #6,d2
 add.w	 d2,a3
 mulu	 #6,d3
 add.w	 d3,a2
 move.w  d0,d6
 subq	 #1,d6
 move.l  a3,a4
 add.w	 d0,a4
 clr.l	 d0
 clr.l	 d1
UncrunchTree:
 btst.b  d1,(a4)
 beq NoBranch
 move.w  d0,-(sp)
 addq	 #2,d0
NextTreeBit:
 addq	 #1,d1
 bclr	 #3,d1
 beq UncrunchTree
 addq	 #1,a4
 bra UncrunchTree
NoBranch:
 clr.b	 0(a6,d0)
 move.b  (a3)+,1(a6,d0)
 addq	 #2,d0
 tst.w	 d6
 beq TreeBuilt
 move.w  (sp)+,d2
 move.w  d0,0(a6,d2)
 bset.b  #7,0(a6,d2)
 dbra	 d6,NextTreeBit
TreeBuilt:
 move.w  (a2)+,d0
 add.w	 d0,a0
 move.w  (a2)+,d3
 move.w  (a2),d7
 subq	 #1,d7
UncrunchData:
 clr.l	 d1
CheckTree:
 move.w  0(a6,d1),d2
 bclr	 #15,d2
 beq EndOfBranch
 btst.b  d3,(a0)
 bne RightBranch
 addq	 #2,d1
 bra NextDataBit
RightBranch:
 move.w  d2,d1
NextDataBit:
 addq	 #1,d3
 bclr	 #3,d3
 beq CheckTree
 addq	 #1,a0
 bra CheckTree
EndOfBranch:
 tst.b	 d5
 bne ExtractString
 move.b  d2,(a1)+
Repeat:
 dbra	 d7,UncrunchData
 bra Done
ExtractString:
 tst.w	 d4
 beq WriteData
 tst.b	 d2
 bne Repeat
 subq	 #1,d4
 bra Repeat
WriteData:
 move.b  d2,(a1)+
 tst.b	 d2
 bne Repeat
Done:
 move.w  tableH(PC),-(sp)
 jsr doorsos::HeapFree
 addq	 #2,sp
 move.w  (a2),d0
 rts

;*****************************************************

tableH	   dc.w 0
tmpstrH    dc.w 0

;*****************************************************

;*****************************************************

	end
