#include <stdio.h>
#include <stdlib.h>
#include <string.h>

FILE *fis = NULL;
FILE *fos = NULL;
int constant_pool_count;
int cpCount;			// current pool index while traversing

const int knownNamesLength = 3;
const char *knownNames[] = { "String", "Window", "Title", };
const char *const replaceWith[] = { "Stringg", "Windoww", "Titlee", };

// read 1,2 or 4 bytes from class file
int readU1()
{
    int u1;
    u1 = (int) fgetc(fis);
    return u1;
}

int readU2()
{
    int u2;
    u2 = (readU1() << 8) & 0x0000ff00;
    u2 += readU1() & 0x000000ff;
    return u2;
}

long readU4()
{
    long u4;
    u4 = readU1() << 24;
    u4 += (readU1() << 16) & 0x00ff0000;
    u4 += (readU1() << 8) & 0x0000ff00;
    u4 += readU1() & 0x000000ff;
    return u4;
}

// first constant pool entry
void cpFirst()
{
    fseek(fis, 10L, SEEK_SET);
    cpCount = 1;
}

// next entry
int cpNext()
{
    int tag, off;
    if (cpCount == constant_pool_count) {	// end reached
	return 0;
    }
    tag = readU1();
    // size of cp_info depends on tag
    switch (tag) {
    case 1:
	off = readU2();
	fseek(fis, off, SEEK_CUR);
	break;
    case 2:
	return 0;
    case 3:
    case 4:
	readU4();
	break;
    case 5:
    case 6:
	readU4();
	readU4();
	break;
    case 7:
    case 8:
	readU2();
	break;
    case 9:
    case 10:
    case 11:
    case 12:
	readU4();
	break;
    default:
	break;
    }
    return ++cpCount;
}

// find constant pool entry with number <index>
void cpToIndex(int index)
{
    int count;
    cpFirst();
    for (count = 1; count < index; ++count) {
	cpNext();
    }
}

char *findClassName()
{
    int namelen;
    static char classname[128];

    if (readU4() != 0xcafebabe) {	// magic
	printf("Not a legal Java class\n");
	return NULL;
    }
    fseek(fis, 8L, SEEK_SET);
    constant_pool_count = readU2();

    // find constant pool index of the class name
    cpFirst();
    while (cpNext() != 0);	// to the end of the constant pool
    readU2();			// access_flags
    cpToIndex(readU2());	// this_class
    readU1();			// tag (value 7: Constant_Class)
    cpToIndex(readU2());	// index to Utf8-String
    readU1();			// tag (value 1: Utf8)
    namelen = readU2();		// length of the name
    if (namelen > 127)
	return classname;
    fread(classname, namelen, 1, fis);
    classname[namelen] = 0;
    return classname;
}

void cleanup(void)
{
    if (fis != NULL)
	fclose(fis);
    if (fos != NULL)
	fclose(fos);
}

int main(int argc, char *argv[])
{
    char classfn[128];
    char stringfn[128];
    char *classname;
    int n;

    atexit(cleanup);
    if (argc != 2 && argc != 3) {
	printf("Usage: class2string <classfn> [<stringfn>]\n");
	exit(EXIT_FAILURE);
    }
    strcpy(classfn, argv[1]);
    if (argc == 3) {
	strcpy(stringfn, argv[2]);
    } else {
	char *dotclass;
	strcpy(stringfn, classfn);
	dotclass = strstr(stringfn, ".class");
	if (dotclass == NULL) {
	    printf("%s: must end with .class", classfn);
	    exit(EXIT_FAILURE);
	}
	*dotclass = 0;
	// check for some known TI specific names and rename them
	for (n = 0; n < knownNamesLength; ++n)
	    if (!strcmp(stringfn, knownNames[n])) {
		strcpy(stringfn, replaceWith[n]);
		break;
	    }

	strcat(stringfn, ".str");
    }

    fis = fopen(classfn, "rb");
    if (!fis) {
	printf("%s not Found\n", classfn);
	exit(EXIT_FAILURE);
    }
    classname = findClassName();
    if (classname == NULL) {
	printf("Class name not found\n");
	exit(EXIT_FAILURE);
    }
    if (strlen(classname) > 127) {
	printf("Class name too long\n");
	exit(EXIT_FAILURE);
    }
    // everything's waba
    if (!strncmp(classname, "java/", 5)) {
	strncpy(classname, "waba", 4);
    }
    fos = fopen(stringfn, "wb");
    if (!fos) {
	printf("Cannot create %s\n", stringfn);
	exit(EXIT_FAILURE);
    }
    fputc(strlen(classname), fos);	// 1 byte: length of class name
    fwrite(classname, strlen(classname), 1, fos);	// the class name
    // the original class data, uses stringfn as buffer
    rewind(fis);
    while ((n = fread(stringfn, 1, sizeof stringfn, fis)) > 0) {
	fwrite(stringfn, 1, n, fos);
    }
    printf("Class name: %s\n", classname);
    return EXIT_SUCCESS;
}
