#define OPTIMIZE_ROM_CALLS
#define USE_TI89
#define USE_KERNEL

#include <tigcclib.h>
#include <luamisc.h>
#include <lua.h>
#include <lauxlib.h>
#include <lualib.h>
#include <lamslib.h>

static lua_State *L = NULL;

static void loadlibs()
{
  luaopen_base(L);
  luaopen_table(L);
  luaopen_io(L);
  luaopen_string(L);
  luaopen_math(L);
  luaopen_debug(L);
  luaopen_ams(L);
}

static void callalert(int status) {
  if (status != 0) {
    lua_getglobal(L, "_ALERT");
    if (lua_isfunction(L, -1)) {
      lua_insert(L, -2);
      lua_call(L, 1, 0);
    }
    else {  /* no _ALERT function; print it */
      printf("%s\n", lua_tostring(L, -2));
      lua_pop(L, 2);  /* remove error message and _ALERT */
    }
  }
}

void _main()
{
  ESI argptr;
  const char *filename;
  int status;

  InitArgPtr(argptr);
  if(GetArgType(argptr) != STR_TAG) {
    DlgMessage("Error", "Usage: lua(\"filename\")", BT_OK, BT_NONE);
    return;
  }
  filename = GetStrnArg(argptr);

  clrscr();
  puts("Loading...\n");
  L = lua_open();
  if(L == NULL) {
    DlgMessage("Error", "Not enough memory", BT_OK, BT_NONE);
    return;
  }
  loadlibs();
  clrscr();
  
  status = luaL_loadfile(L, filename);
  if(status == 0) status = lua_pcall(L, 0, LUA_MULTRET, 0);
  callalert(status);
  
  lua_close(L);
  ngetchx();
}
