#include <luamisc.h>
#include <tigcclib.h>
#include <lamslib.h>
#include <lua.h>
#include <lualib.h>
#include <lauxlib.h>

int _library;

#define INCORRECT_ARGCNT "Incorrect number of arguments"

static void *kbq;

static int ams_getkey(lua_State *L)
{
  int n = lua_gettop(L);
  short int k;

  if(n != 0) {
    lua_pushstring(L, INCORRECT_ARGCNT);
    lua_error(L);
  }
  if(OSdequeue(&k, kbq)) lua_pushnumber(L, 0); else lua_pushnumber(L, k);
  return 1;
}

static int ams_ngetchx(lua_State *L)
{
  int n = lua_gettop(L);
  short int k;

  if(n != 0) {
    lua_pushstring(L, INCORRECT_ARGCNT);
    lua_error(L);
  }
  k = ngetchx();
  lua_pushnumber(L, k);
  return 1;
}

static int ams_clrscr(lua_State *L)
{
  int n = lua_gettop(L);
  short int k;

  if(n != 0) {
    lua_pushstring(L, INCORRECT_ARGCNT);
    lua_error(L);
  }
  clrscr();
  return 0;
}

static int ams_DrawPix(lua_State *L)
{
  int n = lua_gettop(L);
  short int x, y;
  short int attr;

  if(n != 3) {
    lua_pushstring(L, INCORRECT_ARGCNT);
    lua_error(L);
  }
  x = lua_tonumber(L, 1);
  y = lua_tonumber(L, 2);
  attr = lua_tonumber(L, 3);
  DrawPix(x, y, attr);
  return 0;
}

static int ams_ScrRectFill(lua_State *L)
{
  int n = lua_gettop(L);
  SCR_RECT r;
  short int attr;

  if(n != 5) {
    lua_pushstring(L, INCORRECT_ARGCNT);
    lua_error(L);
  }
  r.xy.x0 = lua_tonumber(L, 1);
  r.xy.y0 = lua_tonumber(L, 2);
  r.xy.x1 = lua_tonumber(L, 3);
  r.xy.y1 = lua_tonumber(L, 4);
  attr = lua_tonumber(L, 5);
  ScrRectFill(&r, ScrRect, attr);
  return 0;
}

static int ams_DrawStr(lua_State *L)
{
  int n = lua_gettop(L);
  short int x, y;
  const char *s;
  short int attr;

  if(n != 4) {
    lua_pushstring(L, INCORRECT_ARGCNT);
    lua_error(L);
  }
  x = lua_tonumber(L, 1);
  y = lua_tonumber(L, 2);
  s = lua_tostring(L, 3);
  attr = lua_tonumber(L, 4);
  DrawStr(x, y, s, attr);
  return 0;
}

static const luaL_reg amslib[] = {
  {"getkey",          ams_getkey},
  {"ngetchx",         ams_ngetchx},
  {"clrscr",          ams_clrscr},
  {"DrawPix",         ams_DrawPix},
  {"ScrRectFill",     ams_ScrRectFill},
  {"DrawStr",         ams_DrawStr},
  {NULL, NULL}
};

static void map_constant(lua_State *L, const char *name, double value)
{
  lua_pushstring(L, name);
  lua_pushnumber(L, value);
  lua_rawset(L, -3);
}

static void map_constants(lua_State *L)
{
  map_constant(L, "A_NORMAL", A_NORMAL);
  map_constant(L, "A_REVERSE", A_REVERSE);
  map_constant(L, "A_XOR", A_XOR);
}

// luaopen_ams
LUALIB_API int lamslib__0001 (lua_State *L) {
  map_constants(L);
  kbq = kbd_queue();
  luaL_openlib(L, "ams", amslib, 0);
  lua_pushvalue(L, -1);
  return 1;
}

