/*
** $Id: lauxlib.h,v 1.60 2003/04/03 13:35:34 roberto Exp $
** Auxiliary functions for building Lua libraries
** See Copyright Notice in lua.h
*/


#ifndef lauxlib_h
#define lauxlib_h

#include <stddef.h>
#include <stdio.h>

#include "lua.h"

#ifndef LUALIB_API
#define LUALIB_API	LUA_API
#endif


typedef struct luaL_reg {
  const char *name;
  lua_CFunction func;
} luaL_reg;


#define luaL_argcheck(L, cond,numarg,extramsg) if (!(cond)) \
                                               luaL_argerror(L, numarg,extramsg)
#define luaL_checkstring(L,n)	(luaL_checklstring(L, (n), NULL))
#define luaL_optstring(L,n,d)	(luaL_optlstring(L, (n), (d), NULL))
#define luaL_checkint(L,n)	((int)luaL_checknumber(L, n))
#define luaL_checklong(L,n)	((long)luaL_checknumber(L, n))
#define luaL_optint(L,n,d)	((int)luaL_optnumber(L, n,(lua_Number)(d)))
#define luaL_optlong(L,n,d)	((long)luaL_optnumber(L, n,(lua_Number)(d)))


/*
** {======================================================
** Generic Buffer manipulation
** =======================================================
*/


#ifndef LUAL_BUFFERSIZE
#define LUAL_BUFFERSIZE	  BUFSIZ
#endif


typedef struct luaL_Buffer {
  char *p;			/* current position in buffer */
  int lvl;  /* number of strings in the stack (level) */
  lua_State *L;
  char buffer[LUAL_BUFFERSIZE];
} luaL_Buffer;

#define luaL_putchar(B,c) \
  ((void)((B)->p < ((B)->buffer+LUAL_BUFFERSIZE) || luaL_prepbuffer(B)), \
   (*(B)->p++ = (char)(c)))

#define luaL_addsize(B,n)	((B)->p += (n))


/* }====================================================== */


#define luaL_check_lstr 	luaL_checklstring
#define luaL_opt_lstr 	luaL_optlstring
#define luaL_check_number 	luaL_checknumber
#define luaL_opt_number	luaL_optnumber
#define luaL_arg_check	luaL_argcheck
#define luaL_check_string	luaL_checkstring
#define luaL_opt_string	luaL_optstring
#define luaL_check_int	luaL_checkint
#define luaL_check_long	luaL_checklong
#define luaL_opt_int	luaL_optint
#define luaL_opt_long	luaL_optlong

#define luaL_argerror lualib__0001
LUALIB_API int lualib__0001 (lua_State *L, int narg, const char *extramsg);

#define luaL_typerror lualib__0002
LUALIB_API int lualib__0002 (lua_State *L, int narg, const char *tname);

#define luaL_where lualib__0003
LUALIB_API void lualib__0003 (lua_State *L, int level);

#define luaL_error lualib__0004
LUALIB_API int lualib__0004 (lua_State *L, const char *fmt, ...);

#define luaL_findstring lualib__0005
LUALIB_API int lualib__0005 (const char *name, const char *const list[]);

#define luaL_newmetatable lualib__0006
LUALIB_API int lualib__0006 (lua_State *L, const char *tname);

#define luaL_getmetatable lualib__0007
LUALIB_API void lualib__0007 (lua_State *L, const char *tname);

#define luaL_checkudata lualib__0008
LUALIB_API void *lualib__0008 (lua_State *L, int ud, const char *tname);

#define luaL_checkstack lualib__0009
LUALIB_API void lualib__0009 (lua_State *L, int space, const char *mes);

#define luaL_checktype lualib__0010
LUALIB_API void lualib__0010 (lua_State *L, int narg, int t);

#define luaL_checkany lualib__0011
LUALIB_API void lualib__0011 (lua_State *L, int narg);

#define luaL_checklstring lualib__0012
LUALIB_API const char *lualib__0012 (lua_State *L, int narg, size_t *len);

#define luaL_optlstring lualib__0013
LUALIB_API const char *lualib__0013 (lua_State *L, int narg, const char *def, size_t *len);

#define luaL_checknumber lualib__0014
LUALIB_API lua_Number lualib__0014 (lua_State *L, int narg);

#define luaL_optnumber lualib__0015
LUALIB_API lua_Number lualib__0015 (lua_State *L, int narg, lua_Number def);

#define luaL_getmetafield lualib__0016
LUALIB_API int lualib__0016 (lua_State *L, int obj, const char *event);

#define luaL_callmeta lualib__0017
LUALIB_API int lualib__0017 (lua_State *L, int obj, const char *event);

#define luaL_openlib lualib__0018
LUALIB_API void lualib__0018 (lua_State *L, const char *libname, const luaL_reg *l, int nup);

#define luaL_prepbuffer lualib__0019
LUALIB_API char *lualib__0019 (luaL_Buffer *B);

#define luaL_addlstring lualib__0020
LUALIB_API void lualib__0020 (luaL_Buffer *B, const char *s, size_t l);

#define luaL_addstring lualib__0021
LUALIB_API void lualib__0021 (luaL_Buffer *B, const char *s);

#define luaL_pushresult lualib__0022
LUALIB_API void lualib__0022 (luaL_Buffer *B);

#define luaL_addvalue lualib__0023
LUALIB_API void lualib__0023 (luaL_Buffer *B);

#define luaL_buffinit lualib__0024
LUALIB_API void lualib__0024 (lua_State *L, luaL_Buffer *B);

#define luaL_ref lualib__0025
LUALIB_API int lualib__0025 (lua_State *L, int t);

#define luaL_unref lualib__0026
LUALIB_API void lualib__0026 (lua_State *L, int t, int ref);

#define luaL_loadfile lualib__0027
LUALIB_API int lualib__0027 (lua_State *L, const char *filename);

#define luaL_loadbuffer lualib__0028
LUALIB_API int lualib__0028 (lua_State *L, const char *buff, size_t size, const char *name);

#define lua_dofile lualib__0029
LUALIB_API int lualib__0029 (lua_State *L, const char *filename);

#define lua_dobuffer lualib__0030
LUALIB_API int lualib__0030 (lua_State *L, const char *buff, size_t size, const char *name);

#define lua_dostring lualib__0031
LUALIB_API int lualib__0031 (lua_State *L, const char *str);


#endif
