// C Source File
// Created 09/04/04; 15:12:47

#define CASE_VIDE  255
#define INACTIVE 0
#define ACTIVE 1

#define NB_ELEMENTS 60
#define TAILLE_LEVEL 260

#define lvl_size nb_level*TAILLE_LEVEL+10

#include <tigcclib.h>         // Include All Header Files
#include "graphique1.h"

struct selection
{
	int i,j;
	int l,h;
	unsigned char * donnees;
	char * image1, *image2;
	int active; // indique si la selection est active dans le level = si elle est visible en inverse 
};

volatile unsigned int Counter = 0;
DEFINE_INT_HANDLER( MyInt5 )
{
  Counter++;
}

// Main Function
int aff( int element );
void affiche_level(int*, int,int,int*,int*);
void save( char*, int );
void inverse_level( char*, char,char );
void suppr_level( char*, int );
void efface_ecran(void);
void afficher_selection(unsigned char *, int*, int ,int, int, int, int*, int*); 
void annuler_selection(struct selection *);
	
#define WAIT( condition ) if(1){ while( (condition) && (!_keytest(RR_DIAMOND)) ); Counter = 0; while( Counter < 2 ); }

unsigned char m[13][20];

void _main(void)
{
	LCD_BUFFER buffer0;
	LCD_BUFFER buffer1;
	INT_HANDLER OldInt1 = NULL;
	INT_HANDLER OldInt5 = NULL;
	int x=0, y=0, OldX = 0, OldY =0;
	struct selection *sel = (struct selection *)malloc(sizeof(struct selection)); // structure qui conserve toutes les infos sur la selection courante
	int list[NB_ELEMENTS] = {1,2,3,4,5,6,7,8,9,11,
							12,13,17,18,19,20,21,22,23,25,
							41,42,43,44,45,46,47,48,49,50,
							24,51,52,53,54,55,56,57,58,59,
							60,61,62,63,255,255,255,255,255,255,
							71,72,73,74,75,76,77,78,79,80};
	// liste reciproque de list => donne la place dans la list de l'element numero i
	int rev_list[256] = {-1,0,1,2,3,4,5,6,7,8
						,-1,9,10,11,-1,-1,-1,12,13,14
						,15,16,17,18,30,19,-1,-1,-1,-1
						,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
						,-1,20,21,22,23,24,25,26,27,28
						,29,31,32,33,34,35,36,37,38,39
						,40,41,42,43,-1,-1,-1,-1,-1,-1
						,-1,50,51,52,53,54,55,56,57,58
						,59,-1,-1,-1,-1,-1,-1,-1,-1,-1
						,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
						,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
						,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
						,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
						,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
						,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
						,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
						,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
						,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
						,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
						,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
						,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
						,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
						,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
						,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
						,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
						,-1,-1,-1,-1,-1,44};
	int element = 1, lvl=1, debuti=-1, debutj=-1, changelevel=0;
	//int i_chx=-1, j_chx=-1;
	long i;
	char packlevel[18]={}, nb_level=1; //nom du fichier, nb de level dans le pack

	memset(m,255,TAILLE_LEVEL*sizeof(char));
	sel -> donnees = NULL;
	sel -> image1 = NULL;
	sel -> image2 = NULL;
	sel -> active = INACTIVE;
	
	OldInt1 = GetIntVec (AUTO_INT_1);
	OldInt5 = GetIntVec (AUTO_INT_5);
  
	/*lecture des parametres*/
	ESI argptr;
	InitArgPtr (argptr);
	if (GetArgType (argptr) == STR_TAG)
	strcpy(packlevel,GetStrnArg(argptr));
	if (GetArgType (argptr) == POSINT_TAG )
	lvl = GetIntArg (argptr);
	/*lecture des parametres*/
	
	HANDLE handle;
	char *fptr=fptr;
	SYM_ENTRY *openlevel_sym;
	
	SetIntVec (AUTO_INT_5, MyInt5);
	SetIntVec (AUTO_INT_1, DUMMY_HANDLER);
	if (!GrayOn ()) return;
	FontSetSys(0);
	
debut:	
	if ((openlevel_sym=SymFindPtr(SYMSTR(packlevel),0))) //ouverture du fichier (du pack de levels)
	{
		handle=openlevel_sym->handle;
		fptr=HeapDeref(handle);
		nb_level = *(fptr+3);
		memcpy(&m, (fptr + 4 + lvl * TAILLE_LEVEL - TAILLE_LEVEL), TAILLE_LEVEL); //ouverture du level
	}
	else {lvl=1;}
	
	affiche_level(rev_list,x,y,&debuti,&debutj); //affichage du niveau + initialisation de la position de la balle
	
	if (changelevel==1) //Si on a appuy sur + ou -
	{
		x = y = 0;
		debuti = debutj = -1;
		element = 1;
		Sprite8 (x, y, 8, noir, GrayGetPlane (DARK_PLANE), SPRT_XOR);
		memcpy ( buffer0, GrayGetPlane (LIGHT_PLANE), LCD_SIZE);
		memcpy ( buffer1, GrayGetPlane (DARK_PLANE), LCD_SIZE);
		GraySetAMSPlane(LIGHT_PLANE);
		printf_xy(0,0,"%d",lvl);
		GraySetAMSPlane(DARK_PLANE);
		printf_xy(0,0,"%d",lvl);
		while (_keytest(RR_PLUS) || _keytest(RR_MINUS));

		memcpy ( GrayGetPlane (LIGHT_PLANE), buffer0, LCD_SIZE);
		memcpy ( GrayGetPlane (DARK_PLANE), buffer1, LCD_SIZE);
		Sprite8 (x, y, 8, noir, GrayGetPlane (DARK_PLANE), SPRT_XOR);
		changelevel = 0;
	}
		
	while (!_keytest(RR_ESC)) //si ESC : quitter
	{
		/*****dplacement du curseur*****/
		if (_keytest(RR_LEFT) && x>0) {  x -=8 ;}
		if (_keytest(RR_RIGHT) && x<151) { x +=8 ; }
		if (_keytest(RR_UP) && y>0) { y -= 8 ; }
		if (_keytest(RR_DOWN) && y<91) { y += 8 ; }
		/*****dplacement du curseur*****/
	  
		if (OldX != x || OldY != y) //si le curseur a boug	
		{
			Sprite8 (OldX, OldY, 8, noir, GrayGetPlane (DARK_PLANE), SPRT_XOR);
			Sprite8 (x, y, 8, noir, GrayGetPlane (DARK_PLANE), SPRT_XOR);
			WAIT( _keytest(RR_LEFT) || _keytest(RR_RIGHT) || _keytest(RR_UP) || _keytest(RR_DOWN) );
		}
		
	  
		if (_keytest(RR_APPS)) //passe dans l'cran choix objet
		{
			while( _keytest(RR_APPS) );
			Sprite8 (x, y, 8, noir, GrayGetPlane (DARK_PLANE), SPRT_XOR);
			memcpy ( buffer0, GrayGetPlane (LIGHT_PLANE), LCD_SIZE);
			memcpy ( buffer1, GrayGetPlane (DARK_PLANE), LCD_SIZE);
			element = aff( element );
			memcpy ( GrayGetPlane (LIGHT_PLANE), buffer0, LCD_SIZE);
			memcpy ( GrayGetPlane (DARK_PLANE), buffer1, LCD_SIZE);
			Sprite8 (x, y, 8, noir, GrayGetPlane (DARK_PLANE), SPRT_XOR);
		}
	  
		if (_keytest(RR_CLEAR)) //efface la selection si elle existe sinon efface le curseur
		{
			if (sel -> donnees) // il existe une selection
			{
				if (!(x/8 >= sel -> j && x/8 <= (sel -> j + sel->l) && y/8 >= sel -> i && y/8 <= (sel -> i + sel->h)))
				{
					Sprite8 (x, y, 8, noir, GrayGetPlane (DARK_PLANE), SPRT_XOR);
	  			}
	  		
				unsigned char * vide = (unsigned char *)malloc(sel -> l * sel -> h * sizeof(unsigned char)); // matrice vide
				memset(vide,CASE_VIDE,sel -> l * sel -> h);
				sel ->  active = INACTIVE;
				afficher_selection(vide, rev_list, sel -> i,sel -> j,sel -> l, sel -> h, &debuti, &debutj);
				free(vide);	  		
				Sprite8 (x, y, 8, noir, GrayGetPlane (DARK_PLANE), SPRT_XOR);
			}
			else // pas de selection
			{
				// efface la case sur les 2 plans
				Sprite8 (x, y, 8, blanc, GrayGetPlane (LIGHT_PLANE), SPRT_AND);
				Sprite8 (x, y, 8, blanc, GrayGetPlane (DARK_PLANE), SPRT_AND);
				// affiche le curseur
				Sprite8 (x, y, 8, noir, GrayGetPlane (DARK_PLANE), A_OR);
				// actualise la position de la balle au besoin
				if (m[y/8][x/8]==24) debuti = debutj = -1;
				// actualise la matrice
				m[y/8][x/8] = CASE_VIDE;
			}
		}
		
		if (_keytest(RR_F3)) // annule la selection
		{
			annuler_selection(sel);
			while (_keytest(RR_F3));
		}
		
		if (_keytest(RR_F2)) // rappelle la selection
		{
			if (sel -> donnees) // si il existe une selection
			{
				int i = sel -> i, j = sel -> j, h = sel -> h, l = sel -> l;
				int g = 0;
				Sprite8 (x, y, 8, noir, GrayGetPlane (DARK_PLANE), SPRT_XOR);
				// copie l'cran
				memcpy ( buffer0, GrayGetPlane (LIGHT_PLANE), LCD_SIZE);
				memcpy ( buffer1, GrayGetPlane (DARK_PLANE), LCD_SIZE);
				// affiche image de la selection en gris  la bonne place
				GraySetAMSPlane(LIGHT_PLANE); 
				BitmapPut (j*8, i*8, sel -> image1, &(SCR_RECT){{0, 0, 159, 110}}, A_REPLACE);
				GraySetAMSPlane(DARK_PLANE); 
				BitmapPut (j*8, i*8, sel -> image2, &(SCR_RECT){{0, 0, 159, 110}}, A_REPLACE);
				// passer en mode deplacement
				while (_keytest(RR_F2)); // ~vide le tampon
				while (!_keytest(RR_F2) && !_keytest(RR_F3))
				{
					if (_keytest(RR_LEFT) && j > 0) { WAIT( _keytest(RR_LEFT) ); j--; g = 1;}
					if (_keytest(RR_RIGHT) && j + l < 20) { WAIT( _keytest(RR_RIGHT) ); j++; g = 1;}
					if (_keytest(RR_UP) && i > 0) { WAIT( _keytest(RR_UP) ); i--; g = 1;}
					if (_keytest(RR_DOWN) && i + h <13) { WAIT( _keytest(RR_DOWN) ); i++; g = 1;}
					if (g) //deplace la selection
					{
						// affiche l'cran sauvegarde
						memcpy ( GrayGetPlane (LIGHT_PLANE), buffer0, LCD_SIZE);
						memcpy ( GrayGetPlane (DARK_PLANE), buffer1, LCD_SIZE);
						// affiche la selection
						GraySetAMSPlane(LIGHT_PLANE); 
						BitmapPut (j*8, i*8, sel -> image1, &(SCR_RECT){{0, 0, 159, 110}}, A_REPLACE);
						GraySetAMSPlane(DARK_PLANE); 
						BitmapPut (j*8, i*8, sel -> image2, &(SCR_RECT){{0, 0, 159, 110}}, A_REPLACE);
						g = 0;
					}
				}
				if( _keytest(RR_F2) )
				{
					// colle la selection
					if (_keytest(RR_2ND))
					{
						int element_temp,k;
						for (k=0; k < (sel -> l * sel -> h) ; k++)
						{
							element_temp = 	rev_list[sel -> donnees[k]];
							element_temp ++; 
							if (element_temp < 0) element_temp=42;
							if (element_temp > 42) element_temp=0;
							sel -> donnees[k] = list[element_temp];
						}
					}
					afficher_selection(sel -> donnees,rev_list, i,j,sel -> l, sel -> h, &debuti, &debutj);
					// renregistre la selection
					GraySetAMSPlane(DARK_PLANE);
					ScrRectFill (&(SCR_RECT){{j*8, i*8, (j + sel -> l)*8-1, (i + sel -> h) * 8-1}}, &(SCR_RECT){{0, 0, 159, 110}}, A_XOR);
					BitmapGet (&(SCR_RECT){{j*8, i*8, (j + sel -> l)*8-1, (i + sel -> h)*8-1}}, sel -> image2); 
					ScrRectFill (&(SCR_RECT){{j*8, i*8, (j + sel -> l)*8-1, (i + sel -> h) * 8-1}}, &(SCR_RECT){{0, 0, 159, 110}}, A_XOR);
					GraySetAMSPlane(LIGHT_PLANE); 
					BitmapGet (&(SCR_RECT){{j*8, i*8, (j + sel -> l)*8-1, (i + sel -> h)*8-1}}, sel -> image1); 	
					// repositionne le curseur
					x = j * 8; y = i * 8;
				}
				else
				{
					// affiche l'cran sauvegarde
					memcpy ( GrayGetPlane (LIGHT_PLANE), buffer0, LCD_SIZE);
					memcpy ( GrayGetPlane (DARK_PLANE), buffer1, LCD_SIZE);
				}
				Sprite8 (x, y, 8, noir, GrayGetPlane (DARK_PLANE), SPRT_XOR);
			}
			else
			{
				// message("Selection inexistante")
			}
			while (_keytest(RR_F2) || _keytest(RR_F3) || _keytest(RR_2ND));
		} 
		
		if (_keytest(RR_SHIFT)) //definir la selection
		{
			int taille,i,j;
			int l=y/8, c=x/8, lfin,cfin;
			int l_hg, c_hg, l_bd, c_bd; // coordonnes des coins haut-gauche et bas-droite de la selection
			int indicateur_deplacement = 0; // indicateur pour savoir si la selection a t deplace
			char *bufferimg1 =malloc(BITMAP_HDR_SIZE + 160*104/8);
			char *bufferimg2 =malloc(BITMAP_HDR_SIZE + 160*104/8); 
						
			lfin=l; cfin=c;
			l_hg = min(l,lfin);
			c_hg = min(c,cfin);
			l_bd = max(l,lfin);
			c_bd = max(c,cfin);
			// efface le curseur
			Sprite8 (x, y, 8, noir, GrayGetPlane (DARK_PLANE), SPRT_XOR);
			// copie l'cran
			memcpy ( buffer0, GrayGetPlane (LIGHT_PLANE), LCD_SIZE);
			memcpy ( buffer1, GrayGetPlane (DARK_PLANE), LCD_SIZE);
			// raffiche le curseur
			Sprite8 (x, y, 8, noir, GrayGetPlane (DARK_PLANE), SPRT_XOR);
			// annule la selection au cas ou il y en aurait deja une
			annuler_selection(sel);
			
			while (_keytest(RR_SHIFT))
			{
				if (_keytest(RR_LEFT) && cfin>0) { WAIT( _keytest(RR_LEFT) ); cfin -=1 ;indicateur_deplacement=1;}
				if (_keytest(RR_RIGHT) && cfin<19) { WAIT( _keytest(RR_RIGHT) ); cfin +=1 ; indicateur_deplacement=1;}
				if (_keytest(RR_UP) && lfin>0) { WAIT( _keytest(RR_UP) ); lfin -= 1 ; indicateur_deplacement=1;}
				if (_keytest(RR_DOWN) && lfin<12) { WAIT( _keytest(RR_DOWN) ); lfin += 1 ; indicateur_deplacement=1;}
				if (indicateur_deplacement) // si la selection a chang
				{	
					// efface la selection prcdente	  		
					GraySetAMSPlane(DARK_PLANE);
					ScrRectFill (&(SCR_RECT){{c_hg*8, l_hg*8, c_bd*8+7, l_bd*8+7}}, &(SCR_RECT){{0, 0, 159, 110}}, A_XOR); 
					// actualise les coordonnes
					l_hg = min(l,lfin);
					c_hg = min(c,cfin);
					l_bd = max(l,lfin);
					c_bd = max(c,cfin);
					// affiche la selection => inverse les couleurs
					ScrRectFill (&(SCR_RECT){{c_hg*8, l_hg*8, c_bd*8+7, l_bd*8+7}}, &(SCR_RECT){{0, 0, 159, 110}}, A_XOR);
					indicateur_deplacement = 0;
				}
			}
			cfin = c_bd+1;
			c = c_hg;
			lfin = l_bd+1;
			l = l_hg;
			
			// Copie les 2 plans de la selection
			GraySetAMSPlane(LIGHT_PLANE); 
			BitmapGet (&(SCR_RECT){{c*8, l*8, cfin*8-1, lfin*8-1}}, bufferimg1); 
			GraySetAMSPlane(DARK_PLANE); 
			BitmapGet (&(SCR_RECT){{c*8, l*8, cfin*8-1, lfin*8-1}}, bufferimg2); 
			
			// Definit les coordonnes de la selection
			sel -> i = l;
			sel -> j = c;
			sel -> l = cfin - c;
			sel -> h = lfin - l;
			// Remplit la selection
			sel -> donnees = (unsigned char *)malloc((sel -> h) * (sel -> l) * sizeof(unsigned char));
			for (i = l ; i<lfin ; i++)
			{
				for (j = c; j<cfin; j++)
				{
					sel -> donnees[(sel -> l) * (i - l) + (j - c)] = m[i][j];
				}
			}
			// Copier les images de la selection
			taille = BITMAP_HDR_SIZE + 160*104/8;
			sel -> image1 = (char*)malloc(taille * sizeof(char));
			memcpy(sel -> image1, bufferimg1, taille);
			sel -> image2 = (char*)malloc(taille * sizeof(char));
			memcpy(sel -> image2, bufferimg2, taille);
			
			// Definit la selection comme non visible sur l'ecran
			sel -> active = INACTIVE;
			ScrRectFill (&(SCR_RECT){{c*8, l*8, cfin*8-1, lfin*8-1}}, &(SCR_RECT){{0, 0, 159, 110}}, A_XOR);
	  		
			// Repositionne les coordonnees du curseur en haut  gauche de la selection
			x = c*8; y = l*8;
			Sprite8 (x, y, 8, noir, GrayGetPlane (DARK_PLANE), SPRT_XOR);
			
			free(bufferimg1); free(bufferimg2);
			while (_keytest(RR_SHIFT));
		}
		OldX = x; OldY = y;
		
		if (_keytest(RR_PLUS) || _keytest(RR_MINUS)) //changer de level
		{
			if (sel -> donnees) // si il existe une selection
			{
				sel -> active = INACTIVE;
			}
			lvl-=_keytest(RR_MINUS)*(9*_keytest(RR_DIAMOND)+1); //si appui sur DIAMOND alors les levels vont de 10 en 10
			lvl+=_keytest(RR_PLUS)*(9*_keytest(RR_DIAMOND)+1);
			if (lvl<1) lvl = nb_level;
			if (lvl>nb_level) lvl = 1;
			changelevel = 1; // indicateur de changement de level
			goto debut;
		}
		if (_keytest(RR_MULTIPLY) || _keytest(RR_DIVIDE)) //changer d'objet
		{
			int element_temp;
			if (sel -> donnees)
			{
				sel -> active = INACTIVE;	
				// efface le curseur
				//Sprite8 (x, y, 8, noir, GrayGetPlane (DARK_PLANE), SPRT_XOR);
				int sens = _keytest(RR_DIVIDE) ? (-1) : 1;
				for (i=0; i < (sel -> l * sel -> h) ; i++)
				{
					element_temp = 	rev_list[sel -> donnees[i]];
					element_temp += sens; 
					if (element_temp < 0) element_temp=42;
					if (element_temp > 42) element_temp=0;
					sel -> donnees[i] = list[element_temp];
				}
				afficher_selection(sel -> donnees,rev_list, sel -> i, sel -> j,sel -> l, sel -> h, &debuti, &debutj);
				// renregistre la selection
				GraySetAMSPlane(DARK_PLANE);
				ScrRectFill (&(SCR_RECT){{sel -> j*8, sel -> i*8, (sel -> j + sel -> l)*8-1, (sel -> i + sel -> h) * 8-1}}, &(SCR_RECT){{0, 0, 159, 110}}, A_XOR);
				GraySetAMSPlane(LIGHT_PLANE); 
				BitmapGet (&(SCR_RECT){{sel -> j*8, sel -> i*8, (sel -> j + sel -> l)*8-1, (sel -> i + sel -> h)*8-1}}, sel -> image1); 
				GraySetAMSPlane(DARK_PLANE); 
				BitmapGet (&(SCR_RECT){{sel -> j*8, sel -> i*8, (sel -> j + sel -> l)*8-1, (sel -> i + sel -> h)*8-1}}, sel -> image2); 
				GraySetAMSPlane(DARK_PLANE);
				ScrRectFill (&(SCR_RECT){{sel -> j*8, sel -> i*8, (sel -> j + sel -> l)*8-1, (sel -> i + sel -> h) * 8-1}}, &(SCR_RECT){{0, 0, 159, 110}}, A_XOR);
				// raffiche le curseur
				Sprite8 (x, y, 8, noir, GrayGetPlane (DARK_PLANE), SPRT_XOR);
			}
			else
			{
				element-=_keytest(RR_DIVIDE);
				element+=_keytest(RR_MULTIPLY);
				if (element<1) element=NB_ELEMENTS;
				if (element>NB_ELEMENTS) element=1;
				Sprite8 (x, y, 8, blanc, GrayGetPlane (LIGHT_PLANE), SPRT_AND);
				Sprite8 (x, y, 8, blanc, GrayGetPlane (DARK_PLANE), SPRT_AND);
				
				Sprite8 (x, y, 8, img1[element], GrayGetPlane (LIGHT_PLANE), SPRT_OR );
				Sprite8 (x, y, 8, img2[element], GrayGetPlane (DARK_PLANE), SPRT_OR );
				
				m[y/8][x/8] = list[element-1];
				
				Sprite8 (x, y, 8, noir, GrayGetPlane (DARK_PLANE), SPRT_XOR);
				//i_chx = y/8;
				//j_chx = x/8;
			}
			while (_keytest(RR_MULTIPLY) || _keytest(RR_DIVIDE));
		}
		
		if (_keytest(RR_3) && nb_level>1)
		{
			annuler_selection(sel);
			memcpy ( buffer0, GrayGetPlane (LIGHT_PLANE), LCD_SIZE);
			memcpy ( buffer1, GrayGetPlane (DARK_PLANE), LCD_SIZE);
			GraySetAMSPlane(LIGHT_PLANE);
			printf_xy(0,0,"Etes-vous sur ? (ENTER=o ESC=n) ");
			GraySetAMSPlane(DARK_PLANE);
			printf_xy(0,0,"Etes-vous sur ? (ENTER=o ESC=n) ");
			while (!_keytest(RR_ENTER) && !_keytest(RR_ESC));
			if (_keytest(RR_ENTER))
			{
				suppr_level(packlevel,lvl);
				lvl=(lvl-1)%(nb_level-1)+1;
				while (_keytest(RR_ENTER));
				goto debut;
			}
			while (_keytest(RR_ESC));
			memcpy ( GrayGetPlane (LIGHT_PLANE), buffer0, LCD_SIZE);
			memcpy ( GrayGetPlane (DARK_PLANE), buffer1, LCD_SIZE);
			Sprite8 (x, y, 8, noir, GrayGetPlane (DARK_PLANE), SPRT_XOR);
		}
		
		
		if (_keytest(RR_9) && nb_level>1) //deplacement d'un niveau
		{
			int place=lvl, placeancien=lvl;	
			annuler_selection(sel);
			Sprite8 (x, y, 8, noir, GrayGetPlane (DARK_PLANE), SPRT_XOR);
			memcpy ( buffer0, GrayGetPlane (LIGHT_PLANE), LCD_SIZE);
			memcpy ( buffer1, GrayGetPlane (DARK_PLANE), LCD_SIZE);
			GraySetAMSPlane(LIGHT_PLANE);
			printf_xy(0,0,"Nouvelle place : %d  ",place);
			GraySetAMSPlane(DARK_PLANE);
			printf_xy(0,0,"Nouvelle place : %d  ",place);
				
			while (!_keytest(RR_ENTER) && !_keytest(RR_ESC))
			{
				place-=_keytest(RR_LEFT)*(9*_keytest(RR_DIAMOND)+1);
				place+=_keytest(RR_RIGHT)*(9*_keytest(RR_DIAMOND)+1);
				if (place<1)place=nb_level;
				if (place>nb_level)place=1;
				if (place!=placeancien)
				{
					GraySetAMSPlane(LIGHT_PLANE);
					printf_xy(0,0,"Nouvelle place : %d  ",place);
					GraySetAMSPlane(DARK_PLANE);
					printf_xy(0,0,"Nouvelle place : %d  ",place);
					WAIT( _keytest(RR_LEFT) || _keytest(RR_RIGHT) );
				}
				placeancien=place;
			}
			if (_keytest(RR_ENTER))
			{
				inverse_level(packlevel, lvl, place);
				while (_keytest(RR_ENTER));
				goto debut;
			}
			while(_keytest(RR_ESC));
			memcpy ( GrayGetPlane (LIGHT_PLANE), buffer0, LCD_SIZE);
			memcpy ( GrayGetPlane (DARK_PLANE), buffer1, LCD_SIZE);
			Sprite8 (x, y, 8, noir, GrayGetPlane (DARK_PLANE), SPRT_XOR);
		}
		
		if (_keytest(RR_F5)) // rcupre le bloc sous le curseur
		{
			element = rev_list[m[y/8][x/8]]+1;
		}
		
		if (_keytest(RR_ENTER) || _keytest(RR_2ND) /*|| (i_chx != -1 && (i_chx != y/8 || j_chx != x/8))*/ ) //place l'objet
		{
			if( m[y/8][x/8] != list[element-1] )
			{
				int x_save = x, y_save = y;
				annuler_selection(sel);
				//if (i_chx != -1) {x = j_chx * 8; y = i_chx * 8;}
				Sprite8 (x, y, 8, blanc, GrayGetPlane (LIGHT_PLANE), SPRT_AND);
				Sprite8 (x, y, 8, blanc, GrayGetPlane (DARK_PLANE), SPRT_AND);
				
				Sprite8 (x, y, 8, img1[element], GrayGetPlane (LIGHT_PLANE), A_OR);
				Sprite8 (x, y, 8, img2[element], GrayGetPlane (DARK_PLANE), A_OR);
				
				if (m[y/8][x/8]==24)
				{
					debuti = debutj = -1;
				}
				m[y/8][x/8] = list[element-1] ;
				
				if (list[element-1] == 24)
				{
					if (debuti != -1) //si balle dans le level
					{
						Sprite8 (debutj*8, debuti*8, 8, blanc, GrayGetPlane (LIGHT_PLANE), SPRT_AND);
						Sprite8 (debutj*8, debuti*8, 8, blanc, GrayGetPlane (DARK_PLANE), SPRT_AND);
						m[debuti][debutj] = 255;
					}
					debuti = y/8;
					debutj = x/8;
				}
				x = x_save; y = y_save;
				//if (i_chx != -1) Sprite8 (x, y, 8, noir, GrayGetPlane (DARK_PLANE), SPRT_XOR);
				
				//i_chx = j_chx = -1;
				Sprite8 (x, y, 8, noir, GrayGetPlane (DARK_PLANE), SPRT_XOR);
			}
		}

		if (_keytest(RR_F1)) // sauvegarde le level
		{
			memcpy ( buffer0, GrayGetPlane (LIGHT_PLANE), LCD_SIZE);
			memcpy ( buffer1, GrayGetPlane (DARK_PLANE), LCD_SIZE);
			save(packlevel, lvl);
			GraySetAMSPlane(LIGHT_PLANE);
			printf_xy(0,0,"Level sauvegard ");
			GraySetAMSPlane(DARK_PLANE);
			printf_xy(0,0,"Level sauvegard ");		
			while (_keytest(RR_F1));
			memcpy ( GrayGetPlane (LIGHT_PLANE), buffer0, LCD_SIZE);
			memcpy ( GrayGetPlane (DARK_PLANE), buffer1, LCD_SIZE);
			
		}
		
	}	
	GrayOff();
	SetIntVec (AUTO_INT_5, OldInt5);
	SetIntVec (AUTO_INT_1, OldInt1);
	annuler_selection(sel);
	free(sel);
	GKeyFlush ();
}

int aff( int element ) //ecran choix objet (touche APPS)
{
	int i;
	int x=(element-1)%10*10, y=(element-1)/10*10 ;
	int OldX = x, OldY =y;
	efface_ecran();
	for (i=0;i<NB_ELEMENTS;i++)
	{
		Sprite8 (i%10*10, i/10*10, 8, img1[i+1], GrayGetPlane (LIGHT_PLANE), A_OR);
		Sprite8 (i%10*10, i/10*10, 8, img2[i+1], GrayGetPlane (DARK_PLANE), A_OR);
	}
	Sprite8 (x, y, 8, noir, GrayGetPlane (DARK_PLANE), SPRT_XOR);
	while (!_keytest(RR_APPS) && !_keytest(RR_ESC))
	{
		if( _keytest(RR_ENTER) || _keytest(RR_2ND) )
		{
			while( _keytest(RR_ENTER) || _keytest(RR_2ND) );
			return y+x/10+1;
		}
			
		if (_keytest(RR_LEFT)) { WAIT( _keytest(RR_LEFT)); x -=10 ;}
		if (_keytest(RR_RIGHT)) { WAIT( _keytest(RR_RIGHT)); x +=10 ; }
		if (_keytest(RR_UP)) { WAIT( _keytest(RR_UP)); y -= 10 ; }
		if (_keytest(RR_DOWN)) { WAIT( _keytest(RR_DOWN)); y += 10 ; }
		if (x<0) x = 90;
		if (x>90) x = 0;
		if (y<0) y = 50;
		if (y>50) y = 0;
		if (OldX != x || OldY != y)	
		{
			Sprite8 (OldX, OldY, 8, noir, GrayGetPlane (DARK_PLANE), SPRT_XOR);
			Sprite8 (x, y, 8, noir, GrayGetPlane (DARK_PLANE), SPRT_XOR);
		}
		OldX = x; OldY = y;
	}	
	while (_keytest(RR_APPS) || _keytest(RR_ESC));
	return element;
}

void save(char* packlevel, int lvl) //sauvegarde dans niveau lvl de packlevel
{
	HSym hsym;
	SYM_ENTRY *SymPtr;
	int level_archive;
	char nb_level=1;
	HANDLE handle;
	char *fptr=fptr;
	char *pack=pack;
	if (packlevel[0] == 0) strcpy(packlevel,"gravtemp");

	hsym = SymFind (SYMSTR (packlevel));
	SymPtr = DerefSym (hsym);
	level_archive = SymPtr -> flags.bits.archived;
	
	EM_moveSymFromExtMem (NULL,hsym); // desarchive la variable packlevel
	
	SYM_ENTRY *openlevel_sym;	
	openlevel_sym=SymFindPtr(SYMSTR(packlevel),0);
	if (openlevel_sym)
	{
		handle=openlevel_sym->handle;
		fptr=HeapDeref(handle);
		nb_level = *(fptr+3);
		pack=malloc(lvl_size-10);
		memcpy(pack, fptr+4, TAILLE_LEVEL * nb_level * sizeof(char));
		HSymDel (SymFind (SYMSTR (packlevel)));
	}
	
	
	HANDLE handlefin;
	char *fptrfin;
	SYM_ENTRY *write_sym;
	handlefin=HeapAlloc(lvl_size);
	write_sym=DerefSym(SymAdd(SYMSTR(packlevel)));
	write_sym->handle=handlefin;
	fptrfin=HeapDeref(handlefin);
	*(short*)fptrfin=lvl_size-2;
	fptrfin[3]=nb_level;
	
	if (nb_level>1) memcpy(&fptrfin[4], pack, TAILLE_LEVEL * nb_level * sizeof(char));
	memcpy(&fptrfin[lvl*TAILLE_LEVEL-TAILLE_LEVEL+4], m, TAILLE_LEVEL * sizeof(char));
	
	fptrfin[lvl_size-6]=0;
	strcpy(fptrfin+lvl_size-5,"LVL");
	fptrfin[lvl_size-1]=OTH_TAG; 
	
	
	if (level_archive)
	{
		hsym = SymFind (SYMSTR (packlevel));
		EM_moveSymToExtMem (NULL,hsym); // archive la variable packlevel
	}
	if (openlevel_sym) free(pack);
}

void efface_ecran()
{
	GraySetAMSPlane(LIGHT_PLANE);
	ClrScr();
	GraySetAMSPlane(DARK_PLANE);
	ClrScr();
}

void annuler_selection(struct selection * s)
{
	if (s -> donnees)
	{
		if (s -> active == ACTIVE)
		{
			//Inverse la selection => la remet dans son tat graphique normal
			ScrRectFill (&(SCR_RECT){{s -> j * 8, s -> i * 8, (s -> j + s -> l)*8-1, (s -> i + s -> h)*8-1}}, &(SCR_RECT){{0, 0, 159, 110}}, A_XOR);
		}
		free(s -> donnees);
		free(s -> image1);
		free(s -> image2);
		s -> donnees = NULL;
		s -> image1 = NULL;
		s -> image2 = NULL;
	}
}
			
void affiche_level(int *rev_list,int x,int y, int *debuti, int *debutj) //affiche le level en fonction de m
{
	int i, j;
	efface_ecran();
	
	for (i=0;i<13;i++)
	{
		for (j=0;j<20;j++)
		{
			Sprite8 (j*8, i*8, 8, img1[rev_list[m[i][j]]+1], GrayGetPlane (LIGHT_PLANE), A_OR); Sprite8 (j*8, i*8, 8, img2[rev_list[m[i][j]]+1], GrayGetPlane (DARK_PLANE), A_OR);
			if (m[i][j]==24)
			{
				*debuti=i;
				*debutj=j;
			}
		}
	}
	Sprite8 (x, y, 8, noir, GrayGetPlane (DARK_PLANE), SPRT_XOR);
}

// param **s : donnees de la selection
// param i_NO, j_NO : coordonnes du coin Nord-Ouest de la selection
// param l, h : largeur et hauteur de la selection
// param *debuti, *debutj : coordonnees de la balle
void afficher_selection(unsigned char *s,int *rev_list,int i_NO, int j_NO, int l, int h, int *debuti, int *debutj)
{
	int i, j;
	// efface la selection
	GraySetAMSPlane(LIGHT_PLANE);
	ScrRectFill (&(SCR_RECT){{j_NO*8, i_NO*8, (j_NO + l)*8-1, (i_NO + h) * 8-1}}, &(SCR_RECT){{0, 0, 159, 110}}, A_REVERSE);
	GraySetAMSPlane(DARK_PLANE);
	ScrRectFill (&(SCR_RECT){{j_NO*8, i_NO*8, (j_NO + l)*8-1, (i_NO + h) * 8-1}}, &(SCR_RECT){{0, 0, 159, 110}}, A_REVERSE);
			
	for (i=0 ; i< h ; i++)
	{
		for (j=0 ; j< l ; j++)
		{
			if (s[l*i + j]==24)
			{
				if (*debuti != -1)
				{
					Sprite8 (*debutj * 8, *debuti * 8, 8, blanc, GrayGetPlane (DARK_PLANE), SPRT_AND);
					Sprite8 (*debutj * 8, *debuti * 8, 8, blanc, GrayGetPlane (LIGHT_PLANE), SPRT_AND);
					m[*debuti][*debutj] = 255;
				}
				*debuti = i_NO + i;
				*debutj = j_NO + j;
			}
			Sprite8 ((j_NO + j)*8, (i_NO + i)*8, 8, img1[rev_list[s[l*i+j]]+1], GrayGetPlane (LIGHT_PLANE), A_OR); Sprite8 ((j_NO + j)*8, (i_NO + i)*8, 8, img2[rev_list[s[l*i+j]]+1], GrayGetPlane (DARK_PLANE), A_OR);
			m[i_NO + i][j_NO + j] = s[l*i + j]; 
		}
	}
}


void suppr_level( char *packlevel, int level)
{
	HSym hsym;
	SYM_ENTRY *SymPtr;
	int level_archive;
	char nb_level;
	HANDLE handle;
	char *fptr=fptr;
	hsym = SymFind (SYMSTR (packlevel));
	SymPtr = DerefSym (hsym);
	level_archive = SymPtr -> flags.bits.archived;
	
	EM_moveSymFromExtMem (NULL,hsym); // desarchive la variable packlevel
	
	SYM_ENTRY *openlevel_sym;	
	openlevel_sym=SymFindPtr(SYMSTR(packlevel),0);
	handle=openlevel_sym->handle;
	fptr=HeapDeref(handle);
	nb_level = *(fptr+3);
	char *pack=malloc(lvl_size-10);
	memcpy(pack, fptr+4, TAILLE_LEVEL * nb_level * sizeof(char));

	HSymDel (SymFind (SYMSTR (packlevel)));
	nb_level--;
	HANDLE handlefin;
	char *fptrfin;
	SYM_ENTRY *write_sym;
	
	handlefin=HeapAlloc(lvl_size);
	write_sym=DerefSym(SymAdd(SYMSTR(packlevel)));
	write_sym->handle=handlefin;
	fptrfin=HeapDeref(handlefin);
	*(short*)fptrfin=lvl_size-2;
	fptrfin[3]=nb_level;

	memcpy(&fptrfin[4], pack, (TAILLE_LEVEL * level-TAILLE_LEVEL) * sizeof(char));
	memcpy(&fptrfin[4+TAILLE_LEVEL * level-TAILLE_LEVEL], pack+TAILLE_LEVEL * level, TAILLE_LEVEL * (nb_level-level+1) * sizeof(char));
	
	fptrfin[lvl_size-6]=0;
	strcpy(fptrfin+lvl_size-5,"LVL");
	fptrfin[lvl_size-1]=OTH_TAG; 
	
	
	if (level_archive)
	{
		hsym = SymFind (SYMSTR (packlevel));
		EM_moveSymToExtMem (NULL,hsym); // archive la variable packlevel
	}
	free(pack);
}
void inverse_level( char *packlevel,  char level, char place)
{
	HSym hsym;
	SYM_ENTRY *SymPtr;
	int level_archive;
	char nb_level;
	HANDLE handle;
	char *fptr=fptr;
	
	hsym = SymFind (SYMSTR (packlevel));
	SymPtr = DerefSym (hsym);
	level_archive = SymPtr -> flags.bits.archived;
	
	EM_moveSymFromExtMem (NULL,hsym); // desarchive la variable packlevel

	
	SYM_ENTRY *openlevel_sym;	
	openlevel_sym=SymFindPtr(SYMSTR(packlevel),0);
	handle=openlevel_sym->handle;
	fptr=HeapDeref(handle);
	nb_level = *(fptr+3);
	char *pack=malloc(lvl_size-10);

	
	memcpy(pack, fptr+4, TAILLE_LEVEL * nb_level * sizeof(char)); //enregistre temporairement le pack
	HSymDel (SymFind (SYMSTR (packlevel)));	
	
	HANDLE handlefin;
	char *fptrfin;
	SYM_ENTRY *write_sym;
	
	handlefin=HeapAlloc(lvl_size);
	write_sym=DerefSym(SymAdd(SYMSTR(packlevel)));
	write_sym->handle=handlefin;
	fptrfin=HeapDeref(handlefin);
	*(short*)fptrfin=lvl_size-2;
	fptrfin[3]=nb_level;
	if (level<place)
	{
		memcpy(&fptrfin[4], pack, TAILLE_LEVEL * (level-1) * sizeof(char));
		memcpy(&fptrfin[4 + TAILLE_LEVEL * (level-1)], pack+TAILLE_LEVEL * (level), TAILLE_LEVEL * (place-level) * sizeof(char));
		memcpy(&fptrfin[4 + TAILLE_LEVEL * (place-1)], pack+TAILLE_LEVEL* (level-1), TAILLE_LEVEL*sizeof(char));
		memcpy(&fptrfin[4 + TAILLE_LEVEL * (place)], pack+TAILLE_LEVEL*(place), TAILLE_LEVEL*(nb_level-place)*sizeof(char));
	}
	else
	{
		memcpy(&fptrfin[4], pack, TAILLE_LEVEL * (place-1) * sizeof(char));
		memcpy(&fptrfin[4 + TAILLE_LEVEL * (place-1)], pack+TAILLE_LEVEL*(level-1), TAILLE_LEVEL * sizeof(char));
		memcpy(&fptrfin[4 + TAILLE_LEVEL * (place)], pack+TAILLE_LEVEL * (place-1), TAILLE_LEVEL * (level-place) * sizeof(char));
		memcpy(&fptrfin[4 + TAILLE_LEVEL * (level)], pack+TAILLE_LEVEL*(level), TAILLE_LEVEL*(nb_level-level)*sizeof(char));
	}
	
	
	
	fptrfin[lvl_size-6]=0;
	strcpy(fptrfin+lvl_size-5,"LVL");
	fptrfin[lvl_size-1]=OTH_TAG; 
	
	
	if (level_archive)
	{
		hsym = SymFind (SYMSTR (packlevel));
		EM_moveSymToExtMem (NULL,hsym); // archive la variable packlevel
	}
	free(pack);
}