/******************************************************************************
*                                                                             *
*   A M S   E x t e n d e r                                                   *
*                                                                             *
*   by Stefan Heule                                                           *
*   member of boolsoft (www.boolsoft.org)                                     *
*                                                                             *
*   Source Code                                                               *
*                                                                             *
*   File:   hook.c                                                            *
*   Use:    - source code file                                                *
*           - main routine of the hook                                        *
*                                                                             *
*******************************************************************************

AMS Extender - A utility for TI's 68k calculaters
Copyright (C) 2006-2008  Stefan Heule

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/


// ----------------------------------------------------------------- //
// ---------------------------[ defines ]--------------------------- //
// ----------------------------------------------------------------- //
#define USE_TI89
#define USE_V200

#define _NO_INCLUDE_PATCH
#define OPTIMIZE_ROM_CALLS


// ----------------------------------------------------------------- //
// ------------------------[ header files ]------------------------- //
// ----------------------------------------------------------------- //
#include <tigcclib.h>



// ----------------------------------------------------------------- //
// ----------------------[ global variables ]----------------------- //
// ----------------------------------------------------------------- //
volatile unsigned short internal_key_delay;
volatile unsigned short internal_scroll_delay;
INT_HANDLER old_trap_4 = NULL;




// ----------------------------------------------------------------- //
// ------------------------[ hook header ]-------------------------- //
// ----------------------------------------------------------------- //
// total length of this header is 4 bytes
// offset to jmp EntryPoint:l is 0 bytes
asm(".section _stl1 | First library startup section. This is what the executable starts with.
		__jmp__Event_Hook__:
		jmp EntryPoint:l
		");



// -------------------------[ Install_TSR ]------------------------- //
// TRAP #4 hook                                                      //
// ----------------------------------------------------------------- //
// note:                                                             //
//     Sets the key and scroll delay                                 //
// ----------------------------------------------------------------- //
DEFINE_INT_HANDLER(trap_4_hook)
{
 	// execute the old handler
  ExecuteHandler(old_trap_4);
  
  // set the key/scroll delay
  OSInitKeyInitDelay(internal_key_delay);
  OSInitBetweenKeyDelay(internal_scroll_delay);
}



// --------------------------[ EntryPoint ]------------------------- //
// Installs or uninstalls the trap4 hook, or updates it's config     //
// ----------------------------------------------------------------- //
// input:                                                            //
//     key_delay     = key delay                                     //
//     scroll_delay  = scroll delay                                  //
//     update_config = 0 -> install or uninstall our hook            //
//                     1 -> just update the config without touching  //
//                          the hook                                 //
// note:                                                             //
//     Can be executed as often as needed, but only twice with       //
//     <update_config> set to 0. Once to install the hook, once to   //
//     uninstall it.                                                 //
// ----------------------------------------------------------------- //
void EntryPoint(unsigned short key_delay, unsigned short scroll_delay, unsigned char update_config) {
	internal_key_delay = key_delay;
	internal_scroll_delay = scroll_delay;
	if (update_config || !old_trap_4) {
		OSInitKeyInitDelay(internal_key_delay);
		OSInitBetweenKeyDelay(internal_scroll_delay);
	}
	
	// just update the config
	if (update_config) {
		
	}
	
	// the hook is already running, so stop it and restore the old
	// interrupt vector
	else if (old_trap_4) {
		SetIntVec(INT_VEC_OFF, old_trap_4);
		old_trap_4 = NULL;
	}
	
	// our hook is not running, so backup the old interrupt vector
	// and install our own handler
	else {
		old_trap_4 = GetIntVec(INT_VEC_OFF);
		SetIntVec(INT_VEC_OFF, trap_4_hook);
	}
}























