/* TI-89/92+ Hardware 2.00 AMS 2.0x TSR support v.1.12 C HEADER FILE VERSION
   Copyright (C) Kevin Kofler, 2001-2004

This is the GCC C version of the include file.
WARNING: You need TIGCC 0.95 minimum to use h220xTSR 1.12!

To use it, use #include "h220xtsr.h" and call the function h220xTSR();. You
will also have to link to the static library h220xtsr.a, either by adding
it to your TIGCC IDE project, or by compiling your program using:
"tigcc yourprog.c h220xtsr.a".
The h220xTSR() function returns a value which you might want to read in
your program.
Use it only in your main function and, if you do not use it at the end, you
will have to relocate your program to the ghost space if it was not already
there.
For an event hook installer, I recommend the following sequence:
void _main(void)
{
...
if (!h220xTSR()) {ST_helpMsg("h220xTSR installation failed");return;};
*EV_hook=...;
ST_helpMsg("Success message");
}

Please read the readme file before using this file.

Please DO NOT distribute modified versions without my permission (unless you use
the GPL licensing option, in which case your entire program MUST be GPLed)! Just
include the header file as is and link to the static library as is and it should
work. */

/* FATAL ERRORS: */
#define h220xTSR_FAILED 0 /* installation failed (not enough memory or trap 4 already hooked) */
                          /* A dialog box showing the error will be displayed. */
#define h220xTSR_ERROR_MEMORY 0 /* This is here just for compatibility with older source code. */

/* SUCCESS CODES: */
#define h220xTSR_SUCCESS 1 /* success */
#define h220xTSR_SUCCESS_UPDATE 2 /* successfully updated */

/* NON-FATAL, INFORMATIONAL ERROR CODES: */
#define h220xTSR_HW1 -1 /* ERROR: HW1 detected, h220xTSR is not needed on HW1 */
#define h220xTSR_AMS1 -2 /* ERROR: AMS 1 detected, h220xTSR is not needed on AMS 1 */
#define h220xTSR_PATCHED -3 /* ERROR: HW2/3Patch detected, h220xTSR is not needed on patched HW2 */
#define h220xTSR_ALREADY -4 /* ERROR: h220xTSR is already installed */
#define h220xTSR_PATCHED_HW3 -5 /* ERROR: HW3 with HW3Patch detected, h220xTSR not needed */

/* Do NOT call this function directly. The smart macros below will determine if the extra code
   below is needed or not. */
extern long long h220xTSR_internal(void);

/* FIXME: This is definitely not the correct check for TIGCC 0.95. We need to do something
          linker-side, or to rely on EXECUTE_IN_GHOST_SPACE instead. But it is good enough for now. */
#if defined(SAVE_SCREEN) || defined(RETURN_VALUE) || defined(OPTIMIZE_ROM_CALLS) || \
(!defined(NO_EXIT_SUPPORT) && defined(NOSTUB))
/* Allow h220xTSR to work with "complex main"s.
   THIS REQUIRES TIGCC 0.93 MINIMUM! */
#define h220xTSR() ({extern unsigned long *__save__sp__;long long __temp__;asm("/* Include Patch: save_the_sp */"); \
                   __temp__=h220xTSR_internal();if ((long)__temp__) (*__save__sp__)|=0x40000;(long)(__temp__>>32);})
/* Defining both h220xTSR and h220xtsr for those who don't like uppercase letters in C function
   names. */
#define h220xtsr() ({extern unsigned long *__save__sp__;long long __temp__;asm("/* Include Patch: save_the_sp */"); \
                   __temp__=h220xTSR_internal();if ((long)__temp__) (*__save__sp__)|=0x40000;(long)(__temp__>>32);})
#else
/* Simple redefine for "simple main"s, but we have to drop d1. */
#define h220xTSR() ((long)(h220xTSR_internal()>>32))
/* Defining both h220xTSR and h220xtsr for those who don't like uppercase letters in C function
   names. */
#define h220xtsr() ((long)(h220xTSR_internal()>>32))
#endif
